/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResEnum;
import brut.androlib.res.table.value.ResFlags;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResString;
import brut.androlib.res.xml.ResStringEncoder;
import brut.common.Log;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResAttribute
extends ResBag {
    private static final String TAG = ResAttribute.class.getName();
    private static final int ATTR_TYPE = 0x1000000;
    private static final int ATTR_MIN = 0x1000001;
    private static final int ATTR_MAX = 0x1000002;
    private static final int ATTR_L10N = 0x1000003;
    public static final int ATTR_TYPE_ANY = 65535;
    public static final int ATTR_TYPE_REFERENCE = 1;
    public static final int ATTR_TYPE_STRING = 2;
    public static final int ATTR_TYPE_INTEGER = 4;
    public static final int ATTR_TYPE_BOOLEAN = 8;
    public static final int ATTR_TYPE_COLOR = 16;
    public static final int ATTR_TYPE_FLOAT = 32;
    public static final int ATTR_TYPE_DIMENSION = 64;
    public static final int ATTR_TYPE_FRACTION = 128;
    public static final int ATTR_TYPE_ENUM = 65536;
    public static final int ATTR_TYPE_FLAGS = 131072;
    private static final int[] ATTR_TYPE_MASKS = new int[]{2, 4, 8, 16, 32, 64, 128, 1};
    private static final String[] ATTR_TYPE_NAMES = new String[]{"string", "integer", "boolean", "color", "float", "dimension", "fraction", "reference"};
    private static final int ATTR_L10N_NOT_REQUIRED = 0;
    private static final int ATTR_L10N_SUGGESTED = 1;
    public static final ResAttribute DEFAULT = new ResAttribute(null, 65535, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    protected int mType;
    protected final int mMin;
    protected final int mMax;
    protected final int mL10n;

    public ResAttribute(ResReference parent, int type, int min, int max, int l10n) {
        super(parent);
        this.mType = type;
        this.mMin = min;
        this.mMax = max;
        this.mL10n = l10n;
    }

    public static ResAttribute parse(ResReference parent, ResBag.RawItem[] rawItems) {
        int i;
        int type = 65535;
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        int l10n = 0;
        int n = rawItems.length;
        block6: for (i = 0; i < n; ++i) {
            ResBag.RawItem rawItem = rawItems[i];
            ResPrimitive value = (ResPrimitive)rawItem.getValue();
            switch (rawItem.getKey()) {
                case 0x1000000: {
                    type = value.getData();
                    continue block6;
                }
                case 0x1000001: {
                    min = value.getData();
                    continue block6;
                }
                case 0x1000002: {
                    max = value.getData();
                    continue block6;
                }
                case 0x1000003: {
                    l10n = value.getData();
                    continue block6;
                }
            }
        }
        if (i == n) {
            return new ResAttribute(parent, type, min, max, l10n);
        }
        Symbol[] symbols = new Symbol[n - i];
        ResPackage pkg = parent.getPackage();
        int j = 0;
        while (i < n) {
            ResBag.RawItem rawItem = rawItems[i];
            int nameId = rawItem.getKey();
            ResReference name = new ResReference(pkg, ResId.of(nameId));
            ResPrimitive value = (ResPrimitive)rawItem.getValue();
            symbols[j] = new Symbol(name, value);
            ++i;
            ++j;
        }
        if ((type & 0x10000) != 0) {
            return new ResEnum(parent, type, min, max, l10n, symbols);
        }
        if ((type & 0x20000) != 0) {
            return new ResFlags(parent, type, min, max, l10n, symbols);
        }
        Log.w(TAG, "Invalid attribute type: 0x%08x", type);
        return new ResAttribute(parent, type, min, max, l10n);
    }

    public void addValueType(int valueType) {
        if ((this.mType & 0xFFFF) == 65535) {
            return;
        }
        switch (valueType) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                this.mType |= 1;
                return;
            }
            case 3: {
                this.mType |= 2;
                return;
            }
            case 4: {
                this.mType |= 0x20;
                return;
            }
            case 5: {
                this.mType |= 0x40;
                return;
            }
            case 6: {
                this.mType |= 0x80;
                return;
            }
            case 18: {
                this.mType |= 8;
                return;
            }
        }
        if (valueType >= 28 && valueType <= 31) {
            this.mType |= 0x10;
        } else if (valueType >= 16 && valueType <= 31) {
            this.mType |= 4;
        }
    }

    public boolean hasSymbolsForValue(ResItem value) {
        return this.getSymbolsForValue(value) != null;
    }

    protected Symbol[] getSymbolsForValue(ResItem value) {
        return null;
    }

    public String formatAsTextValue(ResItem value) throws AndrolibException {
        return this.formatValue(value, false);
    }

    public String formatAsAttributeValue(ResItem value) throws AndrolibException {
        return this.formatValue(value, true);
    }

    private String formatValue(ResItem value, boolean asAttrValue) throws AndrolibException {
        String formatted = this.formatValueFromSymbols(value);
        if (formatted != null) {
            return formatted;
        }
        if (asAttrValue && value instanceof ResString) {
            CharSequence strValue = ((ResString)value).getValue();
            return ResStringEncoder.encodeAttributeValue(strValue, this.mType);
        }
        return asAttrValue ? value.toXmlAttributeValue() : value.toXmlTextValue();
    }

    protected String formatValueFromSymbols(ResItem value) throws AndrolibException {
        return null;
    }

    @Override
    public void serializeToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
        String tagName = "attr";
        serial.startTag(null, tagName);
        serial.attribute(null, "name", entry.getName());
        String format = this.renderFormat();
        if (format != null) {
            serial.attribute(null, "format", format);
        }
        if (this.mMin != Integer.MIN_VALUE) {
            serial.attribute(null, "min", Integer.toString(this.mMin));
        }
        if (this.mMax != Integer.MAX_VALUE) {
            serial.attribute(null, "max", Integer.toString(this.mMax));
        }
        if (this.mL10n == 1) {
            serial.attribute(null, "localization", "suggested");
        }
        this.serializeSymbolsToValuesXml(serial, entry);
        serial.endTag(null, tagName);
    }

    private String renderFormat() {
        if ((this.mType & 0xFFFF) == 65535) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ATTR_TYPE_MASKS.length; ++i) {
            if ((this.mType & ATTR_TYPE_MASKS[i]) == 0) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(ATTR_TYPE_NAMES[i]);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    protected void serializeSymbolsToValuesXml(XmlSerializer serial, ResEntry entry) throws AndrolibException, IOException {
    }

    public String toString() {
        return String.format("ResAttribute{type=0x%04x, min=%s, max=%s, l10n=%s}", this.mType, this.mMin, this.mMax, this.mL10n);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResAttribute) {
            ResAttribute other = (ResAttribute)obj;
            return this.mType == other.mType && this.mMin == other.mMin && this.mMax == other.mMax && this.mL10n == other.mL10n;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mMin, this.mMax, this.mL10n);
    }

    public static class Symbol {
        private final ResReference mKey;
        private final ResPrimitive mValue;

        public Symbol(ResReference key, ResPrimitive value) {
            assert (key != null && value != null);
            this.mKey = key;
            this.mValue = value;
        }

        public ResReference getKey() {
            return this.mKey;
        }

        public ResPrimitive getValue() {
            return this.mValue;
        }
    }
}

