/*
 * Decompiled with CFR 0.152.
 */
package brut.apktool;

import brut.androlib.ApkBuilder;
import brut.androlib.ApkDecoder;
import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.FrameworkNotFoundException;
import brut.androlib.exceptions.InFileNotFoundException;
import brut.androlib.exceptions.OutDirExistsException;
import brut.androlib.res.AaptManager;
import brut.androlib.res.Framework;
import brut.util.OSDetection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static final Option verboseOption = Option.builder("v").longOpt("verbose").desc("Increase output verbosity.").get();
    private static final Option quietOption = Option.builder("q").longOpt("quiet").desc("Suppress normal output.").get();
    private static final Option jobsOption = Option.builder("j").longOpt("jobs").desc("Set the number of jobs to execute in parallel to <num>.").hasArg().argName("num").type(Integer.class).get();
    private static final Option frameDirOption = Option.builder("p").longOpt("frame-path").desc("Use framework files located in <dir>.").hasArg().argName("dir").get();
    private static final Option frameTagOption = Option.builder("t").longOpt("frame-tag").desc("Use framework files tagged with <tag>.").hasArg().argName("tag").get();
    private static final Option libOption = Option.builder("l").longOpt("lib").desc("Use shared library <package> located in <file>.\nCan be specified multiple times.").hasArg().argName("package:file").get();
    private static final Option decodeForceOption = Option.builder("f").longOpt("force").desc("Force delete destination directory.").get();
    private static final Option decodeAllSrcOption = Option.builder("a").longOpt("all-src").desc("Decode all sources in the apk (includes unknown dex files).").get();
    private static final Option decodeNoSrcOption = Option.builder("s").longOpt("no-src").desc("Do not decode sources.").get();
    private static final Option decodeNoDebugInfoOption = Option.builder().longOpt("no-debug-info").desc("Do not include debug info in sources (.local, .param, .line, etc.)").get();
    private static final Option decodeNoResOption = Option.builder("r").longOpt("no-res").desc("Do not decode resources.").get();
    private static final Option decodeOnlyManifestOption = Option.builder().longOpt("only-manifest").desc("Only decode AndroidManifest.xml without resources.").get();
    private static final Option decodeResResolveModeOption = Option.builder().longOpt("res-resolve-mode").desc("Set the resolve mode for resources to <mode>.\nPossible values: 'default', 'greedy' or 'lazy'.").hasArg().argName("mode").get();
    private static final Option decodeKeepBrokenResOption = Option.builder().longOpt("keep-broken-res").desc("Use if there was an error and some resources were dropped, e.g.\n\"Invalid resource config detected. Dropping resources\", but you\nwant to decode them anyway, even with errors. You will have to\nfix them manually before building.").get();
    private static final Option decodeIgnoreRawValuesOption = Option.builder().longOpt("ignore-raw-values").desc("Ignore raw attribute values in XML resource files.").get();
    private static final Option decodeMatchOriginalOption = Option.builder().longOpt("match-original").desc("Keep files closest to original as possible (prevents rebuild).").get();
    private static final Option decodeNoAssetsOption = Option.builder().longOpt("no-assets").desc("Do not decode assets.").get();
    private static final Option decodeOutputOption = Option.builder("o").longOpt("output").desc("Output decoded files to <dir>. (default: apk.out)").hasArg().argName("dir").get();
    private static final Option buildForceOption = Option.builder("f").longOpt("force").desc("Skip changes detection and build all files.").get();
    private static final Option buildNoApkOption = Option.builder().longOpt("no-apk").desc("Disable repacking of the built files into a new apk.").get();
    private static final Option buildNoCrunchOption = Option.builder().longOpt("no-crunch").desc("Disable crunching of resource files during the build step.").get();
    private static final Option buildCopyOriginalOption = Option.builder().longOpt("copy-original").desc("Copy original AndroidManifest.xml and META-INF. See project page for more info.").get();
    private static final Option buildDebuggableOption = Option.builder().longOpt("debuggable").desc("Set android:debuggable to \"true\" in AndroidManifest.xml for the built apk.").get();
    private static final Option buildNetSecConfOption = Option.builder().longOpt("net-sec-conf").desc("Add a generic network security configuration file to the built apk.").get();
    private static final Option buildAaptOption = Option.builder().longOpt("aapt").desc("Use aapt2 binary located in <file>.").hasArg().argName("file").get();
    private static final Option buildOutputOption = Option.builder("o").longOpt("output").desc("Output the built apk to <file>. (default: dist/name.apk)").hasArg().argName("file").get();
    private static final Option frameFrameDirOption = Option.builder("p").longOpt("frame-path").desc("Set the path for framework files to <dir>.").hasArg().argName("dir").get();
    private static final Option frameFrameTagOption = Option.builder("t").longOpt("frame-tag").desc("Suffix framework files with <tag>.").hasArg().argName("tag").get();
    private static final Option frameForceAllOption = Option.builder("a").longOpt("all").desc("Include all framework files regardless of tag.").get();
    private static final Options generalOptions = new Options();
    private static final Options decodeOptions = new Options();
    private static final Options buildOptions = new Options();
    private static final Options installFrameworkOptions = new Options();
    private static final Options cleanFrameworksOptions = new Options();
    private static final Options listFrameworksOptions = new Options();
    private static final Options publicizeResourcesOptions = new Options();
    private static final Props props = new Props();
    private static final Config config = new Config(props.getVersion());
    private static Options loadedOptions = null;
    private static boolean advancedMode = false;

    private static void loadOptions(Options options, boolean advanced) {
        loadedOptions = options;
        advancedMode = advanced;
        generalOptions.addOption(quietOption);
        generalOptions.addOption(verboseOption);
        if (options == null || options == decodeOptions) {
            decodeOptions.addOption(decodeAllSrcOption);
            decodeOptions.addOption(decodeForceOption);
            decodeOptions.addOption(decodeNoResOption);
            decodeOptions.addOption(decodeNoSrcOption);
            decodeOptions.addOption(decodeOutputOption);
            decodeOptions.addOption(frameDirOption);
            decodeOptions.addOption(frameTagOption);
            decodeOptions.addOption(jobsOption);
            decodeOptions.addOption(libOption);
            if (advanced) {
                decodeOptions.addOption(decodeIgnoreRawValuesOption);
                decodeOptions.addOption(decodeKeepBrokenResOption);
                decodeOptions.addOption(decodeMatchOriginalOption);
                decodeOptions.addOption(decodeNoAssetsOption);
                decodeOptions.addOption(decodeNoDebugInfoOption);
                decodeOptions.addOption(decodeOnlyManifestOption);
                decodeOptions.addOption(decodeResResolveModeOption);
            }
        }
        if (options == null || options == buildOptions) {
            buildOptions.addOption(buildForceOption);
            buildOptions.addOption(buildOutputOption);
            buildOptions.addOption(frameDirOption);
            buildOptions.addOption(jobsOption);
            buildOptions.addOption(libOption);
            if (advanced) {
                buildOptions.addOption(buildAaptOption);
                buildOptions.addOption(buildCopyOriginalOption);
                buildOptions.addOption(buildDebuggableOption);
                buildOptions.addOption(buildNetSecConfOption);
                buildOptions.addOption(buildNoApkOption);
                buildOptions.addOption(buildNoCrunchOption);
            }
        }
        if (options == null || options == installFrameworkOptions) {
            installFrameworkOptions.addOption(frameFrameDirOption);
            installFrameworkOptions.addOption(frameFrameTagOption);
        }
        if (options == null || options == cleanFrameworksOptions) {
            cleanFrameworksOptions.addOption(frameForceAllOption);
            cleanFrameworksOptions.addOption(frameFrameDirOption);
            cleanFrameworksOptions.addOption(frameFrameTagOption);
        }
        if (options == null || options == listFrameworksOptions) {
            listFrameworksOptions.addOption(frameForceAllOption);
            listFrameworksOptions.addOption(frameFrameDirOption);
            listFrameworksOptions.addOption(frameFrameTagOption);
        }
    }

    public static void main(String[] args) throws AndrolibException {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("jdk.nio.zipfs.allowDotZipEntry", "true");
        System.setProperty("jdk.util.zip.disableZip64ExtraFieldValidation", "true");
        if (!OSDetection.is64Bit()) {
            System.err.println("Warning: Apktool no longer supports 32-bit platforms.");
        }
        if (args.length == 0) {
            Main.loadOptions(null, false);
            Main.printUsage();
            return;
        }
        String cmdName = args[0];
        String[] cmdArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (cmdName) {
            case "d": 
            case "decode": {
                Main.cmdDecode(cmdArgs);
                break;
            }
            case "b": 
            case "build": {
                Main.cmdBuild(cmdArgs);
                break;
            }
            case "if": 
            case "install-framework": {
                Main.cmdInstallFramework(cmdArgs);
                break;
            }
            case "cf": 
            case "clean-frameworks": {
                Main.cmdCleanFrameworks(cmdArgs);
                break;
            }
            case "lf": 
            case "list-frameworks": {
                Main.cmdListFrameworks(cmdArgs);
                break;
            }
            case "pr": 
            case "publicize-resources": {
                Main.cmdPublicizeResources(cmdArgs);
                break;
            }
            case "h": 
            case "help": 
            case "-help": 
            case "--help": {
                Main.loadOptions(null, true);
                Main.printUsage();
                break;
            }
            case "v": 
            case "version": 
            case "-version": 
            case "--version": {
                Main.printVersion();
                break;
            }
            default: {
                System.err.println("Unrecognized command: " + cmdName);
                Main.loadOptions(null, false);
                Main.printUsage();
                System.exit(1);
            }
        }
    }

    private static CommandLine parseOptions(Options options, String[] args) {
        CommandLine cli;
        Main.loadOptions(options, true);
        Options combinedOptions = new Options();
        combinedOptions.addOptions(generalOptions);
        combinedOptions.addOptions(options);
        try {
            cli = new DefaultParser(false).parse(combinedOptions, args, false);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            Main.printUsage();
            System.exit(1);
            return null;
        }
        Verbosity verbosity = Verbosity.NORMAL;
        if (cli.hasOption(verboseOption)) {
            config.setVerbose(true);
            verbosity = Verbosity.VERBOSE;
        }
        if (cli.hasOption(quietOption)) {
            if (cli.hasOption(verboseOption)) {
                Main.printOptionConflict(quietOption, verboseOption);
            } else {
                verbosity = Verbosity.QUIET;
            }
        }
        Main.setupLogging(verbosity);
        return cli;
    }

    private static void cmdDecode(String[] args) throws AndrolibException {
        String apkName;
        CommandLine cli = Main.parseOptions(decodeOptions, args);
        List<String> argList = cli.getArgList();
        switch (argList.size()) {
            case 0: {
                System.err.println("Input apk file was not specified.");
                System.exit(1);
                return;
            }
            case 1: {
                apkName = argList.get(0);
                break;
            }
            default: {
                System.err.println("Invalid arguments.");
                Main.printUsage();
                System.exit(1);
                return;
            }
        }
        if (cli.hasOption(jobsOption)) {
            config.setJobs(Integer.parseInt(cli.getOptionValue(jobsOption)));
        }
        if (cli.hasOption(frameDirOption)) {
            config.setFrameworkDirectory(cli.getOptionValue(frameDirOption));
        }
        if (cli.hasOption(frameTagOption)) {
            config.setFrameworkTag(cli.getOptionValue(frameTagOption));
        }
        if (cli.hasOption(libOption)) {
            config.setLibraryFiles(cli.getOptionValues(libOption));
        }
        if (cli.hasOption(decodeForceOption)) {
            config.setForced(true);
        }
        if (cli.hasOption(decodeAllSrcOption)) {
            config.setDecodeSources(Config.DecodeSources.FULL);
        }
        if (cli.hasOption(decodeNoSrcOption)) {
            if (cli.hasOption(decodeAllSrcOption)) {
                Main.printOptionConflict(decodeNoSrcOption, decodeAllSrcOption);
            } else {
                config.setDecodeSources(Config.DecodeSources.NONE);
            }
        }
        if (cli.hasOption(decodeNoDebugInfoOption)) {
            if (cli.hasOption(decodeNoSrcOption)) {
                Main.printOptionConflict(decodeNoDebugInfoOption, decodeNoSrcOption);
            } else {
                config.setBaksmaliDebugMode(false);
            }
        }
        if (cli.hasOption(decodeNoResOption)) {
            config.setDecodeResources(Config.DecodeResources.NONE);
        }
        if (cli.hasOption(decodeOnlyManifestOption)) {
            if (cli.hasOption(decodeNoResOption)) {
                Main.printOptionConflict(decodeOnlyManifestOption, decodeNoResOption);
            } else {
                config.setDecodeResources(Config.DecodeResources.ONLY_MANIFEST);
            }
        }
        if (cli.hasOption(decodeResResolveModeOption)) {
            if (cli.hasOption(decodeNoResOption)) {
                Main.printOptionConflict(decodeResResolveModeOption, decodeNoResOption);
            } else if (cli.hasOption(decodeOnlyManifestOption)) {
                Main.printOptionConflict(decodeResResolveModeOption, decodeOnlyManifestOption);
            } else {
                String mode;
                switch (mode = cli.getOptionValue(decodeResResolveModeOption)) {
                    case "default": {
                        config.setDecodeResolve(Config.DecodeResolve.DEFAULT);
                        break;
                    }
                    case "greedy": {
                        config.setDecodeResolve(Config.DecodeResolve.GREEDY);
                        break;
                    }
                    case "lazy": {
                        config.setDecodeResolve(Config.DecodeResolve.LAZY);
                        break;
                    }
                    default: {
                        System.err.println("Unknown resolve resources mode: " + mode);
                        System.err.println("Expect: 'default', 'greedy' or 'lazy'.");
                        System.exit(1);
                        return;
                    }
                }
            }
        }
        if (cli.hasOption(decodeKeepBrokenResOption)) {
            if (cli.hasOption(decodeNoResOption)) {
                Main.printOptionConflict(decodeKeepBrokenResOption, decodeNoResOption);
            } else if (cli.hasOption(decodeOnlyManifestOption)) {
                Main.printOptionConflict(decodeKeepBrokenResOption, decodeOnlyManifestOption);
            } else {
                config.setKeepBrokenResources(true);
            }
        }
        if (cli.hasOption(decodeIgnoreRawValuesOption)) {
            if (cli.hasOption(decodeNoResOption)) {
                Main.printOptionConflict(decodeIgnoreRawValuesOption, decodeNoResOption);
            } else {
                config.setIgnoreRawValues(true);
            }
        }
        if (cli.hasOption(decodeMatchOriginalOption)) {
            config.setAnalysisMode(true);
        }
        if (cli.hasOption(decodeNoAssetsOption)) {
            config.setDecodeAssets(Config.DecodeAssets.NONE);
        }
        File outDir = cli.hasOption(decodeOutputOption) ? new File(cli.getOptionValue(decodeOutputOption)) : new File(apkName.endsWith(".apk") ? apkName.substring(0, apkName.length() - 4).trim() : apkName + ".out");
        try {
            new ApkDecoder(new File(apkName), config).decode(outDir);
        }
        catch (FrameworkNotFoundException | InFileNotFoundException | OutDirExistsException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private static void cmdBuild(String[] args) throws AndrolibException {
        String apkDirName;
        CommandLine cli = Main.parseOptions(buildOptions, args);
        List<String> argList = cli.getArgList();
        switch (argList.size()) {
            case 0: {
                apkDirName = ".";
                break;
            }
            case 1: {
                apkDirName = argList.get(0);
                break;
            }
            default: {
                System.err.println("Invalid arguments.");
                Main.printUsage();
                System.exit(1);
                return;
            }
        }
        if (cli.hasOption(jobsOption)) {
            config.setJobs(Integer.parseInt(cli.getOptionValue(jobsOption)));
        }
        if (cli.hasOption(frameDirOption)) {
            config.setFrameworkDirectory(cli.getOptionValue(frameDirOption));
        }
        if (cli.hasOption(libOption)) {
            config.setLibraryFiles(cli.getOptionValues(libOption));
        }
        if (cli.hasOption(buildForceOption)) {
            config.setForced(true);
        }
        if (cli.hasOption(buildNoApkOption)) {
            config.setNoApk(true);
        }
        if (cli.hasOption(buildNoCrunchOption)) {
            config.setNoCrunch(true);
        }
        if (cli.hasOption(buildCopyOriginalOption)) {
            config.setCopyOriginal(true);
        }
        if (cli.hasOption(buildDebuggableOption)) {
            config.setDebuggable(true);
        }
        if (cli.hasOption(buildNetSecConfOption)) {
            config.setNetSecConf(true);
        }
        if (cli.hasOption(buildAaptOption)) {
            try {
                String aaptBinary = cli.getOptionValue(buildAaptOption);
                if (AaptManager.getBinaryVersion(new File(aaptBinary)) == 1) {
                    throw new AndrolibException("Legacy aapt is no longer supported.");
                }
                config.setAaptBinary(aaptBinary);
            }
            catch (AndrolibException ex) {
                System.err.println(ex.getMessage());
                System.exit(1);
                return;
            }
        }
        File outFile = null;
        if (cli.hasOption(buildOutputOption)) {
            if (cli.hasOption(buildNoApkOption)) {
                Main.printOptionConflict(buildOutputOption, buildNoApkOption);
            } else {
                outFile = new File(cli.getOptionValue(buildOutputOption));
            }
        }
        new ApkBuilder(new File(apkDirName), config).build(outFile);
    }

    private static void cmdInstallFramework(String[] args) throws AndrolibException {
        String apkName;
        CommandLine cli = Main.parseOptions(installFrameworkOptions, args);
        List<String> argList = cli.getArgList();
        switch (argList.size()) {
            case 0: {
                System.err.println("Input apk file was not specified.");
                System.exit(1);
                return;
            }
            case 1: {
                apkName = argList.get(0);
                break;
            }
            default: {
                System.err.println("Invalid arguments.");
                Main.printUsage();
                System.exit(1);
                return;
            }
        }
        if (cli.hasOption(frameFrameDirOption)) {
            config.setFrameworkDirectory(cli.getOptionValue(frameFrameDirOption));
        }
        if (cli.hasOption(frameFrameTagOption)) {
            config.setFrameworkTag(cli.getOptionValue(frameFrameTagOption));
        }
        new Framework(config).install(new File(apkName));
    }

    private static void cmdCleanFrameworks(String[] args) throws AndrolibException {
        CommandLine cli = Main.parseOptions(cleanFrameworksOptions, args);
        List<String> argList = cli.getArgList();
        if (!argList.isEmpty()) {
            System.err.println("Invalid arguments.");
            Main.printUsage();
            System.exit(1);
            return;
        }
        if (cli.hasOption(frameFrameDirOption)) {
            config.setFrameworkDirectory(cli.getOptionValue(frameFrameDirOption));
        }
        if (cli.hasOption(frameFrameTagOption)) {
            config.setFrameworkTag(cli.getOptionValue(frameFrameTagOption));
        }
        if (cli.hasOption(frameForceAllOption)) {
            if (cli.hasOption(frameFrameTagOption)) {
                Main.printOptionConflict(frameForceAllOption, frameFrameTagOption);
            } else {
                config.setForced(true);
            }
        }
        new Framework(config).cleanDirectory();
    }

    private static void cmdListFrameworks(String[] args) throws AndrolibException {
        CommandLine cli = Main.parseOptions(listFrameworksOptions, args);
        List<String> argList = cli.getArgList();
        if (!argList.isEmpty()) {
            System.err.println("Invalid arguments.");
            Main.printUsage();
            System.exit(1);
            return;
        }
        if (cli.hasOption(frameFrameDirOption)) {
            config.setFrameworkDirectory(cli.getOptionValue(frameFrameDirOption));
        }
        if (cli.hasOption(frameFrameTagOption)) {
            config.setFrameworkTag(cli.getOptionValue(frameFrameTagOption));
        }
        if (cli.hasOption(frameForceAllOption)) {
            if (cli.hasOption(frameFrameTagOption)) {
                Main.printOptionConflict(frameForceAllOption, frameFrameTagOption);
            } else {
                config.setForced(true);
            }
        }
        for (File file : new Framework(config).listDirectory()) {
            System.out.println(file.getName());
        }
    }

    private static void cmdPublicizeResources(String[] args) throws AndrolibException {
        String arscName;
        CommandLine cli = Main.parseOptions(publicizeResourcesOptions, args);
        List<String> argList = cli.getArgList();
        switch (argList.size()) {
            case 0: {
                System.err.println("Input arsc file was not specified.");
                System.exit(1);
                return;
            }
            case 1: {
                arscName = argList.get(0);
                break;
            }
            default: {
                System.err.println("Invalid arguments.");
                Main.printUsage();
                System.exit(1);
                return;
            }
        }
        new Framework(config).publicizeResources(new File(arscName));
    }

    private static void printOptionConflict(Option option, Option conflict) {
        System.err.println("Ignoring " + Main.formatOption(option) + " (cannot be used with " + Main.formatOption(conflict) + ")");
    }

    private static String formatOption(Option option) {
        String longName;
        StringBuilder sb = new StringBuilder();
        String shortName = option.getOpt();
        if (shortName != null) {
            sb.append('-').append(shortName);
        }
        if ((longName = option.getLongOpt()) != null) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append("--").append(longName);
        }
        return sb.toString();
    }

    private static void printUsage() {
        PrintWriter writer = new PrintWriter(System.out);
        HelpFormatter formatter = new HelpFormatter();
        writer.println("Apktool " + props.getVersion() + " - a tool for reengineering Android apk files");
        writer.println("with smali " + props.getSmaliVersion() + " and baksmali " + props.getBaksmaliVersion());
        writer.println("Copyright 2010 Ryszard Wi\u015bniewski <brut.alll@gmail.com>");
        writer.println("Copyright 2010 Connor Tumbleson <connor.tumbleson@gmail.com>");
        if (advancedMode) {
            writer.println("Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)");
        }
        writer.println();
        writer.println("General options:");
        Main.printOptions(writer, formatter, generalOptions);
        writer.println();
        if (loadedOptions == null || loadedOptions == decodeOptions) {
            writer.println("apktool d|decode [options] <apk-file>");
            Main.printOptions(writer, formatter, decodeOptions);
            writer.println();
        }
        if (loadedOptions == null || loadedOptions == buildOptions) {
            writer.println("apktool b|build [options] <apk-dir>");
            Main.printOptions(writer, formatter, buildOptions);
            writer.println();
        }
        if (loadedOptions == null || loadedOptions == installFrameworkOptions) {
            writer.println("apktool if|install-framework [options] <apk-file>");
            Main.printOptions(writer, formatter, installFrameworkOptions);
            writer.println();
        }
        if (advancedMode && loadedOptions == null || loadedOptions == cleanFrameworksOptions) {
            writer.println("apktool cf|clean-frameworks [options]");
            Main.printOptions(writer, formatter, cleanFrameworksOptions);
            writer.println();
        }
        if (advancedMode && loadedOptions == null || loadedOptions == listFrameworksOptions) {
            writer.println("apktool lf|list-frameworks [options]");
            Main.printOptions(writer, formatter, listFrameworksOptions);
            writer.println();
        }
        if (advancedMode && loadedOptions == null || loadedOptions == publicizeResourcesOptions) {
            writer.println("apktool pr|publicize-resources <arsc-file>");
            Main.printOptions(writer, formatter, publicizeResourcesOptions);
            writer.println();
        }
        if (loadedOptions == null) {
            writer.println("apktool h|help");
            writer.println();
            writer.println("apktool v|version");
            writer.println();
        }
        writer.println("For additional info, see: https://apktool.org");
        writer.println("For smali/baksmali info, see: https://github.com/google/smali");
        writer.flush();
    }

    private static void printOptions(PrintWriter writer, HelpFormatter formatter, Options options) {
        int width = 120;
        boolean leftPadding = true;
        int descPadding = 3;
        if (!options.getOptions().isEmpty()) {
            formatter.printOptions(writer, 120, options, 1, 3);
        }
    }

    private static void printVersion() {
        System.out.println(props.getVersion());
    }

    private static void setupLogging(Verbosity verbosity) {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("");
        if (verbosity == Verbosity.QUIET) {
            logger.setLevel(Level.OFF);
            return;
        }
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (!this.isLoggable(record)) {
                    return;
                }
                try {
                    String message = this.getFormatter().format(record);
                    int level = record.getLevel().intValue();
                    if (level >= Level.WARNING.intValue()) {
                        System.err.println(message);
                    } else {
                        System.out.println(message);
                    }
                }
                catch (Exception ex) {
                    this.reportError(null, ex, 5);
                }
            }

            @Override
            public void flush() {
                System.out.flush();
                System.err.flush();
            }

            @Override
            public void close() throws SecurityException {
                this.flush();
            }
        };
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                int level = record.getLevel().intValue();
                String prefix = level >= Level.SEVERE.intValue() ? "E" : (level >= Level.WARNING.intValue() ? "W" : (level >= Level.INFO.intValue() ? "I" : "D"));
                return prefix + ": " + record.getMessage();
            }
        });
        logger.addHandler(handler);
        logger.setLevel(verbosity == Verbosity.VERBOSE ? Level.ALL : Level.INFO);
    }

    private static enum Verbosity {
        NORMAL,
        VERBOSE,
        QUIET;

    }

    private static class Props
    extends Properties {
        public Props() {
            this.load(this, "/apktool.properties");
            Properties smaliProps = new Properties();
            this.load(smaliProps, "/smali.properties");
            String smaliVersion = smaliProps.getProperty("application.version", "");
            if (!smaliVersion.isEmpty()) {
                this.put("smali.version", smaliVersion);
            }
            Properties baksmaliProps = new Properties();
            this.load(baksmaliProps, "/baksmali.properties");
            String baksmaliVersion = baksmaliProps.getProperty("application.version", "");
            if (!baksmaliVersion.isEmpty()) {
                this.put("baksmali.version", baksmaliVersion);
            }
        }

        public String getVersion() {
            return this.getProperty("application.version", "(unknown)");
        }

        public String getSmaliVersion() {
            return this.getProperty("smali.version", "(unknown)");
        }

        public String getBaksmaliVersion() {
            return this.getProperty("baksmali.version", "(unknown)");
        }

        private void load(Properties props, String name) {
            try (InputStream in = Main.class.getResourceAsStream(name);){
                if (in == null) {
                    throw new FileNotFoundException(name);
                }
                props.load(in);
            }
            catch (IOException ignored) {
                System.err.println("Could not load resource: " + name);
            }
        }
    }
}

