/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.explainer;

import com.google.archivepatcher.explainer.EntryExplanation;
import com.google.archivepatcher.generator.ByteArrayHolder;
import com.google.archivepatcher.generator.DeltaGenerator;
import com.google.archivepatcher.generator.MinimalZipArchive;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.PreDiffExecutor;
import com.google.archivepatcher.generator.PreDiffPlan;
import com.google.archivepatcher.generator.QualifiedRecommendation;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.RecommendationReason;
import com.google.archivepatcher.generator.TempFileHolder;
import com.google.archivepatcher.shared.Compressor;
import com.google.archivepatcher.shared.DeflateUncompressor;
import com.google.archivepatcher.shared.RandomAccessFileInputStream;
import com.google.archivepatcher.shared.Uncompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchExplainer {
    private final Compressor compressor;
    private final DeltaGenerator deltaGenerator;

    public PatchExplainer(Compressor compressor, DeltaGenerator deltaGenerator) {
        this.compressor = compressor;
        this.deltaGenerator = deltaGenerator;
    }

    public List<EntryExplanation> explainPatch(File oldFile, File newFile, RecommendationModifier ... recommendationModifiers) throws IOException, InterruptedException {
        ArrayList<EntryExplanation> result = new ArrayList<EntryExplanation>();
        Map<ByteArrayHolder, MinimalZipEntry> allOldEntries = PatchExplainer.mapEntries(oldFile);
        Map<ByteArrayHolder, MinimalZipEntry> allNewEntries = PatchExplainer.mapEntries(newFile);
        HashMap<ByteArrayHolder, MinimalZipEntry> completelyNewEntries = new HashMap<ByteArrayHolder, MinimalZipEntry>(allNewEntries);
        completelyNewEntries.keySet().removeAll(allOldEntries.keySet());
        for (Map.Entry entry : completelyNewEntries.entrySet()) {
            long compressedSize = this.getCompressedSize(newFile, (MinimalZipEntry)entry.getValue(), this.compressor);
            result.add(new EntryExplanation(new ByteArrayHolder(((MinimalZipEntry)entry.getValue()).getFileNameBytes()), true, null, compressedSize));
        }
        DeflateUncompressor uncompressor = new DeflateUncompressor();
        PreDiffExecutor.Builder builder = new PreDiffExecutor.Builder().readingOriginalFiles(oldFile, newFile);
        for (RecommendationModifier modifier : recommendationModifiers) {
            builder.withRecommendationModifier(modifier);
        }
        PreDiffExecutor executor = builder.build();
        PreDiffPlan plan = executor.prepareForDiffing();
        try (TempFileHolder oldTemp = new TempFileHolder();
             TempFileHolder newTemp = new TempFileHolder();
             TempFileHolder deltaTemp = new TempFileHolder();){
            for (QualifiedRecommendation qualifiedRecommendation : plan.getQualifiedRecommendations()) {
                if (qualifiedRecommendation.getReason() == RecommendationReason.COMPRESSED_BYTES_IDENTICAL) {
                    result.add(new EntryExplanation(new ByteArrayHolder(qualifiedRecommendation.getNewEntry().getFileNameBytes()), false, qualifiedRecommendation.getReason(), 0L));
                    continue;
                }
                if (qualifiedRecommendation.getOldEntry().getCrc32OfUncompressedData() == qualifiedRecommendation.getNewEntry().getCrc32OfUncompressedData() && qualifiedRecommendation.getOldEntry().getUncompressedSize() == qualifiedRecommendation.getNewEntry().getUncompressedSize()) {
                    result.add(new EntryExplanation(new ByteArrayHolder(qualifiedRecommendation.getNewEntry().getFileNameBytes()), false, qualifiedRecommendation.getReason(), 0L));
                    continue;
                }
                long oldOffset = qualifiedRecommendation.getOldEntry().getFileOffsetOfCompressedData();
                long oldLength = qualifiedRecommendation.getOldEntry().getCompressedSize();
                if (qualifiedRecommendation.getRecommendation().uncompressOldEntry) {
                    this.uncompress(oldFile, oldOffset, oldLength, (Uncompressor)uncompressor, oldTemp.file);
                } else {
                    this.extractCopy(oldFile, oldOffset, oldLength, oldTemp.file);
                }
                long newOffset = qualifiedRecommendation.getNewEntry().getFileOffsetOfCompressedData();
                long newLength = qualifiedRecommendation.getNewEntry().getCompressedSize();
                if (qualifiedRecommendation.getRecommendation().uncompressNewEntry) {
                    this.uncompress(newFile, newOffset, newLength, (Uncompressor)uncompressor, newTemp.file);
                } else {
                    this.extractCopy(newFile, newOffset, newLength, newTemp.file);
                }
                FileOutputStream deltaOut = new FileOutputStream(deltaTemp.file);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bufferedDeltaOut = new BufferedOutputStream(deltaOut);
                    Throwable throwable2 = null;
                    try {
                        this.deltaGenerator.generateDelta(oldTemp.file, newTemp.file, (OutputStream)bufferedDeltaOut);
                        bufferedDeltaOut.flush();
                        long compressedDeltaSize = this.getCompressedSize(deltaTemp.file, 0L, deltaTemp.file.length(), this.compressor);
                        result.add(new EntryExplanation(new ByteArrayHolder(qualifiedRecommendation.getOldEntry().getFileNameBytes()), false, qualifiedRecommendation.getReason(), compressedDeltaSize));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedDeltaOut == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedDeltaOut.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedDeltaOut.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (deltaOut == null) continue;
                    if (throwable != null) {
                        try {
                            deltaOut.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    deltaOut.close();
                }
            }
        }
        return result;
    }

    private long getCompressedSize(File file, MinimalZipEntry entry, Compressor compressor) throws IOException {
        return this.getCompressedSize(file, entry.getFileOffsetOfCompressedData(), entry.getCompressedSize(), compressor);
    }

    private void uncompress(File source, long offset, long length, Uncompressor uncompressor, File dest) throws IOException {
        try (RandomAccessFileInputStream rafis = new RandomAccessFileInputStream(source, offset, length);
             FileOutputStream out = new FileOutputStream(dest);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
            uncompressor.uncompress((InputStream)rafis, (OutputStream)bufferedOut);
        }
    }

    private void extractCopy(File source, long offset, long length, File dest) throws IOException {
        try (RandomAccessFileInputStream rafis = new RandomAccessFileInputStream(source, offset, length);
             FileOutputStream out = new FileOutputStream(dest);
             BufferedOutputStream bufferedOut = new BufferedOutputStream(out);){
            byte[] buffer = new byte[32768];
            int numRead = 0;
            while ((numRead = rafis.read(buffer)) >= 0) {
                bufferedOut.write(buffer, 0, numRead);
            }
            bufferedOut.flush();
        }
    }

    /*
     * Exception decompiling
     */
    private long getCompressedSize(File file, long offset, long length, Compressor compressor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<ByteArrayHolder, MinimalZipEntry> mapEntries(File file) throws IOException {
        List allEntries = MinimalZipArchive.listEntries((File)file);
        HashMap<ByteArrayHolder, MinimalZipEntry> result = new HashMap<ByteArrayHolder, MinimalZipEntry>(allEntries.size());
        for (MinimalZipEntry entry : allEntries) {
            result.put(new ByteArrayHolder(entry.getFileNameBytes()), entry);
        }
        return result;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

