/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver;

import com.android.fakeadbserver.ClientState;
import com.android.fakeadbserver.FakeAdbServer;
import com.android.fakeadbserver.statechangehubs.ClientStateChangeHandlerFactory;
import com.android.fakeadbserver.statechangehubs.ClientStateChangeHub;
import com.android.fakeadbserver.statechangehubs.StateChangeQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceState {
    protected final ClientStateChangeHub mClientStateChangeHub = new ClientStateChangeHub();
    protected final Map<String, byte[]> mPathsToFiles = new HashMap<String, byte[]>();
    protected final List<String> mLogcatMessages = new ArrayList<String>();
    protected final Map<Integer, ClientState> mClients = new HashMap<Integer, ClientState>();
    protected FakeAdbServer mServer;
    protected HostConnectionType mHostConnectionType;
    protected String mDeviceId;
    protected String mManufacturer;
    protected String mModel;
    protected String mBuildVersionRelease;
    protected String mBuildVersionSdk;
    protected DeviceStatus mDeviceStatus;

    DeviceState(FakeAdbServer server, String deviceId, String manufacturer, String model, String release, String sdk, HostConnectionType hostConnectionType) {
        this.mServer = server;
        this.mDeviceId = deviceId;
        this.mManufacturer = manufacturer;
        this.mModel = model;
        this.mBuildVersionRelease = release;
        this.mBuildVersionSdk = sdk;
        this.mHostConnectionType = hostConnectionType;
        this.mDeviceStatus = DeviceStatus.OFFLINE;
    }

    public void stop() {
        this.mClientStateChangeHub.stop();
    }

    public String getDeviceId() {
        return this.mDeviceId;
    }

    public String getManufacturer() {
        return this.mManufacturer;
    }

    public String getModel() {
        return this.mModel;
    }

    public String getBuildVersionRelease() {
        return this.mBuildVersionRelease;
    }

    public String getBuildVersionSdk() {
        return this.mBuildVersionSdk;
    }

    public DeviceStatus getDeviceStatus() {
        return this.mDeviceStatus;
    }

    public void setDeviceStatus(DeviceStatus status) {
        this.mDeviceStatus = status;
        this.mServer.getDeviceChangeHub().deviceStatusChanged(this, status);
    }

    public ClientStateChangeHub getClientChangeHub() {
        return this.mClientStateChangeHub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogcatMessage(String message) {
        List<String> list = this.mLogcatMessages;
        synchronized (list) {
            this.mLogcatMessages.add(message);
            this.mClientStateChangeHub.logcatMessageAdded(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogcatChangeHandlerSubscriptionResult subscribeLogcatChangeHandler(ClientStateChangeHandlerFactory handlerFactory) {
        List<String> list = this.mLogcatMessages;
        synchronized (list) {
            StateChangeQueue queue = this.getClientChangeHub().subscribe(handlerFactory);
            if (queue == null) {
                return null;
            }
            return new LogcatChangeHandlerSubscriptionResult(queue, new ArrayList<String>(this.mLogcatMessages));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile(String filepath, byte[] data) {
        Map<String, byte[]> map = this.mPathsToFiles;
        synchronized (map) {
            this.mPathsToFiles.put(filepath, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFile(String filepath) {
        Map<String, byte[]> map = this.mPathsToFiles;
        synchronized (map) {
            return this.mPathsToFiles.get(filepath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientState startClient(int pid, int uid, String packageName, boolean isWaiting) {
        Map<Integer, ClientState> map = this.mClients;
        synchronized (map) {
            ClientState clientState = new ClientState(pid, uid, packageName, isWaiting);
            this.mClients.put(pid, clientState);
            this.mClientStateChangeHub.clientListChanged(this.getClientListCopy());
            return clientState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClient(int pid) {
        Map<Integer, ClientState> map = this.mClients;
        synchronized (map) {
            this.mClients.remove(pid);
            this.mClientStateChangeHub.clientListChanged(this.getClientListCopy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientState getClient(int pid) {
        Map<Integer, ClientState> map = this.mClients;
        synchronized (map) {
            return this.mClients.get(pid);
        }
    }

    public HostConnectionType getHostConnectionType() {
        return this.mHostConnectionType;
    }

    private List<ClientState> getClientListCopy() {
        return new ArrayList<ClientState>(this.mClients.values());
    }

    public static final class LogcatChangeHandlerSubscriptionResult {
        public final StateChangeQueue mQueue;
        public final List<String> mLogcatContents;

        public LogcatChangeHandlerSubscriptionResult(StateChangeQueue queue, List<String> logcatContents) {
            this.mQueue = queue;
            this.mLogcatContents = logcatContents;
        }
    }

    public static enum HostConnectionType {
        USB,
        LOCAL;

    }

    public static enum DeviceStatus {
        BOOTLOADER("bootloader"),
        OFFLINE("offline"),
        ONLINE("device"),
        RECOVERY("recovery"),
        SIDELOAD("sideload"),
        UNAUTHORIZED("unauthorized"),
        DISCONNECTED("disconnected");

        private String mState;

        private DeviceStatus(String state) {
            this.mState = state;
        }

        public static DeviceStatus getState(String state) {
            for (DeviceStatus deviceStatus : DeviceStatus.values()) {
                if (!deviceStatus.mState.equals(state)) continue;
                return deviceStatus;
            }
            return null;
        }

        public String getState() {
            return this.mState;
        }
    }
}

