/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.TablePanel;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SysinfoPanel
extends TablePanel {
    private Label mLabel;
    private Button mFetchButton;
    private Combo mDisplayMode;
    private DefaultPieDataset mDataset;
    private DefaultCategoryDataset mBarDataSet;
    private StackLayout mStackLayout;
    private Composite mChartComposite;
    private Composite mPieChartComposite;
    private Composite mStackedBarComposite;
    private int mMode = 0;
    private String mGfxPackageName;
    private static final Object RECEIVER_LOCK = new Object();
    private ShellOutputReceiver mLastOutputReceiver;
    private static final int MODE_CPU = 0;
    private static final int MODE_MEMINFO = 1;
    private static final int MODE_GFXINFO = 2;
    private static final String[] DUMP_COMMAND = new String[]{"dumpsys cpuinfo", "cat /proc/meminfo ; procrank", "dumpsys gfxinfo"};
    private static final String[] CAPTIONS = new String[]{"CPU load", "Memory usage", "Frame Render Time"};
    private static final String PROP_GFX_PROFILING = "debug.hwui.profile";

    private void generateDataset(File file) {
        if (file == null) {
            return;
        }
        try {
            BufferedReader br = this.getBugreportReader(file);
            if (this.mMode == 0) {
                this.readCpuDataset(br);
            } else if (this.mMode == 1) {
                this.readMeminfoDataset(br);
            } else if (this.mMode == 2) {
                this.readGfxInfoDataset(br);
            }
            br.close();
        }
        catch (IOException e) {
            Log.e((String)"DDMS", (Throwable)e);
        }
    }

    @Override
    public void deviceSelected() {
        if (this.getCurrentDevice() != null) {
            this.mFetchButton.setEnabled(true);
            this.loadFromDevice();
        } else {
            this.mFetchButton.setEnabled(false);
        }
    }

    @Override
    public void clientSelected() {
    }

    @Override
    public void setFocus() {
        this.mDisplayMode.setFocus();
    }

    private void loadFromDevice() {
        String command;
        boolean en;
        this.clearDataSet();
        if (this.mMode == 2 && !(en = this.isGfxProfilingEnabled())) {
            if (this.enableGfxProfiling()) {
                MessageDialog.openInformation(Display.getCurrent().getActiveShell(), "DDMS", "Graphics profiling was enabled on the device.\nIt may be necessary to relaunch your application to see profile information.");
            } else {
                MessageDialog.openError(Display.getCurrent().getActiveShell(), "DDMS", "Unexpected error enabling graphics profiling on device.\n");
                return;
            }
        }
        if ((command = this.getDumpsysCommand(this.mMode)) == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String header = null;
                    if (SysinfoPanel.this.mMode == 1) {
                        header = "------ MEMORY INFO ------\n";
                    }
                    IShellOutputReceiver receiver = SysinfoPanel.this.initShellOutputBuffer(header);
                    SysinfoPanel.this.getCurrentDevice().executeShellCommand(command, receiver);
                }
                catch (IOException e) {
                    Log.e((String)"DDMS", (Throwable)e);
                }
                catch (TimeoutException e) {
                    Log.e((String)"DDMS", (Throwable)e);
                }
                catch (AdbCommandRejectedException e) {
                    Log.e((String)"DDMS", (Throwable)e);
                }
                catch (ShellCommandUnresponsiveException e) {
                    Log.e((String)"DDMS", (Throwable)e);
                }
            }
        }, "Sysinfo Output Collector");
        t.start();
    }

    private boolean isGfxProfilingEnabled() {
        IDevice device = this.getCurrentDevice();
        if (device == null) {
            return false;
        }
        try {
            String prop = device.getPropertySync(PROP_GFX_PROFILING);
            return Boolean.valueOf(prop);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean enableGfxProfiling() {
        IDevice device = this.getCurrentDevice();
        if (device == null) {
            return false;
        }
        try {
            device.executeShellCommand("setprop debug.hwui.profile true", (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getDumpsysCommand(int mode) {
        if (mode == 2) {
            Client c = this.getCurrentClient();
            if (c == null) {
                return null;
            }
            ClientData cd = c.getClientData();
            if (cd == null) {
                return null;
            }
            this.mGfxPackageName = cd.getClientDescription();
            if (this.mGfxPackageName == null) {
                return null;
            }
            return "dumpsys gfxinfo " + this.mGfxPackageName;
        }
        if (mode < DUMP_COMMAND.length) {
            return DUMP_COMMAND[mode];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IShellOutputReceiver initShellOutputBuffer(String header) throws IOException {
        File f = File.createTempFile("ddmsfile", ".txt");
        f.deleteOnExit();
        Object object = RECEIVER_LOCK;
        synchronized (object) {
            if (this.mLastOutputReceiver != null) {
                this.mLastOutputReceiver.cancel();
            }
            this.mLastOutputReceiver = new ShellOutputReceiver(f, header);
        }
        return this.mLastOutputReceiver;
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        top.setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(top, 0);
        buttons.setLayout((Layout)new RowLayout());
        this.mDisplayMode = new Combo(buttons, 8);
        for (String mode : CAPTIONS) {
            this.mDisplayMode.add(mode);
        }
        this.mDisplayMode.select(this.mMode);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysinfoPanel.this.mMode = SysinfoPanel.this.mDisplayMode.getSelectionIndex();
                if (SysinfoPanel.this.getCurrentDevice() != null) {
                    SysinfoPanel.this.loadFromDevice();
                }
            }
        });
        this.mFetchButton = new Button(buttons, 8);
        this.mFetchButton.setText("Update from Device");
        this.mFetchButton.setEnabled(false);
        this.mFetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysinfoPanel.this.loadFromDevice();
            }
        });
        this.mLabel = new Label(top, 0);
        this.mLabel.setLayoutData((Object)new GridData(768));
        this.mChartComposite = new Composite(top, 0);
        this.mChartComposite.setLayoutData((Object)new GridData(1808));
        this.mStackLayout = new StackLayout();
        this.mChartComposite.setLayout((Layout)this.mStackLayout);
        this.mPieChartComposite = this.createPieChartComposite(this.mChartComposite);
        this.mStackedBarComposite = this.createStackedBarComposite(this.mChartComposite);
        this.mStackLayout.topControl = this.mPieChartComposite;
        return top;
    }

    private Composite createStackedBarComposite(Composite chartComposite) {
        this.mBarDataSet = new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createStackedBarChart((String)"Per Frame Rendering Time", (String)"Frame #", (String)"Time (ms)", (CategoryDataset)this.mBarDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartComposite c = this.newChartComposite(chart, chartComposite);
        c.setLayoutData((Object)new GridData(1808));
        return c;
    }

    private Composite createPieChartComposite(Composite chartComposite) {
        this.mDataset = new DefaultPieDataset();
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)this.mDataset, (boolean)false, (boolean)true, (boolean)false);
        ChartComposite c = this.newChartComposite(chart, chartComposite);
        c.setLayoutData((Object)new GridData(1808));
        return c;
    }

    private ChartComposite newChartComposite(JFreeChart chart, Composite parent) {
        return new ChartComposite(parent, 2048, chart, 420, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
    }

    public void clientChanged(Client client, int changeMask) {
    }

    private BufferedReader getBugreportReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    private static long parseTimeMs(String s) {
        long total = 0L;
        Pattern p = Pattern.compile("([\\d\\.]+)\\s*([a-z]+)");
        Matcher m = p.matcher(s);
        while (m.find()) {
            String label = m.group(2);
            if ("sec".equals(label)) {
                total += (long)(Double.parseDouble(m.group(1)) * 1000.0);
                continue;
            }
            long value = Integer.parseInt(m.group(1));
            if ("d".equals(label)) {
                total += value * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("h".equals(label)) {
                total += value * 60L * 60L * 1000L;
                continue;
            }
            if ("m".equals(label)) {
                total += value * 60L * 1000L;
                continue;
            }
            if ("s".equals(label)) {
                total += value * 1000L;
                continue;
            }
            if (!"ms".equals(label)) continue;
            total += value;
        }
        return total;
    }

    private void readCpuDataset(BufferedReader br) throws IOException {
        this.updatePieDataSet(BugReportParser.readCpuDataset(br), "");
    }

    private void readMeminfoDataset(BufferedReader br) throws IOException {
        this.updatePieDataSet(BugReportParser.readMeminfoDataset(br), "PSS in kB");
    }

    private void readGfxInfoDataset(BufferedReader br) throws IOException {
        this.updateBarChartDataSet(BugReportParser.parseGfxInfo(br), this.mGfxPackageName == null ? "" : this.mGfxPackageName);
    }

    private void clearDataSet() {
        this.mLabel.setText("");
        this.mDataset.clear();
        this.mBarDataSet.clear();
    }

    private void updatePieDataSet(final List<BugReportParser.DataValue> data, final String label) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SysinfoPanel.this.mLabel.setText(label);
                ((SysinfoPanel)SysinfoPanel.this).mStackLayout.topControl = SysinfoPanel.this.mPieChartComposite;
                SysinfoPanel.this.mChartComposite.layout();
                for (BugReportParser.DataValue d : data) {
                    SysinfoPanel.this.mDataset.setValue((Comparable)((Object)d.name), d.value);
                }
            }
        });
    }

    private void updateBarChartDataSet(final List<BugReportParser.GfxProfileData> gfxProfileData, final String label) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SysinfoPanel.this.mLabel.setText(label);
                ((SysinfoPanel)SysinfoPanel.this).mStackLayout.topControl = SysinfoPanel.this.mStackedBarComposite;
                SysinfoPanel.this.mChartComposite.layout();
                for (int i = 0; i < gfxProfileData.size(); ++i) {
                    BugReportParser.GfxProfileData d = (BugReportParser.GfxProfileData)gfxProfileData.get(i);
                    String frameNumber = Integer.toString(i);
                    SysinfoPanel.this.mBarDataSet.addValue(d.draw, (Comparable)((Object)"Draw"), (Comparable)((Object)frameNumber));
                    SysinfoPanel.this.mBarDataSet.addValue(d.process, (Comparable)((Object)"Process"), (Comparable)((Object)frameNumber));
                    SysinfoPanel.this.mBarDataSet.addValue(d.execute, (Comparable)((Object)"Execute"), (Comparable)((Object)frameNumber));
                }
            }
        });
    }

    private class ShellOutputReceiver
    implements IShellOutputReceiver {
        private final OutputStream mStream;
        private final File mFile;
        private AtomicBoolean mCancelled = new AtomicBoolean();

        public ShellOutputReceiver(File f, String header) {
            this.mFile = f;
            try {
                this.mStream = new FileOutputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if (header != null) {
                byte[] data = header.getBytes();
                this.addOutput(data, 0, data.length);
            }
        }

        public void addOutput(byte[] data, int offset, int length) {
            try {
                this.mStream.write(data, offset, length);
            }
            catch (IOException e) {
                Log.e((String)"DDMS", (Throwable)e);
            }
        }

        public void flush() {
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                Log.e((String)"DDMS", (Throwable)e);
            }
            if (!this.isCancelled()) {
                SysinfoPanel.this.generateDataset(this.mFile);
            }
        }

        public boolean isCancelled() {
            return this.mCancelled.get();
        }

        public void cancel() {
            this.mCancelled.set(true);
        }

        public File getDataFile() {
            return this.mFile;
        }
    }

    public static final class BugReportParser {
        public static List<GfxProfileData> parseGfxInfo(BufferedReader br) throws IOException {
            Matcher m;
            Matcher m2;
            Pattern headerPattern = Pattern.compile("\\s+Draw\\s+Process\\s+Execute");
            String line = null;
            while ((line = br.readLine()) != null && !(m2 = headerPattern.matcher(line)).find()) {
            }
            if (line == null) {
                return Collections.emptyList();
            }
            Pattern dataPattern = Pattern.compile("(\\d*\\.\\d+)\\s+(\\d*\\.\\d+)\\s+(\\d*\\.\\d+)");
            ArrayList<GfxProfileData> data = new ArrayList<GfxProfileData>(128);
            while ((line = br.readLine()) != null && (m = dataPattern.matcher(line)).find()) {
                double draw = BugReportParser.safeParseDouble(m.group(1));
                double process = BugReportParser.safeParseDouble(m.group(2));
                double execute = BugReportParser.safeParseDouble(m.group(3));
                data.add(new GfxProfileData(draw, process, execute));
            }
            return data;
        }

        public static List<DataValue> readWakelockDataset(BufferedReader br) throws IOException {
            String line;
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            Pattern lockPattern = Pattern.compile("Wake lock (\\S+): (.+) partial");
            Pattern totalPattern = Pattern.compile("Total: (.+) uptime");
            double total = 0.0;
            boolean inCurrent = false;
            while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
                if (line.startsWith("Current Battery Usage Statistics")) {
                    inCurrent = true;
                    continue;
                }
                if (!inCurrent) continue;
                Matcher m = lockPattern.matcher(line);
                if (m.find()) {
                    double value = (double)SysinfoPanel.parseTimeMs(m.group(2)) / 1000.0;
                    results.add(new DataValue(m.group(1), value));
                    total -= value;
                    continue;
                }
                m = totalPattern.matcher(line);
                if (!m.find()) continue;
                total += (double)SysinfoPanel.parseTimeMs(m.group(1)) / 1000.0;
            }
            if (total > 0.0) {
                results.add(new DataValue("Unlocked", total));
            }
            return results;
        }

        public static List<DataValue> readAlarmDataset(BufferedReader br) throws IOException {
            String line;
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            Pattern pattern = Pattern.compile("(\\d+) alarms: Intent .*\\.([^. ]+) flags");
            while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
                Matcher m = pattern.matcher(line);
                if (!m.find()) continue;
                long count = Long.parseLong(m.group(1));
                String name = m.group(2);
                results.add(new DataValue(name, count));
            }
            return results;
        }

        public static List<DataValue> readCpuDataset(BufferedReader br) throws IOException {
            String line;
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            Pattern pattern1 = Pattern.compile("(\\S+): (\\S+)% = (.+)% user . (.+)% kernel");
            Pattern pattern2 = Pattern.compile("(\\S+)% (\\S+): (.+)% user . (.+)% kernel");
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("Load:")) continue;
                String name = "";
                double user = 0.0;
                double kernel = 0.0;
                double both = 0.0;
                boolean found = false;
                Matcher m = pattern1.matcher(line);
                if (m.find()) {
                    found = true;
                    name = m.group(1);
                    both = BugReportParser.safeParseLong(m.group(2));
                    user = BugReportParser.safeParseLong(m.group(3));
                    kernel = BugReportParser.safeParseLong(m.group(4));
                }
                if ((m = pattern2.matcher(line)).find()) {
                    found = true;
                    name = m.group(2);
                    both = BugReportParser.safeParseDouble(m.group(1));
                    user = BugReportParser.safeParseDouble(m.group(3));
                    kernel = BugReportParser.safeParseDouble(m.group(4));
                }
                if (!found) continue;
                if ("TOTAL".equals(name)) {
                    if (!(both < 100.0)) continue;
                    results.add(new DataValue("Idle", 100.0 - both));
                    continue;
                }
                if (user > 0.0) {
                    results.add(new DataValue(name + " (user)", user));
                }
                if (kernel > 0.0) {
                    results.add(new DataValue(name + " (kernel)", both - user));
                }
                if (user != 0.0 || kernel != 0.0 || !(both > 0.0)) continue;
                results.add(new DataValue(name, both));
            }
            return results;
        }

        private static long safeParseLong(String s) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        private static double safeParseDouble(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        public static List<DataValue> readMeminfoDataset(BufferedReader br) throws IOException {
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            Pattern valuePattern = Pattern.compile("(\\d+) kB");
            long total = 0L;
            long other = 0L;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains("----")) continue;
                Matcher m = valuePattern.matcher(line);
                if (!m.find()) break;
                long kb = Long.parseLong(m.group(1));
                if (line.startsWith("MemTotal")) {
                    total = kb;
                    continue;
                }
                if (line.startsWith("MemFree")) {
                    results.add(new DataValue("Free", kb));
                    total -= kb;
                    continue;
                }
                if (line.startsWith("Slab")) {
                    results.add(new DataValue("Slab", kb));
                    total -= kb;
                    continue;
                }
                if (line.startsWith("PageTables")) {
                    results.add(new DataValue("PageTables", kb));
                    total -= kb;
                    continue;
                }
                if (line.startsWith("Buffers") && kb > 0L) {
                    results.add(new DataValue("Buffers", kb));
                    total -= kb;
                    continue;
                }
                if (line.startsWith("Inactive")) {
                    results.add(new DataValue("Inactive", kb));
                    total -= kb;
                    continue;
                }
                if (!line.startsWith("MemFree")) continue;
                results.add(new DataValue("Free", kb));
                total -= kb;
            }
            List<DataValue> procRankResults = BugReportParser.readProcRankDataset(br, line);
            for (DataValue procRank : procRankResults) {
                if (procRank.value > 2000.0) {
                    results.add(procRank);
                } else {
                    other = (long)((double)other + procRank.value);
                }
                total = (long)((double)total - procRank.value);
            }
            if (other > 0L) {
                results.add(new DataValue("Other", other));
            }
            if (total > 0L) {
                results.add(new DataValue("Unknown", total));
            }
            return results;
        }

        static List<DataValue> readProcRankDataset(BufferedReader br, String header) throws IOException {
            String line;
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            if (header == null || !header.contains("PID")) {
                return results;
            }
            Splitter PROCRANK_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
            ArrayList fields = Lists.newArrayList((Iterable)PROCRANK_SPLITTER.split((CharSequence)header));
            int pssIndex = fields.indexOf("Pss");
            int cmdIndex = fields.indexOf("cmdline");
            if (pssIndex == -1 || cmdIndex == -1) {
                return results;
            }
            while ((line = br.readLine()) != null && (fields = Lists.newArrayList((Iterable)PROCRANK_SPLITTER.split((CharSequence)line))).size() >= cmdIndex) {
                String cmdline = ((String)fields.get(cmdIndex)).replace("/system/bin/", "");
                String pssInK = (String)fields.get(pssIndex);
                if (pssInK.endsWith("K")) {
                    pssInK = pssInK.substring(0, pssInK.length() - 1);
                }
                long pss = BugReportParser.safeParseLong(pssInK);
                results.add(new DataValue(cmdline, pss));
            }
            return results;
        }

        public static List<DataValue> readSyncDataset(BufferedReader br) throws IOException {
            String line;
            ArrayList<DataValue> results = new ArrayList<DataValue>();
            while ((line = br.readLine()) != null && !line.startsWith("DUMP OF SERVICE")) {
                long dur;
                if (!line.startsWith(" |") || line.length() <= 70) continue;
                String authority = line.substring(3, 18).trim();
                String duration = line.substring(61, 70).trim();
                String[] durParts = duration.split(":");
                if (durParts.length == 2) {
                    dur = Long.parseLong(durParts[0]) * 60L + Long.parseLong(durParts[1]);
                    results.add(new DataValue(authority, dur));
                    continue;
                }
                if (duration.length() != 3) continue;
                dur = Long.parseLong(durParts[0]) * 3600L + Long.parseLong(durParts[1]) * 60L + Long.parseLong(durParts[2]);
                results.add(new DataValue(authority, dur));
            }
            return results;
        }

        public static final class GfxProfileData {
            final double draw;
            final double process;
            final double execute;

            public GfxProfileData(double draw, double process, double execute) {
                this.draw = draw;
                this.process = process;
                this.execute = execute;
            }
        }

        public static final class DataValue {
            final String name;
            final double value;

            public DataValue(String n, double v) {
                this.name = n;
                this.value = v;
            }
        }
    }
}

