/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.location;

import com.android.ddmuilib.location.LocationPoint;
import com.android.ddmuilib.location.WayPoint;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class KmlParser {
    private static final String NS_KML_2 = "http://earth.google.com/kml/2.";
    private static final String NODE_PLACEMARK = "Placemark";
    private static final String NODE_NAME = "name";
    private static final String NODE_COORDINATES = "coordinates";
    private static final Pattern sLocationPattern = Pattern.compile("([^,]+),([^,]+)(?:,([^,]+))?");
    private static SAXParserFactory sParserFactory = SAXParserFactory.newInstance();
    private String mFileName;
    private KmlHandler mHandler;

    public KmlParser(String fileName) {
        this.mFileName = fileName;
    }

    public boolean parse() {
        try {
            SAXParser parser = sParserFactory.newSAXParser();
            this.mHandler = new KmlHandler();
            parser.parse(new InputSource(new FileReader(this.mFileName)), (DefaultHandler)this.mHandler);
            boolean bl = this.mHandler.getSuccess();
            return bl;
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return false;
    }

    public WayPoint[] getWayPoints() {
        if (this.mHandler != null) {
            return this.mHandler.getWayPoints();
        }
        return null;
    }

    static {
        sParserFactory.setNamespaceAware(true);
    }

    private static class KmlHandler
    extends DefaultHandler {
        List<WayPoint> mWayPoints;
        WayPoint mCurrentWayPoint;
        final StringBuilder mStringAccumulator = new StringBuilder();
        boolean mSuccess = true;

        private KmlHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (uri.startsWith(KmlParser.NS_KML_2) && KmlParser.NODE_PLACEMARK.equals(localName)) {
                    if (this.mWayPoints == null) {
                        this.mWayPoints = new ArrayList<WayPoint>();
                    }
                    this.mCurrentWayPoint = new WayPoint();
                    this.mWayPoints.add(this.mCurrentWayPoint);
                }
            }
            finally {
                this.mStringAccumulator.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mStringAccumulator.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (uri.startsWith(KmlParser.NS_KML_2)) {
                if (KmlParser.NODE_PLACEMARK.equals(localName)) {
                    this.mCurrentWayPoint = null;
                } else if (KmlParser.NODE_NAME.equals(localName)) {
                    if (this.mCurrentWayPoint != null) {
                        this.mCurrentWayPoint.setName(this.mStringAccumulator.toString());
                    }
                } else if (KmlParser.NODE_COORDINATES.equals(localName) && this.mCurrentWayPoint != null) {
                    this.parseLocation(this.mCurrentWayPoint, this.mStringAccumulator.toString());
                }
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.mSuccess = false;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.mSuccess = false;
        }

        private void parseLocation(LocationPoint locationNode, String location) {
            Matcher m = sLocationPattern.matcher(location);
            if (m.matches()) {
                try {
                    double longitude = Double.parseDouble(m.group(1));
                    double latitude = Double.parseDouble(m.group(2));
                    locationNode.setLocation(longitude, latitude);
                    if (m.groupCount() == 3) {
                        locationNode.setElevation(Double.parseDouble(m.group(3)));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        WayPoint[] getWayPoints() {
            if (this.mWayPoints != null) {
                return this.mWayPoints.toArray(new WayPoint[this.mWayPoints.size()]);
            }
            return null;
        }

        boolean getSuccess() {
            return this.mSuccess;
        }
    }
}

