/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.SymbolIo;
import com.android.builder.symbols.SymbolTable;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class RGeneration {
    private RGeneration() {
    }

    public static void generateRForLibraries(SymbolTable main, Collection<SymbolTable> libraries, File out, boolean finalIds) {
        Preconditions.checkArgument((boolean)out.isDirectory(), (Object)"!out.iDirectory");
        HashMap<String, SymbolTable> toWrite = new HashMap<String, SymbolTable>();
        for (SymbolTable st2 : libraries) {
            if (st2.getTablePackage().equals(main.getTablePackage())) continue;
            SymbolTable existing = (SymbolTable)toWrite.get(st2.getTablePackage());
            if (existing != null) {
                toWrite.put(st2.getTablePackage(), existing.merge(st2));
                continue;
            }
            toWrite.put(st2.getTablePackage(), st2);
        }
        for (String pkg : new HashSet(toWrite.keySet())) {
            SymbolTable st3 = (SymbolTable)toWrite.get(pkg);
            st3 = main.filter(st3).rename(st3.getTablePackage());
            toWrite.put(pkg, st3);
        }
        toWrite.values().forEach(st -> SymbolIo.exportToJava(st, out, finalIds));
    }
}

