/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.StringResourceContentHandler;
import com.android.ide.common.res2.StringResourceEscapeUtils;
import com.android.ide.common.res2.StringResourceEscaperCharacterHandler;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class StringResourceEscaper {
    private StringResourceEscaper() {
    }

    static String escapeCharacterData(String xml) {
        if (xml.isEmpty()) {
            return "";
        }
        xml = StringResourceEscapeUtils.escapeCharacterReferences(xml);
        StringBuilder builder = new StringBuilder(xml.length() * 3 / 2);
        if (StringResourceEscaper.startsOrEndsWithSpace(xml)) {
            builder.append('\"');
        } else if (StringResourceEscaper.startsWithQuestionMarkOrAtSign(xml)) {
            builder.append('\\');
        }
        try {
            Escaper escaper = StringResourceEscaper.buildEscaper(!StringResourceEscaper.startsOrEndsWithSpace(xml), false);
            StringResourceEscapeUtils.parse(xml, StringResourceEscaper.newContentHandler(builder, escaper));
        }
        catch (SAXException exception) {
            throw new IllegalArgumentException(xml, exception);
        }
        if (StringResourceEscaper.startsOrEndsWithSpace(xml)) {
            builder.append('\"');
        }
        xml = builder.toString();
        xml = StringResourceEscapeUtils.unescapeCharacterReferences(xml);
        return xml;
    }

    private static ContentHandler newContentHandler(StringBuilder builder, Escaper escaper) {
        StringResourceEscaperCharacterHandler handler = new StringResourceEscaperCharacterHandler(escaper);
        return new StringResourceContentHandler(builder, handler);
    }

    static String escape(String string, boolean escapeMarkupDelimiters) {
        if (string.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(string.length() * 3 / 2);
        if (StringResourceEscaper.startsOrEndsWithSpace(string)) {
            builder.append('\"');
        } else if (StringResourceEscaper.startsWithQuestionMarkOrAtSign(string)) {
            builder.append('\\');
        }
        Escaper escaper = StringResourceEscaper.buildEscaper(!StringResourceEscaper.startsOrEndsWithSpace(string), escapeMarkupDelimiters);
        builder.append(escaper.escape(string));
        if (StringResourceEscaper.startsOrEndsWithSpace(string)) {
            builder.append('\"');
        }
        return builder.toString();
    }

    private static Escaper buildEscaper(boolean escapeApostrophes, boolean escapeMarkupDelimiters) {
        Escapers.Builder builder = Escapers.builder().addEscape('\"', "\\\"").addEscape('\\', "\\\\").addEscape('\n', "\\n").addEscape('\t', "\\t");
        if (escapeApostrophes) {
            builder.addEscape('\'', "\\'");
        }
        if (escapeMarkupDelimiters) {
            builder.addEscape('&', "&amp;").addEscape('<', "&lt;");
        }
        return builder.build();
    }

    private static boolean startsWithQuestionMarkOrAtSign(String string) {
        assert (!string.isEmpty());
        return string.charAt(0) == '?' || string.charAt(0) == '@';
    }

    private static boolean startsOrEndsWithSpace(String string) {
        assert (!string.isEmpty());
        return string.charAt(0) == ' ' || string.charAt(string.length() - 1) == ' ';
    }
}

