/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionQualifier
extends ResourceQualifier {
    public static final int DEFAULT_VERSION = -1;
    private static final Pattern sVersionPattern = Pattern.compile("^v(\\d+)$");
    private int mVersion = -1;
    public static final String NAME = "Platform Version";

    public static VersionQualifier getQualifier(String segment) {
        Matcher m = sVersionPattern.matcher(segment);
        if (m.matches()) {
            int code;
            String v = m.group(1);
            try {
                code = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                return null;
            }
            VersionQualifier qualifier = new VersionQualifier();
            qualifier.mVersion = code;
            return qualifier;
        }
        return null;
    }

    public static String getFolderSegment(int version) {
        if (version != -1) {
            return String.format("v%1$d", version);
        }
        return "";
    }

    public VersionQualifier(int apiLevel) {
        this.mVersion = apiLevel;
    }

    public VersionQualifier() {
    }

    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return "Version";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mVersion != -1;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        VersionQualifier qualifier = VersionQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setVersionQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        return qualifier instanceof VersionQualifier && this.mVersion == ((VersionQualifier)qualifier).mVersion;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof VersionQualifier) {
            return this.mVersion <= ((VersionQualifier)qualifier).mVersion || ((VersionQualifier)qualifier).mVersion == -1;
        }
        return false;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        VersionQualifier compareQ = (VersionQualifier)compareTo2;
        VersionQualifier referenceQ = (VersionQualifier)reference;
        if (compareQ.mVersion == referenceQ.mVersion) {
            return false;
        }
        if (this.mVersion == referenceQ.mVersion) {
            return true;
        }
        return this.mVersion > compareQ.mVersion;
    }

    @Override
    public int hashCode() {
        return this.mVersion;
    }

    @Override
    public String getFolderSegment() {
        return VersionQualifier.getFolderSegment(this.mVersion);
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mVersion != -1) {
            return String.format("API %1$d", this.mVersion);
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.mVersion != -1) {
            return String.format("API Level %1$d", this.mVersion);
        }
        return "";
    }
}

