/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar.internal;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.widgets.Display;

public class MenuBarEnhancerCocoa
implements IMenuBarEnhancer {
    private static final long kAboutMenuItem = 0L;
    private static final long kPreferencesMenuItem = 2L;
    private static final long kQuitMenuItem = 10L;
    static long mSelPreferencesMenuItemSelected;
    static long mSelAboutMenuItemSelected;
    static Callback mProc3Args;
    private String mAppName;

    @Override
    public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
        return IMenuBarEnhancer.MenuBarMode.MAC_OS;
    }

    @Override
    public void setupMenu(String appName, Display display, IMenuBarCallback callbacks) {
        this.mAppName = appName;
        ActionProctarget target = new ActionProctarget(callbacks);
        try {
            this.initialize(target);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                MenuBarEnhancerCocoa.this.invoke(mProc3Args, "dispose");
            }
        });
    }

    private void initialize(Object callbackObject) throws Exception {
        Class<?> osCls = this.classForName("org.eclipse.swt.internal.cocoa.OS");
        if (mSelAboutMenuItemSelected == 0L) {
            mSelPreferencesMenuItemSelected = this.registerName(osCls, "preferencesMenuItemSelected:");
            mSelAboutMenuItemSelected = this.registerName(osCls, "aboutMenuItemSelected:");
        }
        mProc3Args = new Callback(callbackObject, "actionProc", 3);
        Method getAddress = Callback.class.getMethod("getAddress", new Class[0]);
        Object object = getAddress.invoke((Object)mProc3Args, (Object[])null);
        long proc3 = this.convertToLong(object);
        if (proc3 == 0L) {
            SWT.error((int)3);
        }
        Class<?> nsMenuCls = this.classForName("org.eclipse.swt.internal.cocoa.NSMenu");
        Class<?> nsMenuitemCls = this.classForName("org.eclipse.swt.internal.cocoa.NSMenuItem");
        Class<?> nsStringCls = this.classForName("org.eclipse.swt.internal.cocoa.NSString");
        Class<?> nsApplicationCls = this.classForName("org.eclipse.swt.internal.cocoa.NSApplication");
        object = MenuBarEnhancerCocoa.invoke(osCls, "objc_lookUpClass", new Object[]{"SWTApplicationDelegate"});
        long cls = this.convertToLong(object);
        MenuBarEnhancerCocoa.invoke(osCls, "class_addMethod", new Object[]{MenuBarEnhancerCocoa.wrapPointer(cls), MenuBarEnhancerCocoa.wrapPointer(mSelPreferencesMenuItemSelected), MenuBarEnhancerCocoa.wrapPointer(proc3), "@:@"});
        MenuBarEnhancerCocoa.invoke(osCls, "class_addMethod", new Object[]{MenuBarEnhancerCocoa.wrapPointer(cls), MenuBarEnhancerCocoa.wrapPointer(mSelAboutMenuItemSelected), MenuBarEnhancerCocoa.wrapPointer(proc3), "@:@"});
        Object sharedApplication = this.invoke(nsApplicationCls, "sharedApplication");
        Object mainMenu = this.invoke(sharedApplication, "mainMenu");
        Object mainMenuItem = MenuBarEnhancerCocoa.invoke(nsMenuCls, mainMenu, "itemAtIndex", new Object[]{MenuBarEnhancerCocoa.wrapPointer(0L)});
        Object appMenu = this.invoke(mainMenuItem, "submenu");
        Object aboutMenuItem = MenuBarEnhancerCocoa.invoke(nsMenuCls, appMenu, "itemAtIndex", new Object[]{MenuBarEnhancerCocoa.wrapPointer(0L)});
        if (this.mAppName != null) {
            Object nsStr = MenuBarEnhancerCocoa.invoke(nsStringCls, "stringWith", new Object[]{"About " + this.mAppName});
            MenuBarEnhancerCocoa.invoke(nsMenuitemCls, aboutMenuItem, "setTitle", new Object[]{nsStr});
        }
        if (this.mAppName != null) {
            Object quitMenuItem = MenuBarEnhancerCocoa.invoke(nsMenuCls, appMenu, "itemAtIndex", new Object[]{MenuBarEnhancerCocoa.wrapPointer(10L)});
            Object nsStr = MenuBarEnhancerCocoa.invoke(nsStringCls, "stringWith", new Object[]{"Quit " + this.mAppName});
            MenuBarEnhancerCocoa.invoke(nsMenuitemCls, quitMenuItem, "setTitle", new Object[]{nsStr});
        }
        Object prefMenuItem = MenuBarEnhancerCocoa.invoke(nsMenuCls, appMenu, "itemAtIndex", new Object[]{MenuBarEnhancerCocoa.wrapPointer(2L)});
        MenuBarEnhancerCocoa.invoke(nsMenuitemCls, prefMenuItem, "setEnabled", new Object[]{true});
        MenuBarEnhancerCocoa.invoke(nsMenuitemCls, prefMenuItem, "setAction", new Object[]{MenuBarEnhancerCocoa.wrapPointer(mSelPreferencesMenuItemSelected)});
        MenuBarEnhancerCocoa.invoke(nsMenuitemCls, aboutMenuItem, "setAction", new Object[]{MenuBarEnhancerCocoa.wrapPointer(mSelAboutMenuItemSelected)});
    }

    private long registerName(Class<?> osCls, String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = MenuBarEnhancerCocoa.invoke(osCls, "sel_registerName", new Object[]{name});
        return this.convertToLong(object);
    }

    private long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    private static Object wrapPointer(long value) {
        Class<Number> PTR_CLASS;
        Class<Number> clazz = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            return new Long(value);
        }
        return new Integer((int)value);
    }

    private static Object invoke(Class<?> clazz, String methodName, Object[] args) {
        return MenuBarEnhancerCocoa.invoke(clazz, null, methodName, args);
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Object[] args) {
        try {
            Class[] signature = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> thisClass = args[i].getClass();
                signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : (thisClass == Boolean.class ? Boolean.TYPE : thisClass)));
            }
            Method method = clazz.getMethod(methodName, signature);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Class<?> classForName(String classname) {
        try {
            Class<?> cls = Class.forName(classname);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object invoke(Class<?> cls, String methodName) {
        return this.invoke(cls, methodName, (Class[])null, (Object[])null);
    }

    private Object invoke(Class<?> cls, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = cls.getDeclaredMethod(methodName, paramTypes);
            return m.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Object invoke(Object obj, String methodName) {
        return this.invoke(obj, methodName, (Class[])null, (Object[])null);
    }

    private Object invoke(Object obj, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = obj.getClass().getDeclaredMethod(methodName, paramTypes);
            return m.invoke(obj, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ActionProctarget {
        private final IMenuBarCallback mCallbacks;

        public ActionProctarget(IMenuBarCallback callbacks) {
            this.mCallbacks = callbacks;
        }

        public int actionProc(int id, int sel, int arg0) {
            return (int)this.actionProc((long)id, (long)sel, (long)arg0);
        }

        public long actionProc(long id, long sel, long arg0) {
            if (sel == mSelAboutMenuItemSelected) {
                this.mCallbacks.onAboutMenuSelected();
            } else if (sel == mSelPreferencesMenuItemSelected) {
                this.mCallbacks.onPreferencesMenuSelected();
            }
            return 0L;
        }
    }
}

