/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

public class KeepRuleBuilder {
    public static final String KEEP_PREAMBLE = "# Add *one* of the following rules to your Proguard configuration file.\n# Alternatively, you can annotate classes and class members with @android.support.annotation.Keep\n\n";
    public static final String KEEP_RULE = "# keep the class and specified members from being removed or renamed\n";
    public static final String KEEPCLASSMEMBERS_RULE = "# keep the specified class members from being removed or renamed \n# only if the class is preserved\n";
    public static final String KEEPNAMES_RULE = "# keep the class and specified members from being renamed only\n";
    public static final String KEEPCLASSMEMBERNAMES_RULE = "# keep the specified class members from being renamed only\n";
    public static String ANY_CLASS = "**";
    public static String ANY_MEMBER = "*";
    private String packageName;
    private String className;
    private String memberName;

    public KeepRuleBuilder setPackage(String aPackage) {
        this.packageName = aPackage;
        return this;
    }

    public KeepRuleBuilder setClass(String aClass) {
        this.className = aClass;
        return this;
    }

    public KeepRuleBuilder setMember(String member) {
        this.memberName = member;
        return this;
    }

    public String build(KeepType keepType) {
        if (this.packageName == null) {
            throw new IllegalStateException("You must set a package.");
        }
        if (this.className == null) {
            this.className = ANY_CLASS;
        }
        if (this.memberName == null) {
            this.memberName = ANY_MEMBER;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-");
        sb.append(keepType.toString().toLowerCase());
        sb.append(" class ");
        if (!this.packageName.isEmpty()) {
            sb.append(this.packageName);
            sb.append(".");
        }
        sb.append(this.className);
        sb.append(" { ");
        sb.append(this.memberName);
        sb.append("; }");
        return sb.toString();
    }

    public static enum KeepType {
        KEEP,
        KEEPCLASSMEMBERS,
        KEEPNAMES,
        KEEPCLASSMEMBERNAMES;

    }
}

