/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.SdkConstants;
import com.android.tools.lint.HtmlReporter;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.MaterialHtmlReporter;
import com.android.tools.lint.MultiProjectHtmlReporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.AccessibilityDetector;
import com.android.tools.lint.checks.AlwaysShowActionDetector;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.checks.AndroidTvDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.AppCompatCallDetector;
import com.android.tools.lint.checks.AppIndexingApiDetector;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.DetectMissingPrefix;
import com.android.tools.lint.checks.DuplicateResourceDetector;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GridLayoutDetector;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.checks.IncludeDetector;
import com.android.tools.lint.checks.InefficientWeightDetector;
import com.android.tools.lint.checks.JavaPerformanceDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.checks.MissingClassDetector;
import com.android.tools.lint.checks.MissingIdDetector;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.checks.ObsoleteLayoutParamsDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.checks.PropertyFileDetector;
import com.android.tools.lint.checks.PxUsageDetector;
import com.android.tools.lint.checks.ReadParcelableDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.ScrollViewChildDetector;
import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.checks.SignatureOrSystemDetector;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.checks.TextFieldDetector;
import com.android.tools.lint.checks.TextViewDetector;
import com.android.tools.lint.checks.TitleDetector;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.checks.TypographyDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.checks.UselessViewDetector;
import com.android.tools.lint.checks.Utf8Detector;
import com.android.tools.lint.checks.WrongCallDetector;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Beta
public abstract class Reporter {
    public static final String NEW_FORMAT_PROPERTY = "lint.old-html-style";
    public static final boolean USE_MATERIAL_HTML_STYLE = !Boolean.getBoolean("lint.old-html-style");
    protected final LintCliClient client;
    protected final File output;
    protected String title = "Lint Report";
    protected boolean simpleFormat;
    protected boolean bundleResources;
    protected Map<String, String> urlMap;
    protected File resources;
    protected final Map<File, String> resourceUrl = new HashMap<File, String>();
    protected final Map<String, File> nameToFile = new HashMap<String, File>();
    protected boolean displayEmpty = true;
    private static Set<Issue> studioFixes;
    private String stripPrefix;

    public static Reporter createHtmlReporter(LintCliClient client, File output, LintCliFlags flags, boolean simpleFormat) throws IOException {
        if (USE_MATERIAL_HTML_STYLE) {
            return new MaterialHtmlReporter(client, output, flags);
        }
        HtmlReporter reporter = new HtmlReporter(client, output, flags);
        if (simpleFormat) {
            reporter.setSimpleFormat(true);
        }
        return reporter;
    }

    public static Reporter createTextReporter(LintCliClient client, LintCliFlags flags, File file, Writer writer, boolean close) {
        return new TextReporter(client, flags, file, writer, close);
    }

    public static Reporter createXmlReporter(LintCliClient client, File output, boolean intendedForBaseline) throws IOException {
        XmlReporter reporter = new XmlReporter(client, output);
        reporter.setIntendedForBaseline(intendedForBaseline);
        return reporter;
    }

    public abstract void write(Stats var1, List<Warning> var2) throws IOException;

    public void writeProjectList(Stats stats, List<MultiProjectHtmlReporter.ProjectEntry> projects) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Reporter(LintCliClient client, File output) {
        this.client = client;
        this.output = output;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBundleResources(boolean bundleResources) {
        this.bundleResources = bundleResources;
        this.simpleFormat = false;
    }

    public void setSimpleFormat(boolean simpleFormat) {
        this.simpleFormat = simpleFormat;
    }

    public boolean isSimpleFormat() {
        return this.simpleFormat;
    }

    String getUrl(File file) {
        String relativePath;
        String url;
        if (this.bundleResources && !this.simpleFormat && (url = this.getRelativeResourceUrl(file)) != null) {
            return url;
        }
        if (this.urlMap != null) {
            String path = file.getAbsolutePath();
            String pathUrl = Reporter.encodeUrl(path);
            for (Map.Entry<String, String> entry : this.urlMap.entrySet()) {
                String prefix = entry.getKey();
                String prefixUrl = Reporter.encodeUrl(prefix);
                if (!pathUrl.startsWith(prefixUrl)) continue;
                String relative = pathUrl.substring(prefixUrl.length());
                return entry.getValue() + relative;
            }
        }
        if (file.isAbsolute() && (relativePath = Reporter.getRelativePath(this.output.getParentFile(), file)) != null) {
            relativePath = relativePath.replace(File.separatorChar, '/');
            return Reporter.encodeUrl(relativePath);
        }
        try {
            return SdkUtils.fileToUrlString((File)file);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static String encodeUrl(String url) {
        try {
            url = url.replace('\\', '/');
            return URLEncoder.encode(url, "UTF-8").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Invalid string " + e.getLocalizedMessage());
            return url;
        }
    }

    public void setUrlMap(Map<String, String> urlMap) {
        this.urlMap = urlMap;
    }

    File getResourceDir() {
        if (this.resources == null && this.bundleResources) {
            this.resources = this.computeResourceDir();
            if (this.resources == null) {
                this.bundleResources = false;
            }
        }
        return this.resources;
    }

    File computeResourceDir() {
        File resources;
        String fileName = this.output.getName();
        int dot = fileName.indexOf(46);
        if (dot != -1) {
            fileName = fileName.substring(0, dot);
        }
        if (!(resources = new File(this.output.getParentFile(), fileName + "_files")).exists() && !resources.mkdir()) {
            resources = null;
        }
        return resources;
    }

    protected String getRelativeResourceUrl(File file) {
        String resource = this.resourceUrl.get(file);
        if (resource != null) {
            return resource;
        }
        String name = file.getName();
        if (!LintUtils.endsWith((String)name, (String)".png") || LintUtils.endsWith((String)name, (String)".9.png")) {
            return null;
        }
        File resourceDir = this.getResourceDir();
        if (resourceDir != null) {
            String base = file.getName();
            File path = this.nameToFile.get(base);
            if (path != null && !path.equals(file)) {
                for (int i = 0; i < 100 && (path = this.nameToFile.get(base = '_' + base)) != null && !path.equals(file); ++i) {
                }
            }
            File target = new File(resourceDir, base);
            try {
                Files.copy((File)file, (File)target);
            }
            catch (IOException e) {
                return null;
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    protected String addLocalResources(URL url) throws IOException {
        File resourceDir = this.computeResourceDir();
        if (resourceDir != null) {
            String base = url.getFile();
            base = base.substring(base.lastIndexOf(47) + 1);
            this.nameToFile.put(base, new File(url.toExternalForm()));
            File target = new File(resourceDir, base);
            try (FileOutputStream output = new FileOutputStream(target);
                 InputStream input = url.openStream();){
                ByteStreams.copy((InputStream)input, (OutputStream)output);
            }
            return resourceDir.getName() + '/' + Reporter.encodeUrl(base);
        }
        return null;
    }

    static String getRelativePath(File base, File file) {
        int len;
        String filePathToCompare;
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        basePath = !basePath.isEmpty() && basePath.charAt(basePath.length() - 1) == File.separatorChar ? basePath : basePath + File.separatorChar;
        boolean caseSensitive = SdkConstants.CURRENT_PLATFORM == 1;
        Locale l = Locale.getDefault();
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase(l);
        if (basePathToCompare.equals(!(filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase(l)).isEmpty() && filePathToCompare.charAt(filePathToCompare.length() - 1) == File.separatorChar ? filePathToCompare : filePathToCompare + File.separatorChar)) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != File.separatorChar) continue;
            relativePath.append("..");
            relativePath.append(File.separatorChar);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    public boolean isDisplayEmpty() {
        return this.displayEmpty;
    }

    public void setDisplayEmpty(boolean displayEmpty) {
        this.displayEmpty = displayEmpty;
    }

    public static boolean hasAutoFix(Issue issue) {
        if (studioFixes == null) {
            studioFixes = Sets.newHashSet((Object[])new Issue[]{AccessibilityDetector.ISSUE, AlwaysShowActionDetector.ISSUE, AndroidAutoDetector.INVALID_USES_TAG_ISSUE, AndroidTvDetector.MISSING_BANNER, AndroidTvDetector.MISSING_LEANBACK_SUPPORT, AndroidTvDetector.PERMISSION_IMPLIES_UNSUPPORTED_HARDWARE, AndroidTvDetector.UNSUPPORTED_TV_HARDWARE, AnnotationDetector.SWITCH_TYPE_DEF, ApiDetector.INLINED, ApiDetector.OVERRIDE, ApiDetector.UNSUPPORTED, ApiDetector.UNUSED, AppCompatCallDetector.ISSUE, AppIndexingApiDetector.ISSUE_APP_INDEXING, AppIndexingApiDetector.ISSUE_APP_INDEXING_API, ByteOrderMarkDetector.BOM, CleanupDetector.SHARED_PREF, CommentDetector.STOP_SHIP, DetectMissingPrefix.MISSING_NAMESPACE, DuplicateResourceDetector.TYPE_MISMATCH, GradleDetector.COMPATIBILITY, GradleDetector.DEPENDENCY, GradleDetector.DEPRECATED, GradleDetector.NOT_INTERPOLATED, GradleDetector.PLUS, GradleDetector.REMOTE_VERSION, GradleDetector.MIN_SDK_TOO_LOW, GradleDetector.STRING_INTEGER, GridLayoutDetector.ISSUE, IconDetector.WEBP_ELIGIBLE, IconDetector.WEBP_UNSUPPORTED, IncludeDetector.ISSUE, InefficientWeightDetector.BASELINE_WEIGHTS, InefficientWeightDetector.INEFFICIENT_WEIGHT, InefficientWeightDetector.ORIENTATION, JavaPerformanceDetector.USE_VALUE_OF, ManifestDetector.ALLOW_BACKUP, ManifestDetector.APPLICATION_ICON, ManifestDetector.MIPMAP, ManifestDetector.MOCK_LOCATION, ManifestDetector.TARGET_NEWER, MissingClassDetector.INNERCLASS, MissingIdDetector.ISSUE, NamespaceDetector.RES_AUTO, ObsoleteLayoutParamsDetector.ISSUE, ParcelDetector.ISSUE, PropertyFileDetector.ESCAPE, PropertyFileDetector.HTTP, PxUsageDetector.DP_ISSUE, PxUsageDetector.PX_ISSUE, ReadParcelableDetector.ISSUE, RtlDetector.COMPAT, ScrollViewChildDetector.ISSUE, SecurityDetector.EXPORTED_SERVICE, SignatureOrSystemDetector.ISSUE, SupportAnnotationDetector.CHECK_PERMISSION, SupportAnnotationDetector.CHECK_RESULT, SupportAnnotationDetector.MISSING_PERMISSION, TextFieldDetector.ISSUE, TextViewDetector.SELECTABLE, TitleDetector.ISSUE, TypoDetector.ISSUE, TypographyDetector.DASHES, TypographyDetector.ELLIPSIS, TypographyDetector.FRACTIONS, TypographyDetector.OTHER, TypographyDetector.QUOTES, UnusedResourceDetector.ISSUE, UnusedResourceDetector.ISSUE_IDS, UselessViewDetector.USELESS_LEAF, Utf8Detector.ISSUE, WrongCallDetector.ISSUE, WrongCaseDetector.WRONG_CASE});
        }
        return studioFixes.contains(issue);
    }

    protected String stripPath(String path) {
        if (this.stripPrefix != null && path.startsWith(this.stripPrefix) && path.length() > this.stripPrefix.length()) {
            int index = this.stripPrefix.length();
            if (path.charAt(index) == File.separatorChar) {
                ++index;
            }
            return path.substring(index);
        }
        return path;
    }

    public void setStripPrefix(String prefix) {
        this.stripPrefix = prefix;
    }

    public static final class Stats {
        public final int errorCount;
        public final int warningCount;
        public final int baselineWarningCount;
        public final int baselineErrorCount;
        public final int baselineFixedCount;

        public Stats(int errorCount, int warningCount, int baselineErrorCount, int baselineWarningCount, int baselineFixedCount) {
            this.errorCount = errorCount;
            this.warningCount = warningCount;
            this.baselineWarningCount = baselineWarningCount;
            this.baselineErrorCount = baselineErrorCount;
            this.baselineFixedCount = baselineFixedCount;
        }

        public Stats(int errorCount, int warningCount) {
            this(errorCount, warningCount, 0, 0, 0);
        }

        public int count() {
            return this.errorCount + this.warningCount;
        }
    }
}

