/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "checkGetDeclaredMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkLoadClass", "findReflectionClass", "", "element", "Lorg/jetbrains/uast/UElement;", "getApplicableMethodNames", "", "getClassFromMemberLookup", "visitMethod", "node", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks_main"})
public final class PrivateApiDetector
extends Detector
implements Detector.UastScanner {
    @JvmField
    public static final Issue ISSUE;
    private static final String LOAD_CLASS = "loadClass";
    private static final String FOR_NAME = "forName";
    private static final String GET_CLASS = "getClass";
    private static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    private static final String ERROR_MESSAGE = "Accessing internal APIs via reflection is not supported and may not work on all devices or in the future";
    public static final Issues Issues;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object[])new String[]{FOR_NAME, LOAD_CLASS, GET_DECLARED_METHOD});
    }

    public void visitMethod(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (Intrinsics.areEqual((Object)LOAD_CLASS, (Object)method.getName())) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.ClassLoader") || evaluator.isMemberInClass((PsiMember)method, "dalvik.system.DexFile")) {
                this.checkLoadClass(context, node);
            }
        } else {
            if (!evaluator.isMemberInClass((PsiMember)method, "java.lang.Class")) {
                return;
            }
            if (Intrinsics.areEqual((Object)GET_DECLARED_METHOD, (Object)method.getName())) {
                this.checkGetDeclaredMethod(context, node);
            } else {
                this.checkLoadClass(context, node);
            }
        }
    }

    private final void checkGetDeclaredMethod(JavaContext context, UCallExpression call) {
        String string = this.getClassFromMemberLookup(call);
        if (string == null) {
            return;
        }
        String cls = string;
        if (!StringsKt.startsWith$default((String)cls, (String)"com.android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)cls, (String)"android.", (boolean)false, (int)2, null)) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String methodName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass psiClass = context.getEvaluator().findClass(cls);
        if (psiClass == null) {
            return;
        }
        PsiClass aClass = psiClass;
        PsiMethod[] methodsByName = aClass.findMethodsByName(methodName, true);
        Object[] objectArray = methodsByName;
        if (objectArray.length == 0) {
            Location location = context.getLocation((UElement)call);
            Issue issue = ISSUE;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
            JavaContext.report$default((JavaContext)context, (Issue)issue, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final void checkLoadClass(JavaContext context, UCallExpression call) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)));
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String value = string;
        boolean isInternal = false;
        if (StringsKt.startsWith$default((String)value, (String)"com.android.internal.", (boolean)false, (int)2, null)) {
            isInternal = true;
        } else if (StringsKt.startsWith$default((String)value, (String)"com.android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"android.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)value, (String)"android.support.", (boolean)false, (int)2, null)) {
            PsiClass aClass = context.getEvaluator().findClass(value);
            if (aClass != null) {
                return;
            }
            String owner = ClassContext.Companion.getInternalName(value);
            ApiLookup apiLookup = ApiLookup.get(context.getClient(), context.getMainProject().getBuildTarget());
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiLookup2 = apiLookup;
            boolean bl = isInternal = !apiLookup2.containsClass(owner);
        }
        if (isInternal) {
            Location location = context.getLocation((UElement)call);
            Issue issue = ISSUE;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
            JavaContext.report$default((JavaContext)context, (Issue)issue, (UElement)((UElement)call), (Location)location, (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final String getClassFromMemberLookup(UCallExpression call) {
        return this.findReflectionClass((UElement)call.getReceiver());
    }

    private final String findReflectionClass(UElement element) {
        if (element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
            return this.findReflectionClass((UElement)((UQualifiedReferenceExpression)element).getSelector());
        }
        if (element instanceof UCallExpression) {
            UExpression qualifier;
            PsiType qualifierType;
            String name = ((UCallExpression)element).getMethodName();
            if (Intrinsics.areEqual((Object)FOR_NAME, (Object)name) || Intrinsics.areEqual((Object)LOAD_CLASS, (Object)name)) {
                List arguments = ((UCallExpression)element).getValueArguments();
                Collection collection = arguments;
                if (!collection.isEmpty()) {
                    return ConstantEvaluator.evaluateString(null, (UElement)((UElement)arguments.get(0)), (boolean)false);
                }
            } else if (Intrinsics.areEqual((Object)GET_CLASS, (Object)name) && (qualifierType = TypeEvaluator.evaluate((UElement)((UElement)(qualifier = ((UCallExpression)element).getReceiver())))) instanceof PsiClassType) {
                return ((PsiClassType)qualifierType).getCanonicalText();
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression expression = UastLintUtils.findLastAssignment((PsiVariable)((PsiVariable)resolved), (UElement)element);
                return this.findReflectionClass((UElement)expression);
            }
        } else if (element instanceof UClassLiteralExpression) {
            UExpression expression = ((UClassLiteralExpression)element).getExpression();
            if (expression instanceof UTypeReferenceExpression) {
                return ((UTypeReferenceExpression)expression).getQualifiedName();
            }
            PsiType type = ((UClassLiteralExpression)element).getExpressionType();
            if (type instanceof PsiClassType) {
                return ((PsiClassType)type).getCanonicalText();
            }
        }
        return null;
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.create((String)"PrivateApi", (String)"Using Private APIs", (String)"\nUsing reflection to access hidden/private Android APIs is not safe; it will often not work on \\\ndevices from other vendors, and it may suddenly stop working (if the API is removed) or crash \\\nspectacularly (if the API behavior changes, since there are no guarantees for compatibility.)\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/PrivateApiDetector$Issues;", "", "()V", "ERROR_MESSAGE", "", "FOR_NAME", "GET_CLASS", "GET_DECLARED_METHOD", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "LOAD_CLASS", "lint-checks_main"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

