/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.UniteSameType;
import com.intellij.openapi.diff.impl.processing.Word;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ByWord
implements DiffPolicy {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.ByWord");
    private final ComparisonPolicy myComparisonPolicy;

    public ByWord(ComparisonPolicy comparisonPolicy) {
        this.myComparisonPolicy = comparisonPolicy;
    }

    @Override
    @NotNull
    public DiffFragment[] buildFragments(@NotNull String text1, @NotNull String text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        DiffFragment[] diffFragmentArray = this.buildFragments(DiffString.create(text1), DiffString.create(text2));
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        return diffFragmentArray;
    }

    @Override
    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        Object[] words1 = ByWord.buildWords(text1, this.myComparisonPolicy);
        Object[] words2 = ByWord.buildWords(text2, this.myComparisonPolicy);
        Diff.Change change = Diff.buildChanges(words1, words2);
        change = Util.concatEquals(change, words1, words2);
        if (Math.max(ByWord.countNotWhitespaces((Word[])words1), ByWord.countNotWhitespaces((Word[])words2)) > 0 && ByWord.countEqual(change, (Word[])words1, (Word[])words2) == 0) {
            DiffFragment[] diffFragmentArray = new DiffFragment[]{this.myComparisonPolicy.createFragment(text1, text2)};
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
            }
            return diffFragmentArray;
        }
        FragmentBuilder result = new FragmentBuilder((Word[])words1, (Word[])words2, this.myComparisonPolicy, text1, text2);
        FragmentBuilder.Version version1 = result.getVersion1();
        FragmentBuilder.Version version2 = result.getVersion2();
        while (change != null) {
            if (change.line0 > version1.getCurrentWordIndex()) {
                ByWord.processEquals(change.line0, change.line1, result);
            }
            if (change.inserted == 0) {
                ByWord.processOneside(version1, change.deleted);
            } else if (change.deleted == 0) {
                ByWord.processOneside(version2, change.inserted);
            } else {
                DiffString prefix1 = version1.getCurrentWordPrefix();
                DiffString prefix2 = version2.getCurrentWordPrefix();
                if (!prefix1.isEmpty() || !prefix2.isEmpty()) {
                    result.add(this.myComparisonPolicy.createFragment(prefix1, prefix2));
                }
                result.addChangedWords(change.deleted, change.inserted);
            }
            change = change.link;
        }
        ByWord.processEquals(words1.length, words2.length, result);
        result.addTails();
        DiffFragment[] fragments = result.getFragments();
        DiffFragment firstFragment = fragments[0];
        if (firstFragment.isEmpty()) {
            DiffFragment[] newFragments = new DiffFragment[fragments.length - 1];
            System.arraycopy(fragments, 1, newFragments, 0, newFragments.length);
            fragments = newFragments;
        }
        if (fragments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord", "buildFragments"));
        }
        return fragments;
    }

    private static int countNotWhitespaces(@NotNull Word[] words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/openapi/diff/impl/processing/ByWord", "countNotWhitespaces"));
        }
        int counter = 0;
        for (int i = 0; i < words.length; ++i) {
            Word word = words[i];
            if (word.isWhitespace()) continue;
            ++counter;
        }
        return counter;
    }

    private static int countEqual(Diff.Change change, @NotNull Word[] words1, @NotNull Word[] words2) {
        if (words1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/openapi/diff/impl/processing/ByWord", "countEqual"));
        }
        if (words2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words2", "com/intellij/openapi/diff/impl/processing/ByWord", "countEqual"));
        }
        int counter = 0;
        int position1 = 0;
        int position2 = 0;
        while (change != null) {
            if (change.line0 > position1) {
                int same = change.line0 - position1;
                LOG.assertTrue(same == change.line1 - position2);
                for (int i = 0; i < same; ++i) {
                    if (words1[position1 + i].isWhitespace() || words2[position2 + i].isWhitespace()) continue;
                    ++counter;
                }
                position1 += same;
                position2 += same;
            }
            position1 += change.deleted;
            position2 += change.inserted;
            change = change.link;
        }
        int tailCount = words1.length - position1;
        LOG.assertTrue(tailCount == words2.length - position2);
        while (tailCount > 0) {
            if (!words1[words1.length - tailCount].isWhitespace() && !words2[words2.length - tailCount].isWhitespace()) {
                ++counter;
            }
            --tailCount;
        }
        return counter;
    }

    private static void processOneside(@NotNull FragmentBuilder.Version version, int wordCount) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/diff/impl/processing/ByWord", "processOneside"));
        }
        DiffString prefix = version.getCurrentWordPrefix();
        version.addOneSide(prefix, wordCount);
    }

    private static void processEquals(int changed1, int changed2, @NotNull FragmentBuilder result) throws FilesTooBigForDiffException {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/diff/impl/processing/ByWord", "processEquals"));
        }
        while (result.getVersion1().getCurrentWordIndex() < changed1) {
            result.processEqual();
        }
        LOG.assertTrue(changed2 == result.getVersion2().getCurrentWordIndex());
    }

    @NotNull
    static Word[] buildWords(@NotNull String text, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        Word[] wordArray = ByWord.buildWords(DiffString.create(text), policy);
        if (wordArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        return wordArray;
    }

    @NotNull
    static Word[] buildWords(@NotNull DiffString text, @NotNull ComparisonPolicy policy) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        ArrayList<Word> words = new ArrayList<Word>();
        if (text.isEmpty() || !Character.isWhitespace(text.charAt(0))) {
            words.add(policy.createFormatting(text, TextRange.EMPTY_RANGE));
        }
        int start = 0;
        boolean withinFormatting = true;
        for (int i = 0; i < text.length(); ++i) {
            char nextChar = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(nextChar);
            if (withinFormatting) {
                if (isWhitespace) continue;
                if (start != -1 && start < i) {
                    words.add(policy.createFormatting(text, new TextRange(start, i)));
                }
                start = -1;
                withinFormatting = false;
            }
            if (nextChar == '\n') {
                if (start != -1) {
                    words.add(new Word(text, new TextRange(start, i)));
                }
                start = i;
                withinFormatting = true;
                continue;
            }
            if (Util.DELIMITERS_SET.contains((int)nextChar)) {
                if (start == -1) continue;
                words.add(new Word(text, new TextRange(start, i)));
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            TextRange range = new TextRange(start, text.length());
            Word lastWord = withinFormatting ? policy.createFormatting(text, range) : new Word(text, range);
            words.add(lastWord);
        }
        Word[] wordArray = words.toArray(new Word[words.size()]);
        if (wordArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord", "buildWords"));
        }
        return wordArray;
    }

    private static class FragmentBuilder {
        private final ArrayList<DiffFragment> myFragments;
        private final Version myVersion1;
        private final Version myVersion2;
        private final DiffPolicy.ByChar BY_CHAR;
        private final DiffCorrection.ChangedSpace CORRECTION;
        private final ComparisonPolicy myComparisonPolicy;

        public FragmentBuilder(@NotNull Word[] words1, @NotNull Word[] words2, @NotNull ComparisonPolicy comparisonPolicy, @NotNull DiffString text1, @NotNull DiffString text2) {
            if (words1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words1", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "<init>"));
            }
            if (words2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words2", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "<init>"));
            }
            if (comparisonPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "<init>"));
            }
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "<init>"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "<init>"));
            }
            this.myFragments = new ArrayList();
            this.myVersion1 = new Version(words1, text1, this, true);
            this.myVersion2 = new Version(words2, text2, this, false);
            this.BY_CHAR = new DiffPolicy.ByChar(comparisonPolicy);
            this.CORRECTION = new DiffCorrection.ChangedSpace(comparisonPolicy);
            this.myComparisonPolicy = comparisonPolicy;
        }

        @NotNull
        public DiffFragment[] getFragments() {
            DiffFragment[] diffFragmentArray = this.myFragments.toArray(new DiffFragment[this.myFragments.size()]);
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "getFragments"));
            }
            return diffFragmentArray;
        }

        @NotNull
        public Version getVersion1() {
            Version version = this.myVersion1;
            if (version == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "getVersion1"));
            }
            return version;
        }

        @NotNull
        public Version getVersion2() {
            Version version = this.myVersion2;
            if (version == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "getVersion2"));
            }
            return version;
        }

        private void addAll(@NotNull DiffFragment[] fragments) {
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "addAll"));
            }
            for (int i = 0; i < fragments.length; ++i) {
                DiffFragment fragment = fragments[i];
                this.add(fragment);
            }
        }

        private void add(@NotNull DiffFragment fragment) {
            int lastIndex;
            DiffFragment prevFragment;
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "add"));
            }
            DiffString text1 = fragment.getText1();
            DiffString text2 = fragment.getText2();
            if (text1 != null) {
                this.myVersion1.addOffset(text1.length());
            }
            if (text2 != null) {
                this.myVersion2.addOffset(text2.length());
            }
            if (fragment.isEqual() && !this.myFragments.isEmpty() && (prevFragment = this.myFragments.get(lastIndex = this.myFragments.size() - 1)).isEqual()) {
                prevFragment.appendText1(text1);
                prevFragment.appendText2(text2);
                return;
            }
            this.myFragments.add(fragment);
        }

        private void addEqual(@NotNull Word word1, @NotNull Word word2) throws FilesTooBigForDiffException {
            if (word1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word1", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "addEqual"));
            }
            if (word2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word2", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "addEqual"));
            }
            this.addAll(this.CORRECTION.correct(new DiffFragment[]{this.myComparisonPolicy.createFragment(word1, word2)}));
        }

        public void processEqual() throws FilesTooBigForDiffException {
            Word word1 = this.myVersion1.getCurrentWord();
            Word word2 = this.myVersion2.getCurrentWord();
            this.addAll(this.fragmentsByChar(this.myVersion1.getCurrentWordPrefix(), this.myVersion2.getCurrentWordPrefix()));
            this.addEqual(word1, word2);
            this.addPostfixes();
            this.myVersion1.incCurrentWord();
            this.myVersion2.incCurrentWord();
        }

        @NotNull
        private DiffFragment[] fragmentsByChar(@NotNull DiffString text1, @NotNull DiffString text2) throws FilesTooBigForDiffException {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "fragmentsByChar"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "fragmentsByChar"));
            }
            if (text1.isEmpty() && text2.isEmpty()) {
                if (DiffFragment.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "fragmentsByChar"));
                }
                return DiffFragment.EMPTY_ARRAY;
            }
            DiffString side1 = text1.preappend(this.myVersion1.getPrevChar());
            DiffString side2 = text2.preappend(this.myVersion2.getPrevChar());
            DiffFragment[] fragments = this.BY_CHAR.buildFragments(side1, side2);
            DiffFragment[] diffFragmentArray = Util.cutFirst(fragments);
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "fragmentsByChar"));
            }
            return diffFragmentArray;
        }

        private void addPostfixes() throws FilesTooBigForDiffException {
            DiffFragment[] fragments;
            DiffFragment firstFragment;
            DiffString postfix1 = this.myVersion1.getCurrentWordPostfixAndOneMore();
            DiffString postfix2 = this.myVersion2.getCurrentWordPostfixAndOneMore();
            int length1 = postfix1.length();
            int length2 = postfix2.length();
            DiffFragment wholePostfix = this.myComparisonPolicy.createFragment(postfix1, postfix2);
            if (wholePostfix.isEqual()) {
                this.add(DiffFragment.unchanged(FragmentBuilder.cutLast(postfix1, length1), FragmentBuilder.cutLast(postfix2, length2)));
                return;
            }
            if ((length1 > 0 || length2 > 0) && (firstFragment = (fragments = this.BY_CHAR.buildFragments(postfix1, postfix2))[0]).isEqual()) {
                DiffString text1 = FragmentBuilder.cutLast(firstFragment.getText1(), length1);
                DiffString text2 = FragmentBuilder.cutLast(firstFragment.getText2(), length2);
                this.add(this.myComparisonPolicy.createFragment(text1, text2));
            }
        }

        @NotNull
        private static DiffString cutLast(@NotNull DiffString text, int length) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "cutLast"));
            }
            if (text.length() < length) {
                DiffString diffString = text;
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "cutLast"));
                }
                return diffString;
            }
            DiffString diffString = text.substring(0, text.length() - 1);
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "cutLast"));
            }
            return diffString;
        }

        private void addOneSide(@NotNull DiffString text, @NotNull FragmentSide side) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "addOneSide"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder", "addOneSide"));
            }
            DiffFragment fragment = side.createFragment(text, null, false);
            this.add(this.myComparisonPolicy.createFragment(fragment.getText1(), fragment.getText2()));
        }

        public void addChangedWords(int wordCount1, int wordCount2) {
            this.add(new DiffFragment(this.myVersion1.getWordSequence(wordCount1), this.myVersion2.getWordSequence(wordCount2)));
            this.myVersion1.incCurrentWord(wordCount1);
            this.myVersion2.incCurrentWord(wordCount2);
        }

        public void addTails() throws FilesTooBigForDiffException {
            DiffFragment lastFragment;
            DiffString tail1 = this.myVersion1.getNotProcessedTail();
            DiffString tail2 = this.myVersion2.getNotProcessedTail();
            if (tail1.isEmpty() && tail2.isEmpty()) {
                return;
            }
            DiffFragment[] fragments = this.fragmentsByChar(tail1, tail2);
            if (!this.myFragments.isEmpty() && (lastFragment = this.myFragments.get(this.myFragments.size() - 1)).isChange()) {
                int oneSideCount;
                for (oneSideCount = 0; oneSideCount < fragments.length && fragments[oneSideCount].isOneSide(); ++oneSideCount) {
                }
                if (oneSideCount > 0) {
                    this.myFragments.remove(this.myFragments.size() - 1);
                    DiffFragment[] onesideFragments = new DiffFragment[oneSideCount];
                    DiffFragment[] otherFragments = new DiffFragment[fragments.length - oneSideCount];
                    System.arraycopy(fragments, 0, onesideFragments, 0, oneSideCount);
                    System.arraycopy(fragments, oneSideCount, otherFragments, 0, otherFragments.length);
                    DiffFragment startingOneSides = UniteSameType.uniteAll(onesideFragments);
                    if (startingOneSides.isOneSide()) {
                        this.myFragments.add(lastFragment);
                        this.add(startingOneSides);
                    } else {
                        lastFragment = Util.unite(lastFragment, startingOneSides);
                        this.myFragments.add(lastFragment);
                    }
                    fragments = otherFragments;
                }
            }
            this.addAll(fragments);
        }

        public static class Version {
            @NotNull
            private final Word[] myWords;
            private int myCurrentWord;
            private int myOffset;
            @NotNull
            private final DiffString myText;
            @NotNull
            private final FragmentBuilder myBuilder;
            private final FragmentSide mySide;

            public Version(@NotNull Word[] words, @NotNull DiffString text, @NotNull FragmentBuilder builder, boolean delete) {
                if (words == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "<init>"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "<init>"));
                }
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "<init>"));
                }
                this.myCurrentWord = 0;
                this.myOffset = 0;
                this.myWords = words;
                this.myText = text;
                this.myBuilder = builder;
                this.mySide = delete ? FragmentSide.SIDE1 : FragmentSide.SIDE2;
            }

            public int getProcessedOffset() {
                return this.myOffset;
            }

            public int getCurrentWordIndex() {
                return this.myCurrentWord;
            }

            public void addOffset(int offset) {
                this.myOffset += offset;
            }

            public void incCurrentWord() {
                this.incCurrentWord(1);
            }

            @NotNull
            public DiffString getWordSequence(int wordCount) {
                int start = this.myWords[this.myCurrentWord].getStart();
                int end = this.myWords[this.myCurrentWord + wordCount - 1].getEnd();
                DiffString diffString = this.myText.substring(start, end);
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "getWordSequence"));
                }
                return diffString;
            }

            public void incCurrentWord(int inserted) {
                this.myCurrentWord += inserted;
            }

            @NotNull
            public Word getCurrentWord() {
                Word word = this.myWords[this.myCurrentWord];
                if (word == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "getCurrentWord"));
                }
                return word;
            }

            @NotNull
            public DiffString getCurrentWordPrefix() {
                DiffString diffString = this.getCurrentWord().getPrefix(this.getProcessedOffset());
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "getCurrentWordPrefix"));
                }
                return diffString;
            }

            @NotNull
            public DiffString getCurrentWordPostfixAndOneMore() {
                int nextStart = this.myCurrentWord < this.myWords.length - 1 ? this.myWords[this.myCurrentWord + 1].getStart() : this.myText.length();
                Word word = this.getCurrentWord();
                DiffString postfix = this.myText.substring(word.getEnd(), nextStart);
                DiffString diffString = postfix.append(nextStart == this.myText.length() ? (char)'\n' : this.myText.charAt(nextStart));
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "getCurrentWordPostfixAndOneMore"));
                }
                return diffString;
            }

            @NotNull
            public DiffString getNotProcessedTail() {
                LOG.assertTrue(this.myCurrentWord == this.myWords.length);
                DiffString diffString = this.myText.substring(this.myOffset, this.myText.length());
                if (diffString == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "getNotProcessedTail"));
                }
                return diffString;
            }

            public char getPrevChar() {
                return this.myOffset == 0 ? (char)'\n' : this.myText.charAt(this.myOffset - 1);
            }

            public void addOneSide(@NotNull DiffString prefix, int wordCount) {
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/diff/impl/processing/ByWord$FragmentBuilder$Version", "addOneSide"));
                }
                if (!prefix.isEmpty()) {
                    this.myBuilder.addOneSide(prefix, this.mySide);
                }
                this.myBuilder.addOneSide(this.getWordSequence(wordCount), this.mySide);
                this.incCurrentWord(wordCount);
            }
        }
    }
}

