/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExecutionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.OrderedSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionCallback
implements Disposable {
    public static final ActionCallback DONE = new Done();
    public static final ActionCallback REJECTED = new Rejected();
    private final ExecutionCallback myDone;
    private final ExecutionCallback myRejected;
    protected String myError;
    private final String myName;

    public ActionCallback() {
        this(null);
    }

    public ActionCallback(String name) {
        this.myName = name;
        this.myDone = new ExecutionCallback();
        this.myRejected = new ExecutionCallback();
    }

    private ActionCallback(ExecutionCallback done, ExecutionCallback rejected) {
        this.myDone = done;
        this.myRejected = rejected;
        this.myName = null;
    }

    public ActionCallback(int countToDone) {
        this(null, countToDone);
    }

    public ActionCallback(String name, int countToDone) {
        this.myName = name;
        assert (countToDone >= 0) : "count=" + countToDone;
        this.myDone = new ExecutionCallback(countToDone >= 1 ? countToDone : 1);
        this.myRejected = new ExecutionCallback();
        if (countToDone < 1) {
            this.setDone();
        }
    }

    public void setDone() {
        if (this.myDone.setExecuted()) {
            this.myRejected.clear();
            Disposer.dispose(this);
        }
    }

    public boolean isDone() {
        return this.myDone.isExecuted();
    }

    public boolean isRejected() {
        return this.myRejected.isExecuted();
    }

    public boolean isProcessed() {
        return this.isDone() || this.isRejected();
    }

    public void setRejected() {
        if (this.myRejected.setExecuted()) {
            this.myDone.clear();
            Disposer.dispose(this);
        }
    }

    @NotNull
    public ActionCallback reject(String error) {
        this.myError = error;
        this.setRejected();
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "reject"));
        }
        return actionCallback;
    }

    @Nullable
    public String getError() {
        return this.myError;
    }

    @NotNull
    public final ActionCallback doWhenDone(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback", "doWhenDone"));
        }
        this.myDone.doWhenExecuted(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "doWhenDone"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback", "doWhenRejected"));
        }
        this.myRejected.doWhenExecuted(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "doWhenRejected"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenRejected(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/ActionCallback", "doWhenRejected"));
        }
        this.myRejected.doWhenExecuted(() -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/util/ActionCallback", "lambda$doWhenRejected$0"));
            }
            consumer.consume(this.myError);
        });
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "doWhenRejected"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback", "doWhenProcessed"));
        }
        this.doWhenDone(runnable);
        this.doWhenRejected(runnable);
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "doWhenProcessed"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback notifyWhenDone(@NotNull ActionCallback child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/ActionCallback", "notifyWhenDone"));
        }
        ActionCallback actionCallback = this.doWhenDone(child.createSetDoneRunnable());
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "notifyWhenDone"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback notifyWhenRejected(@NotNull ActionCallback child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/ActionCallback", "notifyWhenRejected"));
        }
        ActionCallback actionCallback = this.doWhenRejected(() -> {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/ActionCallback", "lambda$notifyWhenRejected$1"));
            }
            child.reject(this.myError);
        });
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "notifyWhenRejected"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback notify(@NotNull ActionCallback child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/ActionCallback", "notify"));
        }
        ActionCallback actionCallback = this.doWhenDone(child.createSetDoneRunnable()).notifyWhenRejected(child);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "notify"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback processOnDone(@NotNull Runnable runnable, boolean requiresDone) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback", "processOnDone"));
        }
        if (requiresDone) {
            ActionCallback actionCallback = this.doWhenDone(runnable);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "processOnDone"));
            }
            return actionCallback;
        }
        runnable.run();
        ActionCallback actionCallback = this;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "processOnDone"));
        }
        return actionCallback;
    }

    @NonNls
    public String toString() {
        String name = this.myName != null ? this.myName : super.toString();
        return name + " done=[" + this.myDone + "] rejected=[" + this.myRejected + "]";
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Runnable createSetDoneRunnable() {
        Runnable runnable = () -> this.setDone();
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "createSetDoneRunnable"));
        }
        return runnable;
    }

    @Deprecated
    @NotNull
    public Runnable createSetRejectedRunnable() {
        Runnable runnable = () -> this.setRejected();
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback", "createSetRejectedRunnable"));
        }
        return runnable;
    }

    public boolean waitFor(long msTimeout) {
        if (this.isProcessed()) {
            return true;
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.doWhenProcessed(() -> semaphore.up());
        try {
            if (msTimeout == -1L) {
                semaphore.waitForUnsafe();
            } else if (!semaphore.waitForUnsafe(msTimeout)) {
                this.reject("Time limit exceeded");
                return false;
            }
        }
        catch (InterruptedException e) {
            this.reject(e.getMessage());
            return false;
        }
        return true;
    }

    public static class Chunk {
        private final Set<ActionCallback> myCallbacks = new OrderedSet<ActionCallback>();

        public void add(@NotNull ActionCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/util/ActionCallback$Chunk", "add"));
            }
            this.myCallbacks.add(callback);
        }

        @NotNull
        public ActionCallback create() {
            if (this.isEmpty()) {
                ActionCallback actionCallback = DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback$Chunk", "create"));
                }
                return actionCallback;
            }
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable doneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenDone(doneRunnable).notifyWhenRejected(result);
            }
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback$Chunk", "create"));
            }
            return actionCallback;
        }

        public boolean isEmpty() {
            return this.myCallbacks.isEmpty();
        }

        public int getSize() {
            return this.myCallbacks.size();
        }

        @NotNull
        public ActionCallback getWhenProcessed() {
            ActionCallback result = new ActionCallback(this.myCallbacks.size());
            Runnable setDoneRunnable = result.createSetDoneRunnable();
            for (ActionCallback each : this.myCallbacks) {
                each.doWhenProcessed(setDoneRunnable);
            }
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/ActionCallback$Chunk", "getWhenProcessed"));
            }
            return actionCallback;
        }
    }

    private static class IgnoreExecutionCallback
    extends ExecutionCallback {
        private IgnoreExecutionCallback() {
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback$IgnoreExecutionCallback", "doWhenExecuted"));
            }
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return false;
        }
    }

    private static class ExecutedExecutionCallback
    extends ExecutionCallback {
        public ExecutedExecutionCallback() {
            super(0);
        }

        @Override
        void doWhenExecuted(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/ActionCallback$ExecutedExecutionCallback", "doWhenExecuted"));
            }
            runnable.run();
        }

        @Override
        boolean setExecuted() {
            throw new IllegalStateException("Forbidden");
        }

        @Override
        boolean isExecuted() {
            return true;
        }
    }

    public static class Rejected
    extends ActionCallback {
        public Rejected() {
            super(new IgnoreExecutionCallback(), new ExecutedExecutionCallback());
        }
    }

    public static class Done
    extends ActionCallback {
        public Done() {
            super(new ExecutedExecutionCallback(), new IgnoreExecutionCallback());
        }
    }
}

