/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.text.ByteArrayCharSequence;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final File myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){

        @Override
        public int hash(EntryInfo info) {
            return System.identityHashCode(info);
        }

        @Override
        public EntryInfo key(Object o) {
            if (o instanceof EntryInfo) {
                return ((EntryInfo)o).parent;
            }
            return ((EntryInfo[])o)[0].parent;
        }
    };

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/ArchiveHandler", "<init>"));
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference<Object>(null);
        this.myChildrenEntries = new SoftReference<Object>(null);
        this.myPath = new File(path);
    }

    @NotNull
    public File getFile() {
        File file = this.myPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getFile"));
        }
        return file;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getAttributes"));
        }
        if (relativePath.isEmpty()) {
            FileAttributes attributes = FileSystemUtil.getAttributes(this.myPath);
            return attributes != null ? new FileAttributes(true, false, false, false, 0L, -1L, false) : null;
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        return entry != null ? new FileAttributes(entry.isDirectory, false, false, false, entry.length, entry.timestamp, false) : null;
    }

    @NotNull
    public String[] list(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
        }
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        AddonlyKeylessHash<EntryInfo, Object> result = this.getParentChildrenMap();
        Object o = result.get(entry);
        if (o == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (o instanceof EntryInfo) {
            String[] stringArray = new String[]{((EntryInfo)o).shortName.toString()};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
            }
            return stringArray;
        }
        EntryInfo[] infos = (EntryInfo[])o;
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].shortName.toString();
        }
        if (names == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "list"));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AddonlyKeylessHash<EntryInfo, Object> getParentChildrenMap() {
        AddonlyKeylessHash<EntryInfo, Object> map = SoftReference.dereference(this.myChildrenEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myChildrenEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                    } else {
                        try {
                            map = this.createParentChildrenMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                        }
                    }
                    this.myChildrenEntries = new SoftReference<AddonlyKeylessHash<EntryInfo, Object>>(map);
                }
            }
        }
        AddonlyKeylessHash<EntryInfo, Object> addonlyKeylessHash = map;
        if (addonlyKeylessHash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getParentChildrenMap"));
        }
        return addonlyKeylessHash;
    }

    private AddonlyKeylessHash<EntryInfo, Object> createParentChildrenMap() {
        THashMap map = new THashMap();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.isDirectory && !map.containsKey((Object)info)) {
                map.put((Object)info, new SmartList());
            }
            if (info.parent == null) continue;
            SmartList<EntryInfo> parentChildren = (SmartList<EntryInfo>)map.get((Object)info.parent);
            if (parentChildren == null) {
                parentChildren = new SmartList<EntryInfo>();
                map.put((Object)info.parent, parentChildren);
            }
            parentChildren.add(info);
        }
        final AddonlyKeylessHash<EntryInfo, Object> result = new AddonlyKeylessHash<EntryInfo, Object>(map.size(), ourKeyValueMapper);
        map.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<EntryInfo, List<EntryInfo>>(){

            public boolean execute(EntryInfo a, List<EntryInfo> b) {
                int numberOfChildren = b.size();
                if (numberOfChildren == 1) {
                    result.add(b.get(0));
                } else if (numberOfChildren > 1) {
                    result.add(b.toArray(new EntryInfo[numberOfChildren]));
                }
                return true;
            }
        });
        return result;
    }

    public void dispose() {
        this.myEntries.clear();
        this.myChildrenEntries.clear();
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntryInfo"));
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference<Map<String, EntryInfo>>(map);
                }
            }
        }
        Map<String, EntryInfo> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getEntriesMap"));
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        EntryInfo entryInfo = new EntryInfo("", true, 0L, -1L, null);
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "createRootEntry"));
        }
        return entryInfo;
    }

    @NotNull
    protected EntryInfo getOrCreate(@NotNull Map<String, EntryInfo> map, @NotNull String entryName) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair<String, String> path = this.splitPath(entryName);
            EntryInfo parentEntry = this.getOrCreate(map, (String)path.first);
            CharSequence shortName = ByteArrayCharSequence.convertToBytesIfAsciiString((String)path.second);
            entry = new EntryInfo(shortName, true, 0L, -1L, parentEntry);
            map.put(entryName, entry);
        }
        EntryInfo entryInfo = entry;
        if (entryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getOrCreate"));
        }
        return entryInfo;
    }

    @NotNull
    protected Pair<String, String> splitPath(@NotNull String entryName) {
        if (entryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryName", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        int p = entryName.lastIndexOf(47);
        String parentName = p > 0 ? entryName.substring(0, p) : "";
        String shortName = p > 0 ? entryName.substring(p + 1) : entryName;
        Pair<String, String> pair = Pair.create(parentName, shortName);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "splitPath"));
        }
        return pair;
    }

    @NotNull
    public abstract byte[] contentsToByteArray(@NotNull String var1) throws IOException;

    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(relativePath));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/ArchiveHandler", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent;
            if (shortName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
            }
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

