/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathMapper
implements PathMapper {
    @Nullable
    public static String convertToLocal(@NotNull String remotePath, @NotNull Iterable<PathMappingSettings.PathMapping> mappings) {
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/intellij/util/AbstractPathMapper", "convertToLocal"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/util/AbstractPathMapper", "convertToLocal"));
        }
        PathMappingSettings.BestMappingSelector selector = new PathMappingSettings.BestMappingSelector();
        for (PathMappingSettings.PathMapping mapping : mappings) {
            if (!mapping.canReplaceRemote(remotePath)) continue;
            selector.consider(mapping, mapping.getRemoteLen());
        }
        if (selector.get() != null) {
            return selector.get().mapToLocal(remotePath);
        }
        return null;
    }

    @Nullable
    public static String convertToRemote(@NotNull String localPath, @NotNull Collection<PathMappingSettings.PathMapping> pathMappings) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/util/AbstractPathMapper", "convertToRemote"));
        }
        if (pathMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMappings", "com/intellij/util/AbstractPathMapper", "convertToRemote"));
        }
        PathMappingSettings.BestMappingSelector selector = new PathMappingSettings.BestMappingSelector();
        for (PathMappingSettings.PathMapping mapping : pathMappings) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            selector.consider(mapping, mapping.getLocalLen());
        }
        if (selector.get() != null) {
            return selector.get().mapToRemote(localPath);
        }
        return null;
    }

    @Override
    @NotNull
    public final List<String> convertToRemote(@NotNull Collection<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/util/AbstractPathMapper", "convertToRemote"));
        }
        ArrayList<String> result = ContainerUtil.newArrayList();
        for (String p : paths) {
            result.add(this.convertToRemote(p));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/AbstractPathMapper", "convertToRemote"));
        }
        return arrayList;
    }

    @Override
    public final boolean canReplaceRemote(@NotNull String remotePath) {
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/intellij/util/AbstractPathMapper", "canReplaceRemote"));
        }
        for (PathMappingSettings.PathMapping mapping : this.getAvailablePathMappings()) {
            if (!mapping.canReplaceRemote(remotePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean canReplaceLocal(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/util/AbstractPathMapper", "canReplaceLocal"));
        }
        for (PathMappingSettings.PathMapping mapping : this.getAvailablePathMappings()) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<PathMappingSettings.PathMapping> getAvailablePathMappings();
}

