/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMappingSettings
extends AbstractPathMapper
implements Cloneable {
    @NotNull
    private List<PathMapping> myPathMappings;

    public PathMappingSettings(@Nullable List<PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    private static List<PathMapping> create(@Nullable List<PathMapping> mappings) {
        ArrayList<PathMapping> result = ContainerUtil.newArrayList();
        if (mappings != null) {
            for (PathMapping m : mappings) {
                if (m == null || PathMappingSettings.isAnyEmpty(m.getLocalRoot(), m.getRemoteRoot())) continue;
                result.add(m);
            }
        }
        ArrayList<PathMapping> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "create"));
        }
        return arrayList;
    }

    public PathMappingSettings() {
        this.myPathMappings = ContainerUtil.newArrayList();
    }

    @NotNull
    static String norm(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "norm"));
        }
        String string = FileUtil.toSystemIndependentName(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "norm"));
        }
        return string;
    }

    @NotNull
    private static String normLocal(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "normLocal"));
        }
        if (SystemInfo.isWindows) {
            path = path.toLowerCase();
        }
        String string = PathMappingSettings.norm(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "normLocal"));
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return this.myPathMappings.isEmpty();
    }

    @Deprecated
    public boolean isUseMapping() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        if (remotePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePath", "com/intellij/util/PathMappingSettings", "convertToLocal"));
        }
        String localPath = PathMappingSettings.convertToLocal(remotePath, this.myPathMappings);
        String string = localPath != null ? localPath : remotePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "convertToLocal"));
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/util/PathMappingSettings", "convertToRemote"));
        }
        String remotePath = PathMappingSettings.convertToRemote(localPath, this.myPathMappings);
        String string = remotePath != null ? remotePath : localPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "convertToRemote"));
        }
        return string;
    }

    public void add(@NotNull PathMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/util/PathMappingSettings", "add"));
        }
        if (PathMappingSettings.isAnyEmpty(mapping.getLocalRoot(), mapping.getRemoteRoot())) {
            return;
        }
        this.myPathMappings.add(mapping);
    }

    public void addMapping(@Nullable String local, @Nullable String remote) {
        PathMapping mapping = new PathMapping(local, remote);
        this.add(mapping);
    }

    public void addMappingCheckUnique(@NotNull String local, @NotNull String remote) {
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/util/PathMappingSettings", "addMappingCheckUnique"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "com/intellij/util/PathMappingSettings", "addMappingCheckUnique"));
        }
        for (PathMapping mapping : this.myPathMappings) {
            if (!PathMappingSettings.pathEquals(local, mapping.getLocalRoot()) || !PathMappingSettings.pathEquals(remote, mapping.getRemoteRoot())) continue;
            return;
        }
        this.addMapping(local, remote);
    }

    private static boolean pathEquals(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/util/PathMappingSettings", "pathEquals"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/util/PathMappingSettings", "pathEquals"));
        }
        return PathMappingSettings.norm(path1).equals(PathMappingSettings.norm(path2));
    }

    @Override
    @NotNull
    protected final Collection<PathMapping> getAvailablePathMappings() {
        Collection<PathMapping> collection = Collections.unmodifiableCollection(this.myPathMappings);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "getAvailablePathMappings"));
        }
        return collection;
    }

    @NotNull
    public List<PathMapping> getPathMappings() {
        List<PathMapping> list = this.myPathMappings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "getPathMappings"));
        }
        return list;
    }

    public void setPathMappings(@Nullable List<PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    public static String mapToLocal(@NotNull String path, @Nullable String remoteRoot, @Nullable String localRoot) {
        String remotePrefix;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "mapToLocal"));
        }
        if (PathMappingSettings.isAnyEmpty(localRoot, remoteRoot)) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "mapToLocal"));
            }
            return string;
        }
        if (PathMappingSettings.canReplaceRemote(path = PathMappingSettings.norm(path), remotePrefix = PathMappingSettings.norm(remoteRoot))) {
            path = PathMappingSettings.norm(localRoot) + path.substring(remotePrefix.length());
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "mapToLocal"));
        }
        return string;
    }

    @Contract(value="null, _ -> true; _, null -> true", pure=true)
    public static boolean isAnyEmpty(@Nullable String localRoot, @Nullable String remoteRoot) {
        return StringUtil.isEmpty(localRoot) || StringUtil.isEmpty(remoteRoot);
    }

    @Nullable
    public static PathMappingSettings readExternal(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        Element settingsElement = element.getChild(PathMappingSettings.class.getSimpleName());
        if (settingsElement == null) {
            return null;
        }
        return XmlSerializer.deserialize(settingsElement, PathMappingSettings.class);
    }

    public static void writeExternal(@Nullable Element element, @Nullable PathMappingSettings mappings) {
        if (element == null || mappings == null || mappings.isEmpty()) {
            return;
        }
        element.addContent(XmlSerializer.serialize(mappings));
    }

    public void addAll(@NotNull PathMappingSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/util/PathMappingSettings", "addAll"));
        }
        this.myPathMappings.addAll(settings.getPathMappings());
    }

    public void addAll(@NotNull List<PathMapping> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/util/PathMappingSettings", "addAll"));
        }
        this.myPathMappings.addAll(mappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMappingSettings settings = (PathMappingSettings)o;
        return this.myPathMappings.equals(settings.myPathMappings);
    }

    public int hashCode() {
        return this.myPathMappings.hashCode();
    }

    private static boolean canReplaceRemote(@NotNull String path, @NotNull String remotePrefix) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "canReplaceRemote"));
        }
        if (remotePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePrefix", "com/intellij/util/PathMappingSettings", "canReplaceRemote"));
        }
        return (path = PathMappingSettings.norm(path)).startsWith(remotePrefix = PathMappingSettings.norm(remotePrefix)) && (path.length() == remotePrefix.length() || remotePrefix.endsWith("/") || path.substring(remotePrefix.length()).startsWith("/"));
    }

    @Tag(value="mapping")
    public static class PathMapping {
        private String myLocalRoot;
        private String myRemoteRoot;

        public PathMapping() {
        }

        public PathMapping(@Nullable String localRoot, @Nullable String remoteRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @Nullable
        private static String normalize(@Nullable String path) {
            if (path == null) {
                return null;
            }
            return PathMapping.trimSlash(FileUtil.toSystemIndependentName(path));
        }

        @Attribute(value="local-root")
        public String getLocalRoot() {
            return this.myLocalRoot;
        }

        @Attribute(value="remote-root")
        public String getRemoteRoot() {
            return this.myRemoteRoot;
        }

        public int getLocalLen() {
            return this.myLocalRoot != null ? this.myLocalRoot.length() : -1;
        }

        public int getRemoteLen() {
            return this.myRemoteRoot != null ? this.myRemoteRoot.length() : -1;
        }

        public void setLocalRoot(@Nullable String localRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
        }

        public void setRemoteRoot(@Nullable String remoteRoot) {
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @NotNull
        public String mapToLocal(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "mapToLocal"));
            }
            String string = PathMappingSettings.mapToLocal(path, this.myRemoteRoot, this.myLocalRoot);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings$PathMapping", "mapToLocal"));
            }
            return string;
        }

        public boolean canReplaceLocal(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "canReplaceLocal"));
            }
            if (this.isEmpty()) {
                return false;
            }
            String localPrefix = PathMappingSettings.normLocal(this.myLocalRoot);
            return !localPrefix.isEmpty() && PathMappingSettings.normLocal(path).startsWith(localPrefix);
        }

        public String mapToRemote(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "mapToRemote"));
            }
            if (this.isEmpty()) {
                return path;
            }
            if (this.canReplaceLocal(path)) {
                return PathMappingSettings.norm(this.myRemoteRoot) + PathMappingSettings.norm(path).substring(PathMappingSettings.normLocal(this.myLocalRoot).length());
            }
            return path;
        }

        private boolean isEmpty() {
            return PathMappingSettings.isAnyEmpty(this.myLocalRoot, this.myRemoteRoot);
        }

        private static String trimSlash(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/PathMappingSettings$PathMapping", "trimSlash"));
            }
            if (s.equals("/")) {
                return s;
            }
            return StringUtil.trimEnd(s, "/");
        }

        public boolean canReplaceRemote(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "canReplaceRemote"));
            }
            if (this.isEmpty()) {
                return false;
            }
            return PathMappingSettings.canReplaceRemote(path, this.myRemoteRoot);
        }

        public PathMapping clone() {
            return new PathMapping(this.myLocalRoot, this.myRemoteRoot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMapping mapping = (PathMapping)o;
            if (this.myLocalRoot != null ? !this.myLocalRoot.equals(mapping.myLocalRoot) : mapping.myLocalRoot != null) {
                return false;
            }
            return !(this.myRemoteRoot != null ? !this.myRemoteRoot.equals(mapping.myRemoteRoot) : mapping.myRemoteRoot != null);
        }

        public int hashCode() {
            int result = this.myLocalRoot != null ? this.myLocalRoot.hashCode() : 0;
            result = 31 * result + (this.myRemoteRoot != null ? this.myRemoteRoot.hashCode() : 0);
            return result;
        }
    }

    public static class BestMappingSelector {
        private int myBestWeight = -1;
        private PathMapping myBest = null;

        public void consider(PathMapping mapping, int weight) {
            if (weight > this.myBestWeight) {
                this.myBestWeight = weight;
                this.myBest = mapping;
            }
        }

        @Nullable
        public PathMapping get() {
            return this.myBest;
        }
    }
}

