/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.FileUtils;
import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.state.GLState;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.BufferSubDataTransform;
import com.android.ide.eclipse.gltrace.state.transforms.CurrentProgramPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.CurrentVboPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;
import com.android.ide.eclipse.gltrace.state.transforms.ListElementAddTransform;
import com.android.ide.eclipse.gltrace.state.transforms.Predicates;
import com.android.ide.eclipse.gltrace.state.transforms.PropertyChangeTransform;
import com.android.ide.eclipse.gltrace.state.transforms.SparseArrayElementAddTransform;
import com.android.ide.eclipse.gltrace.state.transforms.SparseArrayElementRemoveTransform;
import com.android.ide.eclipse.gltrace.state.transforms.TexImageTransform;
import com.android.ide.eclipse.gltrace.state.transforms.TexturePropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.TextureUnitPropertyAccessor;
import com.google.common.io.Files;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class StateTransformFactory {
    private static final String TEXTURE_DATA_FILE_PREFIX = "tex";
    private static final String TEXTURE_DATA_FILE_SUFFIX = ".dat";
    private static EnumSet<GLEnum> sTexParameterPnameValues;

    public static List<IStateTransform> getTransformsFor(GLProtoBuf.GLMessage msg) {
        switch (msg.getFunction()) {
            case eglCreateContext: {
                return StateTransformFactory.transformsForEglCreateContext(msg);
            }
            case glBindFramebuffer: {
                return StateTransformFactory.transformsForGlBindFramebuffer(msg);
            }
            case glVertexAttribPointer: {
                return StateTransformFactory.transformsForGlVertexAttribPointer(msg);
            }
            case glVertexAttrib1f: 
            case glVertexAttrib2f: 
            case glVertexAttrib3f: 
            case glVertexAttrib4f: {
                return StateTransformFactory.transformsForGlVertexAttribxf(msg);
            }
            case glVertexAttrib1fv: 
            case glVertexAttrib2fv: 
            case glVertexAttrib3fv: 
            case glVertexAttrib4fv: {
                return StateTransformFactory.transformsForGlVertexAttribxfv(msg);
            }
            case glEnableVertexAttribArray: {
                return StateTransformFactory.transformsForGlEnableVertexAttribArray(msg);
            }
            case glDisableVertexAttribArray: {
                return StateTransformFactory.transformsForGlDisableVertexAttribArray(msg);
            }
            case glBindBuffer: {
                return StateTransformFactory.transformsForGlBindBuffer(msg);
            }
            case glGenBuffers: {
                return StateTransformFactory.transformsForGlGenBuffers(msg);
            }
            case glDeleteBuffers: {
                return StateTransformFactory.transformsForGlDeleteBuffers(msg);
            }
            case glBufferData: {
                return StateTransformFactory.transformsForGlBufferData(msg);
            }
            case glBufferSubData: {
                return StateTransformFactory.transformsForGlBufferSubData(msg);
            }
            case glViewport: {
                return StateTransformFactory.transformsForGlViewport(msg);
            }
            case glDepthRangef: {
                return StateTransformFactory.transformsForGlDepthRangef(msg);
            }
            case glLineWidth: {
                return StateTransformFactory.transformsForGlLineWidth(msg);
            }
            case glCullFace: {
                return StateTransformFactory.transformsForGlCullFace(msg);
            }
            case glFrontFace: {
                return StateTransformFactory.transformsForGlFrontFace(msg);
            }
            case glPolygonOffset: {
                return StateTransformFactory.transformsForGlPolygonOffset(msg);
            }
            case glScissor: {
                return StateTransformFactory.transformsForGlScissor(msg);
            }
            case glStencilFunc: {
                return StateTransformFactory.transformsForGlStencilFunc(msg);
            }
            case glStencilFuncSeparate: {
                return StateTransformFactory.transformsForGlStencilFuncSeparate(msg);
            }
            case glStencilOp: {
                return StateTransformFactory.transformsForGlStencilOp(msg);
            }
            case glStencilOpSeparate: {
                return StateTransformFactory.transformsForGlStencilOpSeparate(msg);
            }
            case glDepthFunc: {
                return StateTransformFactory.transformsForGlDepthFunc(msg);
            }
            case glBlendEquation: {
                return StateTransformFactory.transformsForGlBlendEquation(msg);
            }
            case glBlendEquationSeparate: {
                return StateTransformFactory.transformsForGlBlendEquationSeparate(msg);
            }
            case glBlendFunc: {
                return StateTransformFactory.transformsForGlBlendFunc(msg);
            }
            case glBlendFuncSeparate: {
                return StateTransformFactory.transformsForGlBlendFuncSeparate(msg);
            }
            case glPixelStorei: {
                return StateTransformFactory.transformsForGlPixelStorei(msg);
            }
            case glGenTextures: {
                return StateTransformFactory.transformsForGlGenTextures(msg);
            }
            case glDeleteTextures: {
                return StateTransformFactory.transformsForGlDeleteTextures(msg);
            }
            case glActiveTexture: {
                return StateTransformFactory.transformsForGlActiveTexture(msg);
            }
            case glBindTexture: {
                return StateTransformFactory.transformsForGlBindTexture(msg);
            }
            case glTexImage2D: {
                return StateTransformFactory.transformsForGlTexImage2D(msg);
            }
            case glTexSubImage2D: {
                return StateTransformFactory.transformsForGlTexSubImage2D(msg);
            }
            case glTexParameteri: {
                return StateTransformFactory.transformsForGlTexParameter(msg);
            }
            case glCreateProgram: {
                return StateTransformFactory.transformsForGlCreateProgram(msg);
            }
            case glUseProgram: {
                return StateTransformFactory.transformsForGlUseProgram(msg);
            }
            case glAttachShader: {
                return StateTransformFactory.transformsForGlAttachShader(msg);
            }
            case glDetachShader: {
                return StateTransformFactory.transformsForGlDetachShader(msg);
            }
            case glGetActiveAttrib: {
                return StateTransformFactory.transformsForGlGetActiveAttrib(msg);
            }
            case glGetActiveUniform: {
                return StateTransformFactory.transformsForGlGetActiveUniform(msg);
            }
            case glUniform1i: 
            case glUniform2i: 
            case glUniform3i: 
            case glUniform4i: {
                return StateTransformFactory.transformsForGlUniform(msg, false);
            }
            case glUniform1f: 
            case glUniform2f: 
            case glUniform3f: 
            case glUniform4f: {
                return StateTransformFactory.transformsForGlUniform(msg, true);
            }
            case glUniform1iv: 
            case glUniform2iv: 
            case glUniform3iv: 
            case glUniform4iv: {
                return StateTransformFactory.transformsForGlUniformv(msg, false);
            }
            case glUniform1fv: 
            case glUniform2fv: 
            case glUniform3fv: 
            case glUniform4fv: {
                return StateTransformFactory.transformsForGlUniformv(msg, true);
            }
            case glUniformMatrix2fv: 
            case glUniformMatrix3fv: 
            case glUniformMatrix4fv: {
                return StateTransformFactory.transformsForGlUniformMatrix(msg);
            }
            case glCreateShader: {
                return StateTransformFactory.transformsForGlCreateShader(msg);
            }
            case glDeleteShader: {
                return StateTransformFactory.transformsForGlDeleteShader(msg);
            }
            case glShaderSource: {
                return StateTransformFactory.transformsForGlShaderSource(msg);
            }
        }
        return Collections.emptyList();
    }

    private static List<IStateTransform> transformsForGlVertexAttribPointer(GLProtoBuf.GLMessage msg) {
        int index = msg.getArgs(0).getIntValue(0);
        int size = msg.getArgs(1).getIntValue(0);
        int type = msg.getArgs(2).getIntValue(0);
        boolean normalized = msg.getArgs(3).getBoolValue(0);
        int stride = msg.getArgs(4).getIntValue(0);
        long pointer = msg.getArgs(5).getIntValueCount() > 0 ? (long)msg.getArgs(5).getIntValue(0) : msg.getArgs(5).getInt64Value(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_SIZE}), size));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_TYPE}), (Object)GLEnum.valueOf(type)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_NORMALIZED}), normalized));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_STRIDE}), stride));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_POINTER}), pointer));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlVertexAttrib(int context, int index, float v0, float v1, float v2, float v3) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>(4);
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(context, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, index, GLStateType.GENERIC_VERTEX_ATTRIB_V0}), Float.valueOf(v0)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(context, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, index, GLStateType.GENERIC_VERTEX_ATTRIB_V1}), Float.valueOf(v1)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(context, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, index, GLStateType.GENERIC_VERTEX_ATTRIB_V2}), Float.valueOf(v2)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(context, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.GENERIC_VERTEX_ATTRIBUTES, index, GLStateType.GENERIC_VERTEX_ATTRIB_V3}), Float.valueOf(v3)));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlVertexAttribxf(GLProtoBuf.GLMessage msg) {
        int index = msg.getArgs(0).getIntValue(0);
        float v0 = msg.getArgs(1).getFloatValue(0);
        float v1 = msg.getArgsCount() > 2 ? msg.getArgs(2).getFloatValue(0) : 0.0f;
        float v2 = msg.getArgsCount() > 3 ? msg.getArgs(3).getFloatValue(0) : 0.0f;
        float v3 = msg.getArgsCount() > 4 ? msg.getArgs(4).getFloatValue(0) : 0.0f;
        return StateTransformFactory.transformsForGlVertexAttrib(msg.getContextId(), index, v0, v1, v2, v3);
    }

    private static List<IStateTransform> transformsForGlVertexAttribxfv(GLProtoBuf.GLMessage msg) {
        int index = msg.getArgs(0).getIntValue(0);
        float[] v = new float[4];
        int i = 0;
        while (i < msg.getArgs(1).getFloatValueList().size()) {
            v[i] = msg.getArgs(1).getFloatValue(i);
            ++i;
        }
        return StateTransformFactory.transformsForGlVertexAttrib(msg.getContextId(), index, v[0], v[1], v[2], v[3]);
    }

    private static List<IStateTransform> transformsForGlEnableVertexAttribArray(GLProtoBuf.GLMessage msg) {
        int index = msg.getArgs(0).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_ENABLED}), Boolean.TRUE);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlDisableVertexAttribArray(GLProtoBuf.GLMessage msg) {
        int index = msg.getArgs(0).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VERTEX_ATTRIB_ARRAY, index, GLStateType.VERTEX_ATTRIB_ARRAY_ENABLED}), Boolean.FALSE);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlBindBuffer(GLProtoBuf.GLMessage msg) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int buffer = msg.getArgs(1).getIntValue(0);
        GLStateType bufferType = target == GLEnum.GL_ARRAY_BUFFER ? GLStateType.ARRAY_BUFFER_BINDING : GLStateType.ELEMENT_ARRAY_BUFFER_BINDING;
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.BUFFER_BINDINGS, bufferType}), buffer);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlGenBuffers(GLProtoBuf.GLMessage msg) {
        int n = msg.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        int i = 0;
        while (i < n) {
            transforms.add(new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VBO}), msg.getArgs(1).getIntValue(i)));
            ++i;
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlDeleteBuffers(GLProtoBuf.GLMessage msg) {
        int n = msg.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        int i = 0;
        while (i < n) {
            transforms.add(new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VBO}), msg.getArgs(1).getIntValue(i)));
            ++i;
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBufferData(GLProtoBuf.GLMessage msg) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int size = msg.getArgs(1).getIntValue(0);
        byte[] data = null;
        GLEnum usage = GLEnum.valueOf(msg.getArgs(3).getIntValue(0));
        data = msg.getArgs(2).getRawBytesList().size() > 0 ? msg.getArgs(2).getRawBytesList().get(0).toByteArray() : new byte[size];
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(msg.getContextId(), target, GLStateType.BUFFER_SIZE), size));
        transforms.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(msg.getContextId(), target, GLStateType.BUFFER_DATA), data));
        transforms.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(msg.getContextId(), target, GLStateType.BUFFER_USAGE), (Object)usage));
        transforms.add(new PropertyChangeTransform(new CurrentVboPropertyAccessor(msg.getContextId(), target, GLStateType.BUFFER_TYPE), (Object)target));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBufferSubData(GLProtoBuf.GLMessage msg) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int offset = msg.getArgs(1).getIntValue(0);
        byte[] data = msg.getArgs(3).getRawBytesList().get(0).toByteArray();
        BufferSubDataTransform transform = new BufferSubDataTransform(new CurrentVboPropertyAccessor(msg.getContextId(), target, GLStateType.BUFFER_DATA), offset, data);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlBindFramebuffer(GLProtoBuf.GLMessage msg) {
        int fb = msg.getArgs(1).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.FRAMEBUFFER_STATE, GLStateType.FRAMEBUFFER_BINDING}), fb);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlLineWidth(GLProtoBuf.GLMessage msg) {
        float width = msg.getArgs(0).getFloatValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.LINE_WIDTH}), Float.valueOf(width));
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlCullFace(GLProtoBuf.GLMessage msg) {
        int mode = msg.getArgs(0).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.CULL_FACE_MODE}), (Object)GLEnum.valueOf(mode));
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlFrontFace(GLProtoBuf.GLMessage msg) {
        int mode = msg.getArgs(0).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.FRONT_FACE}), (Object)GLEnum.valueOf(mode));
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlPolygonOffset(GLProtoBuf.GLMessage msg) {
        float factor = msg.getArgs(0).getFloatValue(0);
        float units = msg.getArgs(1).getFloatValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.POLYGON_OFFSET_FACTOR}), Float.valueOf(factor)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.RASTERIZATION_STATE, GLStateType.POLYGON_OFFSET_UNITS}), Float.valueOf(units)));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlScissor(GLProtoBuf.GLMessage msg) {
        int x = msg.getArgs(0).getIntValue(0);
        int y = msg.getArgs(1).getIntValue(0);
        int w = msg.getArgs(2).getIntValue(0);
        int h = msg.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_X}), x));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_Y}), y));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_WIDTH}), w));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.SCISSOR_BOX, GLStateType.SCISSOR_BOX_HEIGHT}), h));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilFuncFront(int contextId, GLEnum func, int ref, int mask) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_FUNC}), (Object)func));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_REF}), ref));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_VALUE_MASK}), mask));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilFuncBack(int contextId, GLEnum func, int ref, int mask) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_FUNC}), (Object)func));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_REF}), ref));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_VALUE_MASK}), mask));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilFunc(GLProtoBuf.GLMessage msg) {
        GLEnum func = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int ref = msg.getArgs(1).getIntValue(0);
        int mask = msg.getArgs(2).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.addAll(StateTransformFactory.transformsForGlStencilFuncFront(msg.getContextId(), func, ref, mask));
        transforms.addAll(StateTransformFactory.transformsForGlStencilFuncBack(msg.getContextId(), func, ref, mask));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilFuncSeparate(GLProtoBuf.GLMessage msg) {
        GLEnum face = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum func = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        int ref = msg.getArgs(2).getIntValue(0);
        int mask = msg.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        if (face == GLEnum.GL_FRONT || face == GLEnum.GL_FRONT_AND_BACK) {
            transforms.addAll(StateTransformFactory.transformsForGlStencilFuncFront(msg.getContextId(), func, ref, mask));
        }
        if (face == GLEnum.GL_BACK || face == GLEnum.GL_FRONT_AND_BACK) {
            transforms.addAll(StateTransformFactory.transformsForGlStencilFuncBack(msg.getContextId(), func, ref, mask));
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilOpFront(int contextId, GLEnum sfail, GLEnum dpfail, GLEnum dppass) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_FAIL}), (Object)sfail));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_PASS_DEPTH_FAIL}), (Object)dpfail));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_PASS_DEPTH_PASS}), (Object)dppass));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilOpBack(int contextId, GLEnum sfail, GLEnum dpfail, GLEnum dppass) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_FAIL}), (Object)sfail));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_PASS_DEPTH_FAIL}), (Object)dpfail));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.STENCIL, GLStateType.STENCIL_BACK_PASS_DEPTH_PASS}), (Object)dppass));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilOp(GLProtoBuf.GLMessage msg) {
        GLEnum sfail = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum dpfail = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        GLEnum dppass = GLEnum.valueOf(msg.getArgs(2).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.addAll(StateTransformFactory.transformsForGlStencilOpFront(msg.getContextId(), sfail, dpfail, dppass));
        transforms.addAll(StateTransformFactory.transformsForGlStencilOpBack(msg.getContextId(), sfail, dpfail, dppass));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlStencilOpSeparate(GLProtoBuf.GLMessage msg) {
        GLEnum face = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum sfail = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        GLEnum dpfail = GLEnum.valueOf(msg.getArgs(2).getIntValue(0));
        GLEnum dppass = GLEnum.valueOf(msg.getArgs(3).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        if (face == GLEnum.GL_FRONT || face == GLEnum.GL_FRONT_AND_BACK) {
            transforms.addAll(StateTransformFactory.transformsForGlStencilOpFront(msg.getContextId(), sfail, dpfail, dppass));
        }
        if (face == GLEnum.GL_BACK || face == GLEnum.GL_FRONT_AND_BACK) {
            transforms.addAll(StateTransformFactory.transformsForGlStencilOpBack(msg.getContextId(), sfail, dpfail, dppass));
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlDepthFunc(GLProtoBuf.GLMessage msg) {
        GLEnum func = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.DEPTH_FUNC}), (Object)func);
        return Collections.singletonList(transform);
    }

    private static IStateTransform transformForGlEquationRGB(int contextId, GLEnum mode) {
        return new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, GLStateType.BLEND_EQUATION_RGB}), (Object)mode);
    }

    private static IStateTransform transformForGlEquationAlpha(int contextId, GLEnum mode) {
        return new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, GLStateType.BLEND_EQUATION_ALPHA}), (Object)mode);
    }

    private static List<IStateTransform> transformsForGlBlendEquationSeparate(GLProtoBuf.GLMessage msg) {
        GLEnum rgb = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum alpha = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(StateTransformFactory.transformForGlEquationRGB(msg.getContextId(), rgb));
        transforms.add(StateTransformFactory.transformForGlEquationAlpha(msg.getContextId(), alpha));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBlendEquation(GLProtoBuf.GLMessage msg) {
        GLEnum mode = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(StateTransformFactory.transformForGlEquationRGB(msg.getContextId(), mode));
        transforms.add(StateTransformFactory.transformForGlEquationAlpha(msg.getContextId(), mode));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBlendFuncSrcDst(boolean src, int contextId, GLEnum rgb, GLEnum alpha) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        GLStateType rgbAccessor = GLStateType.BLEND_DST_RGB;
        GLStateType alphaAccessor = GLStateType.BLEND_DST_ALPHA;
        if (src) {
            rgbAccessor = GLStateType.BLEND_SRC_RGB;
            alphaAccessor = GLStateType.BLEND_SRC_ALPHA;
        }
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, rgbAccessor}), (Object)rgb));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.PIXEL_OPERATIONS, GLStateType.BLEND, alphaAccessor}), (Object)alpha));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBlendFuncSeparate(GLProtoBuf.GLMessage msg) {
        GLEnum srcRgb = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum dstRgb = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        GLEnum srcAlpha = GLEnum.valueOf(msg.getArgs(2).getIntValue(0));
        GLEnum dstAlpha = GLEnum.valueOf(msg.getArgs(3).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(true, msg.getContextId(), srcRgb, srcAlpha));
        transforms.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(false, msg.getContextId(), dstRgb, dstAlpha));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlBlendFunc(GLProtoBuf.GLMessage msg) {
        GLEnum sfactor = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum dfactor = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(true, msg.getContextId(), sfactor, sfactor));
        transforms.addAll(StateTransformFactory.transformsForGlBlendFuncSrcDst(false, msg.getContextId(), dfactor, dfactor));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlPixelStorei(GLProtoBuf.GLMessage msg) {
        GLEnum pname = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        Integer param = msg.getArgs(1).getIntValue(0);
        PropertyChangeTransform transform = pname == GLEnum.GL_PACK_ALIGNMENT ? new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_PACKING, GLStateType.PACK_ALIGNMENT}), param) : new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PIXEL_PACKING, GLStateType.UNPACK_ALIGNMENT}), param);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlViewport(GLProtoBuf.GLMessage msg) {
        int x = msg.getArgs(0).getIntValue(0);
        int y = msg.getArgs(1).getIntValue(0);
        int w = msg.getArgs(2).getIntValue(0);
        int h = msg.getArgs(3).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_X}), x));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_Y}), y));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_WIDTH}), w));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.VIEWPORT, GLStateType.VIEWPORT_HEIGHT}), h));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlDepthRangef(GLProtoBuf.GLMessage msg) {
        float near = msg.getArgs(0).getFloatValue(0);
        float far = msg.getArgs(1).getFloatValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.DEPTH_RANGE, GLStateType.DEPTH_RANGE_NEAR}), Float.valueOf(near)));
        transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TRANSFORMATION_STATE, GLStateType.DEPTH_RANGE, GLStateType.DEPTH_RANGE_FAR}), Float.valueOf(far)));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlGenTextures(GLProtoBuf.GLMessage msg) {
        int n = msg.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        int i = 0;
        while (i < n) {
            int texture = msg.getArgs(1).getIntValue(i);
            transforms.add(new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES}), texture));
            ++i;
        }
        return transforms;
    }

    private static List<IStateTransform> transformsToResetBoundTextureUnits(int contextId, int texture) {
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>(32);
        int i = 0;
        while (i < 32) {
            transforms.add(new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURE_UNITS, i, GLStateType.TEXTURE_BINDING_2D}), 0, Predicates.matchesInteger(texture)));
            ++i;
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlDeleteTextures(GLProtoBuf.GLMessage msg) {
        int n = msg.getArgs(0).getIntValue(0);
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>(n);
        int i = 0;
        while (i < n) {
            int texture = msg.getArgs(1).getIntValue(i);
            transforms.add(new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES}), texture));
            transforms.addAll(StateTransformFactory.transformsToResetBoundTextureUnits(msg.getContextId(), texture));
            ++i;
        }
        return transforms;
    }

    private static List<IStateTransform> transformsForGlActiveTexture(GLProtoBuf.GLMessage msg) {
        GLEnum texture = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        Integer textureIndex = (int)(texture.value - GLEnum.GL_TEXTURE0.value);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.TEXTURE_STATE, GLStateType.ACTIVE_TEXTURE_UNIT}), textureIndex);
        return Collections.singletonList(transform);
    }

    private static GLStateType getTextureUnitTargetName(GLEnum target) {
        if (target == GLEnum.GL_TEXTURE_CUBE_MAP) {
            return GLStateType.TEXTURE_BINDING_CUBE_MAP;
        }
        if (target == GLEnum.GL_TEXTURE_EXTERNAL) {
            return GLStateType.TEXTURE_BINDING_EXTERNAL;
        }
        return GLStateType.TEXTURE_BINDING_2D;
    }

    private static GLStateType getTextureTargetName(GLEnum pname) {
        switch (pname) {
            case GL_TEXTURE_MIN_FILTER: {
                return GLStateType.TEXTURE_MIN_FILTER;
            }
            case GL_TEXTURE_MAG_FILTER: {
                return GLStateType.TEXTURE_MAG_FILTER;
            }
            case GL_TEXTURE_WRAP_S: {
                return GLStateType.TEXTURE_WRAP_S;
            }
            case GL_TEXTURE_WRAP_T: {
                return GLStateType.TEXTURE_WRAP_T;
            }
        }
        assert (false) : "glTexParameter's pname argument does not support provided value.";
        return GLStateType.TEXTURE_MIN_FILTER;
    }

    private static List<IStateTransform> transformsForGlBindTexture(GLProtoBuf.GLMessage msg) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        Integer texture = msg.getArgs(1).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(new TextureUnitPropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target)), texture);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlTexImage(GLProtoBuf.GLMessage msg, int widthArgIndex, int heightArgIndex, int xOffsetIndex, int yOffsetIndex) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int level = msg.getArgs(1).getIntValue(0);
        Integer width = msg.getArgs(widthArgIndex).getIntValue(0);
        Integer height = msg.getArgs(heightArgIndex).getIntValue(0);
        GLEnum format = GLEnum.valueOf(msg.getArgs(6).getIntValue(0));
        GLEnum type = GLEnum.valueOf(msg.getArgs(7).getIntValue(0));
        ArrayList<IStateTransform> transforms = new ArrayList<IStateTransform>();
        transforms.add(new PropertyChangeTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), level, GLStateType.TEXTURE_WIDTH), width));
        transforms.add(new PropertyChangeTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), level, GLStateType.TEXTURE_HEIGHT), height));
        transforms.add(new PropertyChangeTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), level, GLStateType.TEXTURE_FORMAT), (Object)format));
        transforms.add(new PropertyChangeTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), level, GLStateType.TEXTURE_IMAGE_TYPE), (Object)type));
        File f = null;
        if (msg.getArgs(8).getIsArray()) {
            ByteString data = msg.getArgs(8).getRawBytes(0);
            f = FileUtils.createTempFile(TEXTURE_DATA_FILE_PREFIX, TEXTURE_DATA_FILE_SUFFIX);
            try {
                Files.write((byte[])data.toByteArray(), (File)f);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int xOffset = 0;
        int yOffset = 0;
        if (xOffsetIndex >= 0) {
            xOffset = msg.getArgs(xOffsetIndex).getIntValue(0);
        }
        if (yOffsetIndex >= 0) {
            yOffset = msg.getArgs(yOffsetIndex).getIntValue(0);
        }
        transforms.add(new TexImageTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), level, GLStateType.TEXTURE_IMAGE), f, format, type, xOffset, yOffset, width, height));
        return transforms;
    }

    private static List<IStateTransform> transformsForGlTexImage2D(GLProtoBuf.GLMessage msg) {
        return StateTransformFactory.transformsForGlTexImage(msg, 3, 4, -1, -1);
    }

    private static List<IStateTransform> transformsForGlTexSubImage2D(GLProtoBuf.GLMessage msg) {
        return StateTransformFactory.transformsForGlTexImage(msg, 4, 5, 2, 3);
    }

    private static List<IStateTransform> transformsForGlTexParameter(GLProtoBuf.GLMessage msg) {
        GLEnum target = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        GLEnum pname = GLEnum.valueOf(msg.getArgs(1).getIntValue(0));
        GLEnum pvalue = GLEnum.valueOf(msg.getArgs(2).getIntValue(0));
        if (sTexParameterPnameValues == null) {
            GLEnum[] pnameValues = new GLEnum[]{GLEnum.GL_TEXTURE_BASE_LEVEL, GLEnum.GL_TEXTURE_COMPARE_FUNC, GLEnum.GL_TEXTURE_COMPARE_MODE, GLEnum.GL_TEXTURE_MIN_FILTER, GLEnum.GL_TEXTURE_MAG_FILTER, GLEnum.GL_TEXTURE_MIN_LOD, GLEnum.GL_TEXTURE_MAX_LOD, GLEnum.GL_TEXTURE_MAX_LEVEL, GLEnum.GL_TEXTURE_SWIZZLE_R, GLEnum.GL_TEXTURE_SWIZZLE_G, GLEnum.GL_TEXTURE_SWIZZLE_B, GLEnum.GL_TEXTURE_SWIZZLE_A, GLEnum.GL_TEXTURE_WRAP_S, GLEnum.GL_TEXTURE_WRAP_T, GLEnum.GL_TEXTURE_WRAP_R};
            sTexParameterPnameValues = EnumSet.copyOf(Arrays.asList(pnameValues));
        }
        if (!sTexParameterPnameValues.contains((Object)pname)) {
            throw new IllegalArgumentException(String.format("Unsupported parameter (%s) for glTexParameter()", new Object[]{pname}));
        }
        PropertyChangeTransform transform = new PropertyChangeTransform(new TexturePropertyAccessor(msg.getContextId(), StateTransformFactory.getTextureUnitTargetName(target), StateTransformFactory.getTextureTargetName(pname)), (Object)pvalue);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlCreateProgram(GLProtoBuf.GLMessage msg) {
        int program = msg.getReturnValue().getIntValue(0);
        SparseArrayElementAddTransform transform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS}), program);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlUseProgram(GLProtoBuf.GLMessage msg) {
        Integer program = msg.getArgs(0).getIntValue(0);
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.CURRENT_PROGRAM}), program);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlAttachShader(GLProtoBuf.GLMessage msg) {
        int program = msg.getArgs(0).getIntValue(0);
        int shader = msg.getArgs(1).getIntValue(0);
        SparseArrayElementAddTransform transform = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, GLStateType.ATTACHED_SHADERS}), shader);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlDetachShader(GLProtoBuf.GLMessage msg) {
        int program = msg.getArgs(0).getIntValue(0);
        int shader = msg.getArgs(1).getIntValue(0);
        SparseArrayElementRemoveTransform transform = new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, GLStateType.ATTACHED_SHADERS}), shader);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlGetActiveAttribOrUniform(GLProtoBuf.GLMessage msg, boolean isAttrib) {
        GLStateType inputSize;
        GLStateType inputType;
        GLStateType inputName;
        GLStateType activeInput;
        int program = msg.getArgs(0).getIntValue(0);
        int size = msg.getArgs(4).getIntValue(0);
        GLEnum type = GLEnum.valueOf(msg.getArgs(5).getIntValue(0));
        String name = msg.getArgs(6).getCharValue(0).toStringUtf8();
        int location = msg.getArgs(7).getIntValue(0);
        if (isAttrib) {
            activeInput = GLStateType.ACTIVE_ATTRIBUTES;
            inputName = GLStateType.ATTRIBUTE_NAME;
            inputType = GLStateType.ATTRIBUTE_TYPE;
            inputSize = GLStateType.ATTRIBUTE_SIZE;
        } else {
            activeInput = GLStateType.ACTIVE_UNIFORMS;
            inputName = GLStateType.UNIFORM_NAME;
            inputType = GLStateType.UNIFORM_TYPE;
            inputSize = GLStateType.UNIFORM_SIZE;
        }
        SparseArrayElementAddTransform addAttribute = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, activeInput}), location);
        PropertyChangeTransform setAttributeName = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, activeInput, location, inputName}), name);
        PropertyChangeTransform setAttributeType = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, activeInput, location, inputType}), (Object)type);
        PropertyChangeTransform setAttributeSize = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.PROGRAM_STATE, GLStateType.PROGRAMS, program, activeInput, location, inputSize}), size);
        return Arrays.asList(addAttribute, setAttributeName, setAttributeType, setAttributeSize);
    }

    private static List<IStateTransform> transformsForGlGetActiveAttrib(GLProtoBuf.GLMessage msg) {
        return StateTransformFactory.transformsForGlGetActiveAttribOrUniform(msg, true);
    }

    private static List<IStateTransform> transformsForGlGetActiveUniform(GLProtoBuf.GLMessage msg) {
        return StateTransformFactory.transformsForGlGetActiveAttribOrUniform(msg, false);
    }

    private static List<IStateTransform> transformsForGlUniformMatrix(GLProtoBuf.GLMessage msg) {
        int location = msg.getArgs(0).getIntValue(0);
        List<Float> uniforms = msg.getArgs(3).getFloatValueList();
        PropertyChangeTransform setValues = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(msg.getContextId(), GLStateType.ACTIVE_UNIFORMS, location, GLStateType.UNIFORM_VALUE), uniforms);
        return Collections.singletonList(setValues);
    }

    private static List<IStateTransform> transformsForGlUniformv(GLProtoBuf.GLMessage msg, boolean isFloats) {
        int location = msg.getArgs(0).getIntValue(0);
        List<Number> uniforms = isFloats ? msg.getArgs(2).getFloatValueList() : msg.getArgs(2).getIntValueList();
        PropertyChangeTransform setValues = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(msg.getContextId(), GLStateType.ACTIVE_UNIFORMS, location, GLStateType.UNIFORM_VALUE), uniforms);
        return Collections.singletonList(setValues);
    }

    private static List<IStateTransform> transformsForGlUniform(GLProtoBuf.GLMessage msg, boolean isFloats) {
        ArrayList<Number> uniforms;
        ArrayList<Number> args;
        int location = msg.getArgs(0).getIntValue(0);
        if (location < 0) {
            throw new IllegalArgumentException("Argument location cannot be less than 0.");
        }
        if (isFloats) {
            args = new ArrayList<Number>(msg.getArgsCount() - 1);
            int i = 1;
            while (i < msg.getArgsCount()) {
                args.add(Float.valueOf(msg.getArgs(1).getFloatValue(0)));
                ++i;
            }
            uniforms = args;
        } else {
            args = new ArrayList(msg.getArgsCount() - 1);
            int i = 1;
            while (i < msg.getArgsCount()) {
                args.add(msg.getArgs(1).getIntValue(0));
                ++i;
            }
            uniforms = args;
        }
        PropertyChangeTransform setValues = new PropertyChangeTransform(new CurrentProgramPropertyAccessor(msg.getContextId(), GLStateType.ACTIVE_UNIFORMS, location, GLStateType.UNIFORM_VALUE), uniforms);
        return Collections.singletonList(setValues);
    }

    private static List<IStateTransform> transformsForGlCreateShader(GLProtoBuf.GLMessage msg) {
        GLEnum shaderType = GLEnum.valueOf(msg.getArgs(0).getIntValue(0));
        int shader = msg.getReturnValue().getIntValue(0);
        SparseArrayElementAddTransform addShader = new SparseArrayElementAddTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.SHADERS}), shader);
        PropertyChangeTransform setShaderType = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.SHADERS, shader, GLStateType.SHADER_TYPE}), (Object)shaderType);
        return Arrays.asList(addShader, setShaderType);
    }

    private static List<IStateTransform> transformsForGlDeleteShader(GLProtoBuf.GLMessage msg) {
        int shader = msg.getArgs(0).getIntValue(0);
        SparseArrayElementRemoveTransform transform = new SparseArrayElementRemoveTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.SHADERS}), shader);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForGlShaderSource(GLProtoBuf.GLMessage msg) {
        int shader = msg.getArgs(0).getIntValue(0);
        String src = msg.getArgs(2).getCharValue(0).toStringUtf8();
        PropertyChangeTransform transform = new PropertyChangeTransform(GLPropertyAccessor.makeAccessor(msg.getContextId(), new Object[]{GLStateType.SHADERS, shader, GLStateType.SHADER_SOURCE}), src);
        return Collections.singletonList(transform);
    }

    private static List<IStateTransform> transformsForEglCreateContext(GLProtoBuf.GLMessage msg) {
        int version = msg.getArgs(0).getIntValue(0);
        IGLProperty glState = null;
        glState = version == 0 ? GLState.createDefaultES1State() : GLState.createDefaultES2State();
        ListElementAddTransform transform = new ListElementAddTransform(null, glState);
        return Collections.singletonList(transform);
    }
}

