
#ifndef OPENCLOUD_SYNC_EXPORT_H
#define OPENCLOUD_SYNC_EXPORT_H

#ifdef OPENCLOUD_BUILT_AS_STATIC
#  define OPENCLOUD_SYNC_EXPORT
#  define LIBSYNC_NO_EXPORT
#else
#  ifndef OPENCLOUD_SYNC_EXPORT
#    ifdef libsync_EXPORTS
        /* We are building this library */
#      define OPENCLOUD_SYNC_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define OPENCLOUD_SYNC_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef LIBSYNC_NO_EXPORT
#    define LIBSYNC_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef LIBSYNC_DEPRECATED
#  define LIBSYNC_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef LIBSYNC_DEPRECATED_EXPORT
#  define LIBSYNC_DEPRECATED_EXPORT OPENCLOUD_SYNC_EXPORT LIBSYNC_DEPRECATED
#endif

#ifndef LIBSYNC_DEPRECATED_NO_EXPORT
#  define LIBSYNC_DEPRECATED_NO_EXPORT LIBSYNC_NO_EXPORT LIBSYNC_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef LIBSYNC_NO_DEPRECATED
#    define LIBSYNC_NO_DEPRECATED
#  endif
#endif

#endif /* OPENCLOUD_SYNC_EXPORT_H */
