/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.GuardNodeTableModel;
import client.NodeItem;
import client.NodeList;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import lib.GTKFixes;
import lib.Localisation;
import lib.Utilities;

public class GuardNodeDialog
extends JDialog {
    public static final int CANCEL = 0;
    public static final int APPLY = 1;
    public static final int RESET = 2;
    private static final String ATLAS = "https://atlas.torproject.org/";
    private static final Localisation LOCAL = new Localisation("resources/MessagesBundle");
    private int intRowSelected = -1;
    private int returnStatus = 0;
    private final GuardNodeTableModel gntm;
    private NodeList nl;
    private JButton jButtonApply;
    private JButton jButtonClear;
    private JButton jButtonClose;
    private JMenuItem jMenuNodeDetails;
    private JMenuItem jMenuWhois;
    private JScrollPane jScrollPane1;
    private JTable jTableGuards;
    private JTextArea jTextArea1;
    private JPopupMenu popupTable;

    public GuardNodeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        GTKFixes.fixTextAreaColor(this.jTextArea1);
        this.jTableGuards.setComponentPopupMenu(this.popupTable);
        this.gntm = new GuardNodeTableModel();
        this.gntm.setColumnName(LOCAL.getString("guardtable_col1"), 0);
        this.gntm.setColumnName(LOCAL.getString("guardtable_col2"), 1);
        this.gntm.setColumnName(LOCAL.getString("guardtable_col3"), 2);
        this.gntm.setColumnName(LOCAL.getString("guardtable_col4"), 3);
        this.gntm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (GuardNodeDialog.this.gntm.getEnabledCount() >= 3 || GuardNodeDialog.this.gntm.getEnabledCount() == 0) {
                    GuardNodeDialog.this.jButtonApply.setEnabled(true);
                } else {
                    GuardNodeDialog.this.jButtonApply.setEnabled(false);
                }
            }
        });
        this.jTableGuards.setModel(this.gntm);
        this.adjustGuardTableColumns();
    }

    public void setNodeList(NodeList nodeList) {
        this.nl = nodeList;
        this.nl.setGuardNodeTableModel(this.gntm);
        this.nl.refreshGuardTableModel();
        this.adjustGuardTableColumns();
    }

    private void adjustGuardTableColumns() {
        Utilities.adjustTableColumnWidth(this.jTableGuards, "XXXXXXXXXXXXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXX", "XXXXXXXXXXXXXXX");
    }

    private void clearSelections() {
        for (int i = 0; i < this.jTableGuards.getRowCount(); ++i) {
            this.jTableGuards.setValueAt(false, i, 3);
        }
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.popupTable = new JPopupMenu();
        this.jMenuNodeDetails = new JMenuItem();
        this.jMenuWhois = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGuards = new JTable();
        this.jButtonClear = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonClose = new JButton();
        this.jTextArea1 = new JTextArea();
        this.popupTable.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                GuardNodeDialog.this.popupTablePopupMenuWillBecomeVisible(popupMenuEvent);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.jMenuNodeDetails.setText(LOCAL.getString("table_popup_details"));
        this.jMenuNodeDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuardNodeDialog.this.jMenuNodeDetailsActionPerformed(actionEvent);
            }
        });
        this.popupTable.add(this.jMenuNodeDetails);
        this.jMenuWhois.setText(LOCAL.getString("table_popup_whois"));
        this.jMenuWhois.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuardNodeDialog.this.jMenuWhoisActionPerformed(actionEvent);
            }
        });
        this.popupTable.add(this.jMenuWhois);
        this.setDefaultCloseOperation(2);
        this.setTitle(LOCAL.getString("wintitle_guardnodes"));
        this.setResizable(false);
        this.jTableGuards.setAutoCreateRowSorter(true);
        this.jTableGuards.setSelectionMode(0);
        this.jTableGuards.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GuardNodeDialog.this.jTableGuardsMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableGuards);
        this.jButtonClear.setText(LOCAL.getString("button_clearguards"));
        this.jButtonClear.setToolTipText(LOCAL.getString("ttip_clearguards"));
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuardNodeDialog.this.jButtonClearActionPerformed(actionEvent);
            }
        });
        this.jButtonApply.setText(LOCAL.getString("button_apply"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuardNodeDialog.this.jButtonApplyActionPerformed(actionEvent);
            }
        });
        this.jButtonClose.setText(LOCAL.getString("button_close"));
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuardNodeDialog.this.jButtonCloseActionPerformed(actionEvent);
            }
        });
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(40);
        this.jTextArea1.setFont(new JLabel().getFont());
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setText(LOCAL.getString("label_guard_minimum"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(this.jTextArea1.getForeground());
        this.jTextArea1.setEnabled(false);
        this.jTextArea1.setMinimumSize(new Dimension(0, 0));
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setRequestFocusEnabled(false);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply)).addComponent(this.jTextArea1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 367, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClear).addComponent(this.jButtonApply).addComponent(this.jButtonClose)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void jButtonApplyActionPerformed(ActionEvent actionEvent) {
        this.nl.saveGuardWhitelist();
        this.doClose(1);
    }

    private void jButtonClearActionPerformed(ActionEvent actionEvent) {
        this.clearSelections();
    }

    private void jMenuNodeDetailsActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.gntm.getValueAt(this.intRowSelected, 4);
        string = string.replace("$", "");
        Utilities.openFileExternally("https://atlas.torproject.org/#details/" + string);
    }

    private void jMenuWhoisActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.gntm.getValueAt(this.intRowSelected, 4);
        NodeItem nodeItem = this.nl.getNode(string);
        if (nodeItem != null) {
            Utilities.openFileExternally("https://www.networksolutions.com/whois/results.jsp?ip=" + nodeItem.getIPAddress());
        }
    }

    private void popupTablePopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.jMenuWhois.setEnabled(this.intRowSelected > -1);
        this.jMenuNodeDetails.setEnabled(this.intRowSelected > -1);
    }

    private void jTableGuardsMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.intRowSelected = this.jTableGuards.getSelectedRow();
        if (this.intRowSelected > 0) {
            this.intRowSelected = this.jTableGuards.convertRowIndexToModel(this.intRowSelected);
        }
    }
}

