/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ExitNodeTableModel;
import client.GuardNodeTableModel;
import client.NodeItem;
import client.TorController;
import java.lang.invoke.CallSite;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;
import lib.Localisation;
import lib.SimpleFile;

public class NodeList {
    public static final int NODELIST_IDLE = 0;
    public static final int NODELIST_BUILDING = 1;
    public static final int NODELIST_BUILT = 2;
    public static final int NODELIST_FAILED = 3;
    public static final int NODELIST_TERMINATED = 4;
    private static final String EMPTYSTRING = "";
    private static final Localisation LOCAL = new Localisation("resources/MessagesBundle");
    private ExitNodeTableModel entm;
    private GuardNodeTableModel gntm;
    private int intStatus = 0;
    private HashMap<String, NodeItem> hmNode;
    private final HashMap<String, NodeItem> hmBridges;
    private final ArrayList<String> alCountries;
    private TorController tc;
    private final String exitFavouritesFile;
    private final String guardFavouritesFile;
    private final String filepath;
    private volatile boolean boolAbortActions;
    private final Pattern pattspace = Pattern.compile(" ");
    private int nooffavs;

    public NodeList(String string, String string2, String string3) {
        this.hmNode = new HashMap();
        this.hmBridges = new HashMap();
        this.filepath = string;
        this.alCountries = new ArrayList();
        this.exitFavouritesFile = string2;
        this.guardFavouritesFile = string3;
    }

    public final NodeItem getNode(String string) {
        ArrayList<String> arrayList;
        NodeItem nodeItem = this.hmNode.get(string);
        if (nodeItem == null && (arrayList = this.getRouterDesc(string)) != null) {
            arrayList.addAll(this.getRouterStatus(string));
            nodeItem = new NodeItem();
            String string2 = this.filterRouterInfo(arrayList, "router ");
            if (string2 == null) {
                return null;
            }
            String[] stringArray = this.pattspace.split(string2);
            nodeItem.setFingerprint(string);
            nodeItem.setNickName(stringArray[0]);
            nodeItem.setIPAddress(stringArray[1]);
            String string3 = this.tc.getCountryFromIP(nodeItem.getIPAddress());
            if (string3 == null || string3.contentEquals("??")) {
                string3 = "U1";
            }
            nodeItem.setCountryCode(string3);
            nodeItem.setCountryName(LOCAL.getDisplayCountry(string3));
            string2 = this.filterRouterInfo(arrayList, "bandwidth ");
            stringArray = this.pattspace.split(string2);
            nodeItem.setBandwidth(this.getLowestBandwidth(stringArray));
            string2 = this.filterRouterInfo(arrayList, "s ");
            if (string2 == null) {
                nodeItem.setType(2);
                nodeItem.setStable(LOCAL.getString("text_yes"));
                return nodeItem;
            }
            if (string2.contains("Guard")) {
                nodeItem.setType(2);
            }
            if (string2.contains("Stable")) {
                nodeItem.setStable(LOCAL.getString("text_yes"));
            } else {
                nodeItem.setStable(LOCAL.getString("text_no"));
            }
            if (string2.contains("Exit") && !string2.contains("BadExit")) {
                nodeItem.setType(1);
                string2 = this.filterRouterInfo(arrayList, "p ");
                if (string2.startsWith("accept") ? !this.containsPort(string2 = string2.replace("accept ", EMPTYSTRING), 80) && !this.containsPort(string2, 443) : this.containsPort(string2 = string2.replace("reject ", EMPTYSTRING), 80) || this.containsPort(string2, 443)) {
                    return nodeItem;
                }
                nodeItem.setHttpSupported(true);
            }
        }
        return nodeItem;
    }

    public ArrayList<String> getRouterDesc(String string) {
        ArrayList<String> arrayList = this.tc.getInfo("desc/id/" + string);
        if (arrayList == null) {
            return null;
        }
        arrayList.remove("250 OK");
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public ArrayList<String> getRouterStatus(String string) {
        ArrayList<String> arrayList = this.tc.getInfo("ns/id/" + string);
        if (arrayList == null) {
            return null;
        }
        arrayList.remove("250 OK");
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public String filterRouterInfo(ArrayList<String> arrayList, String string) {
        for (String string2 : arrayList) {
            if (!string2.startsWith(string)) continue;
            return string2.replace(string, EMPTYSTRING);
        }
        return null;
    }

    public final int getCurrentStatus() {
        return this.intStatus;
    }

    public final void refreshNodelist(TorController torController) {
        this.boolAbortActions = false;
        this.intStatus = 1;
        this.tc = torController;
        boolean bl = this.populateNodeMap();
        if (bl) {
            bl = this.fetchFingerData();
        }
        this.intStatus = bl ? 2 : (this.boolAbortActions ? 4 : 3);
    }

    private boolean populateNodeMap() {
        String string;
        SimpleFile simpleFile = new SimpleFile(this.tc.getDataFolder() + SimpleFile.getSeparator() + "cached-consensus");
        this.hmNode.clear();
        this.alCountries.clear();
        simpleFile.openBufferedRead();
        while (!this.boolAbortActions && !(string = simpleFile.readLine()).startsWith("directory-footer")) {
            String string2;
            String string3;
            if (!string.startsWith("r ")) continue;
            String[] stringArray = this.pattspace.split(string);
            String string4 = stringArray[1];
            String string5 = stringArray[6];
            String string6 = stringArray[7];
            String string7 = stringArray[8];
            while (!(string3 = simpleFile.readLine()).startsWith("s ")) {
            }
            if (!string3.contains("Running") || !string3.contains("Valid")) continue;
            while (!(string2 = simpleFile.readLine()).startsWith("p ")) {
            }
            if (this.tc.getStatus() < 2) {
                this.boolAbortActions = false;
                this.alCountries.clear();
                break;
            }
            String string8 = this.tc.getCountryFromIP(string5);
            if (string8 == null || string8.contains("??")) {
                string8 = "U1";
            }
            if (string8.startsWith("551 GEOIP")) {
                this.alCountries.clear();
                break;
            }
            String string9 = LOCAL.getDisplayCountry(string8);
            NodeItem nodeItem = new NodeItem();
            nodeItem.setCountryCode(string8);
            nodeItem.setCountryName(string9);
            nodeItem.setNickName(string4);
            nodeItem.setIPAddress(string5);
            if (string3.contains("Stable")) {
                nodeItem.setStable(LOCAL.getString("text_yes"));
            } else {
                nodeItem.setStable(LOCAL.getString("text_no"));
            }
            this.hmNode.put(string6 + string7 + ":" + string5, nodeItem);
            if (string3.contains("Guard")) {
                nodeItem.setType(2);
            }
            if (!string3.contains("Exit") || string3.contains("BadExit")) continue;
            nodeItem.setType(1);
            if (string2.startsWith("p accept") ? !this.containsPort(string2 = string2.replace("p accept ", EMPTYSTRING), 80) || !this.containsPort(string2, 443) : this.containsPort(string2 = string2.replace("p reject ", EMPTYSTRING), 80) || this.containsPort(string2, 443)) continue;
            nodeItem.setHttpSupported(true);
            if (this.alCountries.contains(string8 + "," + string9)) continue;
            this.alCountries.add(string8 + "," + string9);
        }
        simpleFile.closeFile();
        if (this.alCountries.isEmpty()) {
            return false;
        }
        Collections.sort(this.alCountries, Collator.getInstance());
        return !this.boolAbortActions;
    }

    private boolean fetchFingerData() {
        boolean bl;
        String string = this.getGuardFavouritesAsCSV();
        HashMap<CallSite, NodeItem> hashMap = new HashMap<CallSite, NodeItem>();
        SimpleFile simpleFile = new SimpleFile(this.tc.getDataFolder() + SimpleFile.getSeparator() + "cached-descriptors");
        SimpleFile simpleFile2 = new SimpleFile(this.tc.getDataFolder() + SimpleFile.getSeparator() + "cached-descriptors.new");
        if (!simpleFile2.exists() || simpleFile2.getFile().length() == 0L) {
            simpleFile2 = null;
        }
        simpleFile.openBufferedRead();
        try {
            while (!this.boolAbortActions) {
                int n;
                String string2 = simpleFile.readLine();
                if (string2 == null) {
                    if (simpleFile2 == null) break;
                    simpleFile.closeFile();
                    simpleFile = simpleFile2;
                    simpleFile.openBufferedRead();
                    simpleFile2 = null;
                    continue;
                }
                if (!string2.startsWith("router ")) continue;
                String[] stringArray = this.pattspace.split(string2);
                String string3 = stringArray[2];
                String string4 = stringArray[3];
                String string5 = stringArray[5];
                String string6 = string4 + string5 + ":";
                if (!this.hmNode.containsKey(string6 + string3)) continue;
                while ((n = (string2 = simpleFile.readLine()).indexOf("fingerprint")) <= -1) {
                }
                string2 = string2.substring(n + 12);
                String string7 = "$" + string2.replace(" ", EMPTYSTRING);
                while ((n = (string2 = simpleFile.readLine()).indexOf("bandwidth")) <= -1) {
                }
                string2 = string2.substring(n + 10);
                stringArray = this.pattspace.split(string2);
                NodeItem nodeItem = this.hmNode.get(string6 + string3);
                nodeItem.setFingerprint(string7);
                nodeItem.setGuardEnabled(string.contains(string7));
                nodeItem.setBandwidth(this.getLowestBandwidth(stringArray));
                hashMap.put((CallSite)((Object)string7), nodeItem);
            }
            bl = !this.boolAbortActions;
        }
        catch (Exception exception) {
            bl = false;
        }
        simpleFile.closeFile();
        this.hmNode = hashMap;
        return bl;
    }

    private float getLowestBandwidth(String[] stringArray) {
        float f = 1000000.0f;
        for (String string : stringArray) {
            float f2 = Float.parseFloat(string) / 1000000.0f;
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    public void addBridge(String string) {
        Pattern pattern = Pattern.compile(" ");
        String[] stringArray = pattern.split(string = string.substring(string.indexOf(36)));
        int n = stringArray[0].indexOf(126);
        if (n < 0) {
            n = stringArray[0].indexOf(61);
        }
        NodeItem nodeItem = new NodeItem();
        nodeItem.setFingerprint(stringArray[0].substring(0, n));
        nodeItem.setIPAddress(stringArray[2]);
        nodeItem.setNickName(stringArray[0].substring(n + 1));
        this.hmBridges.put(nodeItem.getFingerprint(), nodeItem);
    }

    public void clearBridges() {
        this.hmBridges.clear();
    }

    private boolean containsPort(String string, int n) {
        String[] stringArray;
        Pattern pattern = Pattern.compile(",");
        Pattern pattern2 = Pattern.compile("-");
        for (String string2 : stringArray = pattern.split(string)) {
            int n2;
            if (string2.contains("-")) {
                String[] stringArray2 = pattern2.split(string2);
                n2 = Integer.parseInt(stringArray2[0]);
                int n3 = Integer.parseInt(stringArray2[1]);
                if (n < n2 || n > n3) continue;
                return true;
            }
            n2 = Integer.parseInt(string2);
            if (n != n2) continue;
            return true;
        }
        return false;
    }

    public final String[] getValidatedCountries() {
        return this.alCountries.toArray(new String[this.alCountries.size()]);
    }

    public final String[] getValidatedCountryCodes() {
        String[] stringArray = new String[this.alCountries.size()];
        int n = 0;
        for (String string : this.alCountries) {
            stringArray[n++] = string.substring(0, 2);
        }
        return stringArray;
    }

    public final void setGuardNodeTableModel(GuardNodeTableModel guardNodeTableModel) {
        this.gntm = guardNodeTableModel;
    }

    public final void setExitNodeTableModel(ExitNodeTableModel exitNodeTableModel) {
        this.entm = exitNodeTableModel;
    }

    public final ArrayList<String> getExitNodes(boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.entm.getRowCount(); ++i) {
            boolean bl3;
            int n = (Integer)this.entm.getValueAt(i, 7);
            if (bl2 && n == 2 || !(bl3 = (Boolean)this.entm.getValueAt(i, 4) | bl)) continue;
            arrayList.add((String)this.entm.getValueAt(i, 5));
        }
        return arrayList;
    }

    public final String getExitNodesAsString(boolean bl, boolean bl2) {
        String string = this.getExitNodes(bl, bl2).toString();
        string = string.replace("[", EMPTYSTRING).replace(" ", EMPTYSTRING).replace("]", EMPTYSTRING);
        return string;
    }

    public final ArrayList<String> getGuardNodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.gntm == null) {
            return arrayList;
        }
        for (int i = 0; i < this.gntm.getRowCount(); ++i) {
            arrayList.add((String)this.gntm.getValueAt(i, 3));
        }
        return arrayList;
    }

    public final String getGuardFavouritesAsCSV() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = EMPTYSTRING;
        if (this.guardFavouritesFile == null) {
            return stringBuilder.toString();
        }
        SimpleFile simpleFile = new SimpleFile(this.filepath + this.guardFavouritesFile);
        if (!simpleFile.exists()) {
            return stringBuilder.toString();
        }
        simpleFile.openBufferedRead();
        while ((string = simpleFile.readLine()) != null) {
            stringBuilder.append(string2);
            stringBuilder.append(string);
            if (!string2.isEmpty()) continue;
            string2 = ",";
        }
        simpleFile.closeFile();
        return stringBuilder.toString();
    }

    public final void refreshGuardTableModel() {
        if (this.gntm == null) {
            return;
        }
        this.gntm.clear();
        for (String string : this.hmNode.keySet()) {
            NodeItem nodeItem = this.hmNode.get(string);
            if (!nodeItem.isGuard()) continue;
            Object[] objectArray = new Object[]{nodeItem};
            this.gntm.addRow(objectArray);
        }
    }

    public final void refreshExitTableModel(String string) {
        Object object;
        if (this.entm == null) {
            return;
        }
        this.entm.clear();
        String string2 = string;
        String string3 = EMPTYSTRING;
        if (this.exitFavouritesFile != null && ((SimpleFile)(object = new SimpleFile(this.filepath + this.exitFavouritesFile))).exists()) {
            ((SimpleFile)object).openBufferedRead();
            string3 = ((SimpleFile)object).readEntireFile().trim();
            ((SimpleFile)object).closeFile();
        }
        this.nooffavs = 0;
        for (String string4 : this.hmNode.keySet()) {
            NodeItem nodeItem = this.hmNode.get(string4);
            if (!nodeItem.isExit() || !nodeItem.isHttpSupported() || !nodeItem.getCountryCode().contentEquals(string2)) continue;
            nodeItem.setLatency(9999L);
            nodeItem.setTestingMessage(LOCAL.getString("textfield_unknown"));
            nodeItem.setFavouriteEnabled(string3.contains(nodeItem.getIPAddress()));
            if (nodeItem.isFavourite()) {
                ++this.nooffavs;
            }
            Object[] objectArray = new Object[]{nodeItem};
            this.entm.addRow(objectArray);
        }
    }

    public int getNumberOfFavs() {
        return this.nooffavs;
    }

    public final void terminate() {
        this.boolAbortActions = true;
    }

    public void saveExitFavourites() {
        if (this.exitFavouritesFile == null) {
            return;
        }
        SimpleFile simpleFile = new SimpleFile(this.filepath + this.exitFavouritesFile);
        simpleFile.openBufferedWrite();
        this.nooffavs = 0;
        for (String string : this.hmNode.keySet()) {
            NodeItem nodeItem = this.hmNode.get(string);
            if (!nodeItem.isExit() || !nodeItem.isFavourite()) continue;
            ++this.nooffavs;
            simpleFile.writeFile(nodeItem.getIPAddress(), 1);
        }
        simpleFile.closeFile();
    }

    public int saveGuardWhitelist() {
        int n = 0;
        if (this.guardFavouritesFile == null) {
            return n;
        }
        SimpleFile simpleFile = new SimpleFile(this.filepath + this.guardFavouritesFile);
        simpleFile.openBufferedWrite();
        for (String string : this.hmNode.keySet()) {
            NodeItem nodeItem = this.hmNode.get(string);
            if (!nodeItem.isGuard() || !nodeItem.isGuardEnabled()) continue;
            simpleFile.writeFile(nodeItem.getFingerprint(), 1);
            ++n;
        }
        simpleFile.closeFile();
        return n;
    }
}

