/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import lib.OSFunction;
import lib.SimpleFile;

public class PacFactory {
    public static final String FILEUSER = "user";
    private static final String FILEEXT = ".txt";
    public static final int PROXY_DISABLED = 0;
    public static final int PROXY_PATTERN = 1;
    public static final int PROXY_ALL = 2;
    private static final String PACFILE_EXT = ".pac";
    private static final String PATTERNFIRSTLINE = "### Pattern File, Do not remove or modify this line ###";
    private String strKDEProxyPrefsBackup;
    private String strGnome3ProxyPrefsBackup;
    private String strPACPath;
    private String strBackupFolder;
    private String strPatternsFolder;
    private String strTempFolder;
    private String strDefaultProxy = "";
    private String strDoNotProxy = "";
    private String strActiveCountry;
    private String strActivePacName = "";
    private final Random randgen = new Random(System.currentTimeMillis());

    public String getActiveCountry() {
        return this.strActiveCountry;
    }

    public void createPacFile(String string, int n) {
        String string2 = this.createRandomName() + PACFILE_EXT;
        this.savePACFile(string2, this.getPacRules(string, String.valueOf(n)));
        this.setProxyAutoConfigURL("file://" + this.strPACPath.replace("\\", "/") + string2);
        this.strActiveCountry = string;
        if (!this.strActivePacName.isEmpty()) {
            this.deletePAC(this.strActivePacName);
        }
        this.strActivePacName = string2;
    }

    private ArrayList<String> getPacRules(String string, String string2) {
        String string3;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.contentEquals("proxyall")) {
            this.addSocksRule(arrayList, "127.0.0.1", string2);
            return arrayList;
        }
        if (string.contentEquals("direct")) {
            this.addDirectMatchingRule(arrayList, null);
            return arrayList;
        }
        Pattern pattern = Pattern.compile(",");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!this.strDoNotProxy.isEmpty()) {
            stringArray = pattern.split(this.strDoNotProxy);
            for (String string4 : stringArray) {
                if (string4.isEmpty()) continue;
                this.addDirectMatchingRule(arrayList, "*" + (String)string4 + "*");
            }
        }
        this.loadPatternsList(string, arrayList2);
        Iterator<String> iterator = arrayList2.iterator();
        while (iterator.hasNext() && (stringArray = pattern.split(string3 = (String)iterator.next())).length >= 3) {
            if (!stringArray[2].contentEquals("true")) continue;
            if (stringArray[1].contentEquals("*")) {
                this.addSocksRule(arrayList, "127.0.0.1", string2);
                return arrayList;
            }
            this.addSocksMatchingRule(arrayList, stringArray[1], "127.0.0.1", string2);
        }
        if (this.strDefaultProxy.isEmpty()) {
            this.addDirectMatchingRule(arrayList, null);
        } else {
            this.addProxyRule(arrayList, this.strDefaultProxy);
        }
        return arrayList;
    }

    public void addProxyRule(ArrayList<String> arrayList, String string) {
        arrayList.add("\treturn \"PROXY " + string + "\";");
    }

    public void addSocksRule(ArrayList<String> arrayList, String string, String string2) {
        String string3 = "\treturn \"SOCKS5 " + string + ":" + string2 + "\";";
        arrayList.add(string3);
    }

    public void addDirectMatchingRule(ArrayList<String> arrayList, String string) {
        Object object = string == null ? "\treturn \"DIRECT\";" : "\tif (shExpMatch(url, \"" + string + "\"))\n\t{\n\t\treturn \"DIRECT\";\n\t}";
        arrayList.add((String)object);
    }

    public void addSocksMatchingRule(ArrayList<String> arrayList, String string, String string2, String string3) {
        String string4 = "\tif (shExpMatch(url, \"" + string + "\"))\n\t{\n\t\treturn \"SOCKS5 " + string2 + ":" + string3 + "\";\n\t}";
        arrayList.add(string4);
    }

    public void loadPatternsList(String string, ArrayList<String> arrayList) {
        SimpleFile simpleFile = new SimpleFile(this.strPatternsFolder + string.substring(0, 2) + "_user.txt");
        if (simpleFile.exists()) {
            String string2;
            simpleFile.openBufferedRead();
            while ((string2 = simpleFile.readLine()) != null) {
                int n = string2.indexOf(60);
                int n2 = string2.indexOf(62);
                if (n != 0 || n2 != string2.length() - 1) continue;
                arrayList.add(string2.substring(n + 1, n2) + ",user");
            }
            simpleFile.closeFile();
        }
    }

    public void deletePatternsFile(String string, String string2) {
        SimpleFile simpleFile = new SimpleFile(this.strPatternsFolder + string.substring(0, 2) + "_" + string2 + FILEEXT);
        simpleFile.delete();
    }

    public void savePatternsList(String string, String string2, ArrayList<String> arrayList) {
        SimpleFile simpleFile = new SimpleFile(this.strPatternsFolder + string.substring(0, 2) + "_" + string2 + FILEEXT);
        simpleFile.openBufferedWrite();
        simpleFile.writeFile(PATTERNFIRSTLINE, 1);
        for (String string3 : arrayList) {
            simpleFile.writeFile("<" + string3 + ">", 1);
        }
        simpleFile.closeFile();
    }

    public final void setPatternsFolder(String string) {
        this.strPatternsFolder = string + SimpleFile.getSeparator();
        SimpleFile.createFolder(this.strPatternsFolder);
    }

    public final void setPACFolder(String string) {
        this.strPACPath = string;
        SimpleFile.createFolder(string);
    }

    public final void setBackupFolder(String string) {
        this.strBackupFolder = string + SimpleFile.getSeparator();
        SimpleFile.createFolder(this.strBackupFolder);
        this.strGnome3ProxyPrefsBackup = OSFunction.getGsettingsPath() != null ? this.strBackupFolder + "gnome3_proxy.txt" : null;
        this.strKDEProxyPrefsBackup = OSFunction.getKDEProxyPath() != null ? this.strBackupFolder + "kde_proxy.txt" : null;
    }

    public final void setTempFolder(String string) {
        this.strTempFolder = string;
    }

    public void backupProxyPrefs() {
        this.backupGnomeProxyPrefs();
        this.backupKDEProxyPrefs();
    }

    private void backupGnomeProxyPrefs() {
        if (this.strBackupFolder == null) {
            return;
        }
        try {
            SimpleFile simpleFile;
            if (this.strGnome3ProxyPrefsBackup != null && !(simpleFile = new SimpleFile(this.strGnome3ProxyPrefsBackup)).exists()) {
                simpleFile.openBufferedWrite();
                simpleFile.writeFile(OSFunction.getGnome3Pref("org.gnome.system.proxy", "mode"), 1);
                simpleFile.writeFile(OSFunction.getGnome3Pref("org.gnome.system.proxy", "autoconfig-url"), 1);
                simpleFile.closeFile();
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.SEVERE, this.getClass().getName(), "backupGnomeProxyPrefs()", "", exception);
        }
    }

    private void backupKDEProxyPrefs() {
        if (this.strBackupFolder == null) {
            return;
        }
        try {
            SimpleFile simpleFile;
            if (this.strKDEProxyPrefsBackup != null && !(simpleFile = new SimpleFile(this.strKDEProxyPrefsBackup)).exists()) {
                simpleFile.openBufferedWrite();
                simpleFile.writeFile(OSFunction.getKDEPref("Proxy Settings", "Proxy Config Script", ""), 1);
                simpleFile.writeFile(OSFunction.getKDEPref("Proxy Settings", "ProxyType", "0"), 1);
                simpleFile.closeFile();
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.SEVERE, this.getClass().getName(), "backupKDEProxyPrefs()", "", exception);
        }
    }

    public void restoreProxyPrefs(boolean bl) {
        this.restoreGnomeProxyPrefs(bl);
        this.restoreKDEProxyPrefs(bl);
    }

    private void restoreGnomeProxyPrefs(boolean bl) {
        try {
            if (this.strGnome3ProxyPrefsBackup != null) {
                SimpleFile simpleFile = new SimpleFile(this.strGnome3ProxyPrefsBackup);
                if (simpleFile.exists()) {
                    simpleFile.openBufferedRead();
                    String string = simpleFile.readLine();
                    String string2 = simpleFile.readLine();
                    simpleFile.closeFile();
                    if (string2 != null && string != null && !string.isEmpty()) {
                        OSFunction.setGnome3Pref("org.gnome.system.proxy", "mode", string);
                        OSFunction.setGnome3Pref("org.gnome.system.proxy", "autoconfig-url", string2);
                    }
                } else if (bl) {
                    this.setGnomeProxyAutoConfigURL(null);
                }
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.SEVERE, this.getClass().getName(), "restoreGnomeProxyPrefs()", "", exception);
        }
    }

    private void restoreKDEProxyPrefs(boolean bl) {
        try {
            if (this.strKDEProxyPrefsBackup != null) {
                SimpleFile simpleFile = new SimpleFile(this.strKDEProxyPrefsBackup);
                if (simpleFile.exists()) {
                    simpleFile.openBufferedRead();
                    String string = simpleFile.readLine();
                    String string2 = simpleFile.readLine();
                    simpleFile.closeFile();
                    if (string != null && string2 != null) {
                        if (!SimpleFile.exists(string)) {
                            string = "";
                        }
                        OSFunction.setKDEPref("Proxy Settings", "Proxy Config Script", string);
                        OSFunction.setKDEPref("Proxy Settings", "ProxyType", string2);
                    }
                } else if (bl) {
                    this.setKDEProxyAutoConfigURL(null);
                }
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.SEVERE, this.getClass().getName(), "restoreKDEProxyPrefs()", "", exception);
        }
    }

    public void deleteProxyPrefs() {
        this.deleteGnomeProxyPrefs();
        this.deleteKDEProxyPrefs();
    }

    private boolean deleteGnomeProxyPrefs() {
        if (this.strBackupFolder == null) {
            return false;
        }
        boolean bl = true;
        if (this.strGnome3ProxyPrefsBackup != null) {
            bl = SimpleFile.delete(this.strGnome3ProxyPrefsBackup);
        }
        return bl;
    }

    private boolean deleteKDEProxyPrefs() {
        if (this.strBackupFolder == null) {
            return false;
        }
        boolean bl = true;
        if (this.strKDEProxyPrefsBackup != null) {
            bl = SimpleFile.delete(this.strKDEProxyPrefsBackup);
        }
        return bl;
    }

    public void setProxyAutoConfigURL(String string) {
        this.setGnomeProxyAutoConfigURL(string);
        this.setKDEProxyAutoConfigURL(string);
    }

    private void setGnomeProxyAutoConfigURL(String string) {
        if (this.strGnome3ProxyPrefsBackup != null) {
            if (string == null) {
                OSFunction.resetGnome3Pref("org.gnome.system.proxy", "mode");
                OSFunction.resetGnome3Pref("org.gnome.system.proxy", "autoconfig-url");
            } else {
                OSFunction.setGnome3Pref("org.gnome.system.proxy", "mode", "auto");
                OSFunction.setGnome3Pref("org.gnome.system.proxy", "autoconfig-url", string);
            }
        }
    }

    private void setKDEProxyAutoConfigURL(String string) {
        if (this.strKDEProxyPrefsBackup != null) {
            if (string == null) {
                OSFunction.setKDEPref("Proxy Settings", "Proxy Config Script", "");
                OSFunction.setKDEPref("Proxy Settings", "ProxyType", 0);
            } else {
                OSFunction.setKDEPref("Proxy Settings", "Proxy Config Script", string);
                OSFunction.setKDEPref("Proxy Settings", "ProxyType", 2);
            }
        }
    }

    private void savePACFile(String string, ArrayList<String> arrayList) {
        SimpleFile simpleFile = new SimpleFile(this.strPACPath + string);
        simpleFile.openBufferedWrite();
        simpleFile.writeFile("//" + string, 1);
        String string2 = "function FindProxyForURL(url, host) {";
        simpleFile.writeFile(string2, 1);
        for (String string3 : arrayList) {
            simpleFile.writeFile(string3, 1);
        }
        simpleFile.writeFile("}", 1);
        simpleFile.closeFile();
    }

    public boolean deletePAC(String string) {
        return SimpleFile.delete(this.strPACPath + string);
    }

    public void deleteAllPAC() {
        SimpleFile simpleFile = new SimpleFile(this.strPACPath);
        simpleFile.setFileFilter(PACFILE_EXT);
        simpleFile.deleteFileList(simpleFile.getFileList());
    }

    private String createRandomName() {
        int n = this.randgen.nextInt();
        if (n < 0) {
            n = 0 - n;
        }
        return String.valueOf(n);
    }

    public void setDefaultProxy(String string) {
        this.strDefaultProxy = string;
    }

    public void setDoNotProxy(String string) {
        this.strDoNotProxy = string;
    }

    public String getDoNotProxy() {
        return this.strDoNotProxy;
    }

    public void addToPatternFile(String string, String string2, String string3) {
        if (this.strPatternsFolder == null || string3.isEmpty()) {
            return;
        }
        SimpleFile simpleFile = new SimpleFile(this.strPatternsFolder + SimpleFile.getSeparator() + string.substring(0, 2) + "_user.txt");
        simpleFile.openBufferedAppend();
        simpleFile.writeFile("<" + string2 + "," + string3 + ",true>", 1);
        simpleFile.closeFile();
    }

    public File[] getPatternsFiles() {
        SimpleFile simpleFile = new SimpleFile(this.strPatternsFolder);
        simpleFile.setFileFilter("user.txt");
        return simpleFile.getFileList();
    }

    public void exportUserPatterns(String object, File[] fileArray) {
        if (!((String)object).endsWith(".zip")) {
            object = (String)object + ".zip";
        }
        SimpleFile simpleFile = new SimpleFile((String)object);
        simpleFile.openZipStream(9);
        simpleFile.addFilesToZip(fileArray);
        simpleFile.closeZipStream();
    }

    public boolean importPatterns(String string) {
        boolean bl = false;
        SimpleFile simpleFile = new SimpleFile(string);
        if (simpleFile.exists()) {
            String string2 = this.strTempFolder == null ? OSFunction.getTempFolder(null) + this.getClass().getName() : this.strTempFolder + this.getClass().getName();
            SimpleFile.createFolder(string2);
            bl = simpleFile.extractZipTo(string2);
            if (bl) {
                simpleFile.setFileName(string2);
                simpleFile.setFileFilter(FILEEXT);
                File[] fileArray = simpleFile.getFileList();
                try {
                    if (fileArray.length == 0) {
                        throw new Exception();
                    }
                    for (File file : fileArray) {
                        simpleFile.setFile(file);
                        simpleFile.openBufferedRead();
                        String string3 = simpleFile.readLine();
                        simpleFile.closeFile();
                        if (string3 == null) continue;
                        if (string3.toLowerCase().contains("pattern file")) {
                            SimpleFile.copyFromTo(file.getAbsolutePath(), this.strPatternsFolder + file.getName());
                            continue;
                        }
                        bl = false;
                        break;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            SimpleFile.deleteFolder(string2);
        }
        return bl;
    }
}

