/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PacFactory;
import client.QuickAddDialog;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import lib.InfoDialog;
import lib.Localisation;

public final class PatternsEditor
extends JDialog {
    public static final int CANCEL = 0;
    public static final int APPLY = 1;
    private final PACTableModel pactm = new PACTableModel();
    private PacFactory pacFactory = null;
    private String strChange = null;
    private Frame parent = null;
    private String strSelectedCountry = null;
    private static final Localisation LOCAL = new Localisation("resources/MessagesBundle");
    private JButton jButtonAddPattern;
    private JButton jButtonCancel;
    private JButton jButtonDeletePattern;
    private JButton jButtonSave;
    private JComboBox<String> jComboCountry;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JScrollPane jScrollPane1;
    private JTable jTablePatterns;
    private JTextField jTextDoNotProxy;
    private int returnStatus = 0;

    public PatternsEditor(Frame frame, boolean bl, PacFactory pacFactory) {
        super(frame, bl);
        this.parent = frame;
        this.pacFactory = pacFactory;
        this.initComponents();
        this.pactm.setColumnName(LOCAL.getString("patterntable_col1"), 0);
        this.pactm.setColumnName(LOCAL.getString("patterntable_col2"), 1);
        this.pactm.setColumnName(LOCAL.getString("patterntable_col3"), 2);
        this.jTablePatterns.setModel(this.pactm);
        this.jTablePatterns.setDefaultRenderer(String.class, new CustomTableCellRenderer());
        this.adjustTableColumnWidth(0, "AAAAAAAAAA");
        this.adjustTableColumnWidth(1, "AAAAAAAAAAAAAAAAAAAAAAAA");
        this.adjustTableColumnWidth(2, "AAA");
        this.jTablePatterns.setRowHeight(this.jLabel1.getHeight() + 1);
        this.jTablePatterns.setShowGrid(true);
        this.jTextDoNotProxy.setText(this.pacFactory.getDoNotProxy());
    }

    public void populateCountryComboBox(String[] stringArray) {
        this.jComboCountry.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.jComboCountry.setSelectedIndex(-1);
    }

    public void setSelectedCountry(String string) {
        this.jComboCountry.setSelectedItem(string);
    }

    private void populatePatternsTable(ArrayList<String> arrayList) {
        while (this.pactm.getRowCount() > 0) {
            this.pactm.removeRow(0);
        }
        if (arrayList == null) {
            this.strChange = this.pactm.toString() + this.jTextDoNotProxy.getText();
            return;
        }
        Pattern pattern = Pattern.compile(",");
        Object[] objectArray = new Object[3];
        for (String string : arrayList) {
            String[] stringArray = pattern.split(string);
            if (stringArray.length < 4) continue;
            objectArray[0] = stringArray[0];
            objectArray[1] = stringArray[1];
            try {
                objectArray[2] = Boolean.valueOf(stringArray[2]);
            }
            catch (Exception exception) {
                objectArray[2] = true;
            }
            this.pactm.addRow(objectArray, stringArray[3].contains("user"));
        }
        this.strChange = this.pactm.toString() + this.jTextDoNotProxy.getText();
    }

    private boolean isPatternsTableChanged() {
        if (this.strChange == null) {
            return false;
        }
        String string = this.pactm.toString() + this.jTextDoNotProxy.getText();
        return !string.contentEquals(this.strChange);
    }

    private void savePatterns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.pactm.getRowCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String string = String.valueOf(this.pactm.getValueAt(i, 0)) + "," + String.valueOf(this.pactm.getValueAt(i, 1));
                Boolean bl = (Boolean)this.pactm.getValueAt(i, 2);
                string = bl != false ? string + ",true" : string + ",false";
                arrayList.add(string);
            }
        }
        if (arrayList.isEmpty()) {
            this.pacFactory.deletePatternsFile(this.strSelectedCountry, "user");
        } else {
            this.pacFactory.savePatternsList(this.strSelectedCountry, "user", arrayList);
        }
        this.pacFactory.setDoNotProxy(this.jTextDoNotProxy.getText());
        this.strChange = this.pactm.toString() + this.jTextDoNotProxy.getText();
    }

    private int saveOnExitCheck() {
        int n = 0;
        if (this.jButtonSave.isEnabled()) {
            this.jComboCountry.hidePopup();
            InfoDialog infoDialog = new InfoDialog(this.parent);
            infoDialog.createWarn(LOCAL.getString("dlg_patterneditsave_title"), LOCAL.getString("dlg_patterneditsave_body"));
            infoDialog.setVisible(true);
            this.strChange = null;
            if (infoDialog.getReturnStatus() == 2) {
                this.savePatterns();
                n = 1;
            }
            this.jButtonSave.setEnabled(this.isPatternsTableChanged());
        }
        return n;
    }

    private void adjustTableColumnWidth(int n, String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.jTablePatterns.getTableHeader().getFont());
        this.jTablePatterns.getColumn(this.jTablePatterns.getColumnName(n)).setPreferredWidth(fontMetrics.stringWidth(string));
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboCountry = new JComboBox();
        this.jButtonDeletePattern = new JButton();
        this.jButtonAddPattern = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTablePatterns = new JTable();
        this.jLabel17 = new JLabel();
        this.jTextDoNotProxy = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Proxy Pattern Editor");
        this.setIconImage(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PatternsEditor.this.closeDialog(windowEvent);
            }
        });
        this.jButtonSave.setText(LOCAL.getString("button_save"));
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternsEditor.this.jButtonSaveActionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(LOCAL.getString("button_close"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternsEditor.this.jButtonCancelActionPerformed(actionEvent);
            }
        });
        this.jComboCountry.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboCountry.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PatternsEditor.this.jComboCountryItemStateChanged(itemEvent);
            }
        });
        this.jButtonDeletePattern.setText(LOCAL.getString("button_delete"));
        this.jButtonDeletePattern.setEnabled(false);
        this.jButtonDeletePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternsEditor.this.jButtonDeletePatternActionPerformed(actionEvent);
            }
        });
        this.jButtonAddPattern.setText(LOCAL.getString("button_addnew"));
        this.jButtonAddPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternsEditor.this.jButtonAddPatternActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText(LOCAL.getString("label_editcountry"));
        this.jTablePatterns.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTablePatterns.setToolTipText(LOCAL.getString("ttip_patterntable"));
        this.jTablePatterns.setAutoResizeMode(3);
        this.jTablePatterns.setSelectionMode(2);
        this.jTablePatterns.getTableHeader().setResizingAllowed(false);
        this.jTablePatterns.getTableHeader().setReorderingAllowed(false);
        this.jTablePatterns.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PatternsEditor.this.jTablePatternsMouseReleased(mouseEvent);
            }
        });
        this.jTablePatterns.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PatternsEditor.this.jTablePatternsKeyReleased(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jTablePatterns);
        this.jLabel17.setText(LOCAL.getString("label_donotproxy"));
        this.jTextDoNotProxy.setToolTipText(LOCAL.getString("ttip_donotproxy"));
        this.jTextDoNotProxy.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PatternsEditor.this.jTextDoNotProxyFocusLost(focusEvent);
            }
        });
        this.jTextDoNotProxy.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PatternsEditor.this.jTextDoNotProxyKeyReleased(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(groupLayout.createSequentialGroup().addComponent(this.jComboCountry, -2, 264, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jButtonDeletePattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddPattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextDoNotProxy))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboCountry, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 341, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextDoNotProxy, -2, -1, -2).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDeletePattern).addComponent(this.jButtonCancel).addComponent(this.jButtonSave).addComponent(this.jButtonAddPattern)).addContainerGap()));
        this.pack();
    }

    private void jButtonSaveActionPerformed(ActionEvent actionEvent) {
        this.savePatterns();
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
        this.doClose(1);
    }

    private void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        this.doClose(this.saveOnExitCheck());
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void jComboCountryItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        this.saveOnExitCheck();
        if (this.jComboCountry.getItemCount() == 0) {
            this.jTablePatterns.setEnabled(false);
            this.jButtonDeletePattern.setEnabled(false);
            this.jButtonAddPattern.setEnabled(false);
            this.jButtonSave.setEnabled(false);
            this.populatePatternsTable(null);
            return;
        }
        this.jTablePatterns.setEnabled(true);
        this.jButtonAddPattern.setEnabled(true);
        this.strSelectedCountry = (String)this.jComboCountry.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        this.pacFactory.loadPatternsList(this.strSelectedCountry, arrayList);
        this.populatePatternsTable(arrayList);
    }

    private void jTablePatternsMouseReleased(MouseEvent mouseEvent) {
        this.jButtonDeletePattern.setEnabled(this.jTablePatterns.isCellEditable(this.jTablePatterns.getSelectedRow(), 0));
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void jButtonDeletePatternActionPerformed(ActionEvent actionEvent) {
        int[] nArray;
        while ((nArray = this.jTablePatterns.getSelectedRows()).length != 0) {
            this.pactm.removeRow(nArray[0]);
        }
        this.jButtonDeletePattern.setEnabled(false);
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void jTablePatternsKeyReleased(KeyEvent keyEvent) {
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void jButtonAddPatternActionPerformed(ActionEvent actionEvent) {
        QuickAddDialog quickAddDialog = new QuickAddDialog(this.parent, true);
        quickAddDialog.setTitle("Add new pattern");
        quickAddDialog.setLocationRelativeTo(this);
        quickAddDialog.setVisible(true);
        if (quickAddDialog.getReturnStatus() == 0) {
            return;
        }
        if (!quickAddDialog.getPattern().isEmpty()) {
            this.pactm.addRow(new Object[]{quickAddDialog.getDescription(), quickAddDialog.getPattern(), Boolean.TRUE}, true);
        }
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void jTextDoNotProxyKeyReleased(KeyEvent keyEvent) {
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void jTextDoNotProxyFocusLost(FocusEvent focusEvent) {
        this.jButtonSave.setEnabled(this.isPatternsTableChanged());
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    public class PACTableModel
    extends DefaultTableModel {
        private final String[] columnNames = new String[]{"Description", "Pattern", "Enabled"};
        private final Class[] types = new Class[]{String.class, String.class, Boolean.class};
        private final ArrayList<Boolean> rowedit = new ArrayList();

        public void addRow(Object[] objectArray, boolean bl) {
            this.addRow(objectArray);
            this.rowedit.add(bl);
        }

        @Override
        public int getColumnCount() {
            return this.types.length;
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                return true;
            }
            return this.rowedit.get(n);
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public void setColumnName(String string, int n) {
            if (n < this.columnNames.length) {
                this.columnNames[n] = string;
            }
        }

        public String toString() {
            return this.getDataVector().toString();
        }
    }

    public class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable.isRowSelected(n)) {
                return component;
            }
            if (n2 < 2) {
                if (jTable.getModel().isCellEditable(n, n2)) {
                    component.setBackground(UIManager.getDefaults().getColor("Table.background"));
                } else {
                    component.setBackground(UIManager.getDefaults().getColor("control"));
                }
            }
            return component;
        }
    }
}

