/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lib.Localisation;
import lib.SimpleProps;
import lib.Utilities;

public final class PrefsDialog
extends JDialog {
    public static final int CANCEL = 0;
    public static final int APPLY = 1;
    public static final int RESET = 2;
    private static final Localisation LOCAL = new Localisation("resources/MessagesBundle");
    private final SimpleProps sp;
    private final String disabledprefs;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonDefaults;
    private JButton jButtonGetBridges;
    private JCheckBox jCheckAppUpdate;
    private JCheckBox jCheckAutostart;
    private JCheckBox jCheckAvoidDisk;
    private JCheckBox jCheckCacheDelete;
    private JCheckBox jCheckDisableNotify;
    private JCheckBox jCheckDisableTray;
    private JCheckBox jCheckGeoUpdate;
    private JCheckBox jCheckHideMin;
    private JCheckBox jCheckHideTray;
    private JCheckBox jCheckMinOnClose;
    private JCheckBox jCheckSafeLog;
    private JCheckBox jCheckSafeSocks;
    private JCheckBox jCheckTestSocks;
    private JComboBox<String> jComboLogLev;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel6;
    private JLabel jLabelPortRanges;
    private JPanel jPanel1;
    private JPanel jPanelAdvancedPrefs;
    private JPanel jPanelBasicPrefs;
    private JPanel jPanelGeneralPrefs;
    private JPanel jPanelTorPrefs;
    private JSpinner jSpinnerMainPort;
    private JTabbedPane jTabPrefs;
    private JTextField jTextHTTPProxy;
    private JTextField jTextTorArgs;
    private JTextField jTextTorBridge;
    private int returnStatus = 0;

    public PrefsDialog(Frame frame, SimpleProps simpleProps, String string) {
        super(frame, true);
        this.sp = simpleProps;
        this.disabledprefs = string;
        this.initComponents();
        this.loadBasicPrefs(false);
        this.loadAdvancedPrefs(false);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void loadBasicPrefs(boolean bl) {
        this.sp.setDefaultModeEnabled(bl);
        this.jCheckAutostart.setSelected(this.sp.getBool("PREF_AUTOSTART"));
        this.jCheckDisableTray.setSelected(this.sp.getBool("PREF_NOSYSTRAY"));
        this.jCheckHideMin.setEnabled(!this.jCheckDisableTray.isSelected());
        this.jCheckHideTray.setSelected(this.sp.getBool("PREF_HIDETOTRAY"));
        this.jCheckAppUpdate.setSelected(this.sp.getBool("PREF_UPDATECHECK"));
        this.jCheckMinOnClose.setSelected(this.sp.getBool("PREF_MINONCLOSE"));
        this.jCheckCacheDelete.setSelected(this.sp.getBool("PREF_CACHEDELETE"));
        this.jCheckDisableNotify.setSelected(this.sp.getBool("PREF_DISABLE_NOTIFY"));
        this.jCheckHideMin.setSelected(this.sp.getBool("PREF_HIDE_MIN"));
        this.jCheckGeoUpdate.setSelected(this.sp.getBool("PREF_GEOCHECK"));
        if (this.disabledprefs.contains("jCheckDisableTray")) {
            this.jCheckDisableTray.setEnabled(false);
            this.jCheckHideMin.setEnabled(false);
        }
        this.jCheckAppUpdate.setVisible(!this.disabledprefs.contains("jCheckAppUpdate"));
        this.sp.setDefaultModeEnabled(false);
        this.updatePortRanges(this.sp.getInt("PREF_TOR_TESTHREADS"));
    }

    public void loadAdvancedPrefs(boolean bl) {
        this.sp.setDefaultModeEnabled(bl);
        this.jTextHTTPProxy.setText(this.sp.getString("PREF_HTTP_PROXY"));
        this.jSpinnerMainPort.setValue(this.sp.getInt("PREF_LISTENPORT"));
        this.jTextTorBridge.setText(this.sp.getString("PREF_TORBRIDGE"));
        this.jTextTorArgs.setText(this.sp.getString("PREF_TORARGS"));
        this.jComboLogLev.setSelectedIndex(this.sp.getInt("PREF_TORLOGLEV"));
        this.jCheckSafeSocks.setSelected(this.sp.getBool("PREF_SAFESOCKS"));
        this.jCheckTestSocks.setSelected(this.sp.getBool("PREF_TESTSOCKS"));
        this.jCheckAvoidDisk.setSelected(this.sp.getBool("PREF_AVOIDDISK"));
        this.jCheckSafeLog.setSelected(this.sp.getBool("PREF_SAFELOG"));
        this.sp.setDefaultModeEnabled(false);
    }

    public void savePreferences() {
        this.sp.setInt("PREF_LISTENPORT", (Integer)this.jSpinnerMainPort.getValue());
        this.sp.setInt("PREF_TORLOGLEV", this.jComboLogLev.getSelectedIndex());
        this.sp.setBool("PREF_AUTOSTART", this.jCheckAutostart.isSelected());
        this.sp.setBool("PREF_NOSYSTRAY", this.jCheckDisableTray.isSelected());
        this.sp.setBool("PREF_HIDETOTRAY", this.jCheckHideTray.isSelected());
        this.sp.setBool("PREF_UPDATECHECK", this.jCheckAppUpdate.isSelected());
        this.sp.setBool("PREF_MINONCLOSE", this.jCheckMinOnClose.isSelected());
        this.sp.setBool("PREF_SAFESOCKS", this.jCheckSafeSocks.isSelected());
        this.sp.setBool("PREF_TESTSOCKS", this.jCheckTestSocks.isSelected());
        this.sp.setBool("PREF_AVOIDDISK", this.jCheckAvoidDisk.isSelected());
        this.sp.setBool("PREF_SAFELOG", this.jCheckSafeLog.isSelected());
        this.sp.setBool("PREF_CACHEDELETE", this.jCheckCacheDelete.isSelected());
        this.sp.setBool("PREF_DISABLE_NOTIFY", this.jCheckDisableNotify.isSelected());
        this.sp.setBool("PREF_HIDE_MIN", this.jCheckHideMin.isSelected());
        this.sp.setBool("PREF_GEOCHECK", this.jCheckGeoUpdate.isSelected());
        this.sp.setString("PREF_HTTP_PROXY", this.jTextHTTPProxy.getText());
        this.sp.setString("PREF_TORBRIDGE", this.jTextTorBridge.getText());
        this.sp.setString("PREF_TORARGS", this.jTextTorArgs.getText());
    }

    private void updatePortRanges(int n) {
        int n2 = this.sp.getInt("PREF_LISTENPORT");
        String string = LOCAL.getString("label_portranges");
        string = string.replace("$portmin", String.valueOf(n2));
        string = string.replace("$portmax", String.valueOf(n2 + n * 2 + 1));
        this.jLabelPortRanges.setText(string);
    }

    private void initComponents() {
        this.jTabPrefs = new JTabbedPane();
        this.jPanelBasicPrefs = new JPanel();
        this.jPanelGeneralPrefs = new JPanel();
        this.jCheckHideTray = new JCheckBox();
        this.jCheckAppUpdate = new JCheckBox();
        this.jCheckAutostart = new JCheckBox();
        this.jCheckDisableTray = new JCheckBox();
        this.jCheckMinOnClose = new JCheckBox();
        this.jCheckCacheDelete = new JCheckBox();
        this.jCheckDisableNotify = new JCheckBox();
        this.jCheckHideMin = new JCheckBox();
        this.jCheckGeoUpdate = new JCheckBox();
        this.jPanelAdvancedPrefs = new JPanel();
        this.jPanelTorPrefs = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSpinnerMainPort = new JSpinner();
        this.jLabelPortRanges = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextTorBridge = new JTextField();
        this.jButtonGetBridges = new JButton();
        this.jCheckSafeSocks = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.jCheckTestSocks = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jTextTorArgs = new JTextField();
        this.jLabel14 = new JLabel();
        this.jCheckAvoidDisk = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.jComboLogLev = new JComboBox();
        this.jCheckSafeLog = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel16 = new JLabel();
        this.jTextHTTPProxy = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonDefaults = new JButton();
        this.setDefaultCloseOperation(2);
        this.setIconImage(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrefsDialog.this.closeDialog(windowEvent);
            }
        });
        this.jTabPrefs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PrefsDialog.this.jTabPrefsStateChanged(changeEvent);
            }
        });
        this.jPanelBasicPrefs.setFont(this.jPanelBasicPrefs.getFont().deriveFont(this.jPanelBasicPrefs.getFont().getStyle() | 1));
        this.jPanelGeneralPrefs.setBorder(BorderFactory.createTitledBorder(null, LOCAL.getString("panel_general"), 0, 0, this.jPanelBasicPrefs.getFont(), this.jPanelBasicPrefs.getForeground()));
        this.jCheckHideTray.setText(LOCAL.getString("chkbox_hidetotray"));
        this.jCheckHideTray.setToolTipText(LOCAL.getString("ttip_hidetotray"));
        this.jCheckAppUpdate.setSelected(true);
        this.jCheckAppUpdate.setText(LOCAL.getString("chkbox_checkforupdates"));
        this.jCheckAppUpdate.setToolTipText(LOCAL.getString("ttip_checkforupdates"));
        this.jCheckAutostart.setText(LOCAL.getString("chkbox_autostart"));
        this.jCheckAutostart.setToolTipText(LOCAL.getString("ttip_autostart"));
        this.jCheckDisableTray.setText(LOCAL.getString("chkbox_disabletray"));
        this.jCheckDisableTray.setToolTipText(LOCAL.getString("ttip_disabletray"));
        this.jCheckDisableTray.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PrefsDialog.this.jCheckDisableTrayItemStateChanged(itemEvent);
            }
        });
        this.jCheckMinOnClose.setText(LOCAL.getString("chkbox_minonclose"));
        this.jCheckMinOnClose.setToolTipText(LOCAL.getString("ttip_minonclose"));
        this.jCheckCacheDelete.setText(LOCAL.getString("chkbox_securedelete"));
        this.jCheckCacheDelete.setToolTipText(LOCAL.getString("ttip_securedelete"));
        this.jCheckDisableNotify.setText(LOCAL.getString("chkbox_disablenotify"));
        this.jCheckDisableNotify.setToolTipText(LOCAL.getString("ttip_disablenotify"));
        this.jCheckHideMin.setText(LOCAL.getString("chkbox_hidemin"));
        this.jCheckHideMin.setToolTipText(LOCAL.getString("ttip_hidemin"));
        this.jCheckGeoUpdate.setSelected(true);
        this.jCheckGeoUpdate.setText(LOCAL.getString("chkbox_geocheck"));
        this.jCheckGeoUpdate.setToolTipText(LOCAL.getString("ttip_geocheck"));
        GroupLayout groupLayout = new GroupLayout(this.jPanelGeneralPrefs);
        this.jPanelGeneralPrefs.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckAutostart).addComponent(this.jCheckHideTray).addComponent(this.jCheckCacheDelete).addComponent(this.jCheckHideMin).addComponent(this.jCheckDisableNotify)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckAppUpdate).addComponent(this.jCheckGeoUpdate).addComponent(this.jCheckDisableTray).addComponent(this.jCheckMinOnClose)).addContainerGap(39, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckAutostart).addComponent(this.jCheckGeoUpdate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckHideTray).addComponent(this.jCheckDisableTray)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckHideMin).addComponent(this.jCheckMinOnClose)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckCacheDelete).addComponent(this.jCheckAppUpdate)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckDisableNotify).addContainerGap(132, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this.jPanelBasicPrefs);
        this.jPanelBasicPrefs.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelGeneralPrefs, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelGeneralPrefs, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabPrefs.addTab(LOCAL.getString("tab_basic"), this.jPanelBasicPrefs);
        this.jPanelTorPrefs.setBorder(BorderFactory.createTitledBorder(null, LOCAL.getString("panel_torclientset"), 0, 0, this.jPanelBasicPrefs.getFont(), this.jPanelBasicPrefs.getForeground()));
        this.jLabel6.setText(LOCAL.getString("label_listenport"));
        this.jSpinnerMainPort.setModel(new SpinnerNumberModel(9054, 9054, 9999, 1));
        this.jSpinnerMainPort.setToolTipText(LOCAL.getString("ttip_listenport"));
        this.jLabelPortRanges.setText("Currently active port ranges, 9052 to 9063");
        this.jLabel11.setText(LOCAL.getString("label_bridgeaddress"));
        this.jTextTorBridge.setToolTipText(LOCAL.getString("ttip_bridgeaddress"));
        this.jButtonGetBridges.setText(LOCAL.getString("button_getbridges"));
        this.jButtonGetBridges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.jButtonGetBridgesActionPerformed(actionEvent);
            }
        });
        this.jCheckSafeSocks.setText(LOCAL.getString("chkbox_safesocks"));
        this.jCheckSafeSocks.setToolTipText(LOCAL.getString("ttip_safesocks"));
        this.jLabel12.setText(LOCAL.getString("label_torlogging"));
        this.jCheckTestSocks.setText(LOCAL.getString("chkbox_testsocks"));
        this.jCheckTestSocks.setToolTipText(LOCAL.getString("ttip_testsocks"));
        this.jLabel13.setText(LOCAL.getString("label_torargs"));
        this.jTextTorArgs.setToolTipText(LOCAL.getString("ttip_extraargs"));
        this.jLabel14.setText(LOCAL.getString("label_torsocks"));
        this.jCheckAvoidDisk.setText(LOCAL.getString("chkbox_diskavoid"));
        this.jCheckAvoidDisk.setToolTipText(LOCAL.getString("ttip_avoiddisk"));
        this.jLabel15.setText(LOCAL.getString("label_diskoptions"));
        this.jComboLogLev.setModel(new DefaultComboBoxModel<String>(new String[]{LOCAL.getString("combo_loglev1"), LOCAL.getString("combo_loglev2"), LOCAL.getString("combo_loglev3")}));
        this.jComboLogLev.setToolTipText(LOCAL.getString("ttip_combo_loglevel"));
        this.jCheckSafeLog.setText(LOCAL.getString("chkbox_safelog"));
        this.jCheckSafeLog.setToolTipText(LOCAL.getString("ttip_safelogging"));
        GroupLayout groupLayout3 = new GroupLayout(this.jPanelTorPrefs);
        this.jPanelTorPrefs.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.jLabel11).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jCheckSafeSocks).addGap(18, 18, 18).addComponent(this.jCheckTestSocks)).addComponent(this.jCheckAvoidDisk).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jComboLogLev, -2, 145, -2).addGap(18, 18, 18).addComponent(this.jCheckSafeLog)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jTextTorBridge, -2, 259, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGetBridges)).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jSpinnerMainPort, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelPortRanges)).addComponent(this.jTextTorArgs)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelPortRanges).addComponent(this.jSpinnerMainPort, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextTorBridge, -2, -1, -2).addComponent(this.jButtonGetBridges)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jCheckSafeSocks).addComponent(this.jCheckTestSocks)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jComboLogLev, -2, -1, -2).addComponent(this.jCheckSafeLog)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jCheckAvoidDisk)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextTorArgs, -2, -1, -2)).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, LOCAL.getString("panel_network"), 0, 0, this.jPanelBasicPrefs.getFont(), this.jPanelBasicPrefs.getForeground()));
        this.jLabel16.setText(LOCAL.getString("label_defaultproxy"));
        this.jTextHTTPProxy.setToolTipText(LOCAL.getString("ttip_defaultproxy"));
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextHTTPProxy).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextHTTPProxy, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout5 = new GroupLayout(this.jPanelAdvancedPrefs);
        this.jPanelAdvancedPrefs.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelTorPrefs, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jPanelTorPrefs, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabPrefs.addTab(LOCAL.getString("tab_advanced"), this.jPanelAdvancedPrefs);
        this.jButtonCancel.setText(LOCAL.getString("button_close"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.jButtonCancelActionPerformed(actionEvent);
            }
        });
        this.jButtonApply.setText(LOCAL.getString("button_apply"));
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.jButtonApplyActionPerformed(actionEvent);
            }
        });
        this.jButtonDefaults.setText(LOCAL.getString("button_prefdefaults"));
        this.jButtonDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsDialog.this.jButtonDefaultsActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addComponent(this.jButtonDefaults).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply).addContainerGap()).addComponent(this.jTabPrefs));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.jTabPrefs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonCancel).addComponent(this.jButtonDefaults)).addContainerGap()));
        this.pack();
    }

    private void jButtonApplyActionPerformed(ActionEvent actionEvent) {
        this.savePreferences();
        this.updatePortRanges(this.sp.getInt("PREF_TOR_TESTHREADS"));
        this.doClose(1);
    }

    private void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void jButtonGetBridgesActionPerformed(ActionEvent actionEvent) {
        Utilities.openFileExternally("https://bridges.torproject.org/bridges?lang=" + LOCAL.toWebLanguageTag());
    }

    private void jButtonDefaultsActionPerformed(ActionEvent actionEvent) {
        switch (this.jTabPrefs.getSelectedIndex()) {
            case 0: {
                this.loadBasicPrefs(true);
                break;
            }
            case 1: {
                this.loadAdvancedPrefs(true);
            }
        }
    }

    private void jTabPrefsStateChanged(ChangeEvent changeEvent) {
        switch (this.jTabPrefs.getSelectedIndex()) {
            case 0: {
                this.jButtonDefaults.setToolTipText(LOCAL.getString("ttip_resetbasicprefs"));
                break;
            }
            case 1: {
                this.jButtonDefaults.setToolTipText(LOCAL.getString("ttip_resetadvprefs"));
            }
        }
    }

    private void jCheckDisableTrayItemStateChanged(ItemEvent itemEvent) {
        this.jCheckHideMin.setEnabled(!this.jCheckDisableTray.isSelected());
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

