/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ExitNodeTableModel;
import client.GuardNodeDialog;
import client.NodeItem;
import client.NodeList;
import client.PacFactory;
import client.PatternsEditor;
import client.PrefsDialog;
import client.QuickAddDialog;
import client.TorCircuit;
import client.TorController;
import client.TorMonFrame;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import lib.AboutDialog;
import lib.DesktopNotify;
import lib.ExtensionFileFilter;
import lib.GTKFixes;
import lib.InfoDialog;
import lib.Localisation;
import lib.NetFunctions;
import lib.OSFunction;
import lib.SimpleFile;
import lib.SimpleProps;
import lib.SwingTrayIcon;
import lib.TextResourceDialog;
import lib.TrayPopupMenu;
import lib.Utilities;

public class SelekTOR
extends JFrame {
    private static final Localisation LOCAL = new Localisation("resources/MessagesBundle");
    private static final String EMPTYSTR = "";
    private static final String PREFSVER = "1.01";
    private static final String APPNAME = "SelekTOR";
    private static final String APPVER = "3.13.73";
    private static final String APPSERIES = "3xx";
    private static final String WEBDOMAIN = "www.dazzleships.net";
    private static final String FILEDOMAIN = "http://dazzle.000webhostapp.com";
    private static final String HOMEPAGE = "http://www.dazzleships.net";
    private static final String HOMEPAGE_SSL = "https://www.dazzleships.net";
    private static final String CONTACT = "https://www.dazzleships.net/?page_id=247";
    private static final String APPUPDATE = "http://dazzle.000webhostapp.com/anapps/linux/selektor/";
    private static final String TESTURL = "http://google.com";
    private static final String TORPROJECT = "https://torproject.org/";
    private static final String TORCHECK = "https://check.torproject.org/";
    private static final String ATLAS = "https://atlas.torproject.org/";
    private static final String PATREON = "https://www.patreon.com/SelekTOR";
    private static final String DOCSPATH = "/usr/share/doc/selektor/";
    private static final String EXITFAVOURITES = "favourites.txt";
    private static final String GUARDWHITELIST = "guardwhitelist.txt";
    private static final String GEOIPZIP = "geoip.zip";
    private static final String GEOIPSHA = "geoip.sha";
    private static final String ICONFILE = "selektor.png";
    private static final int TESTING_DISABLED = 0;
    private static final int TESTING_ACTIVE = -1;
    private static final long MAXTHRESHOLD = 5000L;
    private String clientLocation;
    private String settingsPath;
    private String cachePath;
    private String defaultGeoipPath;
    private String geoipPath;
    private String geoip6Path;
    private String iconPath = "";
    private TorController tcMain;
    private NodeList nodeList;
    private PacFactory pacFactory;
    private String strExitISOCode = "GB";
    private String strRequestedExit = "";
    private NodeItem niActiveGuard;
    private NodeItem niActiveMiddle;
    private NodeItem niActiveExit;
    private int intRowSelected = -1;
    private ExitNodeTableModel entm;
    private SimpleProps sp;
    private final ArrayList<TorController> alTestThreads = new ArrayList();
    private int intActiveNodeTests = 0;
    private int intBestNodeIndex = 0;
    private String[] strArrBestNodes;
    private long lngThreshold = 5000L;
    private int intThresholdExceeded = 0;
    private NetFunctions nf;
    private boolean boolNetEnabled = true;
    private String strSecret;
    private String strHash;
    private final ArrayList<String> alTestQueue = new ArrayList();
    private Timer tmr;
    private int intBeginTesting;
    private int intLatencyCheck;
    private int intAutoSelectCheck;
    private long lngHibernateTimeStamp;
    private volatile boolean boolFirstRun = true;
    private ArrayList<String> alArgs;
    private TorMonFrame tmf;
    private long startupDelay;
    private DesktopNotify dn;
    private SwingTrayIcon sti;
    private String desktopname = "";
    private String compositor = "";
    private boolean updateCheckDisabled;
    private ButtonGroup buttonGroupProxy;
    private ButtonGroup buttonGroupProxyTray;
    private JButton jButtonClearFavs;
    private JButton jButtonExitNodeDetails;
    private JButton jButtonGuardNodeDetails;
    private JButton jButtonMiddleNodeDetails;
    private JButton jButtonSetGuards;
    private JCheckBoxMenuItem jCheckProxyAll;
    private JCheckBoxMenuItem jCheckProxyByPattern;
    private JCheckBoxMenuItem jCheckProxyDisable;
    private JCheckBoxMenuItem jCheckTrayProxyAll;
    private JCheckBoxMenuItem jCheckTrayProxyByPattern;
    private JCheckBoxMenuItem jCheckTrayProxyDisable;
    private JComboBox<String> jComboCountry;
    private JLabel jLabStatus;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelCountry;
    private JLabel jLabelExit;
    private JLabel jLabelExitBw;
    private JLabel jLabelExitCountry;
    private JLabel jLabelExitIP;
    private JLabel jLabelExitNick;
    private JLabel jLabelExitStable;
    private JLabel jLabelGuard;
    private JLabel jLabelGuardBw;
    private JLabel jLabelGuardCountry;
    private JLabel jLabelGuardIP;
    private JLabel jLabelGuardNick;
    private JLabel jLabelGuardStable;
    private JLabel jLabelMiddle;
    private JLabel jLabelMiddleBw;
    private JLabel jLabelMiddleCountry;
    private JLabel jLabelMiddleIP;
    private JLabel jLabelMiddleNick;
    private JLabel jLabelMiddleStable;
    private JLabel jLabelStreams;
    private JLabel jLabelTorLatency;
    private JMenuBar jMenuBar;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemAddPattern;
    private JMenuItem jMenuItemDebugLog;
    private JMenuItem jMenuItemExport;
    private JMenuItem jMenuItemGUI;
    private JMenuItem jMenuItemGeoip;
    private JMenuItem jMenuItemHelp;
    private JMenuItem jMenuItemImport;
    private JMenuItem jMenuItemLicense;
    private JMenuItem jMenuItemPatternEdit;
    private JMenuItem jMenuItemPrefs;
    private JMenuItem jMenuItemQuit;
    private JMenuItem jMenuItemQuitx;
    private JMenuItem jMenuItemStdout;
    private JMenuItem jMenuItemTorCheck;
    private JMenuItem jMenuItemTorMan;
    private JMenu jMenuMenu;
    private JMenuItem jMenuNodeDetails;
    private JMenu jMenuProxy;
    private JMenuItem jMenuTesting;
    private JMenuItem jMenuWhois;
    private JPanel jPanelMain;
    private JPanel jPanelNodeInfo;
    private JScrollPane jScrollPaneExitNodes;
    private JTable jTableExitNodes;
    private JPopupMenu popupTable;

    public SelekTOR(String[] stringArray) {
        Utilities.loadUIStyle("System");
        if (OSFunction.isMultipleInstance(APPNAME)) {
            this.openInstanceDialog();
            this.cleanupExit();
            return;
        }
        Object object = OSFunction.getUsersCurrentFolder() + OSFunction.getFileSeparator();
        if (((String)object).startsWith("/usr/share")) {
            object = "/usr/share/";
        }
        this.iconPath = (String)object + "icons" + OSFunction.getFileSeparator();
        this.settingsPath = OSFunction.getAppSettingsPath(APPNAME, APPSERIES);
        this.cachePath = this.settingsPath + "cache" + OSFunction.getFileSeparator();
        this.initProperties();
        this.initPacFactory();
        this.desktopname = OSFunction.getActiveDesktop();
        this.compositor = OSFunction.getCompositor();
        if (this.processCLIArgs(stringArray)) {
            this.cleanupExit();
            return;
        }
        this.pacCleanup();
        this.clientLocation = OSFunction.isWindows() ? OSFunction.findFile("tor.exe", "Tor/") : OSFunction.findFile("tor", "/usr/sbin/", "/usr/bin/");
        if (this.clientLocation == null) {
            Logger.getGlobal().log(Level.SEVERE, "Tor client not found.");
            this.openTorClientDialog();
            this.cleanupExit();
            return;
        }
        this.defaultGeoipPath = "/usr/share/tor/";
        this.geoipPath = OSFunction.findFile("geoip", this.settingsPath, this.defaultGeoipPath);
        this.geoip6Path = OSFunction.findFile("geoip6", this.settingsPath, this.defaultGeoipPath);
        if (this.geoipPath == null || this.geoip6Path == null) {
            Logger.getGlobal().log(Level.SEVERE, "Geoip not found.");
            this.openTorClientDialog();
            this.cleanupExit();
            return;
        }
        if (OSFunction.getGsettingsPath() == null) {
            Logger.getGlobal().log(Level.SEVERE, "Gsettings not found.");
            this.openGsettingsDialog();
            this.cleanupExit();
            return;
        }
        this.initComponents();
        Utilities.preloadFileChooser();
        this.updateProgramStatus(LOCAL.getString("progstatus_initial"));
        try {
            Thread.sleep(this.startupDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.startupDelay = -1L;
        this.pacFactory.backupProxyPrefs();
        this.pacFactory.setProxyAutoConfigURL(null);
        this.initNodeTables();
        this.initTorMain();
        float f = this.tcMain.getVersion();
        Logger.getGlobal().logp(Level.INFO, this.getClass().getName(), EMPTYSTR, "Tor version = " + f);
        if ((double)f < 0.242) {
            this.openToOldDialog();
            this.cleanupExit();
            return;
        }
        this.initTestThreads(this.sp.getInt("PREF_TOR_TESTHREADS"));
        this.initFinalComponents();
        this.initSystemTray();
        this.initTimer();
        this.applyMainTorSettings();
        this.tcMain.setStartupDelay(1000L);
        this.tcMain.start();
        this.initGUIVisibility();
        Logger.getGlobal().log(Level.INFO, "Environment = {0}", System.getenv().toString());
        Logger.getGlobal().log(Level.INFO, "Active desktop = {0}", this.desktopname);
        Logger.getGlobal().log(Level.INFO, "Compositor = {0}", this.compositor);
        if (Logger.getGlobal().isLoggable(Level.FINE)) {
            for (String string : OSFunction.getCachedProcesses()) {
                Logger.getGlobal().log(Level.FINE, "Process = {0}", string);
            }
        }
    }

    private void initProperties() {
        this.setTitle(APPNAME);
        this.setIconImage(new ImageIcon(this.iconPath + ICONFILE).getImage());
        Logger.getGlobal().setLevel(Level.SEVERE);
        this.addLoggingFile(this.settingsPath + "status.log", false);
        this.sp = new SimpleProps(this.settingsPath + "SelekTOR.xml", "SelekTOR Settings");
        this.sp.setDefaultModeEnabled(true);
        this.sp.setString("PREF_ISOCOUNTRY", "GB");
        this.sp.setInt("PREF_LISTENPORT", 9054);
        this.sp.setInt("PREF_TOR_TESTHREADS", 2);
        this.sp.setInt("PREF_TORLOGLEV", 2);
        this.sp.setInt("PREF_PROXY_MODE", 2);
        this.sp.setLong("PREF_GEODATE", 0L);
        this.sp.setBool("PREF_GEOCHECK", true);
        this.sp.setBool("PREF_AUTOSTART", false);
        this.sp.setBool("PREF_NOSYSTRAY", false);
        this.sp.setBool("PREF_HIDETOTRAY", false);
        this.sp.setBool("PREF_MINONCLOSE", false);
        this.sp.setBool("PREF_HIDE_MIN", false);
        this.sp.setBool("PREF_UPDATECHECK", true);
        this.sp.setBool("PREF_SAFESOCKS", true);
        this.sp.setBool("PREF_TESTSOCKS", false);
        this.sp.setBool("PREF_AVOIDDISK", true);
        this.sp.setBool("PREF_SAFELOG", true);
        this.sp.setBool("PREF_CACHEDELETE", false);
        this.sp.setBool("PREF_DISABLE_NOTIFY", false);
        this.sp.setString("PREF_HTTP_PROXY", EMPTYSTR);
        this.sp.setString("PREF_DONOT_PROXY", "localhost,127.0.0.1");
        this.sp.setString("PREF_TORBRIDGE", EMPTYSTR);
        this.sp.setString("PREF_TORARGS", EMPTYSTR);
        this.sp.setDefaultModeEnabled(false);
        this.sp.resetToDefaults();
        this.sp.load();
        if (!this.sp.getString("prefsver").contentEquals(PREFSVER)) {
            this.sp.resetToDefaults();
            this.sp.setString("prefsver", PREFSVER);
            this.sp.delete();
            this.sp.save();
        }
        if (this.sp.getInt("PREF_LISTENPORT") < 9054) {
            this.sp.setInt("PREF_LISTENPORT", 9054);
            this.sp.save();
        }
        this.strExitISOCode = this.sp.getString("PREF_ISOCOUNTRY");
    }

    private void addLoggingFile(String string, boolean bl) {
        try {
            if (string != null) {
                FileHandler fileHandler = new FileHandler(string, 10000000, 1, bl);
                fileHandler.setFormatter(new SimpleFormatter());
                Logger.getGlobal().addHandler(fileHandler);
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    private boolean processCLIArgs(String ... stringArray) {
        this.alArgs = new ArrayList();
        this.alArgs.addAll(Arrays.asList(stringArray));
        for (String string : stringArray) {
            Object object;
            if (string.contentEquals("--start-delay")) {
                this.alArgs.remove(string);
                if (this.alArgs.size() > 0) {
                    object = this.alArgs.get(0);
                    try {
                        this.startupDelay = Long.valueOf((String)object) * 1000L;
                        this.alArgs.remove(0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (string.contentEquals("--debug-all")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                    this.alArgs.remove(0);
                }
                Logger.getGlobal().setLevel(Level.ALL);
            }
            if (string.contentEquals("--debug-warn")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                    this.alArgs.remove(0);
                }
                Logger.getGlobal().setLevel(Level.WARNING);
            }
            if (string.contentEquals("--debug-info")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                }
                Logger.getGlobal().setLevel(Level.INFO);
            }
            if (string.contentEquals("--debug-fine")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                    this.alArgs.remove(0);
                }
                Logger.getGlobal().setLevel(Level.FINE);
            }
            if (string.contentEquals("--debug-finer")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                    this.alArgs.remove(0);
                }
                Logger.getGlobal().setLevel(Level.FINER);
            }
            if (string.contentEquals("--debug-finest")) {
                this.alArgs.remove(string);
                if (!this.alArgs.isEmpty()) {
                    this.addLoggingFile(this.alArgs.get(0), false);
                    this.alArgs.remove(0);
                }
                Logger.getGlobal().setLevel(Level.FINEST);
            }
            if (string.contentEquals("--reset-defaults")) {
                this.alArgs.remove(string);
                this.sp.resetToDefaults();
                this.sp.save();
                this.sp.load();
                return true;
            }
            if (string.contentEquals("--clear-cache")) {
                this.alArgs.remove(string);
                SimpleFile.deleteFolder(this.cachePath);
            }
            if (string.contentEquals("--help")) {
                this.alArgs.remove(string);
                this.outputHelp();
                this.pacFactory = null;
                return true;
            }
            if (string.contentEquals("--cleanup")) {
                this.alArgs.remove(string);
                if (!this.sp.getBool("PREF_AUTOSTART")) {
                    return true;
                }
            }
            if (string.contentEquals("--default-proxy-quiet")) {
                this.alArgs.remove(string);
                this.pacFactory.setProxyAutoConfigURL(null);
                this.pacFactory.deleteProxyPrefs();
                this.pacFactory = null;
                return true;
            }
            if (string.contentEquals("--restore-proxy-quiet")) {
                this.alArgs.remove(string);
                return true;
            }
            if (string.contentEquals("--update-disable")) {
                this.alArgs.remove(string);
                this.updateCheckDisabled = true;
            }
            if (string.contentEquals("--restore-proxy")) {
                this.alArgs.remove(string);
                object = this.createInfoDialog();
                ((InfoDialog)object).createWarn(LOCAL.getString("dlg_restoreproxy_title"), LOCAL.getString("dlg_restoreproxy_body"));
                ((Window)object).pack();
                ((Dialog)object).setVisible(true);
                if (((InfoDialog)object).getReturnStatus() == 2) {
                    return true;
                }
                this.pacFactory = null;
                return true;
            }
            if (string.contentEquals("--default-proxy")) {
                this.alArgs.remove(string);
                object = this.createInfoDialog();
                ((InfoDialog)object).createWarn(LOCAL.getString("dlg_resetproxy_title"), LOCAL.getString("dlg_resetproxy_body"));
                ((Window)object).pack();
                ((Dialog)object).setVisible(true);
                if (((InfoDialog)object).getReturnStatus() == 2) {
                    this.pacFactory.setProxyAutoConfigURL(null);
                    this.pacFactory.deleteProxyPrefs();
                }
                this.pacFactory = null;
                return true;
            }
            if (!string.contentEquals("--ignore-desktop")) continue;
            this.alArgs.remove(string);
            this.desktopname = EMPTYSTR;
        }
        if (this.alArgs.size() > 0) {
            this.outputHelp();
            this.pacFactory = null;
            return true;
        }
        return false;
    }

    private void outputHelp() {
        System.out.println("SelekTOR 3.13.73 valid command line arguments.");
        System.out.println();
        System.out.println("--help : This help information");
        System.out.println("--debug-all [filename] : All debug output.");
        System.out.println("--debug-warn [filename] : Warnings level debug output.");
        System.out.println("--debug-info [filename] : Information level debug output.");
        System.out.println("--debug-fine [filename] : Fine level debug output.");
        System.out.println("--debug-finer [filename] : Finer level debug output.");
        System.out.println("--debug-finest [filename] : Finest level debug output.");
        System.out.println("--reset-defaults : Return user settings to their safe defaults.");
        System.out.println("--clear-cache : Clears the Tor cache on startup.");
        System.out.println("--ignore-desktop : Ignore desktop detection information.");
        System.out.println("--start-delay : Delay startup in seconds, eg. --start-delay 5");
        System.out.println("--cleanup : Cleans up after a bad shutdown which may have left system proxy in an unknown state.");
        System.out.println("--default-proxy-quiet : Set system proxy back to its defaults quietly, without GUI dialog.");
        System.out.println("--restore-proxy-quiet : Attempt to restore proxy to its last known settings using a previously saved backup, without GUI dialog.");
        System.out.println("--default-proxy : Set system proxy back to its defaults accepts verification input via a GUI dialog..");
        System.out.println("--restore-proxy : Attempt to restore proxy to its last known settings using a previously saved backup, with input verification via a  GUI dialog.");
        System.out.println("--update-disable : Disables the version update checking at startup and removes the option from preferences.");
        System.out.println();
    }

    private void setComponentsEnabled(boolean bl) {
        this.jButtonExitNodeDetails.setEnabled(bl);
        this.jButtonMiddleNodeDetails.setEnabled(bl);
        this.jButtonGuardNodeDetails.setEnabled(bl);
        this.jButtonSetGuards.setEnabled(bl);
        this.jMenuItemPatternEdit.setEnabled(bl);
        this.jMenuItemAddPattern.setEnabled(bl);
        this.jTableExitNodes.setEnabled(bl);
        this.jComboCountry.setEnabled(bl);
        this.jMenuItemTorCheck.setEnabled(bl);
        this.jCheckProxyDisable.setEnabled(bl);
        this.jCheckProxyByPattern.setEnabled(bl);
        this.jCheckProxyAll.setEnabled(bl);
        this.jCheckTrayProxyDisable.setEnabled(bl);
        this.jCheckTrayProxyByPattern.setEnabled(bl);
        this.jCheckTrayProxyAll.setEnabled(bl);
        this.jButtonClearFavs.setEnabled(bl);
        if (!bl) {
            this.jMenuItemGeoip.setEnabled(bl);
        }
    }

    private void initFinalComponents() {
        GTKFixes.fixMenubarHeight(this.jMenuBar, this.jMenuItemGUI);
        GTKFixes.fixMenuSelectionColor(this.jMenuMenu, this.jMenuProxy, this.jMenuHelp);
        GTKFixes.fixJMenuPopupBorder(this.jMenuMenu, this.jMenuProxy, this.jMenuHelp);
        GTKFixes.fixMenuItemFgColor(this.jCheckProxyDisable, this.jCheckProxyByPattern, this.jCheckProxyAll);
        GTKFixes.fixMenuItemFgColor(this.jCheckTrayProxyDisable, this.jCheckTrayProxyByPattern, this.jCheckTrayProxyAll);
        this.setComponentsEnabled(false);
        this.buttonGroupProxy.add(this.jCheckProxyDisable);
        this.buttonGroupProxy.add(this.jCheckProxyByPattern);
        this.buttonGroupProxy.add(this.jCheckProxyAll);
        this.buttonGroupProxyTray.add(this.jCheckTrayProxyDisable);
        this.buttonGroupProxyTray.add(this.jCheckTrayProxyByPattern);
        this.buttonGroupProxyTray.add(this.jCheckTrayProxyAll);
        switch (this.sp.getInt("PREF_PROXY_MODE")) {
            case 0: {
                this.jCheckProxyDisable.setSelected(true);
                break;
            }
            case 1: {
                this.jCheckProxyByPattern.setSelected(true);
                break;
            }
            case 2: {
                this.jCheckProxyAll.setSelected(true);
            }
        }
        this.jMenuItemDebugLog.setVisible(Logger.getGlobal().getLevel() != Level.SEVERE);
    }

    private void initTimer() {
        this.tmr = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (System.currentTimeMillis() - SelekTOR.this.lngHibernateTimeStamp > 60000L) {
                        Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "initTimer()", "Hibernate Recovery");
                        SelekTOR.this.lngHibernateTimeStamp = System.currentTimeMillis();
                        SelekTOR.this.setComponentsEnabled(false);
                        SelekTOR.this.stopAllTorThreads();
                        SelekTOR.this.boolFirstRun = true;
                        SelekTOR.this.tcMain.start();
                    }
                    SelekTOR.this.lngHibernateTimeStamp = System.currentTimeMillis();
                    if (!SelekTOR.this.boolNetEnabled) {
                        return;
                    }
                    if (SelekTOR.this.intLatencyCheck > 0) {
                        --SelekTOR.this.intLatencyCheck;
                        if (SelekTOR.this.intLatencyCheck == 0) {
                            SelekTOR.this.intLatencyCheck = 5;
                            SelekTOR.this.getFreshNodeInfo();
                            if (SelekTOR.this.niActiveExit != null) {
                                SelekTOR.this.tcMain.doLatencyCheck(4950);
                            }
                        }
                    }
                    if (SelekTOR.this.intAutoSelectCheck > 0) {
                        --SelekTOR.this.intAutoSelectCheck;
                        if (SelekTOR.this.intAutoSelectCheck == 0) {
                            SelekTOR.this.autoSelectNode();
                        }
                    }
                    if (SelekTOR.this.intBeginTesting > 0) {
                        --SelekTOR.this.intBeginTesting;
                        if (SelekTOR.this.intBeginTesting == 0) {
                            SelekTOR.this.runTestingCycle();
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "initTimer() actionPerformed", SelekTOR.EMPTYSTR, exception);
                }
            }
        });
        this.lngHibernateTimeStamp = System.currentTimeMillis();
        this.tmr.setInitialDelay(0);
        this.tmr.setRepeats(true);
        this.tmr.start();
    }

    private void initPacFactory() {
        this.pacFactory = new PacFactory();
        this.pacFactory.setTempFolder(this.cachePath);
        this.pacFactory.setBackupFolder(this.settingsPath + "backup");
        this.pacFactory.setPatternsFolder(this.settingsPath + "patterns");
        this.pacFactory.setPACFolder(this.settingsPath);
        this.pacFactory.setDefaultProxy(this.sp.getString("PREF_HTTP_PROXY"));
        this.pacFactory.setDoNotProxy(this.sp.getString("PREF_DONOT_PROXY"));
    }

    private void openPreferencesDialog() {
        Object object = EMPTYSTR;
        if (!this.sti.isSupported()) {
            this.sp.setBool("PREF_NOSYSTRAY", true);
            object = (String)object + "jCheckDisableTray";
        }
        if (this.updateCheckDisabled) {
            object = (String)object + ",jCheckAppUpdate";
        }
        PrefsDialog prefsDialog = new PrefsDialog((Frame)this, this.sp, (String)object);
        prefsDialog.setTitle(LOCAL.getString("wintitle_prefs").replace("$appname", APPNAME));
        prefsDialog.pack();
        prefsDialog.setLocationRelativeTo(this);
        prefsDialog.setVisible(true);
        String string = this.sp.getChangedProperties();
        if (prefsDialog.getReturnStatus() == 1) {
            this.sp.save();
        }
        if (string.contains("PREF_HTTP_PROXY")) {
            this.pacFactory.setDefaultProxy(this.sp.getString("PREF_HTTP_PROXY"));
            this.rebuildPatternPac();
        }
        if (string.contains("PREF_NOSYSTRAY")) {
            if (this.sp.getBool("PREF_NOSYSTRAY")) {
                this.sti.unload();
            } else {
                this.sti.load();
            }
        }
        if (string.contains("PREF_DISABLE_NOTIFY")) {
            this.dn.setEnabled(!this.sp.getBool("PREF_DISABLE_NOTIFY"));
            if (this.dn.isEnabled() && !this.dn.isSupported()) {
                this.openLibnotifyDialog();
            }
        }
        if (!this.boolNetEnabled) {
            return;
        }
        if (string.contains("TORBRIDGE")) {
            this.updateProgramStatus(LOCAL.getString("progstatus_applychanges"));
            if (!this.tcMain.validateBridges(this.sp.getString("PREF_TORBRIDGE"))) {
                this.sp.setString("PREF_TORBRIDGE", EMPTYSTR);
                this.sp.save();
                this.stopAllTorThreads();
                this.applyMainTorSettings();
                this.tcMain.start();
                this.openBridgeErrorDialog();
            } else {
                this.stopAllTorThreads();
                this.applyMainTorSettings();
                this.tcMain.start();
            }
            return;
        }
        if (string.contains("LISTENPORT") || string.contains("SAFE") || string.contains("AVOID") || string.contains("LOGLEV") || string.contains("TORARGS") || string.contains("TESTSOCKS")) {
            this.updateProgramStatus(LOCAL.getString("progstatus_applychanges"));
            this.stopAllTorThreads();
            this.applyMainTorSettings();
            this.tcMain.start();
        }
    }

    private void applyMainTorSettings() {
        String string = this.sp.getString("PREF_TORBRIDGE");
        if (!this.tcMain.validateBridges(string)) {
            string = EMPTYSTR;
            this.sp.setString("PREF_TORBRIDGE", string);
            this.sp.save();
        }
        if (string.isEmpty()) {
            this.jLabelGuard.setText(LOCAL.getString("label_guardnode"));
        } else {
            this.jLabelGuard.setText(LOCAL.getString("label_bridgenode"));
        }
        this.tcMain.setBridges(string);
        this.tcMain.setTestingURL(TESTURL);
        this.tcMain.setListenPort(this.sp.getInt("PREF_LISTENPORT"));
        this.tcMain.setEntryNodes(this.nodeList.getGuardFavouritesAsCSV());
        this.tcMain.setBoolTorOption("SafeSocks", this.sp.getBool("PREF_SAFESOCKS"));
        this.tcMain.setBoolTorOption("TestSocks", this.sp.getBool("PREF_TESTSOCKS"));
        this.tcMain.setBoolTorOption("AvoidDiskWrites", this.sp.getBool("PREF_AVOIDDISK"));
        this.tcMain.setBoolTorOption("SafeLogging", this.sp.getBool("PREF_SAFELOG"));
        this.tcMain.setExternalArgs(this.sp.getString("PREF_TORARGS"));
        this.tcMain.setLogLevel(this.sp.getInt("PREF_TORLOGLEV"));
        this.tcMain.setGeoIP4(this.geoipPath);
        this.tcMain.setGeoIP6(this.geoip6Path);
        this.tmf.setLaunchString("# Via commandline\n" + this.tcMain.getCLIOptionsAsString() + "\n\n# Via torrc configuration file\n" + this.tcMain.getTorrcOptionsAsString());
    }

    private void abortAllTorThreads() {
        if (this.niActiveExit != null) {
            this.niActiveExit.setCircuitHops(null);
        }
        if (this.tcMain != null) {
            this.tcMain.abortActions();
        }
        this.abortTesting();
    }

    private void stopAllTorThreads() {
        this.abortTesting();
        this.stopTestClients();
        if (this.nodeList != null) {
            this.nodeList.terminate();
        }
        if (this.tcMain != null) {
            this.tcMain.stop();
            this.tcMain.clearStdout();
            this.tcMain.setStartupDelay(2000L);
        }
    }

    private void regenNodelist() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SelekTOR.this.boolFirstRun) {
                    SelekTOR.this.updateProgramStatus(LOCAL.getString("progstatus_generate"));
                    SelekTOR.this.nodeList.refreshNodelist(SelekTOR.this.tcMain);
                    SelekTOR.this.checkForAppUpdates();
                }
                switch (SelekTOR.this.nodeList.getCurrentStatus()) {
                    case 2: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (SelekTOR.this.boolFirstRun) {
                                    SelekTOR.this.dn.setNotificationBody(LOCAL.getString("traymenu_proxymode" + (SelekTOR.this.sp.getInt("PREF_PROXY_MODE") + 1)));
                                    SelekTOR.this.applyProxyChanges(SelekTOR.this.sp.getInt("PREF_PROXY_MODE"));
                                }
                                String[] stringArray = SelekTOR.this.nodeList.getValidatedCountries();
                                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
                                SelekTOR.this.jComboCountry.setModel(defaultComboBoxModel);
                                SelekTOR.this.jComboCountry.setSelectedIndex(-1);
                                String string = SelekTOR.this.strExitISOCode + "," + LOCAL.getDisplayCountry(SelekTOR.this.strExitISOCode);
                                if (defaultComboBoxModel.getIndexOf(string) < 0) {
                                    SelekTOR.this.jComboCountry.setSelectedIndex(0);
                                } else {
                                    SelekTOR.this.jComboCountry.setSelectedItem(string);
                                }
                                int n = SelekTOR.this.nodeList.saveGuardWhitelist();
                                if (n < 3 && n > 0) {
                                    SelekTOR.this.openNotEnoughGuardsDialog();
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Logger.getGlobal().logp(Level.WARNING, SelekTOR.class.getName(), "fetchRemoteData()", "Nodelist Failed");
                                SelekTOR.this.openFatalErrorDialog(LOCAL.getString("dlg_nodelistfail_body"));
                                SelekTOR.this.cleanupExit();
                            }
                        });
                    }
                }
            }
        });
        thread.start();
    }

    private void checkForAppUpdates() {
        String string;
        Object object;
        if (!this.sp.getBool("PREF_UPDATECHECK") || this.updateCheckDisabled) {
            Logger.getGlobal().log(Level.WARNING, "Update check is disabled.");
            return;
        }
        TorCircuit torCircuit = this.tcMain.getLatestCircuit();
        if (torCircuit != null && (object = this.nodeList.getNode(string = torCircuit.getExit(0))) != null) {
            Logger.getGlobal().log(Level.INFO, "Active Exit is {0}({1}) in {2}", new Object[]{((NodeItem)object).getNickName(), string, ((NodeItem)object).getCountryName()});
        }
        string = "http://dazzle.000webhostapp.com/anapps/linux/selektor/version.html";
        object = this.tcMain.createTorSocketToURL(string, false);
        this.nf.setSocketTimeout(5000);
        String string2 = this.nf.getURLContentAsString(string, (Socket)object);
        if (string2 == null) {
            Logger.getGlobal().log(Level.WARNING, "Failed to retrieve version info.");
            return;
        }
        Logger.getGlobal().log(Level.INFO, "Sucessfully retrieved version info.");
        final String string3 = string2.trim();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Utilities.isNewerVersion(SelekTOR.APPVER, string3)) {
                    InfoDialog infoDialog = SelekTOR.this.createInfoDialog();
                    infoDialog.createInfo(LOCAL.getString("dlg_update_title"), LOCAL.getString("dlg_update_body").replace("$version", string3));
                    infoDialog.setAutoClose(30000);
                    infoDialog.pack();
                    infoDialog.setVisible(true);
                }
            }
        });
    }

    private void updateGeoipCheck() {
        this.jMenuItemGeoip.setEnabled(true);
        if (!this.sp.getBool("PREF_GEOCHECK")) {
            return;
        }
        long l = this.sp.getLong("PREF_GEODATE");
        if (System.currentTimeMillis() > l) {
            this.updateGeoip();
        }
    }

    private void updateGeoip() {
        InfoDialog infoDialog = new InfoDialog(this){
            private final InfoDialog id;
            {
                this.id = this;
            }

            @Override
            public void progressTask(int n, final JProgressBar jProgressBar) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String string = "http://dazzle.000webhostapp.com/anapps/linux/selektor/geoip.sha";
                        String string2 = OSFunction.getTempFolder(SelekTOR.EMPTYSTR) + "SelekTOR_geoip.zip";
                        try {
                            Socket socket;
                            this.setAckEnabled(false);
                            jProgressBar.setString(LOCAL.getString("dload_status_contact"));
                            if (this.isCheckBoxSelected()) {
                                if (SelekTOR.this.niActiveExit == null) {
                                    Logger.getGlobal().log(Level.INFO, "Invalid exit node");
                                    throw new IOException();
                                }
                                if (SelekTOR.this.niActiveExit.getLatency() > 4000L) {
                                    Logger.getGlobal().log(Level.INFO, "Poor exit node");
                                    throw new IOException();
                                }
                                socket = SelekTOR.this.tcMain.createTorSocketToURL(string, false);
                            } else {
                                socket = new Socket(SelekTOR.FILEDOMAIN, 80);
                            }
                            SelekTOR.this.nf.setSocketTimeout(5000);
                            SelekTOR.this.nf.setProgressBar(jProgressBar);
                            jProgressBar.setStringPainted(true);
                            if (!id.isVisible()) {
                                throw new IOException();
                            }
                            Logger.getGlobal().log(Level.INFO, "Starting geoip.sha download");
                            String string3 = SelekTOR.this.nf.getURLContentAsString(string, socket);
                            if (string3 == null || string3.isEmpty()) {
                                Logger.getGlobal().log(Level.INFO, "geoip.sha download failed");
                                throw new IOException();
                            }
                            if (!id.isVisible()) {
                                throw new IOException();
                            }
                            Logger.getGlobal().log(Level.INFO, "Starting geoip.zip download");
                            string = "http://dazzle.000webhostapp.com/anapps/linux/selektor/geoip.zip";
                            socket = this.isCheckBoxSelected() ? SelekTOR.this.tcMain.createTorSocketToURL(string, false) : new Socket(SelekTOR.FILEDOMAIN, 80);
                            SimpleFile simpleFile = new SimpleFile(string2);
                            if (simpleFile.exists()) {
                                simpleFile.delete();
                            }
                            SelekTOR.this.nf.saveURLContentToFile(string2, string, socket, true);
                            if (!simpleFile.exists()) {
                                Logger.getGlobal().log(Level.INFO, "geoip.zip download failed");
                                throw new IOException();
                            }
                            String string4 = Utilities.getSha1Sum(string2);
                            if (!string4.contentEquals(string3.trim())) {
                                simpleFile.delete();
                                Logger.getGlobal().log(Level.INFO, "geoip.zip checksum does not match");
                                throw new IOException();
                            }
                            if (!id.isVisible()) {
                                throw new IOException();
                            }
                            if (simpleFile.extractZipTo(SelekTOR.this.settingsPath)) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SelekTOR.this.updateGeoipCheckDate();
                                        SelekTOR.this.geoipPath = OSFunction.findFile("geoip", SelekTOR.this.settingsPath, SelekTOR.this.defaultGeoipPath);
                                        SelekTOR.this.geoip6Path = OSFunction.findFile("geoip6", SelekTOR.this.settingsPath, SelekTOR.this.defaultGeoipPath);
                                        SelekTOR.this.jComboCountry.setEnabled(false);
                                        SelekTOR.this.setComponentsEnabled(false);
                                        SelekTOR.this.boolFirstRun = true;
                                        SelekTOR.this.stopAllTorThreads();
                                        SelekTOR.this.applyMainTorSettings();
                                        SelekTOR.this.tcMain.start();
                                        this.setVisible(false);
                                        this.dispose();
                                    }
                                });
                            }
                        }
                        catch (Exception exception) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Logger.getGlobal().log(Level.WARNING, exception.getMessage());
                                    jProgressBar.setString(LOCAL.getString("dload_status_failed"));
                                    this.setAckEnabled(true);
                                }
                            });
                        }
                    }
                });
                if (n == 2) {
                    thread.start();
                } else {
                    SelekTOR.this.updateGeoipCheckDate();
                    this.setVisible(false);
                    this.dispose();
                }
            }
        };
        infoDialog.setTitle(APPNAME);
        infoDialog.setCancelButtonText(LOCAL.getString("button_cancel"));
        infoDialog.setContinueButtonText(LOCAL.getString("button_continue"));
        infoDialog.setCloseButtonText(LOCAL.getString("button_close"));
        infoDialog.setCheckBoxText(LOCAL.getString("chkbox_viator"));
        infoDialog.setCheckBoxVisible(true);
        infoDialog.setCheckBoxEnabled(true);
        infoDialog.pack();
        infoDialog.createProgress(LOCAL.getString("dlg_geo_title"), LOCAL.getString("dlg_geo_body"));
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void updateGeoipCheckDate() {
        this.sp.setLong("PREF_GEODATE", System.currentTimeMillis() + 7776000000L);
        this.sp.save();
    }

    private void initSystemTray() {
        this.sti = new SwingTrayIcon(this.getGraphicsConfiguration(), "resources/trayicon.png");
        if (this.desktopname.contentEquals("gnome3") || this.desktopname.contentEquals("enlightenment") || this.desktopname.contentEquals("kde5")) {
            this.sti.disable();
        }
        this.dn = new DesktopNotify(this.sti, this.iconPath + ICONFILE);
        this.dn.setNotificationTitle(APPNAME);
        this.dn.setEnabled(!this.sp.getBool("PREF_DISABLE_NOTIFY"));
        if (this.dn.isEnabled() && !this.dn.isSupported()) {
            this.openLibnotifyDialog();
        }
        TrayPopupMenu trayPopupMenu = new TrayPopupMenu();
        GTKFixes.fixTrayMenuPopupBorder(trayPopupMenu);
        trayPopupMenu.add(this.jCheckTrayProxyDisable);
        trayPopupMenu.add(this.jCheckTrayProxyByPattern);
        trayPopupMenu.add(this.jCheckTrayProxyAll);
        trayPopupMenu.add(new JPopupMenu.Separator());
        trayPopupMenu.add(this.jMenuItemGUI);
        trayPopupMenu.add(this.jMenuItemQuitx);
        this.sti.addMouseListener(new MouseInputListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    SelekTOR.this.toggleGUIVisibility();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.sti.setTrayPopupMenu(trayPopupMenu);
        if (!this.sp.getBool("PREF_NOSYSTRAY")) {
            this.sti.load();
        }
    }

    private InfoDialog createInfoDialog() {
        InfoDialog infoDialog = new InfoDialog(this);
        infoDialog.setTitle(APPNAME);
        infoDialog.setCancelButtonText(LOCAL.getString("button_cancel"));
        infoDialog.setContinueButtonText(LOCAL.getString("button_continue"));
        infoDialog.setCloseButtonText(LOCAL.getString("button_close"));
        return infoDialog;
    }

    private void openInstanceDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createError(LOCAL.getString("dlg_instancefail_title"), LOCAL.getString("dlg_instancefail_body").replace("$appname", APPNAME));
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void openNotEnoughGuardsDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createWarn(LOCAL.getString("dlg_guardwarn_title"), LOCAL.getString("dlg_notenoughguards_body").replace("$appname", APPNAME));
        infoDialog.setCancelVisible(false);
        infoDialog.setContinueButtonText(LOCAL.getString("button_setguards"));
        infoDialog.pack();
        infoDialog.setVisible(true);
        if (infoDialog.getReturnStatus() == 2) {
            this.openGuardsSettingDialog();
        }
    }

    private void openGsettingsDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createError(LOCAL.getString("dlg_gsetting_title"), LOCAL.getString("dlg_gsetting_body").replace("$appname", APPNAME));
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void openTorClientDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createError(LOCAL.getString("dlg_torclient_title"), LOCAL.getString("dlg_torclient_body").replace("$appname", APPNAME));
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void openLibnotifyDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createError(LOCAL.getString("dlg_libnotify_title"), LOCAL.getString("dlg_libnotify_body").replace("$appname", APPNAME));
        infoDialog.setModal(false);
        infoDialog.setAutoClose(10000);
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void openBridgeErrorDialog() {
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.createError(LOCAL.getString("dlg_bridgerr_title"), LOCAL.getString("dlg_bridgerr_body").replace("$appname", APPNAME));
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void initNodeTables() {
        this.nodeList = new NodeList(this.settingsPath, EXITFAVOURITES, GUARDWHITELIST);
        this.entm = new ExitNodeTableModel();
        this.entm.setColumnName(LOCAL.getString("exittable_col1"), 0);
        this.entm.setColumnName(LOCAL.getString("exittable_col2"), 1);
        this.entm.setColumnName(LOCAL.getString("exittable_col3"), 2);
        this.entm.setColumnName(LOCAL.getString("exittable_col4"), 3);
        this.entm.setColumnName(LOCAL.getString("exittable_col5"), 4);
        this.entm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 4) {
                    SelekTOR.this.nodeList.saveExitFavourites();
                    SelekTOR.this.intThresholdExceeded = 255;
                    SelekTOR.this.intAutoSelectCheck = 5;
                }
            }
        });
        this.nodeList.setExitNodeTableModel(this.entm);
        this.jTableExitNodes.setModel(this.entm);
        this.adjustExitTableColumns();
    }

    private void clearFavourites() {
        for (int i = 0; i < this.entm.getRowCount(); ++i) {
            this.entm.setValueAt((Object)false, i, 4);
        }
    }

    private void initTorMain() {
        this.intBeginTesting = 0;
        this.nf = new NetFunctions();
        this.tmf = new TorMonFrame();
        this.tmf.setTitle(LOCAL.getString("wintitle_tormonitor"));
        this.tmf.setIconImage(new ImageIcon(this.iconPath + ICONFILE).getImage());
        this.tcMain = new TorController(this.clientLocation, this.cachePath){
            private int intNodeFailCount;

            @Override
            public void controllerEventFired(int n, Object object) {
                Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "controllerEventFired() on Port=" + this.getListenPort(), this.getEventMessage(n) + ", Data=" + String.valueOf(object));
                switch (n) {
                    case 10: {
                        SelekTOR.this.nodeList.addBridge((String)object);
                        break;
                    }
                    case 5: {
                        if (!SelekTOR.this.boolNetEnabled) break;
                        SelekTOR.this.boolNetEnabled = false;
                        SelekTOR.this.boolFirstRun = true;
                        SelekTOR.this.updateProgramStatus(LOCAL.getString("progstatus_nonet"));
                        SelekTOR.this.dn.setNotificationBody(LOCAL.getString("progstatus_nonet"));
                        SelekTOR.this.dn.raiseNotification();
                        SelekTOR.this.setComponentsEnabled(false);
                        break;
                    }
                    case 8: 
                    case 12: {
                        if (this.getStatus() < 2) break;
                        SelekTOR.this.updateProgramStatus(LOCAL.getString("circuit_status_none"));
                        this.intNodeFailCount = 0;
                        SelekTOR.this.resetBestNode();
                        SelekTOR.this.strRequestedExit = SelekTOR.this.getBestNode();
                        if (SelekTOR.this.strRequestedExit == null) {
                            SelekTOR.this.strRequestedExit = SelekTOR.EMPTYSTR;
                        }
                        this.stop();
                        this.setSilentBootEnabled(true);
                        this.setStartupDelay(2000L);
                        this.start(7);
                        break;
                    }
                    case 2: 
                    case 4: {
                        SelekTOR.this.openFatalErrorDialog((String)object);
                        SelekTOR.this.cleanupExit();
                        break;
                    }
                    case 1: {
                        this.stop();
                        this.setStartupDelay(2000L);
                        this.start(6);
                        break;
                    }
                    case 0: {
                        SelekTOR.this.updateProgramStatus((String)object);
                        break;
                    }
                    case 6: {
                        SelekTOR.this.boolNetEnabled = true;
                        SelekTOR.this.regenNodelist();
                        break;
                    }
                    case 7: {
                        SelekTOR.this.boolNetEnabled = true;
                        SelekTOR.this.activateNode(SelekTOR.this.strRequestedExit);
                        break;
                    }
                    case 16: 
                    case 18: {
                        switch (++this.intNodeFailCount) {
                            case 1: {
                                SelekTOR.this.updateProgramStatus(LOCAL.getString("progstatus_nodefailretry"));
                                SelekTOR.this.intThresholdExceeded = 254;
                                SelekTOR.this.intAutoSelectCheck = 2;
                                break;
                            }
                            case 2: {
                                SelekTOR.this.updateProgramStatus(LOCAL.getString("progstatus_nodefail"));
                                SelekTOR.this.intThresholdExceeded = 4;
                                SelekTOR.this.intAutoSelectCheck = 2;
                                break;
                            }
                            case 3: {
                                SelekTOR.this.updateProgramStatus(LOCAL.getString("progstatus_nodefail"));
                                this.intNodeFailCount = 0;
                                SelekTOR.this.intThresholdExceeded = 4;
                                SelekTOR.this.intAutoSelectCheck = 2;
                                if (SelekTOR.this.intBeginTesting <= 2) break;
                                SelekTOR.this.intBeginTesting = 2;
                            }
                        }
                        break;
                    }
                    case 15: {
                        if (!SelekTOR.this.strRequestedExit.isEmpty()) {
                            NodeItem nodeItem = SelekTOR.this.nodeList.getNode(SelekTOR.this.strRequestedExit);
                            if (nodeItem == null) {
                                SelekTOR.this.strRequestedExit = SelekTOR.EMPTYSTR;
                                SelekTOR.this.activateNode(SelekTOR.EMPTYSTR);
                                break;
                            }
                            if (nodeItem.getCircuitHops() != null) {
                                SelekTOR.this.tcMain.activateCircuit(nodeItem.getCircuitHops());
                                break;
                            }
                        }
                    }
                    case 17: {
                        this.intNodeFailCount = 0;
                        SelekTOR.this.intThresholdExceeded = 0;
                        SelekTOR.this.intLatencyCheck = 1;
                        if (SelekTOR.this.intBeginTesting == 0) {
                            SelekTOR.this.intBeginTesting = 2;
                        }
                        if (!SelekTOR.this.boolFirstRun) break;
                        SelekTOR.this.boolFirstRun = false;
                        SelekTOR.this.updateGeoipCheck();
                        break;
                    }
                    case 19: {
                        if (SelekTOR.this.niActiveExit == null) break;
                        SelekTOR.this.niActiveExit.setStreams(this.getActiveStreams().size());
                        SelekTOR.this.niActiveExit.setLatency(this.getLatency());
                        SelekTOR.this.updateGUINodeInfo(SelekTOR.this.niActiveGuard, SelekTOR.this.niActiveMiddle, SelekTOR.this.niActiveExit);
                        if (SelekTOR.this.intThresholdExceeded >= 100) break;
                        if (SelekTOR.this.niActiveExit.getLatency() > SelekTOR.this.lngThreshold) {
                            ++SelekTOR.this.intThresholdExceeded;
                            if (SelekTOR.this.niActiveExit.getLatency() > 5000L) {
                                if (SelekTOR.this.intThresholdExceeded <= 2) break;
                                SelekTOR.this.intAutoSelectCheck = 2;
                                if (SelekTOR.this.intBeginTesting <= 2) break;
                                SelekTOR.this.intBeginTesting = 2;
                                break;
                            }
                            if (SelekTOR.this.nodeList.getNumberOfFavs() == 1) {
                                SelekTOR.this.intThresholdExceeded = 0;
                                break;
                            }
                            if (SelekTOR.this.niActiveExit.getStreams() > 0) {
                                if (SelekTOR.this.intThresholdExceeded <= 11) break;
                                SelekTOR.this.intAutoSelectCheck = 2;
                                break;
                            }
                            if (SelekTOR.this.intThresholdExceeded <= 2) break;
                            SelekTOR.this.intAutoSelectCheck = 2;
                            break;
                        }
                        SelekTOR.this.intThresholdExceeded = 0;
                    }
                }
            }
        };
        this.tcMain.setTorrcOption("ClientOnly", "1");
        this.tcMain.setTorrcOption("StrictNodes", "1");
        this.tcMain.setTorrcOption("UseMicrodescriptors", "0");
        this.tcMain.setTorrcOption("UseEntryGuards", "1");
        this.tcMain.setTorrcOption("NumEntryGuards", "3");
        this.tcMain.setTorrcOption("ExitNodes", "{FI}");
        this.tcMain.setStdoutTextArea(this.tmf.getStdoutTextArea());
        this.tcMain.setListenPort(this.sp.getInt("PREF_LISTENPORT"));
        this.tcMain.setOwnershipID(OSFunction.getOurProcessID());
        this.strSecret = Utilities.generateSecretKey(16);
        this.strHash = Utilities.getTorHashPassword(this.strSecret);
        this.tcMain.setControlPassword(this.strSecret, this.strHash);
    }

    private void initTestThreads(int n) {
        while (this.alTestThreads.size() < n) {
            TorController torController = new TorController(this.clientLocation, this.cachePath){
                private NodeItem ni;

                @Override
                public void controllerEventFired(int n, Object object) {
                    Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "controllerEventFired() on Port=" + this.getListenPort(), this.getEventMessage(n) + ", Data=" + String.valueOf(object));
                    switch (n) {
                        case 5: {
                            if (!SelekTOR.this.boolNetEnabled) break;
                            SelekTOR.this.abortTesting();
                            SelekTOR.this.stopTestClients();
                            SelekTOR.this.niActiveGuard = null;
                            SelekTOR.this.niActiveMiddle = null;
                            SelekTOR.this.niActiveExit = null;
                            SelekTOR.this.updateGUINodeInfo(null, null, null);
                            SelekTOR.this.tcMain.stop();
                            SelekTOR.this.tcMain.setSilentBootEnabled(true);
                            SelekTOR.this.tcMain.setStartupDelay(2000L);
                            SelekTOR.this.tcMain.start(6);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.ni = null;
                            this.stop();
                            this.setSilentBootEnabled(true);
                            this.setStartupDelay(2000L);
                            this.start(6);
                            break;
                        }
                        case 6: 
                        case 7: {
                            this.ni = null;
                        }
                        case 20: {
                            if (this.ni != null) {
                                if (SelekTOR.this.intActiveNodeTests > 0) {
                                    --SelekTOR.this.intActiveNodeTests;
                                }
                                Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "controllerEventFired() on Port=" + this.getListenPort(), "Completed Testing of " + this.ni.getNickName());
                                if (this.getBestLatency() < 9999L) {
                                    this.ni.setTestStatus(1);
                                    SelekTOR.this.entm.setTestFieldValues(this.ni.getFingerprint(), this.getBestLatency(), LOCAL.getString("circuit_status_passed"), this.getBestHops());
                                } else if ((Integer)object > 0) {
                                    this.ni.setTestStatus(2);
                                    SelekTOR.this.entm.setTestFieldValues(this.ni.getFingerprint(), 9999L, LOCAL.getString("circuit_status_failed"), null);
                                } else {
                                    this.ni.setTestStatus(2);
                                    SelekTOR.this.entm.setTestFieldValues(this.ni.getFingerprint(), 9999L, LOCAL.getString("circuit_status_none"), null);
                                    this.stop();
                                    this.setSilentBootEnabled(true);
                                    this.setStartupDelay(2000L);
                                    this.start(7);
                                    break;
                                }
                            }
                            this.ni = null;
                            if (this.getStatus() != 2) break;
                            if (SelekTOR.this.alTestQueue.isEmpty()) {
                                if (SelekTOR.this.intActiveNodeTests <= 0) {
                                    SelekTOR.this.stopTestClients();
                                    SelekTOR.this.jMenuTesting.setEnabled(true);
                                    if (SelekTOR.this.intActiveNodeTests == 0) {
                                        SelekTOR.this.intBeginTesting = 600;
                                        SelekTOR.this.intThresholdExceeded = 255;
                                        SelekTOR.this.intAutoSelectCheck = 1;
                                    }
                                    return;
                                }
                                return;
                            }
                            if (SelekTOR.this.alTestQueue.isEmpty()) break;
                            String string = SelekTOR.this.alTestQueue.get(0);
                            SelekTOR.this.alTestQueue.remove(0);
                            this.ni = SelekTOR.this.nodeList.getNode(string);
                            if (this.ni != null) {
                                ++SelekTOR.this.intActiveNodeTests;
                                SelekTOR.this.entm.setValueAt((Object)LOCAL.getString("circuit_status_creating_3hop"), this.ni.getFingerprint(), 3);
                                Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "controllerEventFired() on Port=" + this.getListenPort(), "Begun testing node " + this.ni.getNickName());
                                this.testNode(this.ni.getFingerprint());
                                break;
                            }
                            Logger.getGlobal().logp(Level.INFO, SelekTOR.class.getName(), "controllerEventFired() on Port=" + this.getListenPort(), string + " node not found in nodelist ");
                            SelekTOR.this.entm.setValueAt((Object)LOCAL.getString("circuit_status_failed"), string, 3);
                            break;
                        }
                        case 17: {
                            if (this.ni == null) break;
                            SelekTOR.this.entm.setValueAt((Object)LOCAL.getString("circuit_status_testing"), this.ni.getFingerprint(), 3);
                            break;
                        }
                        case 22: {
                            if (SelekTOR.this.intActiveNodeTests > 0) {
                                --SelekTOR.this.intActiveNodeTests;
                            }
                            if (this.ni == null) break;
                            SelekTOR.this.entm.setValueAt((Object)LOCAL.getString("circuit_status_aborted"), this.ni.getFingerprint(), 3);
                            this.ni.setTestStatus(0);
                            this.ni = null;
                            break;
                        }
                        case 8: 
                        case 12: {
                            if (SelekTOR.this.intActiveNodeTests > 0) {
                                --SelekTOR.this.intActiveNodeTests;
                            }
                            if (this.ni == null) break;
                            SelekTOR.this.entm.setTestFieldValues(this.ni.getFingerprint(), 9999L, LOCAL.getString("circuit_status_noroute"), null);
                            this.ni.setTestStatus(2);
                            this.ni = null;
                            this.stop();
                            this.setSilentBootEnabled(true);
                            this.setStartupDelay(2000L);
                            this.start(7);
                        }
                    }
                }
            };
            torController.setTorrcOption("ClientOnly", "1");
            torController.setTorrcOption("StrictNodes", "1");
            torController.setTorrcOption("UseMicrodescriptors", "0");
            torController.setTorrcOption("UseEntryGuards", "1");
            torController.setTorrcOption("NumEntryGuards", "3");
            torController.setOwnershipID(this.tcMain.getOwnershipID());
            torController.setControlPassword(this.strSecret, this.strHash);
            torController.setCLIOption("quiet", EMPTYSTR);
            this.alTestThreads.add(torController);
        }
        this.strHash = null;
        this.strSecret = null;
    }

    private void autoSelectNode() {
        String string;
        switch (this.intThresholdExceeded) {
            case 255: {
                this.intThresholdExceeded = 0;
                this.calcBestNodes();
                this.resetBestNode();
                string = this.getBestNode();
                break;
            }
            case 254: {
                string = this.strRequestedExit;
                this.strRequestedExit = EMPTYSTR;
                break;
            }
            default: {
                NodeItem nodeItem = null;
                if (this.niActiveExit != null && this.nodeList.getNumberOfFavs() != 1 && (nodeItem = this.nodeList.getNode(this.niActiveExit.getFingerprint())) != null) {
                    nodeItem.setTestStatus(2);
                }
                string = this.getBestNode();
            }
        }
        this.intThresholdExceeded = 0;
        if (string != null && !string.isEmpty()) {
            if (!string.contentEquals(this.strRequestedExit)) {
                this.strRequestedExit = string;
                this.updateProgramStatus(LOCAL.getString("progstatus_autoswitch") + " " + this.activateNode(this.strRequestedExit) + ".");
            }
        } else {
            this.updateProgramStatus(LOCAL.getString("progstatus_nodefailtorchoose"));
            this.strRequestedExit = EMPTYSTR;
            this.activateNode(this.strRequestedExit);
        }
    }

    private void setThreshold(long l) {
        this.lngThreshold = l;
        this.jTableExitNodes.setToolTipText(LOCAL.getString("ttip_threshold") + ": " + this.lngThreshold + " ms");
    }

    private void calcBestNodes() {
        long l = 0L;
        long l2 = 9999L;
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TableRowSorter<ExitNodeTableModel> tableRowSorter = new TableRowSorter<ExitNodeTableModel>(this.entm);
        tableRowSorter.toggleSortOrder(2);
        for (int i = 0; i < this.entm.getRowCount(); ++i) {
            long l3;
            NodeItem nodeItem = this.entm.getNodeItemAt(tableRowSorter.convertRowIndexToModel(i));
            if (nodeItem.getTestStatus() == 2) continue;
            if (nodeItem.isFavourite()) {
                arrayList2.add(nodeItem.getFingerprint());
            }
            if ((l3 = nodeItem.getTestLatency()) >= l2) continue;
            l2 = (l += l3) / (long)(n + 1) * 3L;
            ++n;
            arrayList.add(nodeItem.getFingerprint());
        }
        if (n == 0) {
            this.setThreshold(5000L);
        } else {
            this.setThreshold(l / (long)n + 100L);
        }
        if (arrayList2.isEmpty()) {
            while (arrayList.size() > 5) {
                arrayList.remove(arrayList.remove(arrayList.size() - 1));
            }
            this.strArrBestNodes = arrayList.toArray(new String[arrayList.size()]);
        } else {
            this.strArrBestNodes = arrayList2.toArray(new String[arrayList2.size()]);
        }
    }

    private void resetTestFields() {
        for (int i = 0; i < this.entm.getRowCount(); ++i) {
            this.entm.setValueAt((Object)9999L, i, 2);
            this.entm.setValueAt((Object)LOCAL.getString("textfield_unknown"), i, 3);
            this.entm.setValueAt(null, i, 6);
        }
    }

    private void runTestingCycle() {
        this.intBeginTesting = -1;
        this.intActiveNodeTests = 0;
        this.jMenuTesting.setEnabled(false);
        this.jTableExitNodes.getRowSorter().setSortKeys(null);
        this.resetTestFields();
        this.alTestQueue.addAll(this.nodeList.getExitNodes(true, false));
        long l = 0L;
        int n = this.tcMain.getListenPort();
        for (TorController torController : this.alTestThreads) {
            torController.setListenPort(n += 2);
            torController.setCachedDataFolder(this.tcMain.getListenPort());
            torController.setBridges(this.sp.getString("PREF_TORBRIDGE"));
            torController.setEntryNodes(this.tcMain.getEntryGuardsAsCSV());
            torController.setTestingURL(TESTURL);
            torController.setBoolTorOption("SafeSocks", this.sp.getBool("PREF_SAFESOCKS"));
            torController.setBoolTorOption("TestSocks", this.sp.getBool("PREF_TESTSOCKS"));
            torController.setBoolTorOption("AvoidDiskWrites", this.sp.getBool("PREF_AVOIDDISK"));
            torController.setBoolTorOption("SafeLogging", this.sp.getBool("PREF_SAFELOG"));
            torController.setGeoIP4(this.geoipPath);
            torController.setGeoIP6(this.geoip6Path);
            torController.setExternalArgs(this.sp.getString("PREF_TORARGS"));
            torController.setLogLevel(this.sp.getInt("PREF_TORLOGLEV"));
            torController.setSilentBootEnabled(true);
            torController.setStartupDelay(l);
            l += 5000L;
            torController.start();
        }
    }

    private void abortTesting() {
        this.intBeginTesting = 0;
        for (TorController torController : this.alTestThreads) {
            torController.abortActions();
        }
        this.intActiveNodeTests = -1;
        this.alTestQueue.clear();
        this.jMenuTesting.setEnabled(true);
    }

    private void stopTestClients() {
        for (TorController torController : this.alTestThreads) {
            torController.stop();
        }
    }

    private String getBestNode() {
        if (this.strArrBestNodes == null || this.strArrBestNodes.length == 0) {
            this.intBestNodeIndex = 0;
            return EMPTYSTR;
        }
        if (this.intBestNodeIndex > this.strArrBestNodes.length - 1) {
            this.intBestNodeIndex = 0;
            if (this.intBeginTesting > 2) {
                this.intBeginTesting = 2;
            }
            return null;
        }
        return this.strArrBestNodes[this.intBestNodeIndex++];
    }

    private void resetBestNode() {
        this.intBestNodeIndex = 0;
    }

    private synchronized void updateProgramStatus(String string) {
        if (string != null) {
            this.jLabStatus.setText(string);
            Logger.getGlobal().log(Level.INFO, "updateProgramStatus {0}", string);
        }
    }

    private void getFreshNodeInfo() {
        TorCircuit torCircuit = this.tcMain.getLatestCircuit();
        if (torCircuit == null) {
            return;
        }
        String string = torCircuit.getGuard(0);
        this.niActiveGuard = this.nodeList.getNode(string).clone();
        string = torCircuit.getExit(0);
        this.niActiveExit = this.nodeList.getNode(string).clone();
        this.niActiveExit.setCircuitHops(torCircuit.getHops());
        this.niActiveExit.setLatency(9999L);
        string = torCircuit.getMiddleMan(0);
        this.niActiveMiddle = this.nodeList.getNode(string).clone();
    }

    private void updateGUINodeInfo(NodeItem nodeItem, NodeItem nodeItem2, NodeItem nodeItem3) {
        if (nodeItem2 == null) {
            this.jLabelMiddleStable.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelMiddleBw.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelMiddleNick.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelMiddleIP.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelMiddleCountry.setText(LOCAL.getString("textfield_unknown"));
            this.jButtonMiddleNodeDetails.setEnabled(false);
        } else {
            this.jLabelMiddleNick.setText(nodeItem2.getNickName());
            this.jLabelMiddleIP.setText(nodeItem2.getIPAddress());
            this.jLabelMiddleCountry.setText(nodeItem2.getCountryName());
            this.jLabelMiddleBw.setText(String.valueOf(nodeItem2.getBandwidth()) + " MB\\s");
            this.jLabelMiddleStable.setText(nodeItem2.getStability());
            this.jButtonMiddleNodeDetails.setEnabled(true);
        }
        if (nodeItem3 == null) {
            this.intLatencyCheck = 0;
            this.intAutoSelectCheck = 0;
            this.jLabelExitNick.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelExitIP.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelExitCountry.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelExitBw.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelExitStable.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelTorLatency.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelStreams.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelGuardStable.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelGuardBw.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelGuardNick.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelGuardIP.setText(LOCAL.getString("textfield_unknown"));
            this.jLabelGuardCountry.setText(LOCAL.getString("textfield_unknown"));
            this.jButtonExitNodeDetails.setEnabled(false);
            this.jButtonGuardNodeDetails.setEnabled(false);
            this.jMenuItemTorCheck.setEnabled(false);
        } else {
            this.jLabelExitNick.setText(nodeItem3.getNickName());
            this.jLabelExitIP.setText(nodeItem3.getIPAddress());
            this.jLabelExitCountry.setText(nodeItem3.getCountryName());
            this.jLabelExitBw.setText(String.valueOf(nodeItem3.getBandwidth()) + " MB\\s");
            this.jLabelExitStable.setText(nodeItem3.getStability());
            this.jButtonExitNodeDetails.setEnabled(true);
            this.jLabelGuardNick.setText(nodeItem.getNickName());
            this.jLabelGuardIP.setText(nodeItem.getIPAddress());
            this.jLabelGuardCountry.setText(nodeItem.getCountryName());
            this.jLabelGuardBw.setText(String.valueOf(nodeItem.getBandwidth()) + " MB\\s");
            this.jLabelGuardStable.setText(nodeItem.getStability());
            this.jMenuItemTorCheck.setEnabled(true);
            this.jButtonGuardNodeDetails.setEnabled(true);
            if (nodeItem3.getLatency() > 5000L) {
                this.jLabelTorLatency.setText("> 5000 ms");
            } else {
                this.jLabelTorLatency.setText(String.valueOf(nodeItem3.getLatency()) + " ms");
            }
            this.jLabelStreams.setText(String.valueOf(nodeItem3.getStreams()));
            this.updateProgramStatus(LOCAL.getString("progstatus_nodeactive3hop").replace("$nodename", this.niActiveExit.getNickName()));
            this.dn.raiseNotification();
        }
        String string = LOCAL.getString("label_country") + " : " + this.sp.getString("PREF_ISOCOUNTRY");
        string = string + "\n" + LOCAL.getString("traymenu_proxymode" + (this.sp.getInt("PREF_PROXY_MODE") + 1));
        string = string + "\n" + LOCAL.getString("traytool_guardnode") + " : " + this.jLabelGuardNick.getText();
        string = string + "\n" + LOCAL.getString("traytool_exitnode") + " : " + this.jLabelExitNick.getText();
        string = string + "\n" + LOCAL.getString("label_torlatency") + " : " + this.jLabelTorLatency.getText();
        string = string + "\n" + LOCAL.getString("label_streams") + " : " + this.jLabelStreams.getText();
        this.sti.setInfoTip(string);
    }

    private void updateExitNodeTable() {
        try {
            this.strArrBestNodes = null;
            this.intRowSelected = -1;
            this.jTableExitNodes.setModel(new ExitNodeTableModel());
            this.nodeList.refreshExitTableModel(this.strExitISOCode);
            this.jTableExitNodes.setModel(this.entm);
            this.resetTestFields();
            this.calcBestNodes();
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "updateExitNodeTable()", EMPTYSTR, exception);
        }
        this.updateGUINodeInfo(null, null, null);
        this.setComponentsEnabled(true);
    }

    private void adjustExitTableColumns() {
        String string = LOCAL.getString("circuit_status_creating_2hop");
        string = string.length() > 6 ? string.substring(0, string.length() - 2) : "XXXXXXXXXXXXXXXXXX";
        Utilities.adjustTableColumnWidth(this.jTableExitNodes, "XXXXXXXXXXXXXXXXXX", this.jTableExitNodes.getColumnName(1) + "X", this.jTableExitNodes.getColumnName(2) + "X", string, this.jTableExitNodes.getColumnName(4) + "X");
    }

    private String getSelectedFinger(int n) {
        return (String)this.entm.getValueAt(n, 5);
    }

    private boolean isValidExit(String string) {
        return this.nodeList.getExitNodes(true, false).contains(string);
    }

    private String activateNode(String string) {
        String string2 = EMPTYSTR;
        this.niActiveGuard = null;
        this.niActiveMiddle = null;
        this.niActiveExit = null;
        this.updateGUINodeInfo(null, null, null);
        if (this.boolFirstRun) {
            this.tcMain.closeCircuitsExcept(EMPTYSTR, true);
        }
        if (string.isEmpty()) {
            ArrayList<String> arrayList = this.nodeList.getExitNodes(false, true);
            if (arrayList.isEmpty()) {
                arrayList = this.nodeList.getExitNodes(true, true);
            }
            Random random = new Random();
            int n = random.nextInt(arrayList.size());
            string = arrayList.get(n);
            this.tcMain.activateNodes(string, 1);
        } else if (!string.startsWith("$")) {
            this.tcMain.activateNodes(string, 1);
        } else {
            NodeItem nodeItem = this.nodeList.getNode(string);
            this.tcMain.activateNodes(string, 1);
            if (nodeItem != null) {
                nodeItem.setTestStatus(1);
                string2 = nodeItem.getNickName();
            } else {
                string2 = string;
            }
        }
        return string2;
    }

    private void countryChanged() {
        this.niActiveExit = null;
        String string = (String)this.jComboCountry.getSelectedItem();
        if (!this.strExitISOCode.contentEquals(string = string.substring(0, 2))) {
            this.strExitISOCode = string;
            this.sp.setString("PREF_ISOCOUNTRY", this.strExitISOCode);
            this.sp.save();
        }
        this.rebuildPatternPac();
        this.updateExitNodeTable();
        this.adjustExitTableColumns();
        this.updateProgramStatus(LOCAL.getString("progstatus_waitfortor"));
        this.strRequestedExit = EMPTYSTR;
        this.activateNode(EMPTYSTR);
    }

    private void pacCleanup() {
        if (this.pacFactory != null) {
            this.pacFactory.restoreProxyPrefs(false);
            this.pacFactory.deleteProxyPrefs();
            this.pacFactory.deleteAllPAC();
        }
    }

    public final void cleanupExit() {
        try {
            this.setVisible(false);
            if (this.tmr != null) {
                this.tmr.stop();
            }
            if (this.sti != null) {
                this.sti.dispose();
            }
            if (this.nodeList != null) {
                this.nodeList.terminate();
            }
            if (this.tmf != null) {
                this.tmf.dispose();
            }
            if (this.tcMain != null) {
                this.tcMain.stop();
            }
            this.stopTestClients();
            this.pacCleanup();
            if (this.sp.getBool("PREF_CACHEDELETE")) {
                SimpleFile.secureWipeFolder(this.cachePath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.getGlobal().log(Level.INFO, "Cleanup completed, shutting down");
        this.dispose();
        System.exit(0);
    }

    private void initGUIVisibility() {
        this.pack();
        this.setLocationRelativeTo(this);
        Utilities.registerWindow();
        if (this.sp.getBool("PREF_HIDETOTRAY")) {
            if (this.sp.getBool("PREF_HIDE_MIN") && this.sti.isLoaded()) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelekTOR.this.repaint();
                        SelekTOR.this.setExtendedState(1);
                    }
                });
            }
        } else {
            this.setVisible(true);
        }
    }

    private void toggleGUIVisibility() {
        if (OSFunction.isLinux()) {
            this.requestFocus();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SelekTOR.this.isVisible()) {
                    SelekTOR.this.setVisible(true);
                    SelekTOR.this.setExtendedState(0);
                    return;
                }
                if ((SelekTOR.this.getExtendedState() & 1) != 0) {
                    SelekTOR.this.setExtendedState(0);
                    SelekTOR.this.toFront();
                } else {
                    if (OSFunction.isLinux()) {
                        switch (SelekTOR.this.desktopname) {
                            case "kde4": {
                                if (!SelekTOR.this.compositor.contentEquals("kwin") || SelekTOR.this.getFocusOwner() != null) break;
                                SelekTOR.this.setVisible(false);
                                SelekTOR.this.setVisible(true);
                                return;
                            }
                            case "mate": {
                                if (SelekTOR.this.compositor.contentEquals("compiz")) {
                                    if (SelekTOR.this.getFocusOwner() != null) break;
                                    SelekTOR.this.setExtendedState(0);
                                    SelekTOR.this.toFront();
                                    return;
                                }
                                if (SelekTOR.this.getFocusOwner() != null) break;
                                SelekTOR.this.setVisible(false);
                                SelekTOR.this.setVisible(true);
                                return;
                            }
                            default: {
                                if (SelekTOR.this.getFocusOwner() != null) break;
                                SelekTOR.this.setExtendedState(0);
                                SelekTOR.this.toFront();
                                return;
                            }
                        }
                    }
                    if (SelekTOR.this.sp.getBool("PREF_HIDE_MIN") && SelekTOR.this.sti.isLoaded()) {
                        SelekTOR.this.setVisible(false);
                    } else {
                        SelekTOR.this.setExtendedState(1);
                    }
                }
            }
        });
    }

    private void openAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog((Frame)this, true);
        aboutDialog.setButtonCloseText(LOCAL.getString("button_close"));
        aboutDialog.setButtonVisitText(LOCAL.getString("button_visitus"));
        aboutDialog.setButtonContactText(LOCAL.getString("button_contactus"));
        aboutDialog.setTitle(LOCAL.getString("wintitle_about").replace("$appname", APPNAME));
        aboutDialog.setContactURL(CONTACT);
        aboutDialog.setHomeURL(HOMEPAGE_SSL);
        aboutDialog.setAppLogo(new ImageIcon(this.iconPath + ICONFILE));
        Object object = LOCAL.getString("appdesc").replace("$appname", APPNAME);
        object = ((String)object).replace("$appver", APPVER) + "\n\nCopyright 2009-2017\nAlistair Neil";
        aboutDialog.setAppDescription((String)object);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.pack();
        aboutDialog.setVisible(true);
    }

    private void openLicenseDialog() {
        TextResourceDialog textResourceDialog = new TextResourceDialog((Frame)this, true);
        textResourceDialog.setTitle(LOCAL.getString("dlg_license_title"));
        textResourceDialog.setURLButtonText(LOCAL.getString("button_translations"));
        textResourceDialog.setButtonURL(LOCAL.getString("gpltransurl"));
        textResourceDialog.setCloseButtonText(LOCAL.getString("button_close"));
        textResourceDialog.setTitle(LOCAL.getString("dlg_license_title").replace("$appname", APPNAME));
        textResourceDialog.setText(Utilities.getTextFromResource("/resources/license.txt"));
        textResourceDialog.setLocationRelativeTo(this);
        textResourceDialog.setVisible(true);
    }

    private void openCreditsDialog() {
        TextResourceDialog textResourceDialog = new TextResourceDialog((Frame)this, true);
        textResourceDialog.setTitle(LOCAL.getString("dlg_credits_title"));
        textResourceDialog.setButtonURL(PATREON);
        textResourceDialog.setURLButtonText(LOCAL.getString("button_patreon"));
        textResourceDialog.setCloseButtonText(LOCAL.getString("button_close"));
        textResourceDialog.setTitle(LOCAL.getString("dlg_credits_title").replace("$appname", APPNAME));
        textResourceDialog.setText(LOCAL.getString("dlg_credits_body") + "\n\n" + Utilities.getTextFromResource("/resources/credits.txt"));
        textResourceDialog.setLocationRelativeTo(this);
        textResourceDialog.setVisible(true);
    }

    private void openPatternExport() {
        File[] fileArray = this.pacFactory.getPatternsFiles();
        if (fileArray.length == 0) {
            InfoDialog infoDialog = this.createInfoDialog();
            infoDialog.createWarn(LOCAL.getString("dlg_exportuser_title"), LOCAL.getString("dlg_exportuser_body"));
            infoDialog.setContinueButtonText(LOCAL.getString("button_close"));
            infoDialog.setCancelVisible(false);
            infoDialog.pack();
            infoDialog.setVisible(true);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(LOCAL.getString("dlg_saveuser_title"));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        this.pacFactory.exportUserPatterns(jFileChooser.getSelectedFile().getAbsolutePath(), fileArray);
    }

    private void openPatternImport() {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(LOCAL.getString("fileext_pattern"), new String[]{"zip"});
        jFileChooser.setFileFilter(extensionFileFilter);
        jFileChooser.setDialogTitle(LOCAL.getString("dlg_import_title"));
        if (jFileChooser.showOpenDialog(this) != 0) {
            return;
        }
        InfoDialog infoDialog = this.createInfoDialog();
        if (this.pacFactory.importPatterns(jFileChooser.getSelectedFile().getAbsolutePath())) {
            this.rebuildPatternPac();
            infoDialog.createWarn(LOCAL.getString("dlg_import_success_title"), LOCAL.getString("dlg_import_success_body"));
            infoDialog.setCancelVisible(false);
            infoDialog.pack();
            infoDialog.setVisible(true);
        } else {
            infoDialog.createWarn(LOCAL.getString("dlg_import_fail_title"), LOCAL.getString("dlg_import_fail_body"));
            infoDialog.setCancelVisible(false);
            infoDialog.pack();
            infoDialog.setVisible(true);
        }
    }

    private void openPatternEditorDialog() {
        PatternsEditor patternsEditor = new PatternsEditor((Frame)this, true, this.pacFactory);
        patternsEditor.populateCountryComboBox(this.nodeList.getValidatedCountries());
        patternsEditor.setSelectedCountry((String)this.jComboCountry.getSelectedItem());
        patternsEditor.setTitle(LOCAL.getString("wintitle_patternedit").replace("$appname", APPNAME));
        patternsEditor.pack();
        patternsEditor.setLocationRelativeTo(this);
        patternsEditor.setVisible(true);
        this.sp.setString("PREF_DONOT_PROXY", this.pacFactory.getDoNotProxy());
        if (this.sp.getChangedProperties().contains("PREF_DONOT_PROXY")) {
            this.sp.save();
        }
        if (patternsEditor.getReturnStatus() == 1) {
            this.rebuildPatternPac();
        }
    }

    private void openQuickAddDialog() {
        QuickAddDialog quickAddDialog = new QuickAddDialog((Frame)this, true);
        quickAddDialog.pack();
        quickAddDialog.setLocationRelativeTo(this);
        quickAddDialog.setVisible(true);
        if (quickAddDialog.getReturnStatus() == 1 && this.strExitISOCode != null) {
            this.pacFactory.addToPatternFile(this.strExitISOCode, quickAddDialog.getDescription(), quickAddDialog.getPattern());
            this.rebuildPatternPac();
        }
    }

    private void openToOldDialog() {
        this.openFatalErrorDialog(LOCAL.getString("dlg_toold_body"));
    }

    private void openFatalErrorDialog(String string) {
        String string2 = "\n\n" + LOCAL.getString("dlg_error_body").replace("$appname", APPNAME);
        InfoDialog infoDialog = this.createInfoDialog();
        infoDialog.setSize(500, 450);
        infoDialog.createInfo(LOCAL.getString("dlg_error_title"), string + string2);
        infoDialog.setModal(true);
        infoDialog.pack();
        infoDialog.setLocationRelativeTo(this);
        infoDialog.pack();
        infoDialog.setVisible(true);
    }

    private void openGuardsSettingDialog() {
        GuardNodeDialog guardNodeDialog = new GuardNodeDialog((Frame)this, true);
        guardNodeDialog.setNodeList(this.nodeList);
        guardNodeDialog.pack();
        guardNodeDialog.setLocationRelativeTo(this);
        guardNodeDialog.setVisible(true);
        if (guardNodeDialog.getReturnStatus() == 1 && this.sp.getString("PREF_TORBRIDGE").isEmpty()) {
            this.updateProgramStatus(LOCAL.getString("progstatus_applychanges"));
            this.abortAllTorThreads();
            this.applyMainTorSettings();
            this.tcMain.start();
        }
    }

    private void openTorMonitor() {
        this.tmf.setLocationRelativeTo(this);
        this.tmf.setVisible(true);
    }

    private void proxyModeChanged(int n) {
        this.sp.setInt("PREF_PROXY_MODE", n);
        this.sp.save();
        this.dn.setNotificationBody(LOCAL.getString("traymenu_proxymode" + (this.sp.getInt("PREF_PROXY_MODE") + 1)));
        this.applyProxyChanges(n);
    }

    private void applyProxyChanges(int n) {
        if (this.tcMain == null) {
            return;
        }
        switch (n) {
            case 0: {
                this.pacFactory.restoreProxyPrefs(true);
                this.pacFactory.deleteAllPAC();
                break;
            }
            case 1: {
                this.pacFactory.createPacFile(this.strExitISOCode, this.tcMain.getListenPort());
                break;
            }
            case 2: {
                this.pacFactory.createPacFile("proxyall", this.tcMain.getListenPort());
            }
        }
    }

    private void rebuildPatternPac() {
        if (this.sp.getInt("PREF_PROXY_MODE") == 1) {
            this.applyProxyChanges(this.sp.getInt("PREF_PROXY_MODE"));
        }
    }

    private void initComponents() {
        this.popupTable = new JPopupMenu();
        this.jMenuNodeDetails = new JMenuItem();
        this.jMenuWhois = new JMenuItem();
        this.jMenuTesting = new JMenuItem();
        this.jMenuItemGUI = new JMenuItem();
        this.jMenuItemQuitx = new JMenuItem();
        this.buttonGroupProxy = new ButtonGroup();
        this.buttonGroupProxyTray = new ButtonGroup();
        this.jCheckTrayProxyDisable = new JCheckBoxMenuItem();
        this.jCheckTrayProxyByPattern = new JCheckBoxMenuItem();
        this.jCheckTrayProxyAll = new JCheckBoxMenuItem();
        this.jPanelMain = new JPanel();
        this.jLabelCountry = new JLabel();
        this.jComboCountry = new JComboBox();
        this.jScrollPaneExitNodes = new JScrollPane();
        this.jTableExitNodes = new JTable();
        this.jPanelNodeInfo = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabelGuardBw = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabelGuardStable = new JLabel();
        this.jLabelGuard = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabelGuardNick = new JLabel();
        this.jLabelGuardIP = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabelGuardCountry = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabelExitNick = new JLabel();
        this.jLabelExitIP = new JLabel();
        this.jLabelMiddle = new JLabel();
        this.jLabelExit = new JLabel();
        this.jLabelMiddleNick = new JLabel();
        this.jLabelMiddleIP = new JLabel();
        this.jLabelMiddleCountry = new JLabel();
        this.jButtonExitNodeDetails = new JButton();
        this.jButtonGuardNodeDetails = new JButton();
        this.jButtonMiddleNodeDetails = new JButton();
        this.jLabelMiddleBw = new JLabel();
        this.jLabelExitBw = new JLabel();
        this.jLabelMiddleStable = new JLabel();
        this.jLabelExitStable = new JLabel();
        this.jLabelExitCountry = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabelTorLatency = new JLabel();
        this.jLabelStreams = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButtonSetGuards = new JButton();
        this.jLabStatus = new JLabel();
        this.jButtonClearFavs = new JButton();
        this.jMenuBar = new JMenuBar();
        this.jMenuMenu = new JMenu();
        this.jMenuItemPrefs = new JMenuItem();
        this.jMenuItemAddPattern = new JMenuItem();
        this.jMenuItemPatternEdit = new JMenuItem();
        this.jMenuItemStdout = new JMenuItem();
        this.jMenuItemExport = new JMenuItem();
        this.jMenuItemImport = new JMenuItem();
        this.jMenuItemGeoip = new JMenuItem();
        this.jMenuItemQuit = new JMenuItem();
        this.jMenuProxy = new JMenu();
        this.jCheckProxyDisable = new JCheckBoxMenuItem();
        this.jCheckProxyByPattern = new JCheckBoxMenuItem();
        this.jCheckProxyAll = new JCheckBoxMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemDebugLog = new JMenuItem();
        this.jMenuItemHelp = new JMenuItem();
        this.jMenuItemTorMan = new JMenuItem();
        this.jMenuItemTorCheck = new JMenuItem();
        this.jMenuItemAbout = new JMenuItem();
        this.jMenuItemLicense = new JMenuItem();
        this.popupTable.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                SelekTOR.this.popupTablePopupMenuWillBecomeVisible(popupMenuEvent);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.jMenuNodeDetails.setText(LOCAL.getString("table_popup_details"));
        this.jMenuNodeDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuNodeDetailsActionPerformed(actionEvent);
            }
        });
        this.popupTable.add(this.jMenuNodeDetails);
        this.jMenuWhois.setText(LOCAL.getString("table_popup_whois"));
        this.jMenuWhois.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuWhoisActionPerformed(actionEvent);
            }
        });
        this.popupTable.add(this.jMenuWhois);
        this.jMenuTesting.setText(LOCAL.getString("table_popup_begintest"));
        this.jMenuTesting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuTestingActionPerformed(actionEvent);
            }
        });
        this.popupTable.add(this.jMenuTesting);
        this.jMenuItemGUI.setBackground(new Color(this.jMenuBar.getBackground().getRGB()));
        this.jMenuItemGUI.setForeground(new Color(this.jMenuBar.getForeground().getRGB()));
        this.jMenuItemGUI.setText(LOCAL.getString("traymenu_showgui"));
        this.jMenuItemGUI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemGUIActionPerformed(actionEvent);
            }
        });
        this.jMenuItemQuitx.setText(LOCAL.getString("menu_quit"));
        this.jMenuItemQuitx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemQuitxActionPerformed(actionEvent);
            }
        });
        this.jCheckTrayProxyDisable.setText(LOCAL.getString("combo_proxymode1"));
        this.jCheckTrayProxyDisable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckTrayProxyDisableItemStateChanged(itemEvent);
            }
        });
        this.jCheckTrayProxyByPattern.setText(LOCAL.getString("combo_proxymode2"));
        this.jCheckTrayProxyByPattern.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckTrayProxyByPatternItemStateChanged(itemEvent);
            }
        });
        this.jCheckTrayProxyAll.setText(LOCAL.getString("combo_proxymode3"));
        this.jCheckTrayProxyAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckTrayProxyAllItemStateChanged(itemEvent);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelekTOR.this.formWindowClosing(windowEvent);
            }
        });
        this.jPanelMain.setFont(this.jPanelMain.getFont().deriveFont(this.jPanelMain.getFont().getStyle() | 1, this.jPanelMain.getFont().getSize() + 1));
        this.jLabelCountry.setFont(this.jLabelCountry.getFont().deriveFont(this.jLabelCountry.getFont().getStyle() | 1));
        this.jLabelCountry.setText(LOCAL.getString("label_activecountry"));
        this.jComboCountry.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jComboCountryItemStateChanged(itemEvent);
            }
        });
        this.jTableExitNodes.setAutoCreateRowSorter(true);
        this.jTableExitNodes.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jTableExitNodes.setToolTipText(LOCAL.getString("ttip_threshold") + " : " + LOCAL.getString("textfield_unknown"));
        this.jTableExitNodes.setComponentPopupMenu(this.popupTable);
        this.jTableExitNodes.setSelectionMode(0);
        this.jTableExitNodes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SelekTOR.this.jTableExitNodesMouseClicked(mouseEvent);
            }
        });
        this.jScrollPaneExitNodes.setViewportView(this.jTableExitNodes);
        this.jPanelNodeInfo.setBorder(BorderFactory.createTitledBorder(null, LOCAL.getString("panel_info"), 0, 0, this.jPanelMain.getFont()));
        this.jPanelNodeInfo.setFont(this.jPanelNodeInfo.getFont().deriveFont(this.jPanelNodeInfo.getFont().getStyle() | 1));
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setText(LOCAL.getString("label_bandwidth"));
        this.jLabelGuardBw.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelGuardBw.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText(LOCAL.getString("label_stable"));
        this.jLabelGuardStable.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelGuardStable.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelGuard.setFont(this.jLabelGuard.getFont().deriveFont(this.jLabelGuard.getFont().getStyle() | 1));
        this.jLabelGuard.setText(LOCAL.getString("label_guard"));
        this.jLabel8.setFont(this.jLabel8.getFont().deriveFont(this.jLabel8.getFont().getStyle() | 1));
        this.jLabel8.setText(LOCAL.getString("label_ip"));
        this.jLabelGuardNick.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelGuardNick.setBorder(BorderFactory.createEtchedBorder());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("resources/MessagesBundle");
        this.jLabelGuardIP.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelGuardIP.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel9.setFont(this.jLabel9.getFont().deriveFont(this.jLabel9.getFont().getStyle() | 1));
        this.jLabel9.setText(LOCAL.getString("label_country"));
        this.jLabelGuardCountry.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelGuardCountry.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel12.setFont(this.jLabel12.getFont().deriveFont(this.jLabel12.getFont().getStyle() | 1));
        this.jLabel12.setText(LOCAL.getString("label_nickname"));
        this.jLabelExitNick.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelExitNick.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelExitIP.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelExitIP.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelMiddle.setFont(this.jLabelMiddle.getFont().deriveFont(this.jLabelMiddle.getFont().getStyle() | 1));
        this.jLabelMiddle.setText(LOCAL.getString("label_middle"));
        this.jLabelExit.setFont(this.jLabelExit.getFont().deriveFont(this.jLabelExit.getFont().getStyle() | 1));
        this.jLabelExit.setText(LOCAL.getString("label_exit"));
        this.jLabelMiddleNick.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelMiddleNick.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelMiddleIP.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelMiddleIP.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelMiddleCountry.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelMiddleCountry.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonExitNodeDetails.setText(LOCAL.getString("button_details"));
        this.jButtonExitNodeDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jButtonExitNodeDetailsActionPerformed(actionEvent);
            }
        });
        this.jButtonGuardNodeDetails.setText(LOCAL.getString("button_details"));
        this.jButtonGuardNodeDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jButtonGuardNodeDetailsActionPerformed(actionEvent);
            }
        });
        this.jButtonMiddleNodeDetails.setText(LOCAL.getString("button_details"));
        this.jButtonMiddleNodeDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jButtonMiddleNodeDetailsActionPerformed(actionEvent);
            }
        });
        this.jLabelMiddleBw.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelMiddleBw.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelExitBw.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelExitBw.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelMiddleStable.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelMiddleStable.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelExitStable.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelExitStable.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelExitCountry.setText(resourceBundle.getString("textfield_unknown"));
        this.jLabelExitCountry.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1));
        this.jLabel4.setText(LOCAL.getString("label_torlatency"));
        this.jLabelTorLatency.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelTorLatency.setBorder(BorderFactory.createEtchedBorder());
        this.jLabelStreams.setText(LOCAL.getString("textfield_unknown"));
        this.jLabelStreams.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1));
        this.jLabel6.setText(LOCAL.getString("label_streams"));
        GroupLayout groupLayout = new GroupLayout(this.jPanelNodeInfo);
        this.jPanelNodeInfo.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.jLabel9).addComponent(this.jLabel8).addComponent(this.jLabel12).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelGuard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonGuardNodeDetails)).addComponent(this.jLabelGuardIP, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelGuardCountry, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelGuardBw, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelGuardStable, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelGuardNick, -1, 200, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelTorLatency, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelMiddle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonMiddleNodeDetails)).addComponent(this.jLabelMiddleIP, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelMiddleCountry, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelMiddleBw, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelMiddleStable, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelMiddleNick, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelExitStable, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelExitBw, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelExitCountry, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE).addComponent(this.jLabelExitIP, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelStreams, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jLabelExit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonExitNodeDetails)).addComponent(this.jLabelExitNick, GroupLayout.Alignment.LEADING, -1, 200, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.linkSize(0, this.jLabel10, this.jLabel12, this.jLabel5, this.jLabel8, this.jLabel9);
        groupLayout.linkSize(0, this.jLabelExitBw, this.jLabelExitCountry, this.jLabelExitIP, this.jLabelExitNick, this.jLabelExitStable, this.jLabelMiddleBw, this.jLabelMiddleCountry, this.jLabelMiddleIP, this.jLabelMiddleStable);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelGuard).addComponent(this.jButtonGuardNodeDetails).addComponent(this.jLabelMiddle).addComponent(this.jButtonMiddleNodeDetails).addComponent(this.jLabelExit).addComponent(this.jButtonExitNodeDetails)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelExitNick).addGap(0, 0, 0).addComponent(this.jLabelExitIP).addGap(0, 0, 0).addComponent(this.jLabelExitCountry).addGap(0, 0, 0).addComponent(this.jLabelExitBw).addGap(0, 0, 0).addComponent(this.jLabelExitStable)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelMiddleNick).addGap(0, 0, 0).addComponent(this.jLabelMiddleIP).addGap(0, 0, 0).addComponent(this.jLabelMiddleCountry).addGap(0, 0, 0).addComponent(this.jLabelMiddleBw).addGap(0, 0, 0).addComponent(this.jLabelMiddleStable)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGuardNick).addComponent(this.jLabel12)).addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGuardIP).addComponent(this.jLabel8)).addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabelGuardCountry)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabelGuardBw)).addGap(0, 0, 0).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGuardStable).addComponent(this.jLabel10)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStreams, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING).addComponent(this.jLabelTorLatency, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.linkSize(1, this.jLabelExitBw, this.jLabelExitCountry, this.jLabelExitIP, this.jLabelExitNick, this.jLabelExitStable, this.jLabelGuardBw, this.jLabelGuardCountry, this.jLabelGuardIP, this.jLabelGuardNick, this.jLabelGuardStable, this.jLabelMiddleBw, this.jLabelMiddleCountry, this.jLabelMiddleIP, this.jLabelMiddleNick, this.jLabelMiddleStable);
        this.jButtonSetGuards.setText(LOCAL.getString("button_setguards"));
        this.jButtonSetGuards.setToolTipText(LOCAL.getString("button_setguards"));
        this.jButtonSetGuards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jButtonSetGuardsActionPerformed(actionEvent);
            }
        });
        this.jLabStatus.setHorizontalAlignment(0);
        this.jLabStatus.setText(LOCAL.getString("textfield_unknown"));
        this.jButtonClearFavs.setText(LOCAL.getString("button_clearfavs"));
        this.jButtonClearFavs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jButtonClearFavsActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabStatus, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPaneExitNodes).addComponent(this.jPanelNodeInfo, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jComboCountry, -2, 260, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSetGuards).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClearFavs)).addComponent(this.jLabelCountry)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jLabelCountry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboCountry, -2, -1, -2).addComponent(this.jButtonSetGuards).addComponent(this.jButtonClearFavs)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneExitNodes, -1, 182, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelNodeInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabStatus).addContainerGap()));
        this.jMenuMenu.setMnemonic(LOCAL.getString("menu_menu").charAt(0));
        this.jMenuMenu.setText(LOCAL.getString("menu_menu"));
        this.jMenuItemPrefs.setMnemonic('P');
        this.jMenuItemPrefs.setText(LOCAL.getString("menu_prefs"));
        this.jMenuItemPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemPrefsActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemPrefs);
        this.jMenuItemAddPattern.setText(LOCAL.getString("menu_quickadd"));
        this.jMenuItemAddPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemAddPatternActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemAddPattern);
        this.jMenuItemPatternEdit.setText(LOCAL.getString("menu_patternedit"));
        this.jMenuItemPatternEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemPatternEditActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemPatternEdit);
        this.jMenuItemStdout.setText(LOCAL.getString("menu_tormonitor"));
        this.jMenuItemStdout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemStdoutActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemStdout);
        this.jMenuItemExport.setText(LOCAL.getString("menu_export"));
        this.jMenuItemExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemExportActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemExport);
        this.jMenuItemImport.setText(LOCAL.getString("menu_import"));
        this.jMenuItemImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemImportActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemImport);
        this.jMenuItemGeoip.setText(LOCAL.getString("menu_geoip"));
        this.jMenuItemGeoip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemGeoipActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemGeoip);
        this.jMenuItemQuit.setMnemonic('Q');
        this.jMenuItemQuit.setText(LOCAL.getString("menu_quit"));
        this.jMenuItemQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemQuitActionPerformed(actionEvent);
            }
        });
        this.jMenuMenu.add(this.jMenuItemQuit);
        this.jMenuBar.add(this.jMenuMenu);
        this.jMenuProxy.setMnemonic(LOCAL.getString("menu_proxy").charAt(0));
        this.jMenuProxy.setText(LOCAL.getString("menu_proxy"));
        this.jCheckProxyDisable.setText(LOCAL.getString("combo_proxymode1"));
        this.jCheckProxyDisable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckProxyDisableItemStateChanged(itemEvent);
            }
        });
        this.jMenuProxy.add(this.jCheckProxyDisable);
        this.jCheckProxyByPattern.setText(LOCAL.getString("combo_proxymode2"));
        this.jCheckProxyByPattern.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckProxyByPatternItemStateChanged(itemEvent);
            }
        });
        this.jMenuProxy.add(this.jCheckProxyByPattern);
        this.jCheckProxyAll.setText(LOCAL.getString("combo_proxymode3"));
        this.jCheckProxyAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SelekTOR.this.jCheckProxyAllItemStateChanged(itemEvent);
            }
        });
        this.jMenuProxy.add(this.jCheckProxyAll);
        this.jMenuBar.add(this.jMenuProxy);
        this.jMenuHelp.setMnemonic(LOCAL.getString("menu_help").charAt(0));
        this.jMenuHelp.setText(LOCAL.getString("menu_help"));
        this.jMenuItemDebugLog.setVisible(false);
        this.jMenuItemDebugLog.setText(LOCAL.getString("menu_debuglog"));
        this.jMenuItemDebugLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemDebugLogActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemDebugLog);
        this.jMenuItemHelp.setMnemonic('C');
        this.jMenuItemHelp.setText(LOCAL.getString("menu_helpcontents"));
        this.jMenuItemHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemHelpActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelp);
        this.jMenuItemTorMan.setText(LOCAL.getString("menu_tormanual"));
        this.jMenuItemTorMan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemTorManActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemTorMan);
        this.jMenuItemTorCheck.setMnemonic('T');
        this.jMenuItemTorCheck.setText(LOCAL.getString("menu_torcheck"));
        this.jMenuItemTorCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemTorCheckActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemTorCheck);
        this.jMenuItemAbout.setMnemonic('A');
        this.jMenuItemAbout.setText(LOCAL.getString("menu_about"));
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemAboutActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemAbout);
        this.jMenuItemLicense.setText(LOCAL.getString("menu_license"));
        this.jMenuItemLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelekTOR.this.jMenuItemLicenseActionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.add(this.jMenuItemLicense);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -2, -1, -2));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        if (this.sp.getBool("PREF_MINONCLOSE")) {
            if (!this.isVisible() && OSFunction.isWindows()) {
                this.cleanupExit();
                return;
            }
            if (this.sp.getBool("PREF_HIDE_MIN") && this.sti.isLoaded()) {
                this.setVisible(false);
            } else {
                this.setExtendedState(1);
            }
        } else {
            this.cleanupExit();
        }
    }

    private void jComboCountryItemStateChanged(ItemEvent itemEvent) {
        switch (itemEvent.getStateChange()) {
            case 2: {
                this.abortTesting();
                break;
            }
            case 1: {
                this.countryChanged();
            }
        }
    }

    private void jMenuItemPrefsActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openPreferencesDialog();
            }
        });
    }

    private void jMenuItemAddPatternActionPerformed(ActionEvent actionEvent) {
        this.openQuickAddDialog();
    }

    private void jMenuItemPatternEditActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openPatternEditorDialog();
            }
        });
    }

    private void jMenuItemImportActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openPatternImport();
            }
        });
    }

    private void jMenuItemQuitActionPerformed(ActionEvent actionEvent) {
        this.cleanupExit();
    }

    private void jMenuItemDebugLogActionPerformed(ActionEvent actionEvent) {
        Utilities.editFile(this.settingsPath + "status.log");
    }

    private void jMenuItemHelpActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(this){

            @Override
            public void run() {
                Utilities.openFileExternally("/usr/share/doc/selektor/help-" + OSFunction.getLangCode() + ".html");
            }
        });
    }

    private void jMenuItemTorCheckActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(this){

            @Override
            public void run() {
                String string = "https://check.torproject.org/?lang=" + LOCAL.toWebLanguageTag();
                Utilities.openFileExternally(string);
            }
        });
    }

    private void jMenuItemAboutActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openAboutDialog();
            }
        });
    }

    private void jMenuItemLicenseActionPerformed(ActionEvent actionEvent) {
        this.openLicenseDialog();
    }

    private void jMenuWhoisActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.entm.getValueAt(this.intRowSelected, 5);
        NodeItem nodeItem = this.nodeList.getNode(string);
        if (nodeItem != null) {
            Utilities.openFileExternally("https://www.networksolutions.com/whois/results.jsp?ip=" + nodeItem.getIPAddress());
        }
    }

    private void jMenuTestingActionPerformed(ActionEvent actionEvent) {
        this.abortTesting();
        this.intBeginTesting = 4;
    }

    private void popupTablePopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.jMenuWhois.setEnabled(this.intRowSelected > -1);
        this.jMenuNodeDetails.setEnabled(this.intRowSelected > -1);
    }

    private void jMenuNodeDetailsActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.entm.getValueAt(this.intRowSelected, 5);
        string = string.replace("$", EMPTYSTR);
        Utilities.openFileExternally("https://atlas.torproject.org/#details/" + string);
    }

    private void jButtonExitNodeDetailsActionPerformed(ActionEvent actionEvent) {
        String string = this.niActiveExit.getFingerprint();
        string = string.replace("$", EMPTYSTR);
        Utilities.openFileExternally("https://atlas.torproject.org/#details/" + string);
    }

    private void jMenuItemStdoutActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openTorMonitor();
            }
        });
    }

    private void jMenuItemTorManActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(this){

            @Override
            public void run() {
                Utilities.openFileExternally("https://torproject.org/docs/tor-manual.html");
            }
        });
    }

    private void jButtonGuardNodeDetailsActionPerformed(ActionEvent actionEvent) {
        String string = this.niActiveGuard.getFingerprint();
        string = string.replace("$", EMPTYSTR);
        Utilities.openFileExternally("https://atlas.torproject.org/#details/" + string);
    }

    private void jButtonSetGuardsActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openGuardsSettingDialog();
            }
        });
    }

    private void jMenuItemGUIActionPerformed(ActionEvent actionEvent) {
        this.toggleGUIVisibility();
    }

    private void jMenuItemQuitxActionPerformed(ActionEvent actionEvent) {
        this.cleanupExit();
    }

    private void jButtonMiddleNodeDetailsActionPerformed(ActionEvent actionEvent) {
        String string = this.niActiveMiddle.getFingerprint();
        string = string.replace("$", EMPTYSTR);
        Utilities.openFileExternally("https://atlas.torproject.org/#details/" + string);
    }

    private void jMenuItemExportActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.openPatternExport();
            }
        });
    }

    private void jCheckProxyDisableItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckTrayProxyDisable.setSelected(true);
            if (this.jCheckProxyDisable.isEnabled()) {
                this.proxyModeChanged(0);
            }
        }
    }

    private void jCheckProxyByPatternItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckTrayProxyByPattern.setSelected(true);
            if (this.jCheckProxyByPattern.isEnabled()) {
                this.proxyModeChanged(1);
            }
        }
    }

    private void jCheckProxyAllItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckTrayProxyAll.setSelected(true);
            if (this.jCheckProxyAll.isEnabled()) {
                this.proxyModeChanged(2);
            }
        }
    }

    private void jCheckTrayProxyDisableItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckProxyDisable.setSelected(true);
        }
    }

    private void jCheckTrayProxyByPatternItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckProxyByPattern.setSelected(true);
        }
    }

    private void jCheckTrayProxyAllItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jCheckProxyAll.setSelected(true);
        }
    }

    private void jMenuItemGeoipActionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelekTOR.this.updateGeoip();
            }
        });
    }

    private void jButtonClearFavsActionPerformed(ActionEvent actionEvent) {
        this.clearFavourites();
    }

    private void jTableExitNodesMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        try {
            this.intRowSelected = this.jTableExitNodes.getSelectedRow();
            if (this.intRowSelected > -1) {
                this.intRowSelected = this.jTableExitNodes.convertRowIndexToModel(this.intRowSelected);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

