/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.util.regex.Pattern;

public final class TorCircuit {
    public static final int FINGER = 0;
    public static final int NICKNAME = 1;
    private String[] dataCirc;
    private String[] dataHops;
    private String circuitinfo;

    public TorCircuit() {
    }

    public TorCircuit(String string) {
        this.setCircuit(string);
    }

    public void setCircuit(String string) {
        this.circuitinfo = string;
        Pattern pattern = Pattern.compile(" ");
        this.dataCirc = pattern.split(string);
        this.setHops(this.dataCirc[2]);
    }

    public String getCircuit() {
        return this.circuitinfo;
    }

    public void setHops(String string) {
        Pattern pattern = Pattern.compile(",");
        this.dataHops = pattern.split(string);
    }

    public String getID() {
        return this.dataCirc[0];
    }

    public String getStatus() {
        return this.dataCirc[1];
    }

    public String getBuildFlags() {
        return this.dataCirc[3].substring(12);
    }

    public String getPurpose() {
        return this.dataCirc[4].substring(8);
    }

    public String getTimestamp() {
        return this.dataCirc[5].substring(13);
    }

    public String getHops() {
        return this.dataCirc[2];
    }

    public String getGuardHop() {
        String string = null;
        try {
            string = this.dataHops[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getMiddleHop() {
        String string = null;
        try {
            string = this.dataHops.length < 3 ? "" : this.dataHops[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getExitHop() {
        String string = null;
        try {
            string = this.dataHops[this.dataHops.length - 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getGuard(int n) {
        return TorCircuit.getFromNodeHop(this.getGuardHop(), n);
    }

    public String getMiddleMan(int n) {
        return TorCircuit.getFromNodeHop(this.getMiddleHop(), n);
    }

    public String getExit(int n) {
        return TorCircuit.getFromNodeHop(this.getExitHop(), n);
    }

    public static String getFromNodeHop(String string, int n) {
        try {
            Pattern pattern = string.contains("~") ? Pattern.compile("~") : Pattern.compile("=");
            String[] stringArray = pattern.split(string);
            if (stringArray.length > 0) {
                return stringArray[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

