/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.TorCircuit;
import client.TorProcess;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import lib.SimpleFile;

public class TorController
extends TorProcess {
    public static final int EVENT_CIRCUITS_BUILT = 15;
    public static final int EVENT_CIRCUITS_FAILED = 16;
    public static final int EVENT_CIRCUIT_BUILT = 17;
    public static final int EVENT_CIRCUIT_FAILED = 18;
    public static final int EVENT_LATENCY_DONE = 19;
    public static final int EVENT_TESTING_DONE = 20;
    public static final int EVENT_CIRCUIT_CHANGED = 21;
    public static final int EVENT_ABORTED = 22;
    private static final String LOCALHOST = "127.0.0.1";
    private static final String[] EVENTMESSAGES = new String[]{"EVENT_CIRCUITS_BUILT", "EVENT_CIRCUITS_FAILED", "EVENT_CIRCUIT_BUILT", "EVENT_CIRCUIT_FAILED", "EVENT_LATENCY_DONE", "EVENT_TESTING_DONE", "EVENT_CIRCUIT_CHANGED", "EVENT_ABORTED"};
    public static final int STATUS_DEAD = 0;
    public static final int STATUS_BOOTING = 1;
    public static final int STATUS_IDLE = 2;
    public static final int STATUS_CIRCUIT_CREATION = 3;
    public static final int STATUS_LATENCY_CHECKING = 4;
    public static final long LATENCY_FAIL = 9999L;
    public static final int STREAM_IP = 5;
    public static final int NODE_GUARD = 0;
    public static final int NODE_MIDDLE = 1;
    public static final int NODE_EXIT = 2;
    private static final int DEFBUILDTIME = 20;
    private volatile Socket sockControl;
    private volatile BufferedReader brSocket;
    private volatile PrintWriter pwSocket;
    private String strLatencyURL;
    private final ConcurrentHashMap<String, TorCircuit> chmUseableCircuits = new ConcurrentHashMap();
    private ArrayList<String> alActiveStreams = new ArrayList();
    private int intStatus = 0;
    private volatile Socket sockProxy;
    private long lngLatency;
    private String strBestHops;
    private long lngBestLatency;
    private String entrynodes = "";
    private Thread tActive;
    private boolean haveEntryNode;

    public TorController(String string, String string2) {
        super(string, string2);
    }

    @Override
    public final void torProcessEventFired(int n, String string) {
        Logger.getGlobal().logp(Level.FINE, TorProcess.class.getName(), "torProcessEventFired() on Port=" + this.getListenPort(), this.getEventMessage(n) + ", Data=" + string);
        switch (n) {
            case 10: {
                this.haveEntryNode = true;
                break;
            }
            case 9: {
                this.setStatus(0);
                break;
            }
            case 6: 
            case 7: {
                this.openControlSocket();
                this.authenticateTor(this.getSecret());
                this.takeOwnership();
                this.waitForBridgeNodes(20);
                this.setStatus(2);
            }
        }
        this.controllerEventFired(n, string);
    }

    @Override
    public String getEventMessage(int n) {
        if (n < 15) {
            return super.getEventMessage(n);
        }
        return EVENTMESSAGES[n - 15];
    }

    public void controllerEventFired(int n, Object object) {
    }

    public synchronized void setStatus(int n) {
        this.intStatus = n;
    }

    public synchronized int getStatus() {
        return this.intStatus;
    }

    public boolean isIdle() {
        return this.getStatus() <= 2;
    }

    public final void stop() {
        this.haveEntryNode = false;
        this.abortActions();
        Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "stop() on Port=" + this.getListenPort(), "Stop requested");
        this.sendCommand("QUIT");
        this.closeControlSocket();
        this.stopProcess();
        this.setStatus(0);
    }

    public final void start() {
        this.createDefaultConfig();
        this.start(6);
    }

    public final void start(int n) {
        if (this.getStatus() == 0) {
            this.setInitialBootEvent(n);
            this.setStatus(1);
            this.startProcess();
            return;
        }
        if (this.getStatus() > 1) {
            this.setStatus(2);
            this.controllerEventFired(n, null);
        }
    }

    public final void abortActions() {
        if (this.getStatus() < 2) {
            return;
        }
        this.setStatus(2);
        this.abortLatencyCheck();
        Thread thread = this.getActiveThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public final void abortLatencyCheck() {
        if (this.sockProxy != null) {
            try {
                this.sockProxy.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sockProxy = null;
    }

    public void saveConf() {
        SimpleFile simpleFile = new SimpleFile(this.getConfigFilePath());
        simpleFile.delete();
        this.sendCommand("SAVECONF");
    }

    public void loadConf() {
        SimpleFile simpleFile = new SimpleFile(this.getConfigFilePath());
        simpleFile.openBufferedRead();
        String string = simpleFile.readEntireFile();
        simpleFile.closeFile();
        this.sendCommand("+loadconf\r\n" + string + "\r\n.");
    }

    public String getCountryFromIP(String string) {
        String string2 = "ip-to-country/" + string;
        ArrayList<String> arrayList = this.getInfo(string2);
        try {
            if (arrayList != null) {
                return arrayList.get(0).toUpperCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setTestingURL(String string) {
        this.strLatencyURL = string;
    }

    private void takeOwnership() {
        this.sendCommand("TAKEOWNERSHIP");
        this.sendCommand("RESETCONF __OwningControllerProcess");
    }

    private void authenticateTor(String string) {
        if (string == null) {
            this.sendCommand("AUTHENTICATE");
        } else {
            this.sendCommand("AUTHENTICATE \"" + string + "\"");
        }
    }

    public void enablePredictiveCircuits(boolean bl) {
        if (bl) {
            this.setConf("__DisablePredictedCircuits=0");
        } else {
            this.setConf("__DisablePredictedCircuits=1");
        }
    }

    public final ArrayList<String> getInfo(String string) {
        return this.sendCommand("GETINFO " + string);
    }

    public final void closeCircuit(String string) {
        this.sendCommand("CLOSECIRCUIT " + string);
    }

    public final ArrayList<String> setConf(String string) {
        return this.sendCommand("SETCONF " + string);
    }

    public final ArrayList<String> resetConf(String string) {
        return this.sendCommand("RESETCONF " + string);
    }

    public final ArrayList<String> signal(String string) {
        return this.sendCommand("SIGNAL " + string);
    }

    public String getEntryGuardsAsCSV() {
        ArrayList<String> arrayList = this.getInfo("entry-guards");
        StringBuilder stringBuilder = new StringBuilder();
        if (!arrayList.contains("250 OK")) {
            return stringBuilder.toString();
        }
        arrayList.remove("250 OK");
        String string = "";
        for (String string2 : arrayList) {
            if (!string2.contains("~")) continue;
            stringBuilder.append(string);
            stringBuilder.append(string2.substring(0, string2.indexOf(126)));
            if (!string.isEmpty()) continue;
            string = ",";
        }
        return stringBuilder.toString();
    }

    public final void doLatencyCheck(final int n) {
        Thread thread = new Thread(new Runnable(){
            long latency;

            @Override
            public void run() {
                this.latency = TorController.this.getTorLatency(n);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TorController.this.lngLatency = latency;
                        TorController.this.controllerEventFired(19, null);
                    }
                });
            }
        });
        if (this.getStatus() < 2) {
            return;
        }
        this.alActiveStreams = this.getInfo("stream-status");
        this.alActiveStreams.remove("250 OK");
        thread.start();
    }

    public final long getLatency() {
        return this.lngLatency;
    }

    public long getTorLatency(int n) {
        long l = 9999L;
        FilterInputStream filterInputStream = null;
        try {
            this.sockProxy = this.createTorSocketToURL(this.strLatencyURL, true);
            if (this.sockProxy != null) {
                this.sockProxy.setSoTimeout(n);
                filterInputStream = new DataInputStream(this.sockProxy.getInputStream());
                long l2 = System.currentTimeMillis();
                ((DataInputStream)filterInputStream).skipBytes(1);
                l = System.currentTimeMillis() - l2;
            }
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "getTorLatency Exception " + this.getListenPort(), iOException.getMessage());
        }
        try {
            if (!this.sockProxy.isClosed()) {
                this.sockProxy.close();
            }
            this.sockProxy = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public void closeCircuitsExcept(String string, boolean bl) {
        Logger.getGlobal().logp(Level.FINEST, TorController.class.getName(), "closeCircuitsExcept() Port=" + this.getListenPort(), "");
        Set<String> set = this.getBuiltCircuits(bl).keySet();
        for (String string2 : set) {
            if (string2.contentEquals(string)) continue;
            this.closeCircuit(string2);
        }
    }

    private String getCircuitIdFromStream(String string) {
        Pattern pattern = Pattern.compile(" ");
        String[] stringArray = pattern.split(string);
        return stringArray[2];
    }

    public final ArrayList<String> getActiveStreams() {
        return this.alActiveStreams;
    }

    public final void activateNodes(final String string, final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TorController.this.activateNodesBlocking(string, n);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TorController.this.isIdle()) {
                            TorController.this.controllerEventFired(22, null);
                            return;
                        }
                        TorController.this.setStatus(2);
                        if (TorController.this.chmUseableCircuits.isEmpty()) {
                            TorController.this.controllerEventFired(16, 0);
                        } else {
                            TorController.this.controllerEventFired(15, TorController.this.chmUseableCircuits.size());
                        }
                    }
                });
            }
        });
        if (this.getStatus() < 2) {
            return;
        }
        this.abortActions();
        this.setStatus(3);
        thread.start();
    }

    public final void activateCircuit(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TorController.this.activateCircuitBlocking(string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TorController.this.isIdle()) {
                            TorController.this.controllerEventFired(22, null);
                            return;
                        }
                        TorController.this.setStatus(2);
                        if (TorController.this.chmUseableCircuits.isEmpty()) {
                            TorController.this.controllerEventFired(18, null);
                        } else {
                            TorController.this.controllerEventFired(17, null);
                        }
                    }
                });
            }
        });
        if (this.getStatus() < 2) {
            return;
        }
        this.setStatus(3);
        thread.start();
    }

    public void setEntryNodes(String string) {
        this.entrynodes = "";
        if (string == null || !this.getBridges().isEmpty()) {
            return;
        }
        this.entrynodes = string;
    }

    public String getEntryNodes() {
        return this.entrynodes;
    }

    public void activateNodesBlocking(String string, int n) {
        this.chmUseableCircuits.clear();
        this.enablePredictiveCircuits(true);
        this.setConf("EntryNodes=" + this.entrynodes);
        this.setConf("ExitNodes=" + string);
        if (string.isEmpty() || string.contains("{")) {
            string = null;
        }
        this.waitForCircuits(20L, n, string);
        this.enablePredictiveCircuits(false);
    }

    private void activateCircuitBlocking(String string) {
        this.chmUseableCircuits.clear();
        this.sendCommand("EXTENDCIRCUIT 0 " + string + " PURPOSE=GENERAL");
        this.waitForCircuit(20L, string);
    }

    private void waitForBridgeNodes(int n) {
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while (!this.haveValidEntryNode()) {
            try {
                Thread.sleep(250L);
                if (System.currentTimeMillis() <= l) continue;
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
    }

    public boolean haveValidEntryNode() {
        if (this.getBridges().isEmpty()) {
            return true;
        }
        return this.haveEntryNode;
    }

    private void waitForCircuits(long l, int n, String string) {
        long l2 = System.currentTimeMillis() + l * (long)n * 1000L;
        this.setActiveThread(Thread.currentThread());
        while (this.chmUseableCircuits.size() < n) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (System.currentTimeMillis() > l2) {
                Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "waitForCircuits() on Port=" + this.getListenPort(), "Timed Out");
                break;
            }
            if (this.isIdle()) {
                Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "waitForCircuits() on Port=" + this.getListenPort(), "Aborting");
                this.chmUseableCircuits.clear();
                break;
            }
            TorCircuit torCircuit = this.getLatestCircuit();
            if (torCircuit == null || string != null && !string.contains(torCircuit.getExit(0))) continue;
            if (this.entrynodes.isEmpty()) {
                this.chmUseableCircuits.put(torCircuit.getID(), torCircuit);
                continue;
            }
            if (!this.entrynodes.contains(torCircuit.getGuard(0))) continue;
            this.chmUseableCircuits.put(torCircuit.getID(), torCircuit);
        }
    }

    private void waitForCircuit(long l, String string) {
        long l2 = System.currentTimeMillis() + l * 1000L;
        this.setActiveThread(Thread.currentThread());
        while (this.chmUseableCircuits.size() < 1) {
            String string2;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (System.currentTimeMillis() > l2) {
                Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "waitForCircuit() on Port=" + this.getListenPort(), "Timed Out");
                break;
            }
            if (this.isIdle()) {
                Logger.getGlobal().logp(Level.INFO, TorController.class.getName(), "waitForCircuit() on Port=" + this.getListenPort(), "Aborting");
                this.chmUseableCircuits.clear();
                break;
            }
            TorCircuit torCircuit = this.getLatestCircuit();
            if (torCircuit == null || !(string2 = torCircuit.getHops()).contains(string)) continue;
            this.chmUseableCircuits.put(torCircuit.getID(), torCircuit);
        }
    }

    private synchronized void setActiveThread(Thread thread) {
        this.tActive = thread;
    }

    private synchronized Thread getActiveThread() {
        return this.tActive;
    }

    public void testNode(final String string) {
        SwingWorker<Void, Integer> swingWorker = new SwingWorker<Void, Integer>(){
            private long bestLatency = 9999L;
            private String bestHops = null;

            @Override
            protected Void doInBackground() {
                TorController.this.closeCircuitsExcept("", true);
                TorController.this.activateNodesBlocking(string, 1);
                if (TorController.this.isIdle()) {
                    return null;
                }
                if (TorController.this.chmUseableCircuits.size() > 0) {
                    String string2 = TorController.this.chmUseableCircuits.keys().nextElement();
                    TorCircuit torCircuit = TorController.this.chmUseableCircuits.get(string2);
                    TorController.this.closeCircuitsExcept("", true);
                    TorController.this.activateCircuitBlocking(torCircuit.getHops());
                    this.publish(17);
                    long l = TorController.this.getTorLatency(5000);
                    if (l < this.bestLatency) {
                        this.bestLatency = l;
                        this.bestHops = torCircuit.getHops();
                    }
                }
                return null;
            }

            @Override
            protected void process(List<Integer> list) {
                for (Integer n : list) {
                    TorController.this.controllerEventFired(n, TorController.this.chmUseableCircuits.size());
                }
            }

            @Override
            protected void done() {
                if (TorController.this.isIdle()) {
                    TorController.this.lngBestLatency = 9999L;
                    TorController.this.strBestHops = null;
                    TorController.this.controllerEventFired(22, null);
                } else {
                    TorController.this.setStatus(2);
                    TorController.this.lngBestLatency = this.bestLatency;
                    TorController.this.strBestHops = this.bestHops;
                    TorController.this.controllerEventFired(20, TorController.this.chmUseableCircuits.size());
                }
            }
        };
        this.setStatus(3);
        this.strBestHops = null;
        this.lngBestLatency = 9999L;
        swingWorker.execute();
    }

    public final long getBestLatency() {
        return this.lngBestLatency;
    }

    public final String getBestHops() {
        return this.strBestHops;
    }

    public final HashMap<String, TorCircuit> getBuiltCircuits(boolean bl) {
        HashMap<String, TorCircuit> hashMap = new HashMap<String, TorCircuit>();
        ArrayList<String> arrayList = this.getInfo("circuit-status");
        arrayList.remove("250 OK");
        for (String string : arrayList) {
            if (!string.contains("BUILT") || bl && (string.contains("ONEHOP_TUNNEL") || string.contains("IS_INTERNAL") || !string.contains("PURPOSE=GENERAL"))) continue;
            TorCircuit torCircuit = new TorCircuit(string);
            hashMap.put(torCircuit.getID(), torCircuit);
        }
        return hashMap;
    }

    public final boolean verifyControlComms() {
        ArrayList<String> arrayList = this.getInfo("circuit-status");
        return !arrayList.isEmpty();
    }

    public final TorCircuit getLatestCircuit() {
        HashMap<String, TorCircuit> hashMap = this.getBuiltCircuits(true);
        Iterator<String> iterator = this.getBuiltCircuits(true).keySet().iterator();
        TorCircuit torCircuit = null;
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            int n2 = Integer.parseInt(string);
            if (n2 <= n) continue;
            n = n2;
            torCircuit = hashMap.get(string);
        }
        return torCircuit;
    }

    private void openControlSocket() {
        try {
            this.sockControl = new Socket(LOCALHOST, this.getControlPort());
            this.sockControl.setKeepAlive(true);
            this.sockControl.setSoTimeout(2000);
            this.pwSocket = new PrintWriter(this.sockControl.getOutputStream());
            this.brSocket = new BufferedReader(new InputStreamReader(this.sockControl.getInputStream()), 1024);
        }
        catch (IOException iOException) {
            Logger.getGlobal().throwing(TorController.class.getName(), "openControlSocket() on Port=" + this.getListenPort(), iOException);
        }
    }

    private void closeControlSocket() {
        try {
            if (this.sockControl != null) {
                this.sockControl.setKeepAlive(false);
                this.sockControl.close();
                this.sockControl = null;
                this.pwSocket.close();
                this.brSocket.close();
                this.pwSocket = null;
                this.brSocket = null;
            }
        }
        catch (IOException iOException) {
            Logger.getGlobal().throwing(TorController.class.getName(), "closeControlSocket() on Port=" + this.getListenPort(), iOException);
        }
    }

    public final synchronized ArrayList<String> sendCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.sockControl == null) {
            Logger.getGlobal().logp(Level.WARNING, TorController.class.getName(), "sendCommand() Port=" + this.getListenPort(), "Cmd=" + string + ", Non-existent socket");
            return arrayList;
        }
        if (this.sockControl.isClosed()) {
            Logger.getGlobal().logp(Level.WARNING, TorController.class.getName(), "sendCommand() Port=" + this.getListenPort(), "Cmd=" + string + ", Socket is closed.");
            return arrayList;
        }
        this.flushReadBuffer();
        if (this.pwSocket.checkError()) {
            Logger.getGlobal().logp(Level.FINEST, TorController.class.getName(), "sendCommand() Port=" + this.getListenPort(), "Cmd=" + string + ", Write Socket Error");
            return arrayList;
        }
        this.pwSocket.write(string + "\r\n");
        this.pwSocket.flush();
        if (string.contentEquals("QUIT")) {
            return arrayList;
        }
        arrayList = this.getCommandResponse();
        if (!arrayList.isEmpty()) {
            Logger.getGlobal().logp(Level.FINEST, TorController.class.getName(), "sendCommand() Port=" + this.getListenPort(), "Cmd=" + string + ", Response=" + arrayList.toString());
        } else {
            Logger.getGlobal().logp(Level.WARNING, TorController.class.getName(), "sendCommand() Port=" + this.getListenPort(), "Cmd=" + string + ", Response=Timed out");
        }
        return arrayList;
    }

    private ArrayList<String> getCommandResponse() {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            while ((string = this.brSocket.readLine()) != null) {
                if (bl) {
                    if (string.startsWith(".")) {
                        bl = false;
                        continue;
                    }
                    arrayList.add(string);
                    continue;
                }
                if (string.startsWith("250+")) {
                    bl = true;
                    if ((string = string.substring(string.indexOf(61) + 1).trim()).isEmpty()) continue;
                    arrayList.add(string);
                    continue;
                }
                if (string.startsWith("250-")) {
                    if ((string = string.substring(string.indexOf(61) + 1).trim()).isEmpty()) continue;
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string);
                if (!string.startsWith("250 ") && !string.startsWith("251 ") && !string.startsWith("4") && !string.startsWith("5")) continue;
                break;
            }
        }
        catch (IOException iOException) {
            arrayList.clear();
        }
        return arrayList;
    }

    private void flushReadBuffer() {
        try {
            while (this.brSocket.ready()) {
                this.brSocket.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Socket createTorSocketToURL(String string, boolean bl) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getHost().toLowerCase();
            if (bl) {
                string2 = string2.replace("www.", "");
            }
            String string3 = uRI.getScheme();
            int n = uRI.getPort();
            if (n == -1) {
                switch (string3) {
                    default: {
                        n = 80;
                        break;
                    }
                    case "https": {
                        n = 443;
                    }
                }
            }
            return this.createSocks4aSocket(LOCALHOST, this.getListenPort(), string2, n);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(TorController.class.getName()).log(Level.SEVERE, null, uRISyntaxException);
            return null;
        }
    }

    public Socket createSocks4aSocket(String string, int n, String string2, int n2) {
        try {
            Socket socket = new Socket(string, n);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(n2);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeBytes(string2);
            dataOutputStream.writeByte(0);
            return socket;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.FINE, this.getClass().getName(), "createSocks4aSocket", "", iOException);
            return null;
        }
    }
}

