/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import lib.ClientProcess;
import lib.SimpleFile;

public class TorProcess
extends ClientProcess {
    public static final int LOG_DEBUG = 0;
    public static final int LOG_INFO = 1;
    public static final int LOG_NOTICE = 2;
    private static final String TORCONFIGFILE = "torrc";
    public static final String EMPTYSTRING = "";
    public static final int TOR_MESSAGE = 0;
    public static final int TOR_BOOT_TIMEOUT = 1;
    public static final int TOR_BOOT_FATAL = 2;
    public static final int TOR_BOOT_ERROR = 3;
    public static final int TOR_CLOCK_ERROR = 4;
    public static final int TOR_NOROUTE = 5;
    public static final int TOR_BOOTED = 6;
    public static final int TOR_RESTARTED = 7;
    public static final int TOR_NOEXITS = 8;
    public static final int TOR_STOPPED = 9;
    public static final int TOR_BRIDGE = 10;
    public static final int TOR_NEWCIRC = 11;
    public static final int TOR_DIRINFO_STALE = 12;
    public static final int TOR_NOHOP0 = 13;
    public static final int TOR_NONET_ACTIVITY = 14;
    private static final String[] EVENTMESSAGES = new String[]{"TOR_MESSAGE", "TOR_BOOT_TIMEOUT", "TOR_BOOT_FATAL", "TOR_BOOT_ERROR", "TOR_CLOCK_ERROR", "TOR_NOROUTE", "TOR_BOOTED", "TOR_RESTARTED", "TOR_NOEXITS", "TOR_STOPPED", "TOR_BRIDGE", "TOR_NEWCIRC", "TOR_DIRINFO_STALE", "TOR_NOHOP0", "TOR_NONET_ACTIVITY"};
    private final LinkedHashMap<String, String> lhmCLIOptions;
    private final LinkedHashMap<String, String> lhmTorrcOptions;
    private final String strClientLocation;
    private final String strConfigFolder;
    private String strSecret;
    private String strCachedDataFolder;
    private String invCommas = "\"";
    private String strExternalArgs = "";
    private String strBridges = "";
    private int intListenPort;
    private int intInitialBootEvent;
    private int loglev = 2;
    private float version = 9999.0f;
    private int maxlines = 50;
    private int nolines;
    private JTextArea jtxtstdout;
    private boolean boolSilentBoot;

    public TorProcess(String string, String string2) {
        this.setSilentBootEnabled(false);
        this.strClientLocation = string;
        this.intInitialBootEvent = 6;
        this.strConfigFolder = string2;
        this.lhmCLIOptions = new LinkedHashMap();
        this.lhmTorrcOptions = new LinkedHashMap();
        if (SimpleFile.getSeparator().compareTo("/") == 0) {
            this.invCommas = EMPTYSTRING;
        }
    }

    public final void startProcess() {
        this.setStartupTimeout(45L);
        float f = this.getCacheAge();
        Logger.getGlobal().logp(Level.INFO, TorProcess.class.getName(), "start() on Port=" + this.getListenPort(), "Cache age = " + (int)f + " minutes.");
        if (f > 180.0f) {
            this.deleteCacheData();
            Logger.getGlobal().logp(Level.INFO, TorProcess.class.getName(), "start() on Port=" + this.getListenPort(), "Cache stale, deleting old cache data.");
        }
        String string = this.strClientLocation + " -f " + this.invCommas + this.getConfigFilePath() + this.invCommas + " " + this.getCLIOptionsAsString() + " " + this.strExternalArgs;
        super.start(string);
    }

    public final void setLogLevel(int n) {
        this.loglev = n;
    }

    public final void setExternalArgs(String string) {
        this.strExternalArgs = string;
    }

    public final void setListenPort(int n) {
        if (this.intListenPort == n) {
            return;
        }
        this.intListenPort = n;
        this.setCLIOption("SocksPort", String.valueOf(n));
        this.setCLIOption("ControlPort", String.valueOf(n + 1));
        this.createDataFolder();
    }

    public final void setInitialBootEvent(int n) {
        this.intInitialBootEvent = n;
    }

    @Override
    public final void clientProcessEventFired(String string) {
        Logger.getGlobal().logp(Level.FINER, TorProcess.class.getName(), "clientProcessEventFired() on Port=" + this.getListenPort(), string);
        if (!string.isEmpty()) {
            this.appendStdout(string);
        }
        if (this.getClientStatus() == 0) {
            this.torProcessEventFired(9, null);
            return;
        }
        if (this.getClientStatus() == 2) {
            this.torProcessEventFired(1, null);
            return;
        }
        if (this.getClientStatus() == 1) {
            if (this.strCachedDataFolder != null) {
                SimpleFile.copyFolderContents(this.strCachedDataFolder, this.getDataFolder() + SimpleFile.getSeparator(), TORCONFIGFILE);
                this.strCachedDataFolder = null;
            }
            if (string.contains("[warn] Our clock")) {
                this.torProcessEventFired(4, string);
                return;
            }
            if (string.contains("exception") || string.contains("[err]")) {
                this.torProcessEventFired(2, string);
                return;
            }
            if (string.contains("NOROUTE")) {
                this.torProcessEventFired(5, string);
                return;
            }
            if (string.contains("[notice] new bridge")) {
                this.torProcessEventFired(10, string);
                return;
            }
            if (string.contains("directory information is no longer up-to-date")) {
                this.torProcessEventFired(12, string);
                return;
            }
            if (string.contains("All routers are down")) {
                this.torProcessEventFired(8, string);
                return;
            }
            if (string.contains("Retrying on a new circuit")) {
                this.torProcessEventFired(11, string);
                return;
            }
            if (string.contains("Failed to find node for hop 0")) {
                this.torProcessEventFired(13, string);
                return;
            }
            if (string.contains("Tor has not observed any network activity")) {
                this.torProcessEventFired(14, string);
                return;
            }
            if (string.contains("Bootstrapped")) {
                int n;
                if (!this.boolSilentBoot) {
                    this.torProcessEventFired(0, string.substring(string.indexOf(93) + 2));
                }
                if ((n = this.getPercentage(string)) >= 15) {
                    this.setStartupTimeout(60L);
                }
                if (n >= 40) {
                    this.setStartupTimeout(120L);
                }
                if (n >= 80) {
                    this.setStartupTimeout(30L);
                }
                if (n >= 100) {
                    this.setStartupTimeout(-1L);
                    this.torProcessEventFired(this.intInitialBootEvent, null);
                    this.intInitialBootEvent = 6;
                    this.setSilentBootEnabled(false);
                }
            }
        }
    }

    private int getPercentage(String string) {
        int n;
        int n2 = -1;
        int n3 = string.indexOf("Bootstrapped ");
        if (n3 > -1 && (n = string.indexOf(37, n3 += 13)) > -1) {
            String string2 = string.substring(n3, n);
            n2 = Integer.parseInt(string2);
        }
        return n2;
    }

    public final void setSilentBootEnabled(boolean bl) {
        this.boolSilentBoot = bl;
    }

    public String getEventMessage(int n) {
        return EVENTMESSAGES[n];
    }

    public void torProcessEventFired(int n, String string) {
    }

    public final void setControlPassword(String string, String string2) {
        this.strSecret = string;
        this.setCLIOption("hashedcontrolpassword", string2);
    }

    public final String getSecret() {
        return this.strSecret;
    }

    public final void setBridges(String string) {
        String[] stringArray;
        this.clearCLIOption("UseBridges");
        this.clearCLIOption("Bridge");
        this.clearCLIOption("UpdateBridgesFromAuthority");
        this.strBridges = EMPTYSTRING;
        if (string == null || string.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = EMPTYSTRING;
        for (String string3 : stringArray = Pattern.compile(",").split(string)) {
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            if (!string2.isEmpty()) continue;
            string2 = " --Bridge ";
        }
        this.strBridges = string;
        this.setCLIOption("UseBridges", "1");
        this.setCLIOption("UpdateBridgesFromAuthority", "1");
        this.setCLIOption("Bridge", stringBuilder.toString());
    }

    public boolean validateBridges(String string) {
        String[] stringArray;
        if (string.isEmpty()) {
            return true;
        }
        for (String string2 : stringArray = Pattern.compile(",").split(string)) {
            if (this.validateHostPort(string2)) continue;
            return false;
        }
        return true;
    }

    public final boolean validateHostPort(String string) {
        try {
            URI uRI = new URI("my://" + string);
            if (uRI.getHost() == null || uRI.getPort() == -1) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public final String getBridges() {
        return this.strBridges;
    }

    public void setOwnershipID(String string) {
        this.setCLIOption("__OwningControllerProcess", string);
    }

    public String getOwnershipID() {
        return this.getCLIOptions("__OwningControllerProcess");
    }

    public final void setGeoIP4(String string) {
        if (string != null) {
            if (SimpleFile.exists(string)) {
                this.setTorrcOption("GeoIPFile", this.invCommas + string + this.invCommas);
            } else {
                this.clearTorrcOption("GeoIPFile");
            }
        } else {
            this.clearTorrcOption("GeoIPFile");
        }
    }

    public final void setGeoIP6(String string) {
        if (string != null) {
            if (SimpleFile.exists(string)) {
                this.setTorrcOption("GeoIPv6File", this.invCommas + string + this.invCommas);
            } else {
                this.clearTorrcOption("GeoIPv6File");
            }
        } else {
            this.clearTorrcOption("GeoIPv6File");
        }
    }

    public final String getClientLocation() {
        return this.strClientLocation;
    }

    public final String getConfigFilePath() {
        return this.getDataFolder() + File.separator + TORCONFIGFILE;
    }

    public final String getCLIOptions(String string) {
        return this.lhmCLIOptions.get(string);
    }

    public final void setCLIOption(String string, String string2) {
        this.lhmCLIOptions.put(string, string2);
    }

    public final void setBoolTorOption(String string, boolean bl) {
        this.lhmCLIOptions.remove(string);
        if (bl) {
            this.lhmCLIOptions.put(string, "1");
        } else {
            this.lhmCLIOptions.put(string, "0");
        }
    }

    public final String getTorrcOption(String string) {
        return this.lhmTorrcOptions.get(string);
    }

    public final void setTorrcOption(String string, String string2) {
        if (string2.startsWith("\"")) {
            string2 = string2.replace('\\', '/');
        }
        this.lhmTorrcOptions.put(string, string2);
    }

    public final String getTorrcOptionsAsString() {
        Iterator<String> iterator = this.lhmTorrcOptions.keySet().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            stringBuilder.append(" ");
            stringBuilder.append(this.lhmTorrcOptions.get(string));
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public final void clearTorrcOption(String string) {
        this.lhmTorrcOptions.remove(string);
    }

    public final boolean getCLIOptionBool(String string) {
        return this.lhmCLIOptions.get(string).contentEquals("1");
    }

    public final void clearCLIOption(String string) {
        this.lhmCLIOptions.remove(string);
    }

    public final String getCLIOptionsAsString() {
        Iterator<String> iterator = this.lhmCLIOptions.keySet().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append("--");
            stringBuilder.append(string);
            stringBuilder.append(" ");
            String string2 = this.lhmCLIOptions.get(string);
            if (string2.isEmpty()) continue;
            stringBuilder.append(string2);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public final int getListenPort() {
        return this.intListenPort;
    }

    public final int getControlPort() {
        return this.intListenPort + 1;
    }

    public final void createDefaultConfig() {
        SimpleFile simpleFile = new SimpleFile(this.getConfigFilePath());
        simpleFile.openBufferedWrite();
        simpleFile.writeFile(this.getTorrcOptionsAsString(), 0);
        switch (this.loglev) {
            case 0: {
                simpleFile.writeFile("log debug stdout", 1);
                break;
            }
            case 1: {
                simpleFile.writeFile("log info stdout", 1);
                break;
            }
            case 2: {
                simpleFile.writeFile("log notice stdout", 1);
            }
        }
        simpleFile.writeFile(EMPTYSTRING, 1);
        simpleFile.closeFile();
    }

    public final void deleteConfigFile() {
        SimpleFile.delete(this.getConfigFilePath());
    }

    public final void createDataFolder() {
        String string = this.getDataFolder();
        if (string != null) {
            this.setTorrcOption("datadirectory", this.invCommas + this.getDataFolder() + this.invCommas);
            SimpleFile.createFolder(this.getDataFolder());
        }
    }

    public final String getDataFolder() {
        if (this.strConfigFolder == null) {
            return null;
        }
        return this.strConfigFolder + String.valueOf(this.intListenPort);
    }

    public float getCacheAge() {
        String string = this.getDataFolder() + SimpleFile.getSeparator() + "cached-consensus";
        if (SimpleFile.exists(string)) {
            return SimpleFile.getAgeOfFile(string, 0);
        }
        return -1.0f;
    }

    public final void deleteCacheData() {
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "cached-consensus");
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "cached-certs");
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "cached-descriptors");
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "cached-descriptors.new");
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "lock");
        SimpleFile.secureWipe(this.getDataFolder() + SimpleFile.getSeparator() + "state");
    }

    public final void setCachedDataFolder(int n) {
        if (n < 0) {
            this.strCachedDataFolder = null;
            return;
        }
        this.strCachedDataFolder = this.strConfigFolder + String.valueOf(n);
    }

    public final String getCachedDataFolder() {
        return this.strCachedDataFolder;
    }

    public void setStdoutTextArea(JTextArea jTextArea) {
        this.jtxtstdout = jTextArea;
    }

    public void setMaxHistory(int n) {
        this.maxlines = n;
    }

    public void clearStdout() {
        if (this.jtxtstdout != null) {
            this.jtxtstdout.setText(EMPTYSTRING);
        }
        this.nolines = 0;
    }

    private void appendStdout(String string) {
        if (this.jtxtstdout == null) {
            return;
        }
        this.jtxtstdout.append(string + "\n");
        if (++this.nolines > this.maxlines) {
            try {
                int n = this.jtxtstdout.getLineEndOffset(0);
                this.jtxtstdout.replaceRange(EMPTYSTRING, 0, n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.jtxtstdout.setCaretPosition(this.jtxtstdout.getText().length());
    }

    public final float getVersion() {
        if (this.version == 9999.0f) {
            String string = EMPTYSTRING;
            try {
                String string2;
                Process process = Runtime.getRuntime().exec(this.strClientLocation + " --version");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 256);
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string2;
                }
                bufferedReader.close();
                process.destroy();
                process.waitFor();
            }
            catch (IOException | InterruptedException exception) {
                Logger.getLogger(TorProcess.class.getName()).log(Level.SEVERE, null, exception);
            }
            int n = string.indexOf("ion");
            if (n > -1) {
                if ((n = (string = string.substring(n + 4).replace(".", EMPTYSTRING)).indexOf(32)) > -1) {
                    string = string.substring(0, n);
                }
                try {
                    this.version = Float.parseFloat("0." + string) * 10.0f;
                }
                catch (Exception exception) {
                    Logger.getGlobal().logp(Level.SEVERE, this.getClass().getName(), "getVersion() Port=" + this.intListenPort, EMPTYSTRING, exception);
                }
            }
        }
        return this.version;
    }
}

