/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class ClientProcess {
    public static final int CLIENT_STOPPED = 0;
    public static final int CLIENT_RUNNING = 1;
    public static final int CLIENT_TIMEDOUT = 2;
    private long initialdelay = 0L;
    private volatile long startupTimeout;
    private SwingWorker<ArrayList<String>, String> swWorker;
    private volatile Process procApplication;
    private PrintWriter pwWriter;
    private volatile Thread threadSleep;
    private int intStatus = 0;

    public ClientProcess() {
        this.setStartupTimeout(15L);
    }

    public final void setStartupDelay(long l) {
        this.initialdelay = l;
    }

    public final void setStartupTimeout(long l) {
        this.startupTimeout = l * 1000L;
    }

    public final void start(final String string) {
        this.swWorker = new SwingWorker<ArrayList<String>, String>(){
            String line;
            int endstatus;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ArrayList<String> doInBackground() {
                BufferedReader bufferedReader = null;
                BufferedReader bufferedReader2 = null;
                try {
                    this.endstatus = 0;
                    if (this.isCancelled()) {
                        ArrayList<String> arrayList = null;
                        return arrayList;
                    }
                    ClientProcess.this.threadSleep = Thread.currentThread();
                    if (ClientProcess.this.initialdelay > 0L) {
                        try {
                            Thread.sleep(ClientProcess.this.initialdelay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ClientProcess.this.threadSleep = null;
                    ClientProcess.this.initialdelay = 0L;
                    if (this.isCancelled()) {
                        ArrayList<String> arrayList = null;
                        return arrayList;
                    }
                    ClientProcess.this.procApplication = Runtime.getRuntime().exec(string);
                    if (ClientProcess.this.procApplication == null) {
                        ArrayList<String> arrayList = null;
                        return arrayList;
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader(ClientProcess.this.procApplication.getInputStream()), 512);
                    bufferedReader2 = new BufferedReader(new InputStreamReader(ClientProcess.this.procApplication.getErrorStream()), 512);
                    ClientProcess.this.pwWriter = new PrintWriter(ClientProcess.this.procApplication.getOutputStream());
                    long l = System.currentTimeMillis() + ClientProcess.this.startupTimeout;
                    while (!this.isCancelled()) {
                        if (bufferedReader.ready()) {
                            l = System.currentTimeMillis() + ClientProcess.this.startupTimeout;
                            this.line = bufferedReader.readLine();
                            this.publish(this.line);
                        }
                        if (bufferedReader2.ready()) {
                            l = System.currentTimeMillis() + ClientProcess.this.startupTimeout;
                            this.line = bufferedReader2.readLine();
                            this.publish(this.line);
                        }
                        if (System.currentTimeMillis() > l && ClientProcess.this.startupTimeout > 0L) {
                            this.endstatus = 2;
                            break;
                        }
                        ClientProcess.this.threadSleep = Thread.currentThread();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ClientProcess.this.threadSleep = null;
                    }
                }
                catch (Exception exception) {
                    Logger.getGlobal().logp(Level.INFO, ClientProcess.class.getName(), "SwingWorker Loop Exception", exception.getMessage());
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedReader2 != null) {
                            bufferedReader2.close();
                        }
                        ClientProcess.this.pwWriter.close();
                        if (ClientProcess.this.procApplication != null) {
                            ClientProcess.this.procApplication.getOutputStream().close();
                            ClientProcess.this.procApplication.getInputStream().close();
                            ClientProcess.this.procApplication.getErrorStream().close();
                            ClientProcess.this.procApplication.destroy();
                        }
                    }
                    catch (Exception exception) {
                        Logger.getGlobal().logp(Level.INFO, ClientProcess.class.getName(), "SwingWorker Cleanup", exception.getMessage());
                    }
                }
                return null;
            }

            @Override
            protected void process(List<String> list) {
                for (String string2 : list) {
                    if (string2 == null) continue;
                    ClientProcess.this.clientProcessEventFired(string2);
                }
            }

            @Override
            protected void done() {
                ClientProcess.this.intStatus = this.endstatus;
                ClientProcess.this.clientProcessEventFired("");
            }
        };
        this.intStatus = 1;
        this.clientProcessEventFired("");
        this.swWorker.execute();
    }

    public final int getClientStatus() {
        return this.intStatus;
    }

    public final Process getProcess() {
        return this.procApplication;
    }

    public final void stopProcess() {
        if (this.threadSleep != null) {
            this.threadSleep.interrupt();
        }
        if (this.swWorker != null) {
            this.swWorker.cancel(true);
        }
        try {
            this.procApplication.waitFor();
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.INFO, ClientProcess.class.getName(), "stopProcess", exception.getMessage());
        }
    }

    public final void sendMessage(String string) {
        this.pwWriter.write(string);
    }

    public void clientProcessEventFired(String string) {
    }
}

