/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.logging.Level;
import java.util.logging.Logger;
import lib.OSFunction;
import lib.SwingTrayIcon;

public class DesktopNotify {
    private final String iconpath;
    private String notifytitle;
    private String notifybody;
    private String notifysendpath;
    private final SwingTrayIcon sti;
    private boolean enabled;
    private boolean supported = true;

    public DesktopNotify(SwingTrayIcon swingTrayIcon, String string) {
        this.sti = swingTrayIcon;
        this.iconpath = string;
        if (OSFunction.isLinux()) {
            this.notifysendpath = OSFunction.findFile("notify-send", "/usr/bin/");
            if (this.notifysendpath == null) {
                Logger.getGlobal().log(Level.WARNING, "notify-send not found.");
                this.supported = false;
            }
        }
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setNotificationTitle(String string) {
        this.notifytitle = string;
    }

    public void setNotificationBody(String string) {
        this.notifybody = string;
    }

    public void raiseNotification() {
        if (this.notifybody == null || this.notifytitle == null || !this.enabled) {
            return;
        }
        if (OSFunction.isWindows()) {
            if (this.sti != null) {
                this.sti.displayMessage(this.notifytitle, this.notifybody);
            }
        } else if (this.notifysendpath != null) {
            OSFunction.launchProcess("notify-send", "-u", "normal", "-i", this.iconpath, this.notifytitle, this.notifybody);
        }
        this.notifybody = null;
    }

    public String getNotifySendPath() {
        return this.notifysendpath;
    }
}

