/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import lib.OSFunction;
import lib.TrayPopupMenu;

public class GTKFixes {
    public static void fixMenubarHeight(JMenuBar jMenuBar, JMenuItem jMenuItem) {
        jMenuBar.setPreferredSize(new Dimension(jMenuBar.getPreferredSize().width, jMenuItem.getPreferredSize().height));
    }

    public static void fixMenuSelectionColor(JMenu ... jMenuArray) {
        if (!UIManager.getLookAndFeel().getID().contentEquals("GTK")) {
            return;
        }
        for (final JMenu jMenu : jMenuArray) {
            final Color color = new Color(((Color)UIManager.get("Menu.selectionBackground")).getRGB());
            final Color color2 = new Color(((Color)UIManager.get("Menu.selectionForeground")).getRGB());
            final Color color3 = jMenu.getForeground();
            final Color color4 = new Color(((Color)UIManager.get("Menu.background")).getRGB());
            jMenu.setText(" " + jMenu.getText() + " ");
            jMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    jMenu.setOpaque(true);
                    jMenu.setForeground(color2);
                    jMenu.setBackground(color);
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                    jMenu.setOpaque(false);
                    jMenu.setForeground(color3);
                    jMenu.setBackground(color4);
                }

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                    jMenu.setOpaque(false);
                    jMenu.setForeground(color3);
                    jMenu.setBackground(color4);
                }
            });
        }
    }

    public static void fixJMenuPopupBorder(JMenu ... jMenuArray) {
        if (!UIManager.getLookAndFeel().getID().contentEquals("GTK")) {
            return;
        }
        for (JMenu jMenu : jMenuArray) {
            jMenu.getPopupMenu().setBorder(BorderFactory.createLineBorder(new Color(UIManager.getColor("PopupMenu.background").getRGB()).darker(), 1));
        }
    }

    public static void fixTrayMenuPopupBorder(TrayPopupMenu trayPopupMenu) {
        trayPopupMenu.setBorder(BorderFactory.createLineBorder(new Color(UIManager.getColor("PopupMenu.background").getRGB()).darker(), 1));
    }

    public static void fixMenuItemFgColor(JMenuItem ... jMenuItemArray) {
        if (!UIManager.getLookAndFeel().getID().contentEquals("GTK")) {
            return;
        }
        for (JMenuItem jMenuItem : jMenuItemArray) {
            Color color = new Color(UIManager.getColor("MenuItem.foreground").getRGB());
            jMenuItem.setForeground(color);
        }
    }

    public static void fixTextAreaColor(JTextArea jTextArea) {
        if (OSFunction.isLinux()) {
            jTextArea.setForeground(UIManager.getColor("JLabel.foreground"));
            jTextArea.setBackground(UIManager.getColor("JLabel.background"));
        }
    }
}

