/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class InfoDialog
extends JDialog {
    public static final int CANCEL_BUTTON = 0;
    public static final int CANCEL_WINDOW = 1;
    public static final int OK = 2;
    private Color fg = null;
    private final Frame parent;
    private String strButtClose;
    private String strTitle = "";
    private final Font fontDefault;
    private Timer tmrAutoClose;
    private Timer tmrButtonLock;
    private JButton jButtonCancel;
    private JButton jButtonContinue;
    private JCheckBox jCheckBoxOption;
    private JPanel jPanelMain;
    private JProgressBar jProgressBar;
    private JScrollPane jScrollPane2;
    private JTextArea jTextInfo;
    private int returnStatus = 0;

    public InfoDialog(Frame frame) {
        super(frame, true);
        this.parent = frame;
        this.initComponents();
        this.jCheckBoxOption.setVisible(false);
        this.jProgressBar.setVisible(false);
        this.fg = this.jTextInfo.getForeground();
        this.fontDefault = this.jTextInfo.getFont();
        this.setContinueButtonText("Continue");
        this.setCancelButtonText("Cancel");
        this.setCloseButtonText("Close");
    }

    @Override
    public final Font getFont() {
        return this.jPanelMain.getFont();
    }

    public final void createInfo(String string) {
        this.createInfo(string, null);
    }

    public final void createInfo(String string, String string2) {
        super.setTitle(this.strTitle + " " + string);
        this.setModal(true);
        this.setCancelVisible(false);
        this.setContinueButtonText(this.strButtClose);
        this.jProgressBar.setVisible(false);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getTitle());
        if (n > this.getWidth()) {
            this.setSize(n, this.getHeight());
        }
        this.jTextInfo.setFont(this.fontDefault);
        this.jTextInfo.setForeground(this.fg);
        this.jTextInfo.setText("");
        if (string2 != null) {
            this.jTextInfo.setText(string2);
        }
        this.jTextInfo.setCaretPosition(0);
        this.setLocationRelativeTo(this.parent);
    }

    @Override
    public final void setTitle(String string) {
        this.strTitle = string;
        super.setTitle(this.strTitle);
    }

    public final void createWarn(String string) {
        this.createWarn(string, null);
    }

    public final void createWarn(String string, String string2) {
        super.setTitle(this.strTitle + " " + string);
        this.setModal(true);
        this.setCancelVisible(true);
        this.jProgressBar.setVisible(false);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getTitle());
        if (n > this.getWidth()) {
            this.setSize(n, this.getHeight());
        }
        this.jTextInfo.setFont(this.fontDefault);
        this.jTextInfo.setForeground(this.fg);
        this.jTextInfo.setText("");
        if (string2 != null) {
            this.jTextInfo.setText(string2);
        }
        this.setLocationRelativeTo(this.parent);
        this.jTextInfo.setCaretPosition(0);
    }

    public final void createProgress(String string, String string2) {
        super.setTitle(this.strTitle + " " + string);
        this.setModal(true);
        this.setCancelVisible(true);
        this.jProgressBar.setVisible(true);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getTitle());
        if (n > this.getWidth()) {
            this.setSize(n, this.getHeight());
        }
        this.jTextInfo.setFont(this.fontDefault);
        this.jTextInfo.setForeground(this.fg);
        this.jTextInfo.setText("");
        if (string2 != null) {
            this.jTextInfo.setText(string2);
        }
        this.setLocationRelativeTo(this.parent);
        this.jTextInfo.setCaretPosition(0);
    }

    public void progressTask(int n, JProgressBar jProgressBar) {
    }

    public final void createError(String string) {
        this.createError(string, null);
    }

    public final void createError(String string, String string2) {
        super.setTitle(this.strTitle + " " + string);
        this.setModal(true);
        this.setCancelVisible(false);
        this.setContinueButtonText(this.strButtClose);
        this.jProgressBar.setVisible(false);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.getTitle());
        if (n > this.getWidth()) {
            this.setSize(n, this.getHeight());
        }
        this.jTextInfo.setFont(this.fontDefault);
        this.jTextInfo.setForeground(this.fg);
        this.jTextInfo.setText("");
        if (string2 != null) {
            this.jTextInfo.setText(string2);
        }
        this.setLocationRelativeTo(this.parent);
        this.jTextInfo.setCaretPosition(0);
    }

    public final void setTimeLock(final int n) {
        this.jButtonCancel.setEnabled(false);
        this.jButtonContinue.setEnabled(false);
        this.setDefaultCloseOperation(0);
        final String string = this.jButtonCancel.getText();
        this.tmrButtonLock = new Timer(1000, new ActionListener(){
            int localsecs;
            {
                this.localsecs = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                --this.localsecs;
                if (this.localsecs == 0) {
                    InfoDialog.this.tmrButtonLock.stop();
                    InfoDialog.this.jButtonCancel.setText(string);
                    InfoDialog.this.jButtonCancel.setEnabled(true);
                    InfoDialog.this.jButtonContinue.setEnabled(true);
                } else {
                    InfoDialog.this.jButtonCancel.setText(string + " (" + this.localsecs + ")");
                }
            }
        });
        this.jButtonCancel.setText(string + " (" + n + ")");
        this.tmrButtonLock.start();
    }

    public final void setCloseButtonText(String string) {
        this.strButtClose = string;
    }

    public final void setCancelButtonText(String string) {
        this.jButtonCancel.setText(string);
    }

    public final void setContinueButtonText(String string) {
        this.jButtonContinue.setText(string);
    }

    public final void setCheckBoxText(String string) {
        this.jCheckBoxOption.setText(string);
    }

    public final void setAutoScrollEnabled(boolean bl) {
        this.jTextInfo.setAutoscrolls(bl);
    }

    public final void appendInfoText(String string) {
        this.jTextInfo.append(string);
        this.jTextInfo.setCaretPosition(this.jTextInfo.getText().length());
    }

    public final void setCheckBoxVisible(boolean bl) {
        this.jCheckBoxOption.setVisible(bl);
    }

    public final void setCheckBoxEnabled(boolean bl) {
        this.jCheckBoxOption.setSelected(bl);
    }

    public final boolean isCheckBoxSelected() {
        return this.jCheckBoxOption.isSelected();
    }

    public final void setFont(String string, int n) {
        this.jTextInfo.setFont(new Font(string, this.jTextInfo.getFont().getStyle(), this.jTextInfo.getFont().getSize() + n));
    }

    public final void setAutoClose(int n) {
        this.tmrAutoClose = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.tmrAutoClose.stop();
                InfoDialog.this.doClose(1);
            }
        });
        this.tmrAutoClose.start();
    }

    public final JTextArea getTextArea() {
        return this.jTextInfo;
    }

    public final int getReturnStatus() {
        return this.returnStatus;
    }

    public final void setInfoText(String string) {
        this.jTextInfo.setText(string);
    }

    public final void setInfoText(String string, Color color) {
        this.jTextInfo.setForeground(color);
        this.jTextInfo.setText(string);
    }

    public final void setCancelEnabled(boolean bl) {
        this.jButtonCancel.setEnabled(bl);
    }

    public final void setCancelVisible(boolean bl) {
        this.jButtonCancel.setVisible(bl);
    }

    public final void setAckEnabled(boolean bl) {
        this.jButtonContinue.setEnabled(bl);
    }

    public final void setAckVisible(boolean bl) {
        this.jButtonContinue.setVisible(bl);
    }

    public void setVisibleWithFocus(boolean bl) {
        super.setVisible(bl);
        this.requestFocus();
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jButtonCancel = new JButton();
        this.jCheckBoxOption = new JCheckBox();
        this.jButtonContinue = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextInfo = new JTextArea();
        this.jProgressBar = new JProgressBar();
        this.setMinimumSize(new Dimension(410, 165));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InfoDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanelMain.setFont(this.jPanelMain.getFont().deriveFont(this.jPanelMain.getFont().getStyle() | 1, this.jPanelMain.getFont().getSize() + 2));
        this.jPanelMain.setOpaque(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.jButtonCancelActionPerformed(actionEvent);
            }
        });
        this.jCheckBoxOption.setText("Disable this notification.");
        this.jButtonContinue.setText("Continue");
        this.jButtonContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.this.jButtonContinueActionPerformed(actionEvent);
            }
        });
        this.jTextInfo.setEditable(false);
        this.jTextInfo.setColumns(20);
        this.jTextInfo.setLineWrap(true);
        this.jTextInfo.setRows(5);
        this.jTextInfo.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.jTextInfo);
        this.jProgressBar.setString("");
        this.jProgressBar.setStringPainted(true);
        GroupLayout groupLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCheckBoxOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonContinue)).addComponent(this.jScrollPane2).addComponent(this.jProgressBar, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxOption).addComponent(this.jButtonContinue).addComponent(this.jButtonCancel))));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        if (this.tmrButtonLock == null || !this.tmrButtonLock.isRunning()) {
            this.doClose(1);
        }
    }

    private void jButtonContinueActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private void doClose(int n) {
        if (this.jProgressBar.isVisible()) {
            this.progressTask(n, this.jProgressBar);
            return;
        }
        if (this.tmrAutoClose != null) {
            this.tmrAutoClose.stop();
            this.tmrAutoClose = null;
        }
        if (this.tmrButtonLock != null) {
            this.tmrButtonLock.stop();
            this.tmrButtonLock = null;
        }
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

