/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.util.Locale;
import java.util.ResourceBundle;

public final class Localisation {
    private final ResourceBundle resourceBundle;
    private String encoding = null;

    public Localisation(String string) {
        String string2 = "fr,en,pt";
        this.encoding = this.getString("encoding");
        if (!string2.contains(this.getLocale().getLanguage())) {
            Locale.setDefault(new Locale("en", "GB"));
            this.resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        } else {
            this.resourceBundle = ResourceBundle.getBundle(string);
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String toWebLanguageTag() {
        return this.getLocale().toLanguageTag().replace('-', '_');
    }

    public String getDisplayCountry(String string) {
        switch (string) {
            case "A1": 
            case "A2": 
            case "O1": 
            case "U1": {
                return this.getString("iso" + string);
            }
        }
        Locale locale = new Locale("", string);
        return locale.getDisplayCountry();
    }

    public String getString(String string) {
        try {
            if (!this.encoding.contentEquals("encoding")) {
                byte[] byArray = this.resourceBundle.getString(string).getBytes("ISO8859-1");
                return new String(byArray, this.encoding);
            }
            return this.resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String[] getStrings(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            stringArray2[n++] = this.getString(string);
        }
        return stringArray2;
    }
}

