/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JProgressBar;

public class NetFunctions {
    public static final int CONNECTION_FAILED = 0;
    public static final int FILE_LOCAL_ISNEWER = 1;
    public static final int FILE_RETRIEVED = 2;
    public static final int FILE_FAILED = 3;
    public static final int EVENT_URLOK = 1;
    public static final int EVENT_URLFAILED = 2;
    public static final int EVENT_NETLATENCY = 3;
    public static final long LATENCY_FAIL = 9999L;
    public static final long LATENCY_UNKNOWN = 0L;
    private int intSocketTimeout = 8000;
    private JProgressBar jpb;

    public void setSocketTimeout(int n) {
        this.intSocketTimeout = n;
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.jpb = jProgressBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveURLContentToFile(String string, String string2, Socket socket, boolean bl) {
        File file = new File(string);
        InputStream inputStream = this.openStreamToURL(string2, socket);
        HttpPage httpPage = new HttpPage(inputStream);
        int n = 3;
        try {
            socket.setSoTimeout(this.intSocketTimeout);
            httpPage.retrieveHeader();
            if (httpPage.isHeaderOK()) {
                n = 1;
                if (httpPage.getLastModified() > file.lastModified() || bl) {
                    if (httpPage.saveBodyToFile(string, this.jpb)) {
                        n = 2;
                        Logger.getGlobal().logp(Level.INFO, this.getClass().getName(), "saveURLContentToFile", "Http body content retrieved");
                    } else {
                        Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "saveURLContentToFile", "Failed to retrieve Http body content");
                    }
                }
            } else {
                Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "saveURLContentToFile", "Failed to retrieve Http header");
            }
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "saveURLContentToFile", iOException.getMessage());
        }
        finally {
            try {
                inputStream.close();
                socket.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public boolean isIPAddress(String string) {
        string = string.replace(".", "");
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public long getLatency(String string, Proxy proxy, int n) {
        long l;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(proxy);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setConnectTimeout(n);
            long l2 = System.currentTimeMillis();
            httpURLConnection.connect();
            l = System.currentTimeMillis() - l2;
        }
        catch (IOException iOException) {
            l = 9999L;
            Logger.getGlobal().log(Level.WARNING, "getLatency {0}", iOException.getMessage());
        }
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLContentAsString(String string, Socket socket) {
        String string2 = null;
        try {
            socket.setSoTimeout(this.intSocketTimeout);
            try (InputStream inputStream = this.openStreamToURL(string, socket);){
                HttpPage httpPage = new HttpPage(inputStream);
                httpPage.retrieveHeader();
                if (httpPage.isHeaderOK()) {
                    string2 = httpPage.getBodyAsString();
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().log(Level.WARNING, "getURLAsString", exception.getMessage());
            string2 = null;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public InputStream openStreamToURL(String string, Socket socket) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getHost();
            String string3 = uRI.getRawPath();
            if (string3 == null) {
                return null;
            }
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            printWriter.print("GET " + string3 + " HTTP/1.1\r\nHost: " + string2 + "\r\nConnection: close\r\n\r\n");
            printWriter.flush();
            InputStream inputStream = socket.getInputStream();
            return inputStream;
        }
        catch (IOException | URISyntaxException exception) {
            return null;
        }
    }

    public static final class HttpPage {
        public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
        public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
        public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
        private final TimeZone GMT = TimeZone.getTimeZone("GMT");
        private final SimpleDateFormat format = new SimpleDateFormat("", Locale.US);
        private final HashMap<String, String> hm = new HashMap();
        private final InputStream israw;

        public HttpPage(InputStream inputStream) {
            this.format.setTimeZone(this.GMT);
            this.israw = inputStream;
        }

        private String readLine(InputStream inputStream) {
            Object object = "";
            Object object2 = "";
            try {
                while (!"\r\n".equals(object2)) {
                    byte by = (byte)inputStream.read();
                    if (by == -1) {
                        return null;
                    }
                    object = (String)object + String.valueOf((char)by);
                    if ((char)by == '\r' || (char)by == '\n') {
                        object2 = (String)object2 + String.valueOf((char)by);
                        continue;
                    }
                    object2 = "";
                }
                object = ((String)object).trim();
            }
            catch (Exception exception) {
                object = null;
            }
            return object;
        }

        public final void retrieveHeader() {
            try {
                String string = this.readLine(this.israw);
                this.hm.put("Header-Response", string);
                while (true) {
                    if ((string = this.readLine(this.israw)).isEmpty()) {
                        if (this.hm.get("Content-Length") == null && !(string = this.readLine(this.israw)).isEmpty()) {
                            try {
                                long l = Long.parseLong(string, 16);
                                this.hm.put("Content-Length", String.valueOf(l));
                            }
                            catch (Exception exception) {}
                        }
                        break;
                    }
                    int n = string.indexOf(58);
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this.hm.put(string2, string3.trim());
                }
            }
            catch (Exception exception) {
                Logger.getGlobal().log(Level.WARNING, "retrieveHeader()", exception.getMessage());
                this.hm.clear();
            }
        }

        public final String getBodyAsString() {
            Object object = "";
            try {
                String string = this.hm.get("Content-Length");
                if (string == null) {
                    return null;
                }
                long l = Long.parseLong(string);
                while (l-- != 0L) {
                    object = (String)object + (char)this.israw.read();
                }
            }
            catch (IOException | NumberFormatException exception) {
                object = null;
                Logger.getGlobal().log(Level.WARNING, "getBodyAsString()", exception.getMessage());
            }
            return object;
        }

        public final boolean saveBodyToFile(String string, JProgressBar jProgressBar) {
            boolean bl;
            long l;
            String string2 = this.hm.get("Content-Length");
            if (string2 == null) {
                return false;
            }
            long l2 = Long.parseLong(string2);
            long l3 = l = l2 / 102L;
            int n = 0;
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                if (jProgressBar != null) {
                    jProgressBar.setString(null);
                }
                while (l2-- != 0L) {
                    fileOutputStream.write(this.israw.read());
                    if (l3-- != 0L) continue;
                    l3 = l;
                    if (jProgressBar == null) continue;
                    jProgressBar.setValue(n++);
                }
                fileOutputStream.close();
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NumberFormatException exception) {
                    Logger.getGlobal().log(Level.WARNING, "saveBody()", exception.getMessage());
                    return false;
                }
            }
            fileOutputStream.close();
            return bl;
        }

        public final String getProperty(String string) {
            return this.hm.get(string);
        }

        private long getHttpDate(String string) {
            try {
                this.format.applyPattern(PATTERN_RFC1123);
                return this.format.parse(string).getTime();
            }
            catch (Exception exception) {
                try {
                    this.format.applyPattern(PATTERN_RFC1036);
                    return this.format.parse(string).getTime();
                }
                catch (Exception exception2) {
                    try {
                        this.format.applyPattern(PATTERN_ASCTIME);
                        return this.format.parse(string).getTime();
                    }
                    catch (Exception exception3) {
                        return -1L;
                    }
                }
            }
        }

        public final long getLastModified() {
            return this.getHttpDate(this.hm.get("Last-Modified"));
        }

        public final long getServerDate() {
            return this.getHttpDate(this.hm.get("Date"));
        }

        public final long getExpires() {
            return this.getHttpDate(this.hm.get("Expires"));
        }

        public final boolean isHeaderOK() {
            String string = this.hm.get("Content-Length");
            if (string == null) {
                return false;
            }
            string = this.hm.get("Header-Response");
            if (string == null) {
                return false;
            }
            return string.contains("200 OK");
        }
    }
}

