/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lib.SimpleFile;

public class OSFunction {
    private static ArrayList<String> alProcesses;

    public static String getOurProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = runtimeMXBean.getName();
        Integer n = OSFunction.tryPattern(string);
        return String.valueOf(n);
    }

    public static String getProcessID(String string) {
        Pattern pattern = Pattern.compile(" +");
        String[] stringArray = pattern.split(string.trim());
        if (OSFunction.isWindows()) {
            return stringArray[1];
        }
        return stringArray[0];
    }

    private static Integer tryPattern(String string) {
        Integer n = null;
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            n = Integer.parseInt(matcher.group(1));
        }
        return n;
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUsersHomeFolder() {
        return System.getProperty("user.home");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getUsersDocFolder() {
        String string = OSFunction.getUsersHomeFolder() + "\\Documents";
        if (OSFunction.isWinXP()) {
            string = OSFunction.getUsersHomeFolder() + "\\My Documents";
        }
        return string;
    }

    public static String getUserSettingsPath() {
        String string = OSFunction.isWindows() ? OSFunction.getUsersHomeFolder() + "\\Application Data\\" : OSFunction.getUsersHomeFolder() + "/";
        return string;
    }

    public static String getAppSettingsPath(String object, String string) {
        Object object2 = OSFunction.getUserSettingsPath();
        if (object == null) {
            return object2;
        }
        if (OSFunction.isLinux()) {
            object = "." + (String)object;
        }
        object2 = (String)object2 + (String)object + OSFunction.getFileSeparator();
        if (string != null) {
            object2 = (String)object2 + string + OSFunction.getFileSeparator();
        }
        return object2;
    }

    public static String getUsersCurrentFolder() {
        return System.getProperty("user.dir");
    }

    public static String getTempFolder(String string) {
        Object object = System.getProperty("java.io.tmpdir");
        String string2 = "";
        if (OSFunction.isLinux()) {
            string2 = OSFunction.getFileSeparator();
        }
        object = (String)object + string2;
        if (string != null && !string.isEmpty()) {
            if (OSFunction.isWindows()) {
                string2 = OSFunction.getFileSeparator();
            }
            object = (String)object + string + string2;
        }
        return object;
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static boolean isWindows() {
        return OSFunction.getOSName().contains("windows");
    }

    public static boolean isWin7() {
        return OSFunction.getOSName().startsWith("windows 7");
    }

    public static boolean isWin8() {
        return OSFunction.getOSName().startsWith("windows 8");
    }

    public static boolean isWin10() {
        return OSFunction.getOSName().startsWith("windows 10");
    }

    public static boolean isWinXP() {
        return OSFunction.getOSName().contentEquals("windows");
    }

    public static boolean isLinux() {
        return OSFunction.getOSName().contains("linux");
    }

    public static String findFile(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!new File(string2 + string).exists()) continue;
            return string2 + string;
        }
        return null;
    }

    public static boolean isMultipleInstance(String string) {
        ArrayList<String> arrayList;
        if (alProcesses == null) {
            alProcesses = OSFunction.getLiveProcesses();
        }
        return OSFunction.filterProcesses(arrayList = OSFunction.filterProcesses(string), "java").size() > 1;
    }

    public static ArrayList<String> getCachedProcesses() {
        return alProcesses;
    }

    public static ArrayList<String> filterProcesses(ArrayList<String> arrayList, String string) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList != null && !arrayList.isEmpty() && string != null) {
            for (String string2 : arrayList) {
                if (!string2.contains(string)) continue;
                arrayList2.add(string2);
            }
        }
        return arrayList2;
    }

    public static ArrayList<String> filterProcesses(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!alProcesses.isEmpty() && string != null) {
            for (String string2 : alProcesses) {
                if (!string2.contains(string)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static String killProcess(String string) {
        if (OSFunction.isWindows()) {
            return OSFunction.killProcessWindows(string);
        }
        if (OSFunction.isLinux()) {
            return OSFunction.killProcessLinux(string);
        }
        return null;
    }

    private static String killProcessWindows(String string) {
        try {
            Process process = Runtime.getRuntime().exec("taskkill /F /pid " + string);
            return OSFunction.getProcessResult(process);
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "killProcessWindows", "", iOException);
            try {
                Process process = Runtime.getRuntime().exec("tskill " + string);
                return OSFunction.getProcessResult(process);
            }
            catch (IOException iOException2) {
                Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "killProcessWindows", "", iOException2);
                return null;
            }
        }
    }

    private static String killProcessLinux(String string) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("kill -9 " + string);
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "killProcessLinux", "", iOException);
        }
        return OSFunction.getProcessResult(process);
    }

    public static void setFileHidden(String string, boolean bl) {
        if (OSFunction.isWindows()) {
            try {
                if (bl) {
                    Runtime.getRuntime().exec("Attrib.exe +H " + string).waitFor();
                } else {
                    Runtime.getRuntime().exec("Attrib.exe -H " + string).waitFor();
                }
            }
            catch (IOException | InterruptedException exception) {
                Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "setFileHidden", "", exception);
            }
        }
    }

    public static String getGnome3Pref(String string, String string2) {
        Process process = OSFunction.launchProcess("gsettings", "get", string, string2);
        String string3 = OSFunction.getProcessResult(process);
        if (string3 != null) {
            string3 = string3.replace("'", "").replace("[", "").replace("]", "");
        }
        return string3;
    }

    public static void setGnome3Pref(String string, String string2, boolean bl) {
        OSFunction.setGnome3Pref(string, string2, String.valueOf(bl));
    }

    public static void setGnome3Pref(String string, String string2, String string3) {
        if (string3 == null || string3.isEmpty()) {
            OSFunction.resetGnome3Pref(string, string2);
        } else {
            OSFunction.launchProcess("gsettings", "set", string, string2, "'" + string3 + "'");
        }
    }

    public static void resetGnome3Pref(String string, String string2) {
        if (string2 == null) {
            OSFunction.launchProcess("gsettings", "reset", string);
        } else {
            OSFunction.launchProcess("gsettings", "reset", string, string2);
        }
    }

    public static String getKDEPref(String string, String string2, String string3) {
        String string4 = OSFunction.getKDEProxyPath();
        if (string4 == null) {
            return null;
        }
        String string5 = null;
        SimpleFile simpleFile = new SimpleFile(string4);
        simpleFile.openBufferedRead();
        while ((string5 = simpleFile.readLine()) != null && !string5.contains("[" + string + "]")) {
        }
        if (string5 == null) {
            return string3;
        }
        while ((string5 = simpleFile.readLine()) != null && !string5.contains(string2)) {
        }
        simpleFile.closeFile();
        if (string5 == null) {
            return string3;
        }
        string5 = string5.substring(string5.indexOf(61) + 1);
        return string5;
    }

    public static void setKDEPref(String string, String string2, String string3) {
        String string4;
        String string5 = OSFunction.getKDEProxyPath();
        if (string5 == null) {
            return;
        }
        SimpleFile simpleFile = new SimpleFile(string5);
        ArrayList<String> arrayList = new ArrayList<String>();
        simpleFile.openBufferedRead();
        while ((string4 = simpleFile.readLine()) != null) {
            arrayList.add(string4);
        }
        simpleFile.closeFile();
        simpleFile.openBufferedWrite();
        boolean bl = false;
        while (!arrayList.isEmpty()) {
            string4 = (String)arrayList.get(0);
            simpleFile.writeFile(string4, 1);
            arrayList.remove(0);
            if (!string4.contentEquals("[" + string + "]")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            simpleFile.writeFile("", 1);
            simpleFile.writeFile("[" + string + "]", 1);
        }
        while (!arrayList.isEmpty()) {
            string4 = (String)arrayList.get(0);
            arrayList.remove(0);
            if (string4.contains(string2)) break;
            simpleFile.writeFile(string4, 1);
        }
        simpleFile.writeFile(string2 + "=" + string3, 1);
        while (!arrayList.isEmpty()) {
            string4 = (String)arrayList.get(0);
            arrayList.remove(0);
            simpleFile.writeFile(string4, 1);
        }
        simpleFile.closeFile();
    }

    public static void setKDEPref(String string, String string2, boolean bl) {
        OSFunction.setKDEPref(string, string2, String.valueOf(bl));
    }

    public static void setKDEPref(String string, String string2, int n) {
        OSFunction.setKDEPref(string, string2, String.valueOf(n));
    }

    public static String getKDEProxyPath() {
        if (OSFunction.isLinux()) {
            File file = new File(OSFunction.getUsersHomeFolder() + "/.config/kioslaverc");
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            file = new File(OSFunction.getUsersHomeFolder() + "/.kde/share/config/kioslaverc");
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            file = new File(OSFunction.getUsersHomeFolder() + "/.kde4/share/config/kioslaverc");
            if (file.exists()) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public static String getGsettingsPath() {
        return OSFunction.findFile("gsettings", "/usr/bin/");
    }

    public static String getProcessResult(Process process) {
        if (process == null) {
            return null;
        }
        return OSFunction.getProcessOutput(process.getInputStream()).toString();
    }

    public static ArrayList<String> getProcessOutput(InputStream inputStream) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.isEmpty()) continue;
                    arrayList.add(string);
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.SEVERE, OSFunction.class.getName(), "getProcessResults", "", iOException);
            return null;
        }
    }

    public static Process launchProcess(String ... stringArray) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            if (process == null) {
                Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "launchProcess", "Failed Process", "");
            }
            return process;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "launchProcess", "", iOException);
            return null;
        }
    }

    public static ArrayList<String> getLiveProcesses() {
        if (OSFunction.isWindows()) {
            return OSFunction.getActiveProcessesWindows();
        }
        return OSFunction.getActiveProcessesLinux();
    }

    private static ArrayList<String> getActiveProcessesWindows() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Logger.getGlobal().info("refreshActiveProcessesWindows()");
            Process process = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe /v");
            arrayList = OSFunction.getProcessOutput(process.getInputStream());
            if (arrayList.size() > 1) {
                arrayList.remove(1);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "refreshActiveProcessesWindows", "", iOException);
            return arrayList;
        }
    }

    private static ArrayList<String> getActiveProcessesLinux() {
        ArrayList<String> arrayList = new ArrayList();
        try {
            Process process = Runtime.getRuntime().exec("ps ax");
            arrayList = OSFunction.getProcessOutput(process.getInputStream());
            return arrayList;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, OSFunction.class.getName(), "refreshActiveProcessesLinux", "", iOException);
            return arrayList;
        }
    }

    public static String getCompositor() {
        String string = "unknown";
        if (OSFunction.isWin7() || OSFunction.isWin8() || OSFunction.isWin10()) {
            return "DWM";
        }
        if (OSFunction.isWindows()) {
            return OSFunction.getOSName();
        }
        if (alProcesses == null) {
            alProcesses = OSFunction.getLiveProcesses();
        }
        for (String string2 : alProcesses) {
            if (string2.contains("kwin")) {
                string = "kwin";
                break;
            }
            if (string2.contains("compton")) {
                string = "compton";
                break;
            }
            if (string2.contains("cinnamon")) {
                string = "clutter";
                break;
            }
            if (string2.contains("marco")) {
                string = "marco";
                break;
            }
            if (!string2.contains("compiz")) continue;
            string = "compiz";
            break;
        }
        return string;
    }

    public static String getActiveDesktop() {
        if (OSFunction.isWindows()) {
            return OSFunction.getOSName();
        }
        String string = "unknown";
        if (alProcesses == null) {
            alProcesses = OSFunction.getLiveProcesses();
        }
        for (String string2 : alProcesses) {
            if (string2.contains("cinnamon-session")) {
                string = "cinnamon";
                break;
            }
            if (string2.contains("xfce4-session")) {
                string = "xfce";
                break;
            }
            if (string2.contains("mate-session")) {
                string = "mate";
                break;
            }
            if (string2.contains("gnome-shell")) {
                string = "gnome3";
                break;
            }
            if (string2.contains("unity-settings-daemon")) {
                string = "unity";
                break;
            }
            if (string2.contains("lxsession")) {
                string = "lxde";
                break;
            }
            if (string2.contains("plasma-desktop")) {
                string = "kde4";
                break;
            }
            if (string2.contains("plasmashell")) {
                string = "kde5";
                break;
            }
            if (!string2.contains("enlightenment")) continue;
            string = "enlightenment";
            break;
        }
        return string;
    }

    public static void clearActiveProcesses() {
        alProcesses.clear();
        alProcesses = null;
    }

    public static String getLangCode() {
        return Locale.getDefault().getLanguage();
    }
}

