/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lib.OSFunction;

public class SimpleFile {
    public static final int PERIOD_MINUTES = 0;
    public static final int PERIOD_HOURS = 1;
    public static final int PERIOD_DAYS = 2;
    public static final int NOTFOUND = 0;
    public static final int FILEDELETEOK = 1;
    public static final int FILEDELETEFAIL = 2;
    private final int blockreadsize = 1024;
    private BufferedReader br;
    private BufferedWriter bw;
    private ZipOutputStream zos;
    private File f;
    private String filter = "";

    public SimpleFile() {
    }

    public SimpleFile(String string) {
        this.f = new File(string);
    }

    public final void setFileName(String string) {
        this.f = new File(string);
    }

    public final void setFile(File file) {
        this.f = file;
    }

    public final File getFile() {
        return this.f;
    }

    public final void closeFile() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(SimpleFile.class.getName()).log(Level.SEVERE, null, iOException);
            }
            this.br = null;
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(SimpleFile.class.getName()).log(Level.SEVERE, null, iOException);
            }
            this.bw = null;
        }
    }

    public final void setFileFilter(String string) {
        this.filter = string;
    }

    public final String getFileFilter() {
        return this.filter;
    }

    public static final String getSeparator() {
        return File.separator;
    }

    public final boolean createFolder() {
        if (this.f.exists()) {
            return true;
        }
        return this.f.mkdirs();
    }

    public static final boolean createFolder(String string) {
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        return file.mkdirs();
    }

    public final boolean createFile() {
        boolean bl = true;
        if (!this.f.exists()) {
            try {
                SimpleFile.createFolder(this.f.getParent());
                bl = this.f.createNewFile();
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public final File[] getFileList() {
        File[] fileArray = this.filter.isEmpty() ? this.f.listFiles() : this.f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getPath().contains(SimpleFile.this.filter);
            }
        });
        return fileArray;
    }

    public final File getOldestFile() {
        File[] fileArray;
        long l = new Date().getTime();
        File file = null;
        for (File file2 : fileArray = this.getFileList()) {
            if (file2.lastModified() >= l) continue;
            l = file2.lastModified();
            file = file2;
        }
        return file;
    }

    public static final void walkFileTree(String string, ArrayList<File> arrayList) {
        SimpleFile.walkFileTree(string, arrayList, "");
    }

    public static final void walkFileTree(String string, ArrayList<File> arrayList, final String string2) {
        File file = new File(string);
        File[] fileArray = string2.isEmpty() ? file.listFiles() : file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getPath().contains(string2);
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                SimpleFile.walkFileTree(file2.getAbsolutePath(), arrayList, string2);
                continue;
            }
            arrayList.add(file2);
        }
    }

    public final void deleteFileList(File[] fileArray) {
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            boolean bl = file.delete();
        }
    }

    public static final boolean deleteFolder(String string) {
        if (OSFunction.isLinux() && string.contentEquals("/")) {
            return false;
        }
        return SimpleFile.deleteFolder(new File(string));
    }

    private static boolean deleteFolder(File file) {
        if (!file.exists()) {
            return false;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                SimpleFile.deleteFolder(file2);
                continue;
            }
            boolean bl = file2.delete();
        }
        return file.delete();
    }

    public static final void secureWipeFolder(String string) {
        if (OSFunction.isLinux() && string.contentEquals("/")) {
            return;
        }
        SimpleFile.secureWipeFolder(new File(string));
    }

    public static final void secureWipeFolder(File file) {
        if (!file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                SimpleFile.secureWipeFolder(file2);
                continue;
            }
            SimpleFile.secureWipe(file2);
        }
        file = SimpleFile.renameTo(file, "0000000");
        file.delete();
    }

    public static final void secureWipe(String string) {
        SimpleFile.secureWipe(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void secureWipe(File file) {
        if (!file.exists()) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[4096];
        long l = file.length() / 4096L;
        int n = (int)(file.length() % 4096L);
        byte[] byArray2 = new byte[n];
        try {
            fileOutputStream = new FileOutputStream(file, false);
            while (l-- > 0L) {
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            }
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
            byArray = new byte[]{};
            fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            Logger.getLogger(SimpleFile.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                file = SimpleFile.renameTo(file, "0000000000");
                file.delete();
            }
            catch (IOException iOException) {}
        }
    }

    public static final File renameTo(File file, String string) {
        File file2;
        Object object = file.getParent();
        if (object != null && file.renameTo(file2 = new File((String)(object = (String)object + File.separator + string)))) {
            return file2;
        }
        return file;
    }

    public static final void copyFolderContents(String string, String string2, String string3) {
        try {
            File file = new File(string);
            for (File file2 : file.listFiles()) {
                if (string3.contains(file2.getName())) continue;
                SimpleFile.copyFromTo(file2.getAbsolutePath(), string2 + file2.getName());
            }
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, "SimpleFile", "copyFolderContents()", "", exception);
        }
    }

    public final String[] getFilenames(int n) {
        File[] fileArray = this.getFileList();
        String[] stringArray = new String[fileArray.length + n];
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                stringArray[i + n] = string.substring(0, string.indexOf(46));
            }
            return stringArray;
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "getFilenames(int offset)", "", exception);
            return null;
        }
    }

    public final boolean exists() {
        return this.f.exists();
    }

    public static final boolean exists(String string) {
        return new File(string).exists();
    }

    public final boolean delete() {
        return this.f.delete();
    }

    public static final boolean delete(String string) {
        return new File(string).delete();
    }

    public final boolean renameFile(String string) {
        return this.f.renameTo(new File(string));
    }

    public final BufferedReader openBufferedRead() {
        try {
            this.br = new BufferedReader(new FileReader(this.f));
            return this.br;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public final void openBufferedResource() {
        try {
            String string = this.f.getPath();
            string = string.replace('\\', '/');
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.br = new BufferedReader(new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "openBufferedRead(int filehandle)", "", exception);
        }
    }

    public final void openBufferedAppend() {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.f, true));
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "openBufferedAppend()", "", iOException);
        }
    }

    public final String readLine() {
        try {
            return this.br.readLine();
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "readLine(int filehandle)", "", iOException);
            return null;
        }
    }

    public final String readEntireFile() {
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while (this.br.ready()) {
                int n = this.br.read(cArray);
                stringBuilder.append(cArray, 0, n);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "readEntireFile()", "", iOException);
            return "";
        }
    }

    public final FileInputStream openFileInputStream(String string) {
        try {
            return new FileInputStream(new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "openFileInputStream()", "", fileNotFoundException);
            return null;
        }
    }

    public final FileOutputStream openFileOutputStream() {
        try {
            return new FileOutputStream(this.f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "openFileOutputStream()", "", fileNotFoundException);
            return null;
        }
    }

    public final void openBufferedWrite() {
        try {
            this.bw = new BufferedWriter(new FileWriter(this.f));
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "openBufferedWrite()", "", iOException);
        }
    }

    public final void flushWriter() {
        try {
            this.bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void writeFile(String string, int n) {
        try {
            this.bw.write(string);
            while (n > 0) {
                this.bw.newLine();
                --n;
            }
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "writeToFile(" + string + "," + String.valueOf(n) + ")", "", iOException);
        }
    }

    public final void writeFile(char[] cArray, int n) {
        try {
            this.bw.write(cArray, 0, n);
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "writeToFile()", "", iOException);
        }
    }

    public static final void copyFromTo(String string, String string2) {
        try {
            Path path = new File(string).toPath();
            Path path2 = new File(string2).toPath();
            Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, "SimpleFile", "copyFromTo()", "", iOException);
        }
    }

    public static final void mergeFiles(String string, String string2, String string3) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(string3));){
            Path path = new File(string).toPath();
            Files.copy(path, fileOutputStream);
            path = new File(string2).toPath();
            Files.copy(path, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, "SimpleFile", "mergeFiles", "", iOException);
        }
    }

    public static final float getAgeOfFile(String string, int n) {
        File file = new File(string);
        if (!file.exists()) {
            return -1.0f;
        }
        float f = System.currentTimeMillis() - file.lastModified();
        switch (n) {
            case 0: {
                return f / 60000.0f;
            }
            case 1: {
                return f / 3600000.0f;
            }
            case 2: {
                return f / 8.64E7f;
            }
        }
        return -1.0f;
    }

    public static final boolean isMinutesOlder(String string, long l) {
        long l2 = System.currentTimeMillis() - new File(string).lastModified();
        return l2 > 60000L * l;
    }

    public static final boolean isHoursOlder(String string, long l) {
        long l2 = System.currentTimeMillis() - new File(string).lastModified();
        return l2 > 3600000L * l;
    }

    public static final boolean isDaysOlder(String string, long l) {
        long l2 = System.currentTimeMillis() - new File(string).lastModified();
        return l2 > 86400000L * l;
    }

    public final boolean openZipStream(int n) {
        try {
            this.zos = new ZipOutputStream(new FileOutputStream(this.f.getAbsolutePath()));
            if (n < 0 || n > 9) {
                n = 6;
            }
            this.zos.setLevel(n);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public final void closeZipStream() {
        if (this.zos != null) {
            try {
                this.zos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void compress(String string, String string2) {
        final Path path = Paths.get(string, new String[0]);
        try {
            final ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) {
                    try {
                        Path path2 = path.relativize(path3);
                        zipOutputStream.putNextEntry(new ZipEntry(path2.toString()));
                        byte[] byArray = Files.readAllBytes(path3);
                        zipOutputStream.write(byArray, 0, byArray.length);
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addFilesToZip(File ... fileArray) {
        FileInputStream fileInputStream = null;
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        try {
            for (File file : fileArray) {
                fileInputStream = new FileInputStream(file);
                this.zos.putNextEntry(new ZipEntry(file.getName()));
                byte[] byArray = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
                this.zos.write(byArray, 0, byArray.length);
                fileInputStream.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public final boolean extractZipTo(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.f);
            try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    FileOutputStream fileOutputStream;
                    byte[] byArray = new byte[2048];
                    try {
                        fileOutputStream = new FileOutputStream(string + File.separator + zipEntry.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        continue;
                    }
                    try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);){
                        int n;
                        while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n);
                        }
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                    }
                    fileOutputStream.close();
                }
                zipInputStream.close();
                fileInputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "extractZipTo()", "", iOException);
            return false;
        }
    }

    public static final boolean objectWrite(String string, Object object) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectOutputStream == null) {
            return false;
        }
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final Object objectRead(String string, Object object) {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectInputStream == null) {
            return object;
        }
        Object object2 = object;
        try {
            object2 = objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return object2;
    }
}

