/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleProps {
    private final File fileStore;
    private final String comment;
    private final ArrayList<String> alChanged;
    private boolean boolDefaultEnabled;
    private final Properties defProps = new Properties();
    private Properties appProps;

    public SimpleProps(String string, String string2) {
        this.alChanged = new ArrayList();
        this.fileStore = new File(string);
        this.comment = string2;
    }

    public void setDefaultModeEnabled(boolean bl) {
        this.boolDefaultEnabled = bl;
    }

    public void setLong(String string, long l) {
        String string2 = String.valueOf(l);
        this.setString(string, string2);
    }

    public long getLong(String string) {
        try {
            if (this.boolDefaultEnabled) {
                return Long.parseLong(this.defProps.getProperty(string));
            }
            return Long.parseLong(this.appProps.getProperty(string));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "getLong", "", numberFormatException);
            return -1L;
        }
    }

    public void setInt(String string, int n) {
        String string2 = String.valueOf(n);
        this.setString(string, string2);
    }

    public int getInt(String string) {
        try {
            if (this.boolDefaultEnabled) {
                return Integer.parseInt(this.defProps.getProperty(string));
            }
            return Integer.parseInt(this.appProps.getProperty(string));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "getInt", "", numberFormatException);
            return -1;
        }
    }

    public void setBool(String string, boolean bl) {
        if (bl) {
            this.setString(string, "true");
        } else {
            this.setString(string, "false");
        }
    }

    public boolean getBool(String string) {
        try {
            String string2 = this.boolDefaultEnabled ? this.defProps.getProperty(string).toLowerCase() : this.appProps.getProperty(string).toLowerCase();
            return string2.contentEquals("true");
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "getBool", "", exception);
            return false;
        }
    }

    public Object setString(String string, String string2) {
        string2 = string2.trim();
        if (this.boolDefaultEnabled) {
            return this.defProps.setProperty(string, string2);
        }
        String string3 = this.appProps.getProperty(string);
        if (string3 == null) {
            string3 = "null";
        }
        if (string3.contentEquals(string2)) {
            if (this.alChanged.contains(string)) {
                this.alChanged.remove(string);
            }
        } else if (!this.alChanged.contains(string)) {
            this.alChanged.add(string);
        }
        return this.appProps.setProperty(string, string2);
    }

    public String getString(String string) {
        try {
            String string2 = this.boolDefaultEnabled ? this.defProps.getProperty(string) : this.appProps.getProperty(string);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }
        catch (Exception exception) {
            Logger.getGlobal().logp(Level.WARNING, this.getClass().getName(), "getString", "", exception);
            return null;
        }
    }

    public void save() {
        this.alChanged.clear();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.fileStore);
            this.appProps.storeToXML(fileOutputStream, this.comment);
        }
        catch (Exception exception) {
            Logger.getLogger(SimpleProps.class.getName()).log(Level.SEVERE, null, exception);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void load() {
        InputStream inputStream = null;
        try {
            if (!this.fileStore.exists()) {
                this.fileStore.getParentFile().mkdirs();
                this.fileStore.createNewFile();
                this.save();
            }
            inputStream = new FileInputStream(this.fileStore);
            this.appProps.loadFromXML(inputStream);
        }
        catch (IOException iOException) {
            Logger.getLogger(SimpleProps.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        this.alChanged.clear();
    }

    public boolean delete() {
        if (this.fileStore.exists()) {
            return this.fileStore.delete();
        }
        return false;
    }

    public String getChangedProperties() {
        return this.alChanged.toString();
    }

    public void resetToDefaults() {
        this.appProps = new Properties(this.defProps);
        this.alChanged.clear();
    }
}

