/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import lib.OSFunction;
import lib.TrayPopupMenu;

public final class SwingTrayIcon {
    private InfoTip infoToolTip;
    private JDialog jdiagPopup;
    private TrayPopupMenu trayPopupMenu;
    private AWTEventListener awtEventListen;
    private volatile boolean mouseExited = false;
    private SystemTray st = null;
    private GraphicsConfiguration gc = null;
    private Point mouseloc;
    private TrayIcon ti;
    private boolean loaded = false;

    public SwingTrayIcon(GraphicsConfiguration graphicsConfiguration, String string) {
        if (!SystemTray.isSupported()) {
            return;
        }
        try {
            this.st = SystemTray.getSystemTray();
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.ti = new TrayIcon(new ImageIcon(classLoader.getResource(string)).getImage());
        }
        catch (Exception exception) {
            return;
        }
        this.ti.setImageAutoSize(true);
        this.gc = graphicsConfiguration;
        this.initDiagPopup();
        if (OSFunction.isLinux()) {
            this.infoToolTip = new InfoTip();
            this.infoToolTip.setFocusable(false);
        }
        this.initMouseHandler();
    }

    private void initMouseHandler() {
        this.awtEventListen = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (!(mouseEvent.getSource() instanceof TrayIcon)) {
                    return;
                }
                SwingTrayIcon.this.mouseloc = MouseInfo.getPointerInfo().getLocation();
                switch (mouseEvent.getID()) {
                    case 504: {
                        if (SwingTrayIcon.this.infoToolTip == null || SwingTrayIcon.this.trayPopupMenu.isVisible()) {
                            return;
                        }
                        SwingTrayIcon.this.mouseExited = false;
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (!SwingTrayIcon.this.trayPopupMenu.isVisible() && !SwingTrayIcon.this.mouseExited) {
                                    SwingTrayIcon.this.infoToolTip.setLocation(SwingTrayIcon.this.getPlacementPosition(SwingTrayIcon.this.mouseloc, SwingTrayIcon.this.infoToolTip.getWidth(), SwingTrayIcon.this.infoToolTip.getHeight(), true));
                                    SwingTrayIcon.this.infoToolTip.setVisible(true);
                                } else {
                                    SwingTrayIcon.this.infoToolTip.setVisible(false);
                                }
                            }
                        });
                        thread.start();
                        break;
                    }
                    case 505: {
                        SwingTrayIcon.this.mouseExited = true;
                        if (SwingTrayIcon.this.infoToolTip == null) break;
                        SwingTrayIcon.this.infoToolTip.setVisible(false);
                        break;
                    }
                    case 502: {
                        if (mouseEvent.getButton() != 3) break;
                        if (SwingTrayIcon.this.infoToolTip != null) {
                            SwingTrayIcon.this.infoToolTip.setVisible(false);
                        }
                        SwingTrayIcon.this.mouseExited = true;
                        SwingTrayIcon.this.raisePopupMenu(SwingTrayIcon.this.mouseloc);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListen, 16L);
    }

    private void initDiagPopup() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jdiagPopup = new JDialog();
        this.jdiagPopup.setUndecorated(true);
        this.jdiagPopup.setMinimumSize(new Dimension(0, 0));
        this.jdiagPopup.setBounds(new Rectangle(0, 0));
        this.jdiagPopup.setType(Window.Type.POPUP);
        this.jdiagPopup.setFocusable(false);
        this.jdiagPopup.setAutoRequestFocus(false);
        try {
            this.jdiagPopup.setLocation(new Point(dimension.width, dimension.height));
            this.jdiagPopup.setOpacity(0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jdiagPopup.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                SwingTrayIcon.this.trayPopupMenu.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void dispose() {
        this.unload();
        if (this.ti != null) {
            for (EventListener eventListener : this.ti.getMouseListeners()) {
                this.ti.removeMouseListener((MouseListener)eventListener);
            }
        }
        if (this.awtEventListen != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListen);
            this.awtEventListen = null;
        }
        if (this.trayPopupMenu != null) {
            for (EventListener eventListener : this.trayPopupMenu.getPopupMenuListeners()) {
                this.trayPopupMenu.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            this.trayPopupMenu = null;
        }
        if (this.jdiagPopup != null) {
            for (EventListener eventListener : this.jdiagPopup.getComponentListeners()) {
                this.jdiagPopup.removeComponentListener((ComponentListener)eventListener);
            }
            this.jdiagPopup.dispose();
            this.jdiagPopup = null;
        }
        if (this.infoToolTip != null) {
            this.infoToolTip.dispose();
            this.infoToolTip = null;
        }
        this.st = null;
    }

    public void disable() {
        this.unload();
        this.st = null;
    }

    public void setTrayPopupMenu(TrayPopupMenu trayPopupMenu) {
        this.trayPopupMenu = trayPopupMenu;
        if (trayPopupMenu == null || this.ti == null) {
            return;
        }
        this.trayPopupMenu.setFocusable(false);
        this.trayPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SwingTrayIcon.this.jdiagPopup.setVisible(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                SwingTrayIcon.this.jdiagPopup.setVisible(false);
            }
        });
        this.trayPopupMenu.setEnabled(true);
        this.trayPopupMenu.setInvoker(this.jdiagPopup);
    }

    private void raisePopupMenu(Point point) {
        if (this.trayPopupMenu != null) {
            Point point2 = this.getPlacementPosition(point, this.trayPopupMenu.getVisibleRect().width, this.trayPopupMenu.getHeight(), false);
            this.trayPopupMenu.setLocation(point2);
            this.jdiagPopup.setVisible(true);
        }
    }

    private Point getPlacementPosition(Point point, int n, int n2, boolean bl) {
        double d;
        double d2;
        Insets insets;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point2 = new Point();
        int n3 = 0;
        if (OSFunction.isLinux()) {
            insets = Toolkit.getDefaultToolkit().getScreenInsets(this.gc);
            int n4 = insets.bottom + insets.left + insets.right + insets.top;
            if (n4 == 0) {
                insets = new Insets(32, 32, 32, 32);
            }
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        double d3 = point.x;
        if (d3 > dimension.getWidth() / 2.0) {
            d2 = dimension.width - insets.right;
            if (d3 + (double)n > d2) {
                d3 = insets.right == 0 ? (d3 -= (double)n) : d2 - (double)n;
            }
        } else {
            d2 = insets.left;
            if (d3 < d2) {
                d3 = d2;
            }
        }
        if ((d = (double)point.y) > dimension.getHeight() / 2.0) {
            if (bl && insets.bottom == 0) {
                n3 = (int)((this.ti.getSize().getHeight() + 1.0) / 2.0);
            }
        } else if (bl && insets.top == 0) {
            n3 = (int)((this.ti.getSize().getHeight() + 1.0) / 2.0);
        }
        if (insets.top != 0 && d < (double)insets.top) {
            d += (double)insets.top - d;
        }
        d = d + (double)n3 + (double)n2 > (d2 = (double)(dimension.height - insets.bottom)) ? (n3 > 0 ? (d -= (double)(n2 + n3)) : (insets.bottom == 0 ? (d -= (double)(n2 + n3)) : d2 - (double)n2)) : (d += (double)n3);
        point2.setLocation(d3, d);
        return point2;
    }

    public void setInfoTip(String string) {
        if (this.ti == null) {
            return;
        }
        if (OSFunction.isLinux()) {
            if (SystemTray.isSupported() && this.isLoaded() && this.st.getTrayIcons().length == 0) {
                try {
                    this.st.add(this.ti);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.infoToolTip != null) {
                this.infoToolTip.setText(string);
                if (this.infoToolTip.isVisible()) {
                    this.infoToolTip.setLocation(this.getPlacementPosition(this.mouseloc, this.infoToolTip.getWidth(), this.infoToolTip.getHeight(), true));
                }
            }
        } else {
            this.ti.setToolTip(string);
        }
    }

    public void displayMessage(String string, String string2) {
        if (this.ti != null) {
            this.ti.displayMessage(string, string2, TrayIcon.MessageType.INFO);
        }
    }

    public void load() {
        if (this.trayPopupMenu != null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.trayPopupMenu.setLocation(dimension.height, dimension.width);
            this.trayPopupMenu.setVisible(true);
            this.trayPopupMenu.setVisible(false);
        }
        try {
            if (this.st != null) {
                this.st.add(this.ti);
                this.loaded = true;
            }
        }
        catch (Exception exception) {
            this.loaded = false;
        }
    }

    public void unload() {
        if (this.st != null) {
            this.st.remove(this.ti);
        }
        this.loaded = false;
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.ti != null) {
            this.ti.addMouseListener(mouseListener);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isSupported() {
        return this.st != null;
    }

    private static final class InfoTip
    extends JWindow {
        JTextArea jta;
        Pattern p = Pattern.compile("\n");

        public InfoTip() {
            this.initInfoTip();
        }

        private void initInfoTip() {
            this.setType(Window.Type.POPUP);
            this.jta = new JTextArea();
            this.add(this.jta);
            JToolTip jToolTip = this.jta.createToolTip();
            this.jta.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            this.jta.setBackground(new Color(jToolTip.getBackground().getRGB()));
            this.jta.setForeground(new Color(jToolTip.getForeground().getRGB()));
            this.setBackground(this.jta.getBackground());
            this.jta.setOpaque(true);
            this.jta.setEditable(false);
            this.jta.setLineWrap(true);
            this.jta.setWrapStyleWord(true);
            this.jta.setVisible(true);
            this.setEnabled(true);
        }

        public void setText(String string) {
            int n;
            String[] stringArray = this.p.split(string);
            String string2 = "";
            int n2 = 0;
            for (String string3 : stringArray) {
                n = this.jta.getFontMetrics(this.jta.getFont()).stringWidth(string3);
                if (n <= n2) continue;
                string2 = string3;
                n2 = n;
            }
            this.jta.setText("  " + string.replace("\n", "\n  "));
            n = this.jta.getFontMetrics(this.jta.getFont()).stringWidth(string2 + "XXX");
            int n3 = this.jta.getFontMetrics(this.jta.getFont()).getHeight() + 1;
            int n4 = this.jta.getLineCount() * n3;
            this.setSize(n, n4);
        }
    }
}

