/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.awt.Desktop;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Random;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import lib.OSFunction;
import lib.SimpleFile;

public final class Utilities {
    public static String getListAsCSV(ArrayList<String> arrayList) {
        return arrayList.toString().replace("[", "").replace("]", "").replace(" ", "");
    }

    public static void preloadFileChooser() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = new JFileChooser();
            }
        });
        thread.start();
    }

    public static String openFileChooser(Frame frame, String string, FileFilter fileFilter, int n) {
        int n2;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(n);
        jFileChooser.setCurrentDirectory(new File(string));
        if (fileFilter != null) {
            jFileChooser.addChoosableFileFilter(fileFilter);
        }
        if ((n2 = jFileChooser.showOpenDialog(frame)) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static boolean isNewerVersion(String string, String string2) {
        return Utilities.convertBuildnumToFloat(string2) > Utilities.convertBuildnumToFloat(string);
    }

    private static float convertBuildnumToFloat(String string) {
        float f;
        try {
            String[] stringArray;
            if (string.contains("-")) {
                Pattern pattern = Pattern.compile("-");
                stringArray = pattern.split(string);
            } else {
                Pattern pattern = Pattern.compile("\\.");
                stringArray = pattern.split(string);
                stringArray[0] = stringArray[0] + "." + stringArray[1];
                stringArray[1] = stringArray[2];
                stringArray[2] = "";
            }
            f = Float.parseFloat(stringArray[0]);
            f += Float.parseFloat(stringArray[1]) / 100000.0f;
        }
        catch (Exception exception) {
            string = string.replaceAll("[^0-9.]", "");
            f = Utilities.convertVersionToFloat(string);
        }
        return f;
    }

    private static float convertVersionToFloat(String string) {
        float f;
        if ((string = string.toLowerCase()).startsWith("v")) {
            string = string.substring(1);
        }
        try {
            char c = string.charAt(string.length() - 1);
            if (c > '`') {
                string = string.substring(0, string.length() - 1);
                Float f2 = Float.valueOf((float)(c - 96) / 10000.0f);
                f = Float.parseFloat(string) + f2.floatValue();
            } else {
                f = Float.parseFloat(string);
            }
        }
        catch (Exception exception) {
            f = 0.0f;
        }
        return f;
    }

    public static void editFile(String string) {
        if (OSFunction.isLinux()) {
            OSFunction.launchProcess("xdg-open", string);
            return;
        }
        if (OSFunction.isWindows()) {
            OSFunction.launchProcess("notepad", string);
        }
    }

    public static boolean openFileExternally(String string) {
        String string2 = string.replace("\\", "/");
        try {
            if (OSFunction.isLinux()) {
                OSFunction.launchProcess("xdg-open", string2);
            } else if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (string2.startsWith("http") || string2.startsWith("ftp")) {
                    desktop.browse(new URI(string2));
                } else {
                    desktop.open(new File(string2));
                }
            }
            return true;
        }
        catch (IOException | URISyntaxException exception) {
            return false;
        }
    }

    public static void loadUIStyle(String string) {
        try {
            if (string == null) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                return;
            }
            if (string.contentEquals("Metal")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                return;
            }
            if (string.contentEquals("Nimbus")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                return;
            }
            if (string.contentEquals("System")) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    return;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                        return;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception2) {}
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    public static void adjustTableColumnWidth(JTable jTable, String ... stringArray) {
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        int n = 0;
        for (String string : stringArray) {
            jTable.getColumn(jTable.getColumnName(n++)).setPreferredWidth(fontMetrics.stringWidth(string));
        }
    }

    public static String generateSecretKey(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        String string = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        try {
            for (int i = 0; i < n; ++i) {
                int n2 = random.nextInt(string.length() - 1);
                stringBuilder.append(string.substring(n2, n2 + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String getTorHashPassword(String string) {
        byte[] byArray = Utilities.S2KRFC2440(string);
        return "16:" + Utilities.byteToHex(byArray);
    }

    public static byte[] S2KRFC2440(String string) {
        byte[] byArray;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            return null;
        }
        int n = 32;
        byte[] byArray2 = new byte[9];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray2);
        byArray2[8] = (byte)n;
        int n2 = 16 + (n & 0xF) << (n >> 4) + 6;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        byte[] byArray3 = new byte[8 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        while (true) {
            if (n2 < byArray3.length) break;
            messageDigest.update(byArray3);
            n2 -= byArray3.length;
        }
        messageDigest.update(byArray3, 0, n2);
        byte[] byArray4 = new byte[29];
        System.arraycopy(messageDigest.digest(), 0, byArray4, 9, 20);
        System.arraycopy(byArray2, 0, byArray4, 0, 9);
        return byArray4;
    }

    public static String getSHAHash(String string) {
        String string2 = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            messageDigest.update(string.getBytes("UTF-8"));
            string2 = Utilities.byteToHex(messageDigest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        return string2;
    }

    private static String byteToHex(byte[] byArray) {
        String string;
        try (Formatter formatter = new Formatter();){
            for (byte by : byArray) {
                formatter.format("%02x", by);
            }
            string = formatter.toString();
        }
        return string;
    }

    public static String getTextFromResource(String string) {
        SimpleFile simpleFile = new SimpleFile(string);
        simpleFile.openBufferedResource();
        String string2 = simpleFile.readEntireFile();
        simpleFile.closeFile();
        return string2;
    }

    public static String getTextFromFile(String string) {
        SimpleFile simpleFile = new SimpleFile(string);
        String string2 = "";
        if (simpleFile.exists()) {
            simpleFile.openBufferedRead();
            string2 = simpleFile.readEntireFile();
            simpleFile.closeFile();
        }
        return string2;
    }

    public static String getSha1Sum(String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            for (int i = 0; i < byArray2.length; ++i) {
                stringBuilder.append(Integer.toString((byArray2[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static void registerWindow() {
        final JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                jFrame.dispose();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
        jFrame.setUndecorated(true);
        jFrame.setBounds(0, 0, 0, 0);
        jFrame.setVisible(true);
    }
}

